# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetLBOutboundRuleResult',
    'AwaitableGetLBOutboundRuleResult',
    'get_lb_outbound_rule',
    'get_lb_outbound_rule_output',
]

@pulumi.output_type
class GetLBOutboundRuleResult:
    """
    A collection of values returned by getLBOutboundRule.
    """
    def __init__(__self__, allocated_outbound_ports=None, backend_address_pool_id=None, enable_tcp_reset=None, frontend_ip_configurations=None, id=None, idle_timeout_in_minutes=None, loadbalancer_id=None, name=None, protocol=None, tcp_reset_enabled=None):
        if allocated_outbound_ports and not isinstance(allocated_outbound_ports, int):
            raise TypeError("Expected argument 'allocated_outbound_ports' to be a int")
        pulumi.set(__self__, "allocated_outbound_ports", allocated_outbound_ports)
        if backend_address_pool_id and not isinstance(backend_address_pool_id, str):
            raise TypeError("Expected argument 'backend_address_pool_id' to be a str")
        pulumi.set(__self__, "backend_address_pool_id", backend_address_pool_id)
        if enable_tcp_reset and not isinstance(enable_tcp_reset, bool):
            raise TypeError("Expected argument 'enable_tcp_reset' to be a bool")
        pulumi.set(__self__, "enable_tcp_reset", enable_tcp_reset)
        if frontend_ip_configurations and not isinstance(frontend_ip_configurations, list):
            raise TypeError("Expected argument 'frontend_ip_configurations' to be a list")
        pulumi.set(__self__, "frontend_ip_configurations", frontend_ip_configurations)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if idle_timeout_in_minutes and not isinstance(idle_timeout_in_minutes, int):
            raise TypeError("Expected argument 'idle_timeout_in_minutes' to be a int")
        pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if loadbalancer_id and not isinstance(loadbalancer_id, str):
            raise TypeError("Expected argument 'loadbalancer_id' to be a str")
        pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if protocol and not isinstance(protocol, str):
            raise TypeError("Expected argument 'protocol' to be a str")
        pulumi.set(__self__, "protocol", protocol)
        if tcp_reset_enabled and not isinstance(tcp_reset_enabled, bool):
            raise TypeError("Expected argument 'tcp_reset_enabled' to be a bool")
        pulumi.set(__self__, "tcp_reset_enabled", tcp_reset_enabled)

    @_builtins.property
    @pulumi.getter(name="allocatedOutboundPorts")
    def allocated_outbound_ports(self) -> _builtins.int:
        """
        The number of outbound ports used for NAT.
        """
        return pulumi.get(self, "allocated_outbound_ports")

    @_builtins.property
    @pulumi.getter(name="backendAddressPoolId")
    def backend_address_pool_id(self) -> _builtins.str:
        """
        The ID of the Backend Address Pool. Outbound traffic is randomly load balanced across IPs in the backend IPs.
        """
        return pulumi.get(self, "backend_address_pool_id")

    @_builtins.property
    @pulumi.getter(name="enableTcpReset")
    def enable_tcp_reset(self) -> _builtins.bool:
        return pulumi.get(self, "enable_tcp_reset")

    @_builtins.property
    @pulumi.getter(name="frontendIpConfigurations")
    def frontend_ip_configurations(self) -> Sequence['outputs.GetLBOutboundRuleFrontendIpConfigurationResult']:
        """
        A `frontend_ip_configuration` block as defined below.
        """
        return pulumi.get(self, "frontend_ip_configurations")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> _builtins.int:
        """
        The timeout for the TCP idle connection.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @_builtins.property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> _builtins.str:
        return pulumi.get(self, "loadbalancer_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Frontend IP Configuration.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The transport protocol for the external endpoint.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="tcpResetEnabled")
    def tcp_reset_enabled(self) -> _builtins.bool:
        """
        Is the bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination enabled? This value is useful when the protocol is set to TCP.
        """
        return pulumi.get(self, "tcp_reset_enabled")


class AwaitableGetLBOutboundRuleResult(GetLBOutboundRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLBOutboundRuleResult(
            allocated_outbound_ports=self.allocated_outbound_ports,
            backend_address_pool_id=self.backend_address_pool_id,
            enable_tcp_reset=self.enable_tcp_reset,
            frontend_ip_configurations=self.frontend_ip_configurations,
            id=self.id,
            idle_timeout_in_minutes=self.idle_timeout_in_minutes,
            loadbalancer_id=self.loadbalancer_id,
            name=self.name,
            protocol=self.protocol,
            tcp_reset_enabled=self.tcp_reset_enabled)


def get_lb_outbound_rule(loadbalancer_id: Optional[_builtins.str] = None,
                         name: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLBOutboundRuleResult:
    """
    Use this data source to access information about an existing Load Balancer Outbound Rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.lb.get_lb_outbound_rule(name="existing_lb_outbound_rule",
        loadbalancer_id="existing_load_balancer_id")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2023-09-01


    :param _builtins.str loadbalancer_id: The ID of the Load Balancer in which the Outbound Rule exists.
    :param _builtins.str name: The name of this Load Balancer Outbound Rule.
    """
    __args__ = dict()
    __args__['loadbalancerId'] = loadbalancer_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:lb/getLBOutboundRule:getLBOutboundRule', __args__, opts=opts, typ=GetLBOutboundRuleResult).value

    return AwaitableGetLBOutboundRuleResult(
        allocated_outbound_ports=pulumi.get(__ret__, 'allocated_outbound_ports'),
        backend_address_pool_id=pulumi.get(__ret__, 'backend_address_pool_id'),
        enable_tcp_reset=pulumi.get(__ret__, 'enable_tcp_reset'),
        frontend_ip_configurations=pulumi.get(__ret__, 'frontend_ip_configurations'),
        id=pulumi.get(__ret__, 'id'),
        idle_timeout_in_minutes=pulumi.get(__ret__, 'idle_timeout_in_minutes'),
        loadbalancer_id=pulumi.get(__ret__, 'loadbalancer_id'),
        name=pulumi.get(__ret__, 'name'),
        protocol=pulumi.get(__ret__, 'protocol'),
        tcp_reset_enabled=pulumi.get(__ret__, 'tcp_reset_enabled'))
def get_lb_outbound_rule_output(loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                                name: Optional[pulumi.Input[_builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLBOutboundRuleResult]:
    """
    Use this data source to access information about an existing Load Balancer Outbound Rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.lb.get_lb_outbound_rule(name="existing_lb_outbound_rule",
        loadbalancer_id="existing_load_balancer_id")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2023-09-01


    :param _builtins.str loadbalancer_id: The ID of the Load Balancer in which the Outbound Rule exists.
    :param _builtins.str name: The name of this Load Balancer Outbound Rule.
    """
    __args__ = dict()
    __args__['loadbalancerId'] = loadbalancer_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:lb/getLBOutboundRule:getLBOutboundRule', __args__, opts=opts, typ=GetLBOutboundRuleResult)
    return __ret__.apply(lambda __response__: GetLBOutboundRuleResult(
        allocated_outbound_ports=pulumi.get(__response__, 'allocated_outbound_ports'),
        backend_address_pool_id=pulumi.get(__response__, 'backend_address_pool_id'),
        enable_tcp_reset=pulumi.get(__response__, 'enable_tcp_reset'),
        frontend_ip_configurations=pulumi.get(__response__, 'frontend_ip_configurations'),
        id=pulumi.get(__response__, 'id'),
        idle_timeout_in_minutes=pulumi.get(__response__, 'idle_timeout_in_minutes'),
        loadbalancer_id=pulumi.get(__response__, 'loadbalancer_id'),
        name=pulumi.get(__response__, 'name'),
        protocol=pulumi.get(__response__, 'protocol'),
        tcp_reset_enabled=pulumi.get(__response__, 'tcp_reset_enabled')))
