# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DefinitionAuthorization',
    'DefinitionEligibleAuthorization',
    'DefinitionEligibleAuthorizationJustInTimeAccessPolicy',
    'DefinitionEligibleAuthorizationJustInTimeAccessPolicyApprover',
    'DefinitionPlan',
]

@pulumi.output_type
class DefinitionAuthorization(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "roleDefinitionId":
            suggest = "role_definition_id"
        elif key == "delegatedRoleDefinitionIds":
            suggest = "delegated_role_definition_ids"
        elif key == "principalDisplayName":
            suggest = "principal_display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefinitionAuthorization. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefinitionAuthorization.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefinitionAuthorization.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: _builtins.str,
                 role_definition_id: _builtins.str,
                 delegated_role_definition_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_display_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str principal_id: Principal ID of the security group/service principal/user that would be assigned permissions to the projected subscription.
        :param _builtins.str role_definition_id: The role definition identifier. This role will define the permissions that are granted to the principal. This cannot be an `Owner` role.
        :param Sequence[_builtins.str] delegated_role_definition_ids: The set of role definition ids which define all the permissions that the principal id can assign.
        :param _builtins.str principal_display_name: The display name of the security group/service principal/user that would be assigned permissions to the projected subscription.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "role_definition_id", role_definition_id)
        if delegated_role_definition_ids is not None:
            pulumi.set(__self__, "delegated_role_definition_ids", delegated_role_definition_ids)
        if principal_display_name is not None:
            pulumi.set(__self__, "principal_display_name", principal_display_name)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> _builtins.str:
        """
        Principal ID of the security group/service principal/user that would be assigned permissions to the projected subscription.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> _builtins.str:
        """
        The role definition identifier. This role will define the permissions that are granted to the principal. This cannot be an `Owner` role.
        """
        return pulumi.get(self, "role_definition_id")

    @_builtins.property
    @pulumi.getter(name="delegatedRoleDefinitionIds")
    def delegated_role_definition_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        The set of role definition ids which define all the permissions that the principal id can assign.
        """
        return pulumi.get(self, "delegated_role_definition_ids")

    @_builtins.property
    @pulumi.getter(name="principalDisplayName")
    def principal_display_name(self) -> Optional[_builtins.str]:
        """
        The display name of the security group/service principal/user that would be assigned permissions to the projected subscription.
        """
        return pulumi.get(self, "principal_display_name")


@pulumi.output_type
class DefinitionEligibleAuthorization(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "roleDefinitionId":
            suggest = "role_definition_id"
        elif key == "justInTimeAccessPolicy":
            suggest = "just_in_time_access_policy"
        elif key == "principalDisplayName":
            suggest = "principal_display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefinitionEligibleAuthorization. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefinitionEligibleAuthorization.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefinitionEligibleAuthorization.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: _builtins.str,
                 role_definition_id: _builtins.str,
                 just_in_time_access_policy: Optional['outputs.DefinitionEligibleAuthorizationJustInTimeAccessPolicy'] = None,
                 principal_display_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str principal_id: Principal ID of the security group/service principal/user that would be assigned permissions to the projected subscription.
        :param _builtins.str role_definition_id: The Principal ID of the Azure built-in role that defines the permissions that the Azure Active Directory will have on the projected scope.
        :param 'DefinitionEligibleAuthorizationJustInTimeAccessPolicyArgs' just_in_time_access_policy: A `just_in_time_access_policy` block as defined below.
        :param _builtins.str principal_display_name: The display name of the Azure Active Directory Principal.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "role_definition_id", role_definition_id)
        if just_in_time_access_policy is not None:
            pulumi.set(__self__, "just_in_time_access_policy", just_in_time_access_policy)
        if principal_display_name is not None:
            pulumi.set(__self__, "principal_display_name", principal_display_name)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> _builtins.str:
        """
        Principal ID of the security group/service principal/user that would be assigned permissions to the projected subscription.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="roleDefinitionId")
    def role_definition_id(self) -> _builtins.str:
        """
        The Principal ID of the Azure built-in role that defines the permissions that the Azure Active Directory will have on the projected scope.
        """
        return pulumi.get(self, "role_definition_id")

    @_builtins.property
    @pulumi.getter(name="justInTimeAccessPolicy")
    def just_in_time_access_policy(self) -> Optional['outputs.DefinitionEligibleAuthorizationJustInTimeAccessPolicy']:
        """
        A `just_in_time_access_policy` block as defined below.
        """
        return pulumi.get(self, "just_in_time_access_policy")

    @_builtins.property
    @pulumi.getter(name="principalDisplayName")
    def principal_display_name(self) -> Optional[_builtins.str]:
        """
        The display name of the Azure Active Directory Principal.
        """
        return pulumi.get(self, "principal_display_name")


@pulumi.output_type
class DefinitionEligibleAuthorizationJustInTimeAccessPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maximumActivationDuration":
            suggest = "maximum_activation_duration"
        elif key == "multiFactorAuthProvider":
            suggest = "multi_factor_auth_provider"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefinitionEligibleAuthorizationJustInTimeAccessPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefinitionEligibleAuthorizationJustInTimeAccessPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefinitionEligibleAuthorizationJustInTimeAccessPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 approvers: Optional[Sequence['outputs.DefinitionEligibleAuthorizationJustInTimeAccessPolicyApprover']] = None,
                 maximum_activation_duration: Optional[_builtins.str] = None,
                 multi_factor_auth_provider: Optional[_builtins.str] = None):
        """
        :param Sequence['DefinitionEligibleAuthorizationJustInTimeAccessPolicyApproverArgs'] approvers: An `approver` block as defined below.
        :param _builtins.str maximum_activation_duration: The maximum access duration in ISO 8601 format for just-in-time access requests. Defaults to `PT8H`.
        :param _builtins.str multi_factor_auth_provider: The multi-factor authorization provider to be used for just-in-time access requests. Possible value is `Azure`.
               
               > **Note:** When this property isn't set, it would be set to `None`.
        """
        if approvers is not None:
            pulumi.set(__self__, "approvers", approvers)
        if maximum_activation_duration is not None:
            pulumi.set(__self__, "maximum_activation_duration", maximum_activation_duration)
        if multi_factor_auth_provider is not None:
            pulumi.set(__self__, "multi_factor_auth_provider", multi_factor_auth_provider)

    @_builtins.property
    @pulumi.getter
    def approvers(self) -> Optional[Sequence['outputs.DefinitionEligibleAuthorizationJustInTimeAccessPolicyApprover']]:
        """
        An `approver` block as defined below.
        """
        return pulumi.get(self, "approvers")

    @_builtins.property
    @pulumi.getter(name="maximumActivationDuration")
    def maximum_activation_duration(self) -> Optional[_builtins.str]:
        """
        The maximum access duration in ISO 8601 format for just-in-time access requests. Defaults to `PT8H`.
        """
        return pulumi.get(self, "maximum_activation_duration")

    @_builtins.property
    @pulumi.getter(name="multiFactorAuthProvider")
    def multi_factor_auth_provider(self) -> Optional[_builtins.str]:
        """
        The multi-factor authorization provider to be used for just-in-time access requests. Possible value is `Azure`.

        > **Note:** When this property isn't set, it would be set to `None`.
        """
        return pulumi.get(self, "multi_factor_auth_provider")


@pulumi.output_type
class DefinitionEligibleAuthorizationJustInTimeAccessPolicyApprover(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "principalId":
            suggest = "principal_id"
        elif key == "principalDisplayName":
            suggest = "principal_display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DefinitionEligibleAuthorizationJustInTimeAccessPolicyApprover. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DefinitionEligibleAuthorizationJustInTimeAccessPolicyApprover.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DefinitionEligibleAuthorizationJustInTimeAccessPolicyApprover.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 principal_id: _builtins.str,
                 principal_display_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str principal_id: The Principal ID of the Azure Active Directory principal for the approver.
        :param _builtins.str principal_display_name: The display name of the Azure Active Directory Principal for the approver.
        """
        pulumi.set(__self__, "principal_id", principal_id)
        if principal_display_name is not None:
            pulumi.set(__self__, "principal_display_name", principal_display_name)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> _builtins.str:
        """
        The Principal ID of the Azure Active Directory principal for the approver.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="principalDisplayName")
    def principal_display_name(self) -> Optional[_builtins.str]:
        """
        The display name of the Azure Active Directory Principal for the approver.
        """
        return pulumi.get(self, "principal_display_name")


@pulumi.output_type
class DefinitionPlan(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 product: _builtins.str,
                 publisher: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str name: The plan name of the marketplace offer.
        :param _builtins.str product: The product code of the plan.
        :param _builtins.str publisher: The publisher ID of the plan.
        :param _builtins.str version: The version of the plan.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The plan name of the marketplace offer.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def product(self) -> _builtins.str:
        """
        The product code of the plan.
        """
        return pulumi.get(self, "product")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> _builtins.str:
        """
        The publisher ID of the plan.
        """
        return pulumi.get(self, "publisher")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of the plan.
        """
        return pulumi.get(self, "version")


