# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['IntegrationAccountArgs', 'IntegrationAccount']

@pulumi.input_type
class IntegrationAccountArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku_name: pulumi.Input[_builtins.str],
                 integration_service_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a IntegrationAccount resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Logic App Integration Account should exist. Changing this forces a new Logic App Integration Account to be created.
        :param pulumi.Input[_builtins.str] sku_name: The SKU name of the Logic App Integration Account. Possible Values are `Basic`, `Free` and `Standard`.
        :param pulumi.Input[_builtins.str] integration_service_environment_id: The resource ID of the Integration Service Environment. Changing this forces a new Logic App Integration Account to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Logic App Integration Account should exist. Changing this forces a new Logic App Integration Account to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Logic App Integration Account. Changing this forces a new Logic App Integration Account to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Logic App Integration Account.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku_name", sku_name)
        if integration_service_environment_id is not None:
            pulumi.set(__self__, "integration_service_environment_id", integration_service_environment_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Logic App Integration Account should exist. Changing this forces a new Logic App Integration Account to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Input[_builtins.str]:
        """
        The SKU name of the Logic App Integration Account. Possible Values are `Basic`, `Free` and `Standard`.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="integrationServiceEnvironmentId")
    def integration_service_environment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the Integration Service Environment. Changing this forces a new Logic App Integration Account to be created.
        """
        return pulumi.get(self, "integration_service_environment_id")

    @integration_service_environment_id.setter
    def integration_service_environment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "integration_service_environment_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Logic App Integration Account should exist. Changing this forces a new Logic App Integration Account to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Logic App Integration Account. Changing this forces a new Logic App Integration Account to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Logic App Integration Account.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _IntegrationAccountState:
    def __init__(__self__, *,
                 integration_service_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering IntegrationAccount resources.
        :param pulumi.Input[_builtins.str] integration_service_environment_id: The resource ID of the Integration Service Environment. Changing this forces a new Logic App Integration Account to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Logic App Integration Account should exist. Changing this forces a new Logic App Integration Account to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Logic App Integration Account. Changing this forces a new Logic App Integration Account to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Logic App Integration Account should exist. Changing this forces a new Logic App Integration Account to be created.
        :param pulumi.Input[_builtins.str] sku_name: The SKU name of the Logic App Integration Account. Possible Values are `Basic`, `Free` and `Standard`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Logic App Integration Account.
        """
        if integration_service_environment_id is not None:
            pulumi.set(__self__, "integration_service_environment_id", integration_service_environment_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="integrationServiceEnvironmentId")
    def integration_service_environment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the Integration Service Environment. Changing this forces a new Logic App Integration Account to be created.
        """
        return pulumi.get(self, "integration_service_environment_id")

    @integration_service_environment_id.setter
    def integration_service_environment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "integration_service_environment_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Logic App Integration Account should exist. Changing this forces a new Logic App Integration Account to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Logic App Integration Account. Changing this forces a new Logic App Integration Account to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Logic App Integration Account should exist. Changing this forces a new Logic App Integration Account to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SKU name of the Logic App Integration Account. Possible Values are `Basic`, `Free` and `Standard`.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Logic App Integration Account.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:logicapps/integrationAccount:IntegrationAccount")
class IntegrationAccount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 integration_service_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Logic App Integration Account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_integration_account = azure.logicapps.IntegrationAccount("example",
            name="example-ia",
            resource_group_name=example.name,
            location=example.location,
            sku_name="Standard",
            tags={
                "foo": "bar",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Logic` - 2019-05-01

        ## Import

        Logic App Integration Accounts can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:logicapps/integrationAccount:IntegrationAccount example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Logic/integrationAccounts/account1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] integration_service_environment_id: The resource ID of the Integration Service Environment. Changing this forces a new Logic App Integration Account to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Logic App Integration Account should exist. Changing this forces a new Logic App Integration Account to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Logic App Integration Account. Changing this forces a new Logic App Integration Account to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Logic App Integration Account should exist. Changing this forces a new Logic App Integration Account to be created.
        :param pulumi.Input[_builtins.str] sku_name: The SKU name of the Logic App Integration Account. Possible Values are `Basic`, `Free` and `Standard`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Logic App Integration Account.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationAccountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Logic App Integration Account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_integration_account = azure.logicapps.IntegrationAccount("example",
            name="example-ia",
            resource_group_name=example.name,
            location=example.location,
            sku_name="Standard",
            tags={
                "foo": "bar",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Logic` - 2019-05-01

        ## Import

        Logic App Integration Accounts can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:logicapps/integrationAccount:IntegrationAccount example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Logic/integrationAccounts/account1
        ```

        :param str resource_name: The name of the resource.
        :param IntegrationAccountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationAccountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 integration_service_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationAccountArgs.__new__(IntegrationAccountArgs)

            __props__.__dict__["integration_service_environment_id"] = integration_service_environment_id
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sku_name is None and not opts.urn:
                raise TypeError("Missing required property 'sku_name'")
            __props__.__dict__["sku_name"] = sku_name
            __props__.__dict__["tags"] = tags
        super(IntegrationAccount, __self__).__init__(
            'azure:logicapps/integrationAccount:IntegrationAccount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            integration_service_environment_id: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            sku_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'IntegrationAccount':
        """
        Get an existing IntegrationAccount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] integration_service_environment_id: The resource ID of the Integration Service Environment. Changing this forces a new Logic App Integration Account to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Logic App Integration Account should exist. Changing this forces a new Logic App Integration Account to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Logic App Integration Account. Changing this forces a new Logic App Integration Account to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Logic App Integration Account should exist. Changing this forces a new Logic App Integration Account to be created.
        :param pulumi.Input[_builtins.str] sku_name: The SKU name of the Logic App Integration Account. Possible Values are `Basic`, `Free` and `Standard`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Logic App Integration Account.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntegrationAccountState.__new__(_IntegrationAccountState)

        __props__.__dict__["integration_service_environment_id"] = integration_service_environment_id
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["tags"] = tags
        return IntegrationAccount(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="integrationServiceEnvironmentId")
    def integration_service_environment_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource ID of the Integration Service Environment. Changing this forces a new Logic App Integration Account to be created.
        """
        return pulumi.get(self, "integration_service_environment_id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Logic App Integration Account should exist. Changing this forces a new Logic App Integration Account to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Logic App Integration Account. Changing this forces a new Logic App Integration Account to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Logic App Integration Account should exist. Changing this forces a new Logic App Integration Account to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[_builtins.str]:
        """
        The SKU name of the Logic App Integration Account. Possible Values are `Basic`, `Free` and `Standard`.
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Logic App Integration Account.
        """
        return pulumi.get(self, "tags")

