# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['GroupPolicyRemediationArgs', 'GroupPolicyRemediation']

@pulumi.input_type
class GroupPolicyRemediationArgs:
    def __init__(__self__, *,
                 management_group_id: pulumi.Input[_builtins.str],
                 policy_assignment_id: pulumi.Input[_builtins.str],
                 failure_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 location_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parallel_deployments: Optional[pulumi.Input[_builtins.int]] = None,
                 policy_definition_reference_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_count: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a GroupPolicyRemediation resource.
        :param pulumi.Input[_builtins.str] management_group_id: The Management Group ID at which the Policy Remediation should be applied. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] policy_assignment_id: The ID of the Policy Assignment that should be remediated.
        :param pulumi.Input[_builtins.float] failure_percentage: A number between 0.0 to 1.0 representing the percentage failure threshold. The remediation will fail if the percentage of failed remediation operations (i.e. failed deployments) exceeds this threshold.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] location_filters: A list of the resource locations that will be remediated.
        :param pulumi.Input[_builtins.str] name: The name of the Policy Remediation. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] parallel_deployments: Determines how many resources to remediate at any given time. Can be used to increase or reduce the pace of the remediation. If not provided, the default parallel deployments value is used.
        :param pulumi.Input[_builtins.str] policy_definition_reference_id: The unique ID for the policy definition reference within the policy set definition that should be remediated. Required when the policy assignment being remediated assigns a policy set definition.
        :param pulumi.Input[_builtins.int] resource_count: Determines the max number of resources that can be remediated by the remediation job. If not provided, the default resource count is used.
        """
        pulumi.set(__self__, "management_group_id", management_group_id)
        pulumi.set(__self__, "policy_assignment_id", policy_assignment_id)
        if failure_percentage is not None:
            pulumi.set(__self__, "failure_percentage", failure_percentage)
        if location_filters is not None:
            pulumi.set(__self__, "location_filters", location_filters)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parallel_deployments is not None:
            pulumi.set(__self__, "parallel_deployments", parallel_deployments)
        if policy_definition_reference_id is not None:
            pulumi.set(__self__, "policy_definition_reference_id", policy_definition_reference_id)
        if resource_count is not None:
            pulumi.set(__self__, "resource_count", resource_count)

    @_builtins.property
    @pulumi.getter(name="managementGroupId")
    def management_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Management Group ID at which the Policy Remediation should be applied. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "management_group_id")

    @management_group_id.setter
    def management_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "management_group_id", value)

    @_builtins.property
    @pulumi.getter(name="policyAssignmentId")
    def policy_assignment_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Policy Assignment that should be remediated.
        """
        return pulumi.get(self, "policy_assignment_id")

    @policy_assignment_id.setter
    def policy_assignment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_assignment_id", value)

    @_builtins.property
    @pulumi.getter(name="failurePercentage")
    def failure_percentage(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        A number between 0.0 to 1.0 representing the percentage failure threshold. The remediation will fail if the percentage of failed remediation operations (i.e. failed deployments) exceeds this threshold.
        """
        return pulumi.get(self, "failure_percentage")

    @failure_percentage.setter
    def failure_percentage(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "failure_percentage", value)

    @_builtins.property
    @pulumi.getter(name="locationFilters")
    def location_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of the resource locations that will be remediated.
        """
        return pulumi.get(self, "location_filters")

    @location_filters.setter
    def location_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "location_filters", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Policy Remediation. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="parallelDeployments")
    def parallel_deployments(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Determines how many resources to remediate at any given time. Can be used to increase or reduce the pace of the remediation. If not provided, the default parallel deployments value is used.
        """
        return pulumi.get(self, "parallel_deployments")

    @parallel_deployments.setter
    def parallel_deployments(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "parallel_deployments", value)

    @_builtins.property
    @pulumi.getter(name="policyDefinitionReferenceId")
    def policy_definition_reference_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique ID for the policy definition reference within the policy set definition that should be remediated. Required when the policy assignment being remediated assigns a policy set definition.
        """
        return pulumi.get(self, "policy_definition_reference_id")

    @policy_definition_reference_id.setter
    def policy_definition_reference_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_definition_reference_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceCount")
    def resource_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Determines the max number of resources that can be remediated by the remediation job. If not provided, the default resource count is used.
        """
        return pulumi.get(self, "resource_count")

    @resource_count.setter
    def resource_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "resource_count", value)


@pulumi.input_type
class _GroupPolicyRemediationState:
    def __init__(__self__, *,
                 failure_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 location_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 management_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parallel_deployments: Optional[pulumi.Input[_builtins.int]] = None,
                 policy_assignment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_definition_reference_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_count: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering GroupPolicyRemediation resources.
        :param pulumi.Input[_builtins.float] failure_percentage: A number between 0.0 to 1.0 representing the percentage failure threshold. The remediation will fail if the percentage of failed remediation operations (i.e. failed deployments) exceeds this threshold.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] location_filters: A list of the resource locations that will be remediated.
        :param pulumi.Input[_builtins.str] management_group_id: The Management Group ID at which the Policy Remediation should be applied. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Policy Remediation. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] parallel_deployments: Determines how many resources to remediate at any given time. Can be used to increase or reduce the pace of the remediation. If not provided, the default parallel deployments value is used.
        :param pulumi.Input[_builtins.str] policy_assignment_id: The ID of the Policy Assignment that should be remediated.
        :param pulumi.Input[_builtins.str] policy_definition_reference_id: The unique ID for the policy definition reference within the policy set definition that should be remediated. Required when the policy assignment being remediated assigns a policy set definition.
        :param pulumi.Input[_builtins.int] resource_count: Determines the max number of resources that can be remediated by the remediation job. If not provided, the default resource count is used.
        """
        if failure_percentage is not None:
            pulumi.set(__self__, "failure_percentage", failure_percentage)
        if location_filters is not None:
            pulumi.set(__self__, "location_filters", location_filters)
        if management_group_id is not None:
            pulumi.set(__self__, "management_group_id", management_group_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parallel_deployments is not None:
            pulumi.set(__self__, "parallel_deployments", parallel_deployments)
        if policy_assignment_id is not None:
            pulumi.set(__self__, "policy_assignment_id", policy_assignment_id)
        if policy_definition_reference_id is not None:
            pulumi.set(__self__, "policy_definition_reference_id", policy_definition_reference_id)
        if resource_count is not None:
            pulumi.set(__self__, "resource_count", resource_count)

    @_builtins.property
    @pulumi.getter(name="failurePercentage")
    def failure_percentage(self) -> Optional[pulumi.Input[_builtins.float]]:
        """
        A number between 0.0 to 1.0 representing the percentage failure threshold. The remediation will fail if the percentage of failed remediation operations (i.e. failed deployments) exceeds this threshold.
        """
        return pulumi.get(self, "failure_percentage")

    @failure_percentage.setter
    def failure_percentage(self, value: Optional[pulumi.Input[_builtins.float]]):
        pulumi.set(self, "failure_percentage", value)

    @_builtins.property
    @pulumi.getter(name="locationFilters")
    def location_filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of the resource locations that will be remediated.
        """
        return pulumi.get(self, "location_filters")

    @location_filters.setter
    def location_filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "location_filters", value)

    @_builtins.property
    @pulumi.getter(name="managementGroupId")
    def management_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Management Group ID at which the Policy Remediation should be applied. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "management_group_id")

    @management_group_id.setter
    def management_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "management_group_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Policy Remediation. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="parallelDeployments")
    def parallel_deployments(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Determines how many resources to remediate at any given time. Can be used to increase or reduce the pace of the remediation. If not provided, the default parallel deployments value is used.
        """
        return pulumi.get(self, "parallel_deployments")

    @parallel_deployments.setter
    def parallel_deployments(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "parallel_deployments", value)

    @_builtins.property
    @pulumi.getter(name="policyAssignmentId")
    def policy_assignment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Policy Assignment that should be remediated.
        """
        return pulumi.get(self, "policy_assignment_id")

    @policy_assignment_id.setter
    def policy_assignment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_assignment_id", value)

    @_builtins.property
    @pulumi.getter(name="policyDefinitionReferenceId")
    def policy_definition_reference_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique ID for the policy definition reference within the policy set definition that should be remediated. Required when the policy assignment being remediated assigns a policy set definition.
        """
        return pulumi.get(self, "policy_definition_reference_id")

    @policy_definition_reference_id.setter
    def policy_definition_reference_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_definition_reference_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceCount")
    def resource_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Determines the max number of resources that can be remediated by the remediation job. If not provided, the default resource count is used.
        """
        return pulumi.get(self, "resource_count")

    @resource_count.setter
    def resource_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "resource_count", value)


@pulumi.type_token("azure:management/groupPolicyRemediation:GroupPolicyRemediation")
class GroupPolicyRemediation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 failure_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 location_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 management_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parallel_deployments: Optional[pulumi.Input[_builtins.int]] = None,
                 policy_assignment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_definition_reference_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_count: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages an Azure Management Group Policy Remediation.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_azure as azure

        example_group = azure.management.Group("example", display_name="Example Management Group")
        example = azure.policy.get_policy_defintion(display_name="Allowed locations")
        example_group_policy_assignment = azure.management.GroupPolicyAssignment("example",
            name="exampleAssignment",
            management_group_id=example_group.id,
            policy_definition_id=example.id,
            parameters=json.dumps({
                "listOfAllowedLocations": {
                    "value": ["East US"],
                },
            }))
        example_group_policy_remediation = azure.management.GroupPolicyRemediation("example",
            name="example",
            management_group_id=example_group.id,
            policy_assignment_id=example_group_policy_assignment.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Management` - 2021-10-01

        ## Import

        Policy Remediations can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:management/groupPolicyRemediation:GroupPolicyRemediation example /providers/Microsoft.Management/managementGroups/my-mgmt-group-id/providers/Microsoft.PolicyInsights/remediations/remediation1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.float] failure_percentage: A number between 0.0 to 1.0 representing the percentage failure threshold. The remediation will fail if the percentage of failed remediation operations (i.e. failed deployments) exceeds this threshold.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] location_filters: A list of the resource locations that will be remediated.
        :param pulumi.Input[_builtins.str] management_group_id: The Management Group ID at which the Policy Remediation should be applied. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Policy Remediation. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] parallel_deployments: Determines how many resources to remediate at any given time. Can be used to increase or reduce the pace of the remediation. If not provided, the default parallel deployments value is used.
        :param pulumi.Input[_builtins.str] policy_assignment_id: The ID of the Policy Assignment that should be remediated.
        :param pulumi.Input[_builtins.str] policy_definition_reference_id: The unique ID for the policy definition reference within the policy set definition that should be remediated. Required when the policy assignment being remediated assigns a policy set definition.
        :param pulumi.Input[_builtins.int] resource_count: Determines the max number of resources that can be remediated by the remediation job. If not provided, the default resource count is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupPolicyRemediationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Management Group Policy Remediation.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_azure as azure

        example_group = azure.management.Group("example", display_name="Example Management Group")
        example = azure.policy.get_policy_defintion(display_name="Allowed locations")
        example_group_policy_assignment = azure.management.GroupPolicyAssignment("example",
            name="exampleAssignment",
            management_group_id=example_group.id,
            policy_definition_id=example.id,
            parameters=json.dumps({
                "listOfAllowedLocations": {
                    "value": ["East US"],
                },
            }))
        example_group_policy_remediation = azure.management.GroupPolicyRemediation("example",
            name="example",
            management_group_id=example_group.id,
            policy_assignment_id=example_group_policy_assignment.id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Management` - 2021-10-01

        ## Import

        Policy Remediations can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:management/groupPolicyRemediation:GroupPolicyRemediation example /providers/Microsoft.Management/managementGroups/my-mgmt-group-id/providers/Microsoft.PolicyInsights/remediations/remediation1
        ```

        :param str resource_name: The name of the resource.
        :param GroupPolicyRemediationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupPolicyRemediationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 failure_percentage: Optional[pulumi.Input[_builtins.float]] = None,
                 location_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 management_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parallel_deployments: Optional[pulumi.Input[_builtins.int]] = None,
                 policy_assignment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_definition_reference_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_count: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupPolicyRemediationArgs.__new__(GroupPolicyRemediationArgs)

            __props__.__dict__["failure_percentage"] = failure_percentage
            __props__.__dict__["location_filters"] = location_filters
            if management_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'management_group_id'")
            __props__.__dict__["management_group_id"] = management_group_id
            __props__.__dict__["name"] = name
            __props__.__dict__["parallel_deployments"] = parallel_deployments
            if policy_assignment_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_assignment_id'")
            __props__.__dict__["policy_assignment_id"] = policy_assignment_id
            __props__.__dict__["policy_definition_reference_id"] = policy_definition_reference_id
            __props__.__dict__["resource_count"] = resource_count
        super(GroupPolicyRemediation, __self__).__init__(
            'azure:management/groupPolicyRemediation:GroupPolicyRemediation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            failure_percentage: Optional[pulumi.Input[_builtins.float]] = None,
            location_filters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            management_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parallel_deployments: Optional[pulumi.Input[_builtins.int]] = None,
            policy_assignment_id: Optional[pulumi.Input[_builtins.str]] = None,
            policy_definition_reference_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_count: Optional[pulumi.Input[_builtins.int]] = None) -> 'GroupPolicyRemediation':
        """
        Get an existing GroupPolicyRemediation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.float] failure_percentage: A number between 0.0 to 1.0 representing the percentage failure threshold. The remediation will fail if the percentage of failed remediation operations (i.e. failed deployments) exceeds this threshold.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] location_filters: A list of the resource locations that will be remediated.
        :param pulumi.Input[_builtins.str] management_group_id: The Management Group ID at which the Policy Remediation should be applied. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Policy Remediation. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] parallel_deployments: Determines how many resources to remediate at any given time. Can be used to increase or reduce the pace of the remediation. If not provided, the default parallel deployments value is used.
        :param pulumi.Input[_builtins.str] policy_assignment_id: The ID of the Policy Assignment that should be remediated.
        :param pulumi.Input[_builtins.str] policy_definition_reference_id: The unique ID for the policy definition reference within the policy set definition that should be remediated. Required when the policy assignment being remediated assigns a policy set definition.
        :param pulumi.Input[_builtins.int] resource_count: Determines the max number of resources that can be remediated by the remediation job. If not provided, the default resource count is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupPolicyRemediationState.__new__(_GroupPolicyRemediationState)

        __props__.__dict__["failure_percentage"] = failure_percentage
        __props__.__dict__["location_filters"] = location_filters
        __props__.__dict__["management_group_id"] = management_group_id
        __props__.__dict__["name"] = name
        __props__.__dict__["parallel_deployments"] = parallel_deployments
        __props__.__dict__["policy_assignment_id"] = policy_assignment_id
        __props__.__dict__["policy_definition_reference_id"] = policy_definition_reference_id
        __props__.__dict__["resource_count"] = resource_count
        return GroupPolicyRemediation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="failurePercentage")
    def failure_percentage(self) -> pulumi.Output[Optional[_builtins.float]]:
        """
        A number between 0.0 to 1.0 representing the percentage failure threshold. The remediation will fail if the percentage of failed remediation operations (i.e. failed deployments) exceeds this threshold.
        """
        return pulumi.get(self, "failure_percentage")

    @_builtins.property
    @pulumi.getter(name="locationFilters")
    def location_filters(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of the resource locations that will be remediated.
        """
        return pulumi.get(self, "location_filters")

    @_builtins.property
    @pulumi.getter(name="managementGroupId")
    def management_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Management Group ID at which the Policy Remediation should be applied. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "management_group_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Policy Remediation. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="parallelDeployments")
    def parallel_deployments(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Determines how many resources to remediate at any given time. Can be used to increase or reduce the pace of the remediation. If not provided, the default parallel deployments value is used.
        """
        return pulumi.get(self, "parallel_deployments")

    @_builtins.property
    @pulumi.getter(name="policyAssignmentId")
    def policy_assignment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Policy Assignment that should be remediated.
        """
        return pulumi.get(self, "policy_assignment_id")

    @_builtins.property
    @pulumi.getter(name="policyDefinitionReferenceId")
    def policy_definition_reference_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The unique ID for the policy definition reference within the policy set definition that should be remediated. Required when the policy assignment being remediated assigns a policy set definition.
        """
        return pulumi.get(self, "policy_definition_reference_id")

    @_builtins.property
    @pulumi.getter(name="resourceCount")
    def resource_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Determines the max number of resources that can be remediated by the remediation job. If not provided, the default resource count is used.
        """
        return pulumi.get(self, "resource_count")

