# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkPacketCoreControlPlaneArgs', 'NetworkPacketCoreControlPlane']

@pulumi.input_type
class NetworkPacketCoreControlPlaneArgs:
    def __init__(__self__, *,
                 local_diagnostics_access: pulumi.Input['NetworkPacketCoreControlPlaneLocalDiagnosticsAccessArgs'],
                 resource_group_name: pulumi.Input[_builtins.str],
                 site_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 sku: pulumi.Input[_builtins.str],
                 control_plane_access_ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
                 control_plane_access_ipv4_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 control_plane_access_ipv4_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 control_plane_access_name: Optional[pulumi.Input[_builtins.str]] = None,
                 core_network_technology: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['NetworkPacketCoreControlPlaneIdentityArgs']] = None,
                 interoperability_settings_json: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input['NetworkPacketCoreControlPlanePlatformArgs']] = None,
                 software_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_equipment_mtu_in_bytes: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a NetworkPacketCoreControlPlane resource.
        :param pulumi.Input['NetworkPacketCoreControlPlaneLocalDiagnosticsAccessArgs'] local_diagnostics_access: One or more `local_diagnostics_access` blocks as defined below. Specifies the Kubernetes ingress configuration that controls access to the packet core diagnostics through local APIs.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Mobile Network Packet Core Control Plane should exist. Changing this forces a new Mobile Network Packet Core Control Plane to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] site_ids: A list of Mobile Network Site IDs in which this packet core control plane should be deployed. The Sites must be in the same location as the packet core control plane. Currently, the API supports exactly 1 resource ID in the list. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: The SKU defining the throughput and SIM allowances for this packet core control plane deployment. Possible values are `G0`, `G1`, `G2`, `G3`, `G4`, `G5` and `G10`.
        :param pulumi.Input[_builtins.str] control_plane_access_ipv4_address: The IPv4 address for the control plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        :param pulumi.Input[_builtins.str] control_plane_access_ipv4_gateway: The default IPv4 gateway for the control plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        :param pulumi.Input[_builtins.str] control_plane_access_ipv4_subnet: The IPv4 subnet for the control plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        :param pulumi.Input[_builtins.str] control_plane_access_name: Specifies the logical name for this interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        :param pulumi.Input[_builtins.str] core_network_technology: The core network technology generation. Possible values are `5GC` and `EPC`.
        :param pulumi.Input['NetworkPacketCoreControlPlaneIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] interoperability_settings_json: Settings in JSON format to allow interoperability with third party components e.g. RANs and UEs.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Mobile Network Packet Core Control Plane should exist. Changing this forces a new Mobile Network Packet Core Control Plane to be created.
        :param pulumi.Input[_builtins.str] name: Specifies The name of the Mobile Network Packet Core Control Plane. Changing this forces a new Mobile Network Packet Core Control Plane to be created.
        :param pulumi.Input['NetworkPacketCoreControlPlanePlatformArgs'] platform: A `platform` block as defined below.
        :param pulumi.Input[_builtins.str] software_version: Specifies the version of the packet core software that is deployed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Mobile Network Packet Core Control Plane.
        :param pulumi.Input[_builtins.int] user_equipment_mtu_in_bytes: Specifies the MTU in bytes that can be sent to the user equipment. The same MTU is set on the user plane data links for all data networks. The MTU set on the user plane access link will be 60 bytes greater than this value to allow for GTP encapsulation.
        """
        pulumi.set(__self__, "local_diagnostics_access", local_diagnostics_access)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "site_ids", site_ids)
        pulumi.set(__self__, "sku", sku)
        if control_plane_access_ipv4_address is not None:
            pulumi.set(__self__, "control_plane_access_ipv4_address", control_plane_access_ipv4_address)
        if control_plane_access_ipv4_gateway is not None:
            pulumi.set(__self__, "control_plane_access_ipv4_gateway", control_plane_access_ipv4_gateway)
        if control_plane_access_ipv4_subnet is not None:
            pulumi.set(__self__, "control_plane_access_ipv4_subnet", control_plane_access_ipv4_subnet)
        if control_plane_access_name is not None:
            pulumi.set(__self__, "control_plane_access_name", control_plane_access_name)
        if core_network_technology is not None:
            pulumi.set(__self__, "core_network_technology", core_network_technology)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if interoperability_settings_json is not None:
            pulumi.set(__self__, "interoperability_settings_json", interoperability_settings_json)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if software_version is not None:
            pulumi.set(__self__, "software_version", software_version)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_equipment_mtu_in_bytes is not None:
            pulumi.set(__self__, "user_equipment_mtu_in_bytes", user_equipment_mtu_in_bytes)

    @_builtins.property
    @pulumi.getter(name="localDiagnosticsAccess")
    def local_diagnostics_access(self) -> pulumi.Input['NetworkPacketCoreControlPlaneLocalDiagnosticsAccessArgs']:
        """
        One or more `local_diagnostics_access` blocks as defined below. Specifies the Kubernetes ingress configuration that controls access to the packet core diagnostics through local APIs.
        """
        return pulumi.get(self, "local_diagnostics_access")

    @local_diagnostics_access.setter
    def local_diagnostics_access(self, value: pulumi.Input['NetworkPacketCoreControlPlaneLocalDiagnosticsAccessArgs']):
        pulumi.set(self, "local_diagnostics_access", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Resource Group where the Mobile Network Packet Core Control Plane should exist. Changing this forces a new Mobile Network Packet Core Control Plane to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="siteIds")
    def site_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of Mobile Network Site IDs in which this packet core control plane should be deployed. The Sites must be in the same location as the packet core control plane. Currently, the API supports exactly 1 resource ID in the list. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "site_ids")

    @site_ids.setter
    def site_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "site_ids", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Input[_builtins.str]:
        """
        The SKU defining the throughput and SIM allowances for this packet core control plane deployment. Possible values are `G0`, `G1`, `G2`, `G3`, `G4`, `G5` and `G10`.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="controlPlaneAccessIpv4Address")
    def control_plane_access_ipv4_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 address for the control plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        """
        return pulumi.get(self, "control_plane_access_ipv4_address")

    @control_plane_access_ipv4_address.setter
    def control_plane_access_ipv4_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "control_plane_access_ipv4_address", value)

    @_builtins.property
    @pulumi.getter(name="controlPlaneAccessIpv4Gateway")
    def control_plane_access_ipv4_gateway(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default IPv4 gateway for the control plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        """
        return pulumi.get(self, "control_plane_access_ipv4_gateway")

    @control_plane_access_ipv4_gateway.setter
    def control_plane_access_ipv4_gateway(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "control_plane_access_ipv4_gateway", value)

    @_builtins.property
    @pulumi.getter(name="controlPlaneAccessIpv4Subnet")
    def control_plane_access_ipv4_subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 subnet for the control plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        """
        return pulumi.get(self, "control_plane_access_ipv4_subnet")

    @control_plane_access_ipv4_subnet.setter
    def control_plane_access_ipv4_subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "control_plane_access_ipv4_subnet", value)

    @_builtins.property
    @pulumi.getter(name="controlPlaneAccessName")
    def control_plane_access_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the logical name for this interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        """
        return pulumi.get(self, "control_plane_access_name")

    @control_plane_access_name.setter
    def control_plane_access_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "control_plane_access_name", value)

    @_builtins.property
    @pulumi.getter(name="coreNetworkTechnology")
    def core_network_technology(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The core network technology generation. Possible values are `5GC` and `EPC`.
        """
        return pulumi.get(self, "core_network_technology")

    @core_network_technology.setter
    def core_network_technology(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "core_network_technology", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['NetworkPacketCoreControlPlaneIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['NetworkPacketCoreControlPlaneIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="interoperabilitySettingsJson")
    def interoperability_settings_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Settings in JSON format to allow interoperability with third party components e.g. RANs and UEs.
        """
        return pulumi.get(self, "interoperability_settings_json")

    @interoperability_settings_json.setter
    def interoperability_settings_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interoperability_settings_json", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Mobile Network Packet Core Control Plane should exist. Changing this forces a new Mobile Network Packet Core Control Plane to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies The name of the Mobile Network Packet Core Control Plane. Changing this forces a new Mobile Network Packet Core Control Plane to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input['NetworkPacketCoreControlPlanePlatformArgs']]:
        """
        A `platform` block as defined below.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input['NetworkPacketCoreControlPlanePlatformArgs']]):
        pulumi.set(self, "platform", value)

    @_builtins.property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the version of the packet core software that is deployed.
        """
        return pulumi.get(self, "software_version")

    @software_version.setter
    def software_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "software_version", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Mobile Network Packet Core Control Plane.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="userEquipmentMtuInBytes")
    def user_equipment_mtu_in_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the MTU in bytes that can be sent to the user equipment. The same MTU is set on the user plane data links for all data networks. The MTU set on the user plane access link will be 60 bytes greater than this value to allow for GTP encapsulation.
        """
        return pulumi.get(self, "user_equipment_mtu_in_bytes")

    @user_equipment_mtu_in_bytes.setter
    def user_equipment_mtu_in_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "user_equipment_mtu_in_bytes", value)


@pulumi.input_type
class _NetworkPacketCoreControlPlaneState:
    def __init__(__self__, *,
                 control_plane_access_ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
                 control_plane_access_ipv4_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 control_plane_access_ipv4_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 control_plane_access_name: Optional[pulumi.Input[_builtins.str]] = None,
                 core_network_technology: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['NetworkPacketCoreControlPlaneIdentityArgs']] = None,
                 interoperability_settings_json: Optional[pulumi.Input[_builtins.str]] = None,
                 local_diagnostics_access: Optional[pulumi.Input['NetworkPacketCoreControlPlaneLocalDiagnosticsAccessArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input['NetworkPacketCoreControlPlanePlatformArgs']] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 software_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_equipment_mtu_in_bytes: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering NetworkPacketCoreControlPlane resources.
        :param pulumi.Input[_builtins.str] control_plane_access_ipv4_address: The IPv4 address for the control plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        :param pulumi.Input[_builtins.str] control_plane_access_ipv4_gateway: The default IPv4 gateway for the control plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        :param pulumi.Input[_builtins.str] control_plane_access_ipv4_subnet: The IPv4 subnet for the control plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        :param pulumi.Input[_builtins.str] control_plane_access_name: Specifies the logical name for this interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        :param pulumi.Input[_builtins.str] core_network_technology: The core network technology generation. Possible values are `5GC` and `EPC`.
        :param pulumi.Input['NetworkPacketCoreControlPlaneIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] interoperability_settings_json: Settings in JSON format to allow interoperability with third party components e.g. RANs and UEs.
        :param pulumi.Input['NetworkPacketCoreControlPlaneLocalDiagnosticsAccessArgs'] local_diagnostics_access: One or more `local_diagnostics_access` blocks as defined below. Specifies the Kubernetes ingress configuration that controls access to the packet core diagnostics through local APIs.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Mobile Network Packet Core Control Plane should exist. Changing this forces a new Mobile Network Packet Core Control Plane to be created.
        :param pulumi.Input[_builtins.str] name: Specifies The name of the Mobile Network Packet Core Control Plane. Changing this forces a new Mobile Network Packet Core Control Plane to be created.
        :param pulumi.Input['NetworkPacketCoreControlPlanePlatformArgs'] platform: A `platform` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Mobile Network Packet Core Control Plane should exist. Changing this forces a new Mobile Network Packet Core Control Plane to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] site_ids: A list of Mobile Network Site IDs in which this packet core control plane should be deployed. The Sites must be in the same location as the packet core control plane. Currently, the API supports exactly 1 resource ID in the list. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: The SKU defining the throughput and SIM allowances for this packet core control plane deployment. Possible values are `G0`, `G1`, `G2`, `G3`, `G4`, `G5` and `G10`.
        :param pulumi.Input[_builtins.str] software_version: Specifies the version of the packet core software that is deployed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Mobile Network Packet Core Control Plane.
        :param pulumi.Input[_builtins.int] user_equipment_mtu_in_bytes: Specifies the MTU in bytes that can be sent to the user equipment. The same MTU is set on the user plane data links for all data networks. The MTU set on the user plane access link will be 60 bytes greater than this value to allow for GTP encapsulation.
        """
        if control_plane_access_ipv4_address is not None:
            pulumi.set(__self__, "control_plane_access_ipv4_address", control_plane_access_ipv4_address)
        if control_plane_access_ipv4_gateway is not None:
            pulumi.set(__self__, "control_plane_access_ipv4_gateway", control_plane_access_ipv4_gateway)
        if control_plane_access_ipv4_subnet is not None:
            pulumi.set(__self__, "control_plane_access_ipv4_subnet", control_plane_access_ipv4_subnet)
        if control_plane_access_name is not None:
            pulumi.set(__self__, "control_plane_access_name", control_plane_access_name)
        if core_network_technology is not None:
            pulumi.set(__self__, "core_network_technology", core_network_technology)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if interoperability_settings_json is not None:
            pulumi.set(__self__, "interoperability_settings_json", interoperability_settings_json)
        if local_diagnostics_access is not None:
            pulumi.set(__self__, "local_diagnostics_access", local_diagnostics_access)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if site_ids is not None:
            pulumi.set(__self__, "site_ids", site_ids)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if software_version is not None:
            pulumi.set(__self__, "software_version", software_version)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_equipment_mtu_in_bytes is not None:
            pulumi.set(__self__, "user_equipment_mtu_in_bytes", user_equipment_mtu_in_bytes)

    @_builtins.property
    @pulumi.getter(name="controlPlaneAccessIpv4Address")
    def control_plane_access_ipv4_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 address for the control plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        """
        return pulumi.get(self, "control_plane_access_ipv4_address")

    @control_plane_access_ipv4_address.setter
    def control_plane_access_ipv4_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "control_plane_access_ipv4_address", value)

    @_builtins.property
    @pulumi.getter(name="controlPlaneAccessIpv4Gateway")
    def control_plane_access_ipv4_gateway(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default IPv4 gateway for the control plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        """
        return pulumi.get(self, "control_plane_access_ipv4_gateway")

    @control_plane_access_ipv4_gateway.setter
    def control_plane_access_ipv4_gateway(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "control_plane_access_ipv4_gateway", value)

    @_builtins.property
    @pulumi.getter(name="controlPlaneAccessIpv4Subnet")
    def control_plane_access_ipv4_subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv4 subnet for the control plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        """
        return pulumi.get(self, "control_plane_access_ipv4_subnet")

    @control_plane_access_ipv4_subnet.setter
    def control_plane_access_ipv4_subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "control_plane_access_ipv4_subnet", value)

    @_builtins.property
    @pulumi.getter(name="controlPlaneAccessName")
    def control_plane_access_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the logical name for this interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        """
        return pulumi.get(self, "control_plane_access_name")

    @control_plane_access_name.setter
    def control_plane_access_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "control_plane_access_name", value)

    @_builtins.property
    @pulumi.getter(name="coreNetworkTechnology")
    def core_network_technology(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The core network technology generation. Possible values are `5GC` and `EPC`.
        """
        return pulumi.get(self, "core_network_technology")

    @core_network_technology.setter
    def core_network_technology(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "core_network_technology", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['NetworkPacketCoreControlPlaneIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['NetworkPacketCoreControlPlaneIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="interoperabilitySettingsJson")
    def interoperability_settings_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Settings in JSON format to allow interoperability with third party components e.g. RANs and UEs.
        """
        return pulumi.get(self, "interoperability_settings_json")

    @interoperability_settings_json.setter
    def interoperability_settings_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interoperability_settings_json", value)

    @_builtins.property
    @pulumi.getter(name="localDiagnosticsAccess")
    def local_diagnostics_access(self) -> Optional[pulumi.Input['NetworkPacketCoreControlPlaneLocalDiagnosticsAccessArgs']]:
        """
        One or more `local_diagnostics_access` blocks as defined below. Specifies the Kubernetes ingress configuration that controls access to the packet core diagnostics through local APIs.
        """
        return pulumi.get(self, "local_diagnostics_access")

    @local_diagnostics_access.setter
    def local_diagnostics_access(self, value: Optional[pulumi.Input['NetworkPacketCoreControlPlaneLocalDiagnosticsAccessArgs']]):
        pulumi.set(self, "local_diagnostics_access", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Mobile Network Packet Core Control Plane should exist. Changing this forces a new Mobile Network Packet Core Control Plane to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies The name of the Mobile Network Packet Core Control Plane. Changing this forces a new Mobile Network Packet Core Control Plane to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input['NetworkPacketCoreControlPlanePlatformArgs']]:
        """
        A `platform` block as defined below.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input['NetworkPacketCoreControlPlanePlatformArgs']]):
        pulumi.set(self, "platform", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Resource Group where the Mobile Network Packet Core Control Plane should exist. Changing this forces a new Mobile Network Packet Core Control Plane to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="siteIds")
    def site_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of Mobile Network Site IDs in which this packet core control plane should be deployed. The Sites must be in the same location as the packet core control plane. Currently, the API supports exactly 1 resource ID in the list. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "site_ids")

    @site_ids.setter
    def site_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "site_ids", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SKU defining the throughput and SIM allowances for this packet core control plane deployment. Possible values are `G0`, `G1`, `G2`, `G3`, `G4`, `G5` and `G10`.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the version of the packet core software that is deployed.
        """
        return pulumi.get(self, "software_version")

    @software_version.setter
    def software_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "software_version", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Mobile Network Packet Core Control Plane.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="userEquipmentMtuInBytes")
    def user_equipment_mtu_in_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the MTU in bytes that can be sent to the user equipment. The same MTU is set on the user plane data links for all data networks. The MTU set on the user plane access link will be 60 bytes greater than this value to allow for GTP encapsulation.
        """
        return pulumi.get(self, "user_equipment_mtu_in_bytes")

    @user_equipment_mtu_in_bytes.setter
    def user_equipment_mtu_in_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "user_equipment_mtu_in_bytes", value)


@pulumi.type_token("azure:mobile/networkPacketCoreControlPlane:NetworkPacketCoreControlPlane")
class NetworkPacketCoreControlPlane(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 control_plane_access_ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
                 control_plane_access_ipv4_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 control_plane_access_ipv4_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 control_plane_access_name: Optional[pulumi.Input[_builtins.str]] = None,
                 core_network_technology: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['NetworkPacketCoreControlPlaneIdentityArgs', 'NetworkPacketCoreControlPlaneIdentityArgsDict']]] = None,
                 interoperability_settings_json: Optional[pulumi.Input[_builtins.str]] = None,
                 local_diagnostics_access: Optional[pulumi.Input[Union['NetworkPacketCoreControlPlaneLocalDiagnosticsAccessArgs', 'NetworkPacketCoreControlPlaneLocalDiagnosticsAccessArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[Union['NetworkPacketCoreControlPlanePlatformArgs', 'NetworkPacketCoreControlPlanePlatformArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 software_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_equipment_mtu_in_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages a Mobile Network Packet Core Control Plane.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_network = azure.mobile.Network("example",
            name="example-mn",
            resource_group_name=example.name,
            location=example.location,
            mobile_country_code="001",
            mobile_network_code="01")
        example_network_site = azure.mobile.NetworkSite("example",
            name="example-mns",
            mobile_network_id=test["id"],
            location=example.location)
        example_device = azure.databoxedge.Device("example",
            name="example-device",
            resource_group_name=example.name,
            location=example.location,
            sku_name="EdgeP_Base-Standard")
        example_network_packet_core_control_plane = azure.mobile.NetworkPacketCoreControlPlane("example",
            name="example-mnpccp",
            resource_group_name=example.name,
            location=example.location,
            sku="G0",
            control_plane_access_name="default-interface",
            control_plane_access_ipv4_address="192.168.1.199",
            control_plane_access_ipv4_gateway="192.168.1.1",
            control_plane_access_ipv4_subnet="192.168.1.0/25",
            site_ids=[example_network_site.id],
            local_diagnostics_access={
                "authentication_type": "AAD",
            },
            platform={
                "type": "AKS-HCI",
                "edge_device_id": example_device.id,
            },
            interoperability_settings_json=json.dumps({
                "key": "value",
            }),
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.MobileNetwork` - 2022-11-01

        ## Import

        Mobile Network Packet Core Control Plane can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mobile/networkPacketCoreControlPlane:NetworkPacketCoreControlPlane example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/packetCoreControlPlane1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] control_plane_access_ipv4_address: The IPv4 address for the control plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        :param pulumi.Input[_builtins.str] control_plane_access_ipv4_gateway: The default IPv4 gateway for the control plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        :param pulumi.Input[_builtins.str] control_plane_access_ipv4_subnet: The IPv4 subnet for the control plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        :param pulumi.Input[_builtins.str] control_plane_access_name: Specifies the logical name for this interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        :param pulumi.Input[_builtins.str] core_network_technology: The core network technology generation. Possible values are `5GC` and `EPC`.
        :param pulumi.Input[Union['NetworkPacketCoreControlPlaneIdentityArgs', 'NetworkPacketCoreControlPlaneIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] interoperability_settings_json: Settings in JSON format to allow interoperability with third party components e.g. RANs and UEs.
        :param pulumi.Input[Union['NetworkPacketCoreControlPlaneLocalDiagnosticsAccessArgs', 'NetworkPacketCoreControlPlaneLocalDiagnosticsAccessArgsDict']] local_diagnostics_access: One or more `local_diagnostics_access` blocks as defined below. Specifies the Kubernetes ingress configuration that controls access to the packet core diagnostics through local APIs.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Mobile Network Packet Core Control Plane should exist. Changing this forces a new Mobile Network Packet Core Control Plane to be created.
        :param pulumi.Input[_builtins.str] name: Specifies The name of the Mobile Network Packet Core Control Plane. Changing this forces a new Mobile Network Packet Core Control Plane to be created.
        :param pulumi.Input[Union['NetworkPacketCoreControlPlanePlatformArgs', 'NetworkPacketCoreControlPlanePlatformArgsDict']] platform: A `platform` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Mobile Network Packet Core Control Plane should exist. Changing this forces a new Mobile Network Packet Core Control Plane to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] site_ids: A list of Mobile Network Site IDs in which this packet core control plane should be deployed. The Sites must be in the same location as the packet core control plane. Currently, the API supports exactly 1 resource ID in the list. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: The SKU defining the throughput and SIM allowances for this packet core control plane deployment. Possible values are `G0`, `G1`, `G2`, `G3`, `G4`, `G5` and `G10`.
        :param pulumi.Input[_builtins.str] software_version: Specifies the version of the packet core software that is deployed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Mobile Network Packet Core Control Plane.
        :param pulumi.Input[_builtins.int] user_equipment_mtu_in_bytes: Specifies the MTU in bytes that can be sent to the user equipment. The same MTU is set on the user plane data links for all data networks. The MTU set on the user plane access link will be 60 bytes greater than this value to allow for GTP encapsulation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkPacketCoreControlPlaneArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Mobile Network Packet Core Control Plane.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_network = azure.mobile.Network("example",
            name="example-mn",
            resource_group_name=example.name,
            location=example.location,
            mobile_country_code="001",
            mobile_network_code="01")
        example_network_site = azure.mobile.NetworkSite("example",
            name="example-mns",
            mobile_network_id=test["id"],
            location=example.location)
        example_device = azure.databoxedge.Device("example",
            name="example-device",
            resource_group_name=example.name,
            location=example.location,
            sku_name="EdgeP_Base-Standard")
        example_network_packet_core_control_plane = azure.mobile.NetworkPacketCoreControlPlane("example",
            name="example-mnpccp",
            resource_group_name=example.name,
            location=example.location,
            sku="G0",
            control_plane_access_name="default-interface",
            control_plane_access_ipv4_address="192.168.1.199",
            control_plane_access_ipv4_gateway="192.168.1.1",
            control_plane_access_ipv4_subnet="192.168.1.0/25",
            site_ids=[example_network_site.id],
            local_diagnostics_access={
                "authentication_type": "AAD",
            },
            platform={
                "type": "AKS-HCI",
                "edge_device_id": example_device.id,
            },
            interoperability_settings_json=json.dumps({
                "key": "value",
            }),
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.MobileNetwork` - 2022-11-01

        ## Import

        Mobile Network Packet Core Control Plane can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mobile/networkPacketCoreControlPlane:NetworkPacketCoreControlPlane example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.MobileNetwork/packetCoreControlPlanes/packetCoreControlPlane1
        ```

        :param str resource_name: The name of the resource.
        :param NetworkPacketCoreControlPlaneArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkPacketCoreControlPlaneArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 control_plane_access_ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
                 control_plane_access_ipv4_gateway: Optional[pulumi.Input[_builtins.str]] = None,
                 control_plane_access_ipv4_subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 control_plane_access_name: Optional[pulumi.Input[_builtins.str]] = None,
                 core_network_technology: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['NetworkPacketCoreControlPlaneIdentityArgs', 'NetworkPacketCoreControlPlaneIdentityArgsDict']]] = None,
                 interoperability_settings_json: Optional[pulumi.Input[_builtins.str]] = None,
                 local_diagnostics_access: Optional[pulumi.Input[Union['NetworkPacketCoreControlPlaneLocalDiagnosticsAccessArgs', 'NetworkPacketCoreControlPlaneLocalDiagnosticsAccessArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[Union['NetworkPacketCoreControlPlanePlatformArgs', 'NetworkPacketCoreControlPlanePlatformArgsDict']]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 site_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 software_version: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_equipment_mtu_in_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkPacketCoreControlPlaneArgs.__new__(NetworkPacketCoreControlPlaneArgs)

            __props__.__dict__["control_plane_access_ipv4_address"] = control_plane_access_ipv4_address
            __props__.__dict__["control_plane_access_ipv4_gateway"] = control_plane_access_ipv4_gateway
            __props__.__dict__["control_plane_access_ipv4_subnet"] = control_plane_access_ipv4_subnet
            __props__.__dict__["control_plane_access_name"] = control_plane_access_name
            __props__.__dict__["core_network_technology"] = core_network_technology
            __props__.__dict__["identity"] = identity
            __props__.__dict__["interoperability_settings_json"] = interoperability_settings_json
            if local_diagnostics_access is None and not opts.urn:
                raise TypeError("Missing required property 'local_diagnostics_access'")
            __props__.__dict__["local_diagnostics_access"] = local_diagnostics_access
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["platform"] = platform
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if site_ids is None and not opts.urn:
                raise TypeError("Missing required property 'site_ids'")
            __props__.__dict__["site_ids"] = site_ids
            if sku is None and not opts.urn:
                raise TypeError("Missing required property 'sku'")
            __props__.__dict__["sku"] = sku
            __props__.__dict__["software_version"] = software_version
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_equipment_mtu_in_bytes"] = user_equipment_mtu_in_bytes
        super(NetworkPacketCoreControlPlane, __self__).__init__(
            'azure:mobile/networkPacketCoreControlPlane:NetworkPacketCoreControlPlane',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            control_plane_access_ipv4_address: Optional[pulumi.Input[_builtins.str]] = None,
            control_plane_access_ipv4_gateway: Optional[pulumi.Input[_builtins.str]] = None,
            control_plane_access_ipv4_subnet: Optional[pulumi.Input[_builtins.str]] = None,
            control_plane_access_name: Optional[pulumi.Input[_builtins.str]] = None,
            core_network_technology: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['NetworkPacketCoreControlPlaneIdentityArgs', 'NetworkPacketCoreControlPlaneIdentityArgsDict']]] = None,
            interoperability_settings_json: Optional[pulumi.Input[_builtins.str]] = None,
            local_diagnostics_access: Optional[pulumi.Input[Union['NetworkPacketCoreControlPlaneLocalDiagnosticsAccessArgs', 'NetworkPacketCoreControlPlaneLocalDiagnosticsAccessArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            platform: Optional[pulumi.Input[Union['NetworkPacketCoreControlPlanePlatformArgs', 'NetworkPacketCoreControlPlanePlatformArgsDict']]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            site_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            sku: Optional[pulumi.Input[_builtins.str]] = None,
            software_version: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            user_equipment_mtu_in_bytes: Optional[pulumi.Input[_builtins.int]] = None) -> 'NetworkPacketCoreControlPlane':
        """
        Get an existing NetworkPacketCoreControlPlane resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] control_plane_access_ipv4_address: The IPv4 address for the control plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        :param pulumi.Input[_builtins.str] control_plane_access_ipv4_gateway: The default IPv4 gateway for the control plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        :param pulumi.Input[_builtins.str] control_plane_access_ipv4_subnet: The IPv4 subnet for the control plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        :param pulumi.Input[_builtins.str] control_plane_access_name: Specifies the logical name for this interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        :param pulumi.Input[_builtins.str] core_network_technology: The core network technology generation. Possible values are `5GC` and `EPC`.
        :param pulumi.Input[Union['NetworkPacketCoreControlPlaneIdentityArgs', 'NetworkPacketCoreControlPlaneIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] interoperability_settings_json: Settings in JSON format to allow interoperability with third party components e.g. RANs and UEs.
        :param pulumi.Input[Union['NetworkPacketCoreControlPlaneLocalDiagnosticsAccessArgs', 'NetworkPacketCoreControlPlaneLocalDiagnosticsAccessArgsDict']] local_diagnostics_access: One or more `local_diagnostics_access` blocks as defined below. Specifies the Kubernetes ingress configuration that controls access to the packet core diagnostics through local APIs.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Mobile Network Packet Core Control Plane should exist. Changing this forces a new Mobile Network Packet Core Control Plane to be created.
        :param pulumi.Input[_builtins.str] name: Specifies The name of the Mobile Network Packet Core Control Plane. Changing this forces a new Mobile Network Packet Core Control Plane to be created.
        :param pulumi.Input[Union['NetworkPacketCoreControlPlanePlatformArgs', 'NetworkPacketCoreControlPlanePlatformArgsDict']] platform: A `platform` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Mobile Network Packet Core Control Plane should exist. Changing this forces a new Mobile Network Packet Core Control Plane to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] site_ids: A list of Mobile Network Site IDs in which this packet core control plane should be deployed. The Sites must be in the same location as the packet core control plane. Currently, the API supports exactly 1 resource ID in the list. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: The SKU defining the throughput and SIM allowances for this packet core control plane deployment. Possible values are `G0`, `G1`, `G2`, `G3`, `G4`, `G5` and `G10`.
        :param pulumi.Input[_builtins.str] software_version: Specifies the version of the packet core software that is deployed.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Mobile Network Packet Core Control Plane.
        :param pulumi.Input[_builtins.int] user_equipment_mtu_in_bytes: Specifies the MTU in bytes that can be sent to the user equipment. The same MTU is set on the user plane data links for all data networks. The MTU set on the user plane access link will be 60 bytes greater than this value to allow for GTP encapsulation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkPacketCoreControlPlaneState.__new__(_NetworkPacketCoreControlPlaneState)

        __props__.__dict__["control_plane_access_ipv4_address"] = control_plane_access_ipv4_address
        __props__.__dict__["control_plane_access_ipv4_gateway"] = control_plane_access_ipv4_gateway
        __props__.__dict__["control_plane_access_ipv4_subnet"] = control_plane_access_ipv4_subnet
        __props__.__dict__["control_plane_access_name"] = control_plane_access_name
        __props__.__dict__["core_network_technology"] = core_network_technology
        __props__.__dict__["identity"] = identity
        __props__.__dict__["interoperability_settings_json"] = interoperability_settings_json
        __props__.__dict__["local_diagnostics_access"] = local_diagnostics_access
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["platform"] = platform
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["site_ids"] = site_ids
        __props__.__dict__["sku"] = sku
        __props__.__dict__["software_version"] = software_version
        __props__.__dict__["tags"] = tags
        __props__.__dict__["user_equipment_mtu_in_bytes"] = user_equipment_mtu_in_bytes
        return NetworkPacketCoreControlPlane(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="controlPlaneAccessIpv4Address")
    def control_plane_access_ipv4_address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IPv4 address for the control plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        """
        return pulumi.get(self, "control_plane_access_ipv4_address")

    @_builtins.property
    @pulumi.getter(name="controlPlaneAccessIpv4Gateway")
    def control_plane_access_ipv4_gateway(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The default IPv4 gateway for the control plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        """
        return pulumi.get(self, "control_plane_access_ipv4_gateway")

    @_builtins.property
    @pulumi.getter(name="controlPlaneAccessIpv4Subnet")
    def control_plane_access_ipv4_subnet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The IPv4 subnet for the control plane interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        """
        return pulumi.get(self, "control_plane_access_ipv4_subnet")

    @_builtins.property
    @pulumi.getter(name="controlPlaneAccessName")
    def control_plane_access_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the logical name for this interface. This should match one of the interfaces configured on your Azure Stack Edge device.
        """
        return pulumi.get(self, "control_plane_access_name")

    @_builtins.property
    @pulumi.getter(name="coreNetworkTechnology")
    def core_network_technology(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The core network technology generation. Possible values are `5GC` and `EPC`.
        """
        return pulumi.get(self, "core_network_technology")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.NetworkPacketCoreControlPlaneIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="interoperabilitySettingsJson")
    def interoperability_settings_json(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Settings in JSON format to allow interoperability with third party components e.g. RANs and UEs.
        """
        return pulumi.get(self, "interoperability_settings_json")

    @_builtins.property
    @pulumi.getter(name="localDiagnosticsAccess")
    def local_diagnostics_access(self) -> pulumi.Output['outputs.NetworkPacketCoreControlPlaneLocalDiagnosticsAccess']:
        """
        One or more `local_diagnostics_access` blocks as defined below. Specifies the Kubernetes ingress configuration that controls access to the packet core diagnostics through local APIs.
        """
        return pulumi.get(self, "local_diagnostics_access")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Azure Region where the Mobile Network Packet Core Control Plane should exist. Changing this forces a new Mobile Network Packet Core Control Plane to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies The name of the Mobile Network Packet Core Control Plane. Changing this forces a new Mobile Network Packet Core Control Plane to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def platform(self) -> pulumi.Output[Optional['outputs.NetworkPacketCoreControlPlanePlatform']]:
        """
        A `platform` block as defined below.
        """
        return pulumi.get(self, "platform")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Resource Group where the Mobile Network Packet Core Control Plane should exist. Changing this forces a new Mobile Network Packet Core Control Plane to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="siteIds")
    def site_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of Mobile Network Site IDs in which this packet core control plane should be deployed. The Sites must be in the same location as the packet core control plane. Currently, the API supports exactly 1 resource ID in the list. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "site_ids")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Output[_builtins.str]:
        """
        The SKU defining the throughput and SIM allowances for this packet core control plane deployment. Possible values are `G0`, `G1`, `G2`, `G3`, `G4`, `G5` and `G10`.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the version of the packet core software that is deployed.
        """
        return pulumi.get(self, "software_version")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Mobile Network Packet Core Control Plane.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="userEquipmentMtuInBytes")
    def user_equipment_mtu_in_bytes(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the MTU in bytes that can be sent to the user equipment. The same MTU is set on the user plane data links for all data networks. The MTU set on the user plane access link will be 60 bytes greater than this value to allow for GTP encapsulation.
        """
        return pulumi.get(self, "user_equipment_mtu_in_bytes")

