# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkSliceArgs', 'NetworkSlice']

@pulumi.input_type
class NetworkSliceArgs:
    def __init__(__self__, *,
                 mobile_network_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 single_network_slice_selection_assistance_information: Optional[pulumi.Input['NetworkSliceSingleNetworkSliceSelectionAssistanceInformationArgs']] = None,
                 slice_differentiator: Optional[pulumi.Input[_builtins.str]] = None,
                 slice_service_type: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a NetworkSlice resource.
        :param pulumi.Input[_builtins.str] mobile_network_id: The ID of Mobile Network which the Mobile Network Slice belongs to. Changing this forces a new Mobile Network Slice to be created.
        :param pulumi.Input[_builtins.str] description: A description for this Mobile Network Slice.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Mobile Network Slice should exist. Changing this forces a new Mobile Network Slice to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Mobile Network Slice. Changing this forces a new Mobile Network Slice to be created.
        :param pulumi.Input[_builtins.str] slice_differentiator: Slice differentiator (SD). Must be a 6 digit hex string. For single-network slice selection assistance information (S-NSSAI). Unique at the scope of a mobile network.
        :param pulumi.Input[_builtins.int] slice_service_type: Slice/service type (SST). Must be between `0` and `255`. For single-network slice selection assistance information (S-NSSAI). Unique at the scope of a mobile network.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Mobile Network Slice.
        """
        pulumi.set(__self__, "mobile_network_id", mobile_network_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if single_network_slice_selection_assistance_information is not None:
            warnings.warn("""`single_network_slice_selection_assistance_information` has been deprecated and its properties, `slice_differentiator` and `slice_service_type` have been moved to the top level. The `single_network_slice_selection_assistance_information` block will be removed in v5.0 of the AzureRM Provider.""", DeprecationWarning)
            pulumi.log.warn("""single_network_slice_selection_assistance_information is deprecated: `single_network_slice_selection_assistance_information` has been deprecated and its properties, `slice_differentiator` and `slice_service_type` have been moved to the top level. The `single_network_slice_selection_assistance_information` block will be removed in v5.0 of the AzureRM Provider.""")
        if single_network_slice_selection_assistance_information is not None:
            pulumi.set(__self__, "single_network_slice_selection_assistance_information", single_network_slice_selection_assistance_information)
        if slice_differentiator is not None:
            pulumi.set(__self__, "slice_differentiator", slice_differentiator)
        if slice_service_type is not None:
            pulumi.set(__self__, "slice_service_type", slice_service_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="mobileNetworkId")
    def mobile_network_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of Mobile Network which the Mobile Network Slice belongs to. Changing this forces a new Mobile Network Slice to be created.
        """
        return pulumi.get(self, "mobile_network_id")

    @mobile_network_id.setter
    def mobile_network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "mobile_network_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description for this Mobile Network Slice.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Mobile Network Slice should exist. Changing this forces a new Mobile Network Slice to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Mobile Network Slice. Changing this forces a new Mobile Network Slice to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="singleNetworkSliceSelectionAssistanceInformation")
    @_utilities.deprecated("""`single_network_slice_selection_assistance_information` has been deprecated and its properties, `slice_differentiator` and `slice_service_type` have been moved to the top level. The `single_network_slice_selection_assistance_information` block will be removed in v5.0 of the AzureRM Provider.""")
    def single_network_slice_selection_assistance_information(self) -> Optional[pulumi.Input['NetworkSliceSingleNetworkSliceSelectionAssistanceInformationArgs']]:
        return pulumi.get(self, "single_network_slice_selection_assistance_information")

    @single_network_slice_selection_assistance_information.setter
    def single_network_slice_selection_assistance_information(self, value: Optional[pulumi.Input['NetworkSliceSingleNetworkSliceSelectionAssistanceInformationArgs']]):
        pulumi.set(self, "single_network_slice_selection_assistance_information", value)

    @_builtins.property
    @pulumi.getter(name="sliceDifferentiator")
    def slice_differentiator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Slice differentiator (SD). Must be a 6 digit hex string. For single-network slice selection assistance information (S-NSSAI). Unique at the scope of a mobile network.
        """
        return pulumi.get(self, "slice_differentiator")

    @slice_differentiator.setter
    def slice_differentiator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slice_differentiator", value)

    @_builtins.property
    @pulumi.getter(name="sliceServiceType")
    def slice_service_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Slice/service type (SST). Must be between `0` and `255`. For single-network slice selection assistance information (S-NSSAI). Unique at the scope of a mobile network.
        """
        return pulumi.get(self, "slice_service_type")

    @slice_service_type.setter
    def slice_service_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "slice_service_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Mobile Network Slice.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _NetworkSliceState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 mobile_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 single_network_slice_selection_assistance_information: Optional[pulumi.Input['NetworkSliceSingleNetworkSliceSelectionAssistanceInformationArgs']] = None,
                 slice_differentiator: Optional[pulumi.Input[_builtins.str]] = None,
                 slice_service_type: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering NetworkSlice resources.
        :param pulumi.Input[_builtins.str] description: A description for this Mobile Network Slice.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Mobile Network Slice should exist. Changing this forces a new Mobile Network Slice to be created.
        :param pulumi.Input[_builtins.str] mobile_network_id: The ID of Mobile Network which the Mobile Network Slice belongs to. Changing this forces a new Mobile Network Slice to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Mobile Network Slice. Changing this forces a new Mobile Network Slice to be created.
        :param pulumi.Input[_builtins.str] slice_differentiator: Slice differentiator (SD). Must be a 6 digit hex string. For single-network slice selection assistance information (S-NSSAI). Unique at the scope of a mobile network.
        :param pulumi.Input[_builtins.int] slice_service_type: Slice/service type (SST). Must be between `0` and `255`. For single-network slice selection assistance information (S-NSSAI). Unique at the scope of a mobile network.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Mobile Network Slice.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if mobile_network_id is not None:
            pulumi.set(__self__, "mobile_network_id", mobile_network_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if single_network_slice_selection_assistance_information is not None:
            warnings.warn("""`single_network_slice_selection_assistance_information` has been deprecated and its properties, `slice_differentiator` and `slice_service_type` have been moved to the top level. The `single_network_slice_selection_assistance_information` block will be removed in v5.0 of the AzureRM Provider.""", DeprecationWarning)
            pulumi.log.warn("""single_network_slice_selection_assistance_information is deprecated: `single_network_slice_selection_assistance_information` has been deprecated and its properties, `slice_differentiator` and `slice_service_type` have been moved to the top level. The `single_network_slice_selection_assistance_information` block will be removed in v5.0 of the AzureRM Provider.""")
        if single_network_slice_selection_assistance_information is not None:
            pulumi.set(__self__, "single_network_slice_selection_assistance_information", single_network_slice_selection_assistance_information)
        if slice_differentiator is not None:
            pulumi.set(__self__, "slice_differentiator", slice_differentiator)
        if slice_service_type is not None:
            pulumi.set(__self__, "slice_service_type", slice_service_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description for this Mobile Network Slice.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Mobile Network Slice should exist. Changing this forces a new Mobile Network Slice to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="mobileNetworkId")
    def mobile_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of Mobile Network which the Mobile Network Slice belongs to. Changing this forces a new Mobile Network Slice to be created.
        """
        return pulumi.get(self, "mobile_network_id")

    @mobile_network_id.setter
    def mobile_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mobile_network_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Mobile Network Slice. Changing this forces a new Mobile Network Slice to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="singleNetworkSliceSelectionAssistanceInformation")
    @_utilities.deprecated("""`single_network_slice_selection_assistance_information` has been deprecated and its properties, `slice_differentiator` and `slice_service_type` have been moved to the top level. The `single_network_slice_selection_assistance_information` block will be removed in v5.0 of the AzureRM Provider.""")
    def single_network_slice_selection_assistance_information(self) -> Optional[pulumi.Input['NetworkSliceSingleNetworkSliceSelectionAssistanceInformationArgs']]:
        return pulumi.get(self, "single_network_slice_selection_assistance_information")

    @single_network_slice_selection_assistance_information.setter
    def single_network_slice_selection_assistance_information(self, value: Optional[pulumi.Input['NetworkSliceSingleNetworkSliceSelectionAssistanceInformationArgs']]):
        pulumi.set(self, "single_network_slice_selection_assistance_information", value)

    @_builtins.property
    @pulumi.getter(name="sliceDifferentiator")
    def slice_differentiator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Slice differentiator (SD). Must be a 6 digit hex string. For single-network slice selection assistance information (S-NSSAI). Unique at the scope of a mobile network.
        """
        return pulumi.get(self, "slice_differentiator")

    @slice_differentiator.setter
    def slice_differentiator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slice_differentiator", value)

    @_builtins.property
    @pulumi.getter(name="sliceServiceType")
    def slice_service_type(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Slice/service type (SST). Must be between `0` and `255`. For single-network slice selection assistance information (S-NSSAI). Unique at the scope of a mobile network.
        """
        return pulumi.get(self, "slice_service_type")

    @slice_service_type.setter
    def slice_service_type(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "slice_service_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Mobile Network Slice.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:mobile/networkSlice:NetworkSlice")
class NetworkSlice(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 mobile_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 single_network_slice_selection_assistance_information: Optional[pulumi.Input[Union['NetworkSliceSingleNetworkSliceSelectionAssistanceInformationArgs', 'NetworkSliceSingleNetworkSliceSelectionAssistanceInformationArgsDict']]] = None,
                 slice_differentiator: Optional[pulumi.Input[_builtins.str]] = None,
                 slice_service_type: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Mobile Network Slice.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_network = azure.mobile.Network("example",
            name="example-mn",
            location=example.location,
            resource_group_name=example.name,
            mobile_country_code="001",
            mobile_network_code="01")
        example_network_slice = azure.mobile.NetworkSlice("example",
            name="example-mns",
            mobile_network_id=example_network.id,
            location=example.location,
            description="an example slice",
            slice_service_type=1,
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.MobileNetwork` - 2022-11-01

        ## Import

        Mobile Network Slice can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mobile/networkSlice:NetworkSlice example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.MobileNetwork/mobileNetworks/mobileNetwork1/slices/slice1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description for this Mobile Network Slice.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Mobile Network Slice should exist. Changing this forces a new Mobile Network Slice to be created.
        :param pulumi.Input[_builtins.str] mobile_network_id: The ID of Mobile Network which the Mobile Network Slice belongs to. Changing this forces a new Mobile Network Slice to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Mobile Network Slice. Changing this forces a new Mobile Network Slice to be created.
        :param pulumi.Input[_builtins.str] slice_differentiator: Slice differentiator (SD). Must be a 6 digit hex string. For single-network slice selection assistance information (S-NSSAI). Unique at the scope of a mobile network.
        :param pulumi.Input[_builtins.int] slice_service_type: Slice/service type (SST). Must be between `0` and `255`. For single-network slice selection assistance information (S-NSSAI). Unique at the scope of a mobile network.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Mobile Network Slice.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkSliceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Mobile Network Slice.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_network = azure.mobile.Network("example",
            name="example-mn",
            location=example.location,
            resource_group_name=example.name,
            mobile_country_code="001",
            mobile_network_code="01")
        example_network_slice = azure.mobile.NetworkSlice("example",
            name="example-mns",
            mobile_network_id=example_network.id,
            location=example.location,
            description="an example slice",
            slice_service_type=1,
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.MobileNetwork` - 2022-11-01

        ## Import

        Mobile Network Slice can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mobile/networkSlice:NetworkSlice example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.MobileNetwork/mobileNetworks/mobileNetwork1/slices/slice1
        ```

        :param str resource_name: The name of the resource.
        :param NetworkSliceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkSliceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 mobile_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 single_network_slice_selection_assistance_information: Optional[pulumi.Input[Union['NetworkSliceSingleNetworkSliceSelectionAssistanceInformationArgs', 'NetworkSliceSingleNetworkSliceSelectionAssistanceInformationArgsDict']]] = None,
                 slice_differentiator: Optional[pulumi.Input[_builtins.str]] = None,
                 slice_service_type: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkSliceArgs.__new__(NetworkSliceArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["location"] = location
            if mobile_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'mobile_network_id'")
            __props__.__dict__["mobile_network_id"] = mobile_network_id
            __props__.__dict__["name"] = name
            __props__.__dict__["single_network_slice_selection_assistance_information"] = single_network_slice_selection_assistance_information
            __props__.__dict__["slice_differentiator"] = slice_differentiator
            __props__.__dict__["slice_service_type"] = slice_service_type
            __props__.__dict__["tags"] = tags
        super(NetworkSlice, __self__).__init__(
            'azure:mobile/networkSlice:NetworkSlice',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            mobile_network_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            single_network_slice_selection_assistance_information: Optional[pulumi.Input[Union['NetworkSliceSingleNetworkSliceSelectionAssistanceInformationArgs', 'NetworkSliceSingleNetworkSliceSelectionAssistanceInformationArgsDict']]] = None,
            slice_differentiator: Optional[pulumi.Input[_builtins.str]] = None,
            slice_service_type: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'NetworkSlice':
        """
        Get an existing NetworkSlice resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description for this Mobile Network Slice.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Mobile Network Slice should exist. Changing this forces a new Mobile Network Slice to be created.
        :param pulumi.Input[_builtins.str] mobile_network_id: The ID of Mobile Network which the Mobile Network Slice belongs to. Changing this forces a new Mobile Network Slice to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Mobile Network Slice. Changing this forces a new Mobile Network Slice to be created.
        :param pulumi.Input[_builtins.str] slice_differentiator: Slice differentiator (SD). Must be a 6 digit hex string. For single-network slice selection assistance information (S-NSSAI). Unique at the scope of a mobile network.
        :param pulumi.Input[_builtins.int] slice_service_type: Slice/service type (SST). Must be between `0` and `255`. For single-network slice selection assistance information (S-NSSAI). Unique at the scope of a mobile network.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Mobile Network Slice.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkSliceState.__new__(_NetworkSliceState)

        __props__.__dict__["description"] = description
        __props__.__dict__["location"] = location
        __props__.__dict__["mobile_network_id"] = mobile_network_id
        __props__.__dict__["name"] = name
        __props__.__dict__["single_network_slice_selection_assistance_information"] = single_network_slice_selection_assistance_information
        __props__.__dict__["slice_differentiator"] = slice_differentiator
        __props__.__dict__["slice_service_type"] = slice_service_type
        __props__.__dict__["tags"] = tags
        return NetworkSlice(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description for this Mobile Network Slice.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Azure Region where the Mobile Network Slice should exist. Changing this forces a new Mobile Network Slice to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="mobileNetworkId")
    def mobile_network_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of Mobile Network which the Mobile Network Slice belongs to. Changing this forces a new Mobile Network Slice to be created.
        """
        return pulumi.get(self, "mobile_network_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name which should be used for this Mobile Network Slice. Changing this forces a new Mobile Network Slice to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="singleNetworkSliceSelectionAssistanceInformation")
    @_utilities.deprecated("""`single_network_slice_selection_assistance_information` has been deprecated and its properties, `slice_differentiator` and `slice_service_type` have been moved to the top level. The `single_network_slice_selection_assistance_information` block will be removed in v5.0 of the AzureRM Provider.""")
    def single_network_slice_selection_assistance_information(self) -> pulumi.Output['outputs.NetworkSliceSingleNetworkSliceSelectionAssistanceInformation']:
        return pulumi.get(self, "single_network_slice_selection_assistance_information")

    @_builtins.property
    @pulumi.getter(name="sliceDifferentiator")
    def slice_differentiator(self) -> pulumi.Output[_builtins.str]:
        """
        Slice differentiator (SD). Must be a 6 digit hex string. For single-network slice selection assistance information (S-NSSAI). Unique at the scope of a mobile network.
        """
        return pulumi.get(self, "slice_differentiator")

    @_builtins.property
    @pulumi.getter(name="sliceServiceType")
    def slice_service_type(self) -> pulumi.Output[_builtins.int]:
        """
        Slice/service type (SST). Must be between `0` and `255`. For single-network slice selection assistance information (S-NSSAI). Unique at the scope of a mobile network.
        """
        return pulumi.get(self, "slice_service_type")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Mobile Network Slice.
        """
        return pulumi.get(self, "tags")

