# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ActionGroupArgs', 'ActionGroup']

@pulumi.input_type
class ActionGroupArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 short_name: pulumi.Input[_builtins.str],
                 arm_role_receivers: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupArmRoleReceiverArgs']]]] = None,
                 automation_runbook_receivers: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupAutomationRunbookReceiverArgs']]]] = None,
                 azure_app_push_receivers: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupAzureAppPushReceiverArgs']]]] = None,
                 azure_function_receivers: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupAzureFunctionReceiverArgs']]]] = None,
                 email_receivers: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupEmailReceiverArgs']]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 event_hub_receivers: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupEventHubReceiverArgs']]]] = None,
                 itsm_receivers: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupItsmReceiverArgs']]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logic_app_receivers: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupLogicAppReceiverArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sms_receivers: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupSmsReceiverArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 voice_receivers: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupVoiceReceiverArgs']]]] = None,
                 webhook_receivers: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupWebhookReceiverArgs']]]] = None):
        """
        The set of arguments for constructing a ActionGroup resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Action Group instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] short_name: The short name of the action group. This will be used in SMS messages.
        :param pulumi.Input[Sequence[pulumi.Input['ActionGroupArmRoleReceiverArgs']]] arm_role_receivers: One or more `arm_role_receiver` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ActionGroupAutomationRunbookReceiverArgs']]] automation_runbook_receivers: One or more `automation_runbook_receiver` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ActionGroupAzureAppPushReceiverArgs']]] azure_app_push_receivers: One or more `azure_app_push_receiver` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ActionGroupAzureFunctionReceiverArgs']]] azure_function_receivers: One or more `azure_function_receiver` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ActionGroupEmailReceiverArgs']]] email_receivers: One or more `email_receiver` blocks as defined below.
        :param pulumi.Input[_builtins.bool] enabled: Whether this action group is enabled. If an action group is not enabled, then none of its receivers will receive communications. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['ActionGroupEventHubReceiverArgs']]] event_hub_receivers: One or more `event_hub_receiver` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ActionGroupItsmReceiverArgs']]] itsm_receivers: One or more `itsm_receiver` blocks as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Action Group should exist. Changing this forces a new Action Group to be created. Defaults to `global`.
        :param pulumi.Input[Sequence[pulumi.Input['ActionGroupLogicAppReceiverArgs']]] logic_app_receivers: One or more `logic_app_receiver` blocks as defined below.
        :param pulumi.Input[_builtins.str] name: The name of the Action Group. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ActionGroupSmsReceiverArgs']]] sms_receivers: One or more `sms_receiver` blocks as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input['ActionGroupVoiceReceiverArgs']]] voice_receivers: One or more `voice_receiver` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ActionGroupWebhookReceiverArgs']]] webhook_receivers: One or more `webhook_receiver` blocks as defined below.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "short_name", short_name)
        if arm_role_receivers is not None:
            pulumi.set(__self__, "arm_role_receivers", arm_role_receivers)
        if automation_runbook_receivers is not None:
            pulumi.set(__self__, "automation_runbook_receivers", automation_runbook_receivers)
        if azure_app_push_receivers is not None:
            pulumi.set(__self__, "azure_app_push_receivers", azure_app_push_receivers)
        if azure_function_receivers is not None:
            pulumi.set(__self__, "azure_function_receivers", azure_function_receivers)
        if email_receivers is not None:
            pulumi.set(__self__, "email_receivers", email_receivers)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if event_hub_receivers is not None:
            pulumi.set(__self__, "event_hub_receivers", event_hub_receivers)
        if itsm_receivers is not None:
            pulumi.set(__self__, "itsm_receivers", itsm_receivers)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if logic_app_receivers is not None:
            pulumi.set(__self__, "logic_app_receivers", logic_app_receivers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sms_receivers is not None:
            pulumi.set(__self__, "sms_receivers", sms_receivers)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if voice_receivers is not None:
            pulumi.set(__self__, "voice_receivers", voice_receivers)
        if webhook_receivers is not None:
            pulumi.set(__self__, "webhook_receivers", webhook_receivers)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the Action Group instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="shortName")
    def short_name(self) -> pulumi.Input[_builtins.str]:
        """
        The short name of the action group. This will be used in SMS messages.
        """
        return pulumi.get(self, "short_name")

    @short_name.setter
    def short_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "short_name", value)

    @_builtins.property
    @pulumi.getter(name="armRoleReceivers")
    def arm_role_receivers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupArmRoleReceiverArgs']]]]:
        """
        One or more `arm_role_receiver` blocks as defined below.
        """
        return pulumi.get(self, "arm_role_receivers")

    @arm_role_receivers.setter
    def arm_role_receivers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupArmRoleReceiverArgs']]]]):
        pulumi.set(self, "arm_role_receivers", value)

    @_builtins.property
    @pulumi.getter(name="automationRunbookReceivers")
    def automation_runbook_receivers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupAutomationRunbookReceiverArgs']]]]:
        """
        One or more `automation_runbook_receiver` blocks as defined below.
        """
        return pulumi.get(self, "automation_runbook_receivers")

    @automation_runbook_receivers.setter
    def automation_runbook_receivers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupAutomationRunbookReceiverArgs']]]]):
        pulumi.set(self, "automation_runbook_receivers", value)

    @_builtins.property
    @pulumi.getter(name="azureAppPushReceivers")
    def azure_app_push_receivers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupAzureAppPushReceiverArgs']]]]:
        """
        One or more `azure_app_push_receiver` blocks as defined below.
        """
        return pulumi.get(self, "azure_app_push_receivers")

    @azure_app_push_receivers.setter
    def azure_app_push_receivers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupAzureAppPushReceiverArgs']]]]):
        pulumi.set(self, "azure_app_push_receivers", value)

    @_builtins.property
    @pulumi.getter(name="azureFunctionReceivers")
    def azure_function_receivers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupAzureFunctionReceiverArgs']]]]:
        """
        One or more `azure_function_receiver` blocks as defined below.
        """
        return pulumi.get(self, "azure_function_receivers")

    @azure_function_receivers.setter
    def azure_function_receivers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupAzureFunctionReceiverArgs']]]]):
        pulumi.set(self, "azure_function_receivers", value)

    @_builtins.property
    @pulumi.getter(name="emailReceivers")
    def email_receivers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupEmailReceiverArgs']]]]:
        """
        One or more `email_receiver` blocks as defined below.
        """
        return pulumi.get(self, "email_receivers")

    @email_receivers.setter
    def email_receivers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupEmailReceiverArgs']]]]):
        pulumi.set(self, "email_receivers", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this action group is enabled. If an action group is not enabled, then none of its receivers will receive communications. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="eventHubReceivers")
    def event_hub_receivers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupEventHubReceiverArgs']]]]:
        """
        One or more `event_hub_receiver` blocks as defined below.
        """
        return pulumi.get(self, "event_hub_receivers")

    @event_hub_receivers.setter
    def event_hub_receivers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupEventHubReceiverArgs']]]]):
        pulumi.set(self, "event_hub_receivers", value)

    @_builtins.property
    @pulumi.getter(name="itsmReceivers")
    def itsm_receivers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupItsmReceiverArgs']]]]:
        """
        One or more `itsm_receiver` blocks as defined below.
        """
        return pulumi.get(self, "itsm_receivers")

    @itsm_receivers.setter
    def itsm_receivers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupItsmReceiverArgs']]]]):
        pulumi.set(self, "itsm_receivers", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Action Group should exist. Changing this forces a new Action Group to be created. Defaults to `global`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="logicAppReceivers")
    def logic_app_receivers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupLogicAppReceiverArgs']]]]:
        """
        One or more `logic_app_receiver` blocks as defined below.
        """
        return pulumi.get(self, "logic_app_receivers")

    @logic_app_receivers.setter
    def logic_app_receivers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupLogicAppReceiverArgs']]]]):
        pulumi.set(self, "logic_app_receivers", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Action Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="smsReceivers")
    def sms_receivers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupSmsReceiverArgs']]]]:
        """
        One or more `sms_receiver` blocks as defined below.
        """
        return pulumi.get(self, "sms_receivers")

    @sms_receivers.setter
    def sms_receivers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupSmsReceiverArgs']]]]):
        pulumi.set(self, "sms_receivers", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="voiceReceivers")
    def voice_receivers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupVoiceReceiverArgs']]]]:
        """
        One or more `voice_receiver` blocks as defined below.
        """
        return pulumi.get(self, "voice_receivers")

    @voice_receivers.setter
    def voice_receivers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupVoiceReceiverArgs']]]]):
        pulumi.set(self, "voice_receivers", value)

    @_builtins.property
    @pulumi.getter(name="webhookReceivers")
    def webhook_receivers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupWebhookReceiverArgs']]]]:
        """
        One or more `webhook_receiver` blocks as defined below.
        """
        return pulumi.get(self, "webhook_receivers")

    @webhook_receivers.setter
    def webhook_receivers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupWebhookReceiverArgs']]]]):
        pulumi.set(self, "webhook_receivers", value)


@pulumi.input_type
class _ActionGroupState:
    def __init__(__self__, *,
                 arm_role_receivers: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupArmRoleReceiverArgs']]]] = None,
                 automation_runbook_receivers: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupAutomationRunbookReceiverArgs']]]] = None,
                 azure_app_push_receivers: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupAzureAppPushReceiverArgs']]]] = None,
                 azure_function_receivers: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupAzureFunctionReceiverArgs']]]] = None,
                 email_receivers: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupEmailReceiverArgs']]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 event_hub_receivers: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupEventHubReceiverArgs']]]] = None,
                 itsm_receivers: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupItsmReceiverArgs']]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logic_app_receivers: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupLogicAppReceiverArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 short_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sms_receivers: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupSmsReceiverArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 voice_receivers: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupVoiceReceiverArgs']]]] = None,
                 webhook_receivers: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupWebhookReceiverArgs']]]] = None):
        """
        Input properties used for looking up and filtering ActionGroup resources.
        :param pulumi.Input[Sequence[pulumi.Input['ActionGroupArmRoleReceiverArgs']]] arm_role_receivers: One or more `arm_role_receiver` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ActionGroupAutomationRunbookReceiverArgs']]] automation_runbook_receivers: One or more `automation_runbook_receiver` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ActionGroupAzureAppPushReceiverArgs']]] azure_app_push_receivers: One or more `azure_app_push_receiver` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ActionGroupAzureFunctionReceiverArgs']]] azure_function_receivers: One or more `azure_function_receiver` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ActionGroupEmailReceiverArgs']]] email_receivers: One or more `email_receiver` blocks as defined below.
        :param pulumi.Input[_builtins.bool] enabled: Whether this action group is enabled. If an action group is not enabled, then none of its receivers will receive communications. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['ActionGroupEventHubReceiverArgs']]] event_hub_receivers: One or more `event_hub_receiver` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ActionGroupItsmReceiverArgs']]] itsm_receivers: One or more `itsm_receiver` blocks as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Action Group should exist. Changing this forces a new Action Group to be created. Defaults to `global`.
        :param pulumi.Input[Sequence[pulumi.Input['ActionGroupLogicAppReceiverArgs']]] logic_app_receivers: One or more `logic_app_receiver` blocks as defined below.
        :param pulumi.Input[_builtins.str] name: The name of the Action Group. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Action Group instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] short_name: The short name of the action group. This will be used in SMS messages.
        :param pulumi.Input[Sequence[pulumi.Input['ActionGroupSmsReceiverArgs']]] sms_receivers: One or more `sms_receiver` blocks as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input['ActionGroupVoiceReceiverArgs']]] voice_receivers: One or more `voice_receiver` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ActionGroupWebhookReceiverArgs']]] webhook_receivers: One or more `webhook_receiver` blocks as defined below.
        """
        if arm_role_receivers is not None:
            pulumi.set(__self__, "arm_role_receivers", arm_role_receivers)
        if automation_runbook_receivers is not None:
            pulumi.set(__self__, "automation_runbook_receivers", automation_runbook_receivers)
        if azure_app_push_receivers is not None:
            pulumi.set(__self__, "azure_app_push_receivers", azure_app_push_receivers)
        if azure_function_receivers is not None:
            pulumi.set(__self__, "azure_function_receivers", azure_function_receivers)
        if email_receivers is not None:
            pulumi.set(__self__, "email_receivers", email_receivers)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if event_hub_receivers is not None:
            pulumi.set(__self__, "event_hub_receivers", event_hub_receivers)
        if itsm_receivers is not None:
            pulumi.set(__self__, "itsm_receivers", itsm_receivers)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if logic_app_receivers is not None:
            pulumi.set(__self__, "logic_app_receivers", logic_app_receivers)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if short_name is not None:
            pulumi.set(__self__, "short_name", short_name)
        if sms_receivers is not None:
            pulumi.set(__self__, "sms_receivers", sms_receivers)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if voice_receivers is not None:
            pulumi.set(__self__, "voice_receivers", voice_receivers)
        if webhook_receivers is not None:
            pulumi.set(__self__, "webhook_receivers", webhook_receivers)

    @_builtins.property
    @pulumi.getter(name="armRoleReceivers")
    def arm_role_receivers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupArmRoleReceiverArgs']]]]:
        """
        One or more `arm_role_receiver` blocks as defined below.
        """
        return pulumi.get(self, "arm_role_receivers")

    @arm_role_receivers.setter
    def arm_role_receivers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupArmRoleReceiverArgs']]]]):
        pulumi.set(self, "arm_role_receivers", value)

    @_builtins.property
    @pulumi.getter(name="automationRunbookReceivers")
    def automation_runbook_receivers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupAutomationRunbookReceiverArgs']]]]:
        """
        One or more `automation_runbook_receiver` blocks as defined below.
        """
        return pulumi.get(self, "automation_runbook_receivers")

    @automation_runbook_receivers.setter
    def automation_runbook_receivers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupAutomationRunbookReceiverArgs']]]]):
        pulumi.set(self, "automation_runbook_receivers", value)

    @_builtins.property
    @pulumi.getter(name="azureAppPushReceivers")
    def azure_app_push_receivers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupAzureAppPushReceiverArgs']]]]:
        """
        One or more `azure_app_push_receiver` blocks as defined below.
        """
        return pulumi.get(self, "azure_app_push_receivers")

    @azure_app_push_receivers.setter
    def azure_app_push_receivers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupAzureAppPushReceiverArgs']]]]):
        pulumi.set(self, "azure_app_push_receivers", value)

    @_builtins.property
    @pulumi.getter(name="azureFunctionReceivers")
    def azure_function_receivers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupAzureFunctionReceiverArgs']]]]:
        """
        One or more `azure_function_receiver` blocks as defined below.
        """
        return pulumi.get(self, "azure_function_receivers")

    @azure_function_receivers.setter
    def azure_function_receivers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupAzureFunctionReceiverArgs']]]]):
        pulumi.set(self, "azure_function_receivers", value)

    @_builtins.property
    @pulumi.getter(name="emailReceivers")
    def email_receivers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupEmailReceiverArgs']]]]:
        """
        One or more `email_receiver` blocks as defined below.
        """
        return pulumi.get(self, "email_receivers")

    @email_receivers.setter
    def email_receivers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupEmailReceiverArgs']]]]):
        pulumi.set(self, "email_receivers", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this action group is enabled. If an action group is not enabled, then none of its receivers will receive communications. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="eventHubReceivers")
    def event_hub_receivers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupEventHubReceiverArgs']]]]:
        """
        One or more `event_hub_receiver` blocks as defined below.
        """
        return pulumi.get(self, "event_hub_receivers")

    @event_hub_receivers.setter
    def event_hub_receivers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupEventHubReceiverArgs']]]]):
        pulumi.set(self, "event_hub_receivers", value)

    @_builtins.property
    @pulumi.getter(name="itsmReceivers")
    def itsm_receivers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupItsmReceiverArgs']]]]:
        """
        One or more `itsm_receiver` blocks as defined below.
        """
        return pulumi.get(self, "itsm_receivers")

    @itsm_receivers.setter
    def itsm_receivers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupItsmReceiverArgs']]]]):
        pulumi.set(self, "itsm_receivers", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Action Group should exist. Changing this forces a new Action Group to be created. Defaults to `global`.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="logicAppReceivers")
    def logic_app_receivers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupLogicAppReceiverArgs']]]]:
        """
        One or more `logic_app_receiver` blocks as defined below.
        """
        return pulumi.get(self, "logic_app_receivers")

    @logic_app_receivers.setter
    def logic_app_receivers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupLogicAppReceiverArgs']]]]):
        pulumi.set(self, "logic_app_receivers", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Action Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the Action Group instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="shortName")
    def short_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The short name of the action group. This will be used in SMS messages.
        """
        return pulumi.get(self, "short_name")

    @short_name.setter
    def short_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "short_name", value)

    @_builtins.property
    @pulumi.getter(name="smsReceivers")
    def sms_receivers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupSmsReceiverArgs']]]]:
        """
        One or more `sms_receiver` blocks as defined below.
        """
        return pulumi.get(self, "sms_receivers")

    @sms_receivers.setter
    def sms_receivers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupSmsReceiverArgs']]]]):
        pulumi.set(self, "sms_receivers", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="voiceReceivers")
    def voice_receivers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupVoiceReceiverArgs']]]]:
        """
        One or more `voice_receiver` blocks as defined below.
        """
        return pulumi.get(self, "voice_receivers")

    @voice_receivers.setter
    def voice_receivers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupVoiceReceiverArgs']]]]):
        pulumi.set(self, "voice_receivers", value)

    @_builtins.property
    @pulumi.getter(name="webhookReceivers")
    def webhook_receivers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupWebhookReceiverArgs']]]]:
        """
        One or more `webhook_receiver` blocks as defined below.
        """
        return pulumi.get(self, "webhook_receivers")

    @webhook_receivers.setter
    def webhook_receivers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ActionGroupWebhookReceiverArgs']]]]):
        pulumi.set(self, "webhook_receivers", value)


@pulumi.type_token("azure:monitoring/actionGroup:ActionGroup")
class ActionGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arm_role_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupArmRoleReceiverArgs', 'ActionGroupArmRoleReceiverArgsDict']]]]] = None,
                 automation_runbook_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupAutomationRunbookReceiverArgs', 'ActionGroupAutomationRunbookReceiverArgsDict']]]]] = None,
                 azure_app_push_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupAzureAppPushReceiverArgs', 'ActionGroupAzureAppPushReceiverArgsDict']]]]] = None,
                 azure_function_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupAzureFunctionReceiverArgs', 'ActionGroupAzureFunctionReceiverArgsDict']]]]] = None,
                 email_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupEmailReceiverArgs', 'ActionGroupEmailReceiverArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 event_hub_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupEventHubReceiverArgs', 'ActionGroupEventHubReceiverArgsDict']]]]] = None,
                 itsm_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupItsmReceiverArgs', 'ActionGroupItsmReceiverArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logic_app_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupLogicAppReceiverArgs', 'ActionGroupLogicAppReceiverArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 short_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sms_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupSmsReceiverArgs', 'ActionGroupSmsReceiverArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 voice_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupVoiceReceiverArgs', 'ActionGroupVoiceReceiverArgsDict']]]]] = None,
                 webhook_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupWebhookReceiverArgs', 'ActionGroupWebhookReceiverArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages an Action Group within Azure Monitor.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="monitoring-resources",
            location="West Europe")
        current = azure.core.get_client_config()
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="workspace-01",
            location=example.location,
            resource_group_name=example.name)
        example_action_group = azure.monitoring.ActionGroup("example",
            name="CriticalAlertsAction",
            resource_group_name=example.name,
            short_name="p0action",
            arm_role_receivers=[{
                "name": "armroleaction",
                "role_id": "de139f84-1756-47ae-9be6-808fbbe84772",
                "use_common_alert_schema": True,
            }],
            automation_runbook_receivers=[{
                "name": "action_name_1",
                "automation_account_id": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg-runbooks/providers/Microsoft.Automation/automationAccounts/aaa001",
                "runbook_name": "my runbook",
                "webhook_resource_id": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg-runbooks/providers/Microsoft.Automation/automationAccounts/aaa001/webHooks/webhook_alert",
                "is_global_runbook": True,
                "service_uri": "https://s13events.azure-automation.net/webhooks?token=randomtoken",
                "use_common_alert_schema": True,
            }],
            azure_app_push_receivers=[{
                "name": "pushtoadmin",
                "email_address": "admin@contoso.com",
            }],
            azure_function_receivers=[{
                "name": "funcaction",
                "function_app_resource_id": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg-funcapp/providers/Microsoft.Web/sites/funcapp",
                "function_name": "myfunc",
                "http_trigger_url": "https://example.com/trigger",
                "use_common_alert_schema": True,
            }],
            email_receivers=[
                {
                    "name": "sendtoadmin",
                    "email_address": "admin@contoso.com",
                },
                {
                    "name": "sendtodevops",
                    "email_address": "devops@contoso.com",
                    "use_common_alert_schema": True,
                },
            ],
            event_hub_receivers=[{
                "name": "sendtoeventhub",
                "event_hub_namespace": "eventhubnamespace",
                "event_hub_name": "eventhub1",
                "subscription_id": "00000000-0000-0000-0000-000000000000",
                "use_common_alert_schema": False,
            }],
            itsm_receivers=[{
                "name": "createorupdateticket",
                "workspace_id": example_analytics_workspace.workspace_id.apply(lambda workspace_id: f"{current.subscription_id}|{workspace_id}"),
                "connection_id": "53de6956-42b4-41ba-be3c-b154cdf17b13",
                "ticket_configuration": "{\\"PayloadRevision\\":0,\\"WorkItemType\\":\\"Incident\\",\\"UseTemplate\\":false,\\"WorkItemData\\":\\"{}\\",\\"CreateOneWIPerCI\\":false}",
                "region": "southcentralus",
            }],
            logic_app_receivers=[{
                "name": "logicappaction",
                "resource_id": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg-logicapp/providers/Microsoft.Logic/workflows/logicapp",
                "callback_url": "https://logicapptriggerurl/...",
                "use_common_alert_schema": True,
            }],
            sms_receivers=[{
                "name": "oncallmsg",
                "country_code": "1",
                "phone_number": "1231231234",
            }],
            voice_receivers=[{
                "name": "remotesupport",
                "country_code": "86",
                "phone_number": "13888888888",
            }],
            webhook_receivers=[{
                "name": "callmyapiaswell",
                "service_uri": "http://example.com/alert",
                "use_common_alert_schema": True,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Insights` - 2023-01-01

        ## Import

        Action Groups can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:monitoring/actionGroup:ActionGroup example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Insights/actionGroups/myagname
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupArmRoleReceiverArgs', 'ActionGroupArmRoleReceiverArgsDict']]]] arm_role_receivers: One or more `arm_role_receiver` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupAutomationRunbookReceiverArgs', 'ActionGroupAutomationRunbookReceiverArgsDict']]]] automation_runbook_receivers: One or more `automation_runbook_receiver` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupAzureAppPushReceiverArgs', 'ActionGroupAzureAppPushReceiverArgsDict']]]] azure_app_push_receivers: One or more `azure_app_push_receiver` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupAzureFunctionReceiverArgs', 'ActionGroupAzureFunctionReceiverArgsDict']]]] azure_function_receivers: One or more `azure_function_receiver` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupEmailReceiverArgs', 'ActionGroupEmailReceiverArgsDict']]]] email_receivers: One or more `email_receiver` blocks as defined below.
        :param pulumi.Input[_builtins.bool] enabled: Whether this action group is enabled. If an action group is not enabled, then none of its receivers will receive communications. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupEventHubReceiverArgs', 'ActionGroupEventHubReceiverArgsDict']]]] event_hub_receivers: One or more `event_hub_receiver` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupItsmReceiverArgs', 'ActionGroupItsmReceiverArgsDict']]]] itsm_receivers: One or more `itsm_receiver` blocks as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Action Group should exist. Changing this forces a new Action Group to be created. Defaults to `global`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupLogicAppReceiverArgs', 'ActionGroupLogicAppReceiverArgsDict']]]] logic_app_receivers: One or more `logic_app_receiver` blocks as defined below.
        :param pulumi.Input[_builtins.str] name: The name of the Action Group. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Action Group instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] short_name: The short name of the action group. This will be used in SMS messages.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupSmsReceiverArgs', 'ActionGroupSmsReceiverArgsDict']]]] sms_receivers: One or more `sms_receiver` blocks as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupVoiceReceiverArgs', 'ActionGroupVoiceReceiverArgsDict']]]] voice_receivers: One or more `voice_receiver` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupWebhookReceiverArgs', 'ActionGroupWebhookReceiverArgsDict']]]] webhook_receivers: One or more `webhook_receiver` blocks as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ActionGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Action Group within Azure Monitor.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="monitoring-resources",
            location="West Europe")
        current = azure.core.get_client_config()
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="workspace-01",
            location=example.location,
            resource_group_name=example.name)
        example_action_group = azure.monitoring.ActionGroup("example",
            name="CriticalAlertsAction",
            resource_group_name=example.name,
            short_name="p0action",
            arm_role_receivers=[{
                "name": "armroleaction",
                "role_id": "de139f84-1756-47ae-9be6-808fbbe84772",
                "use_common_alert_schema": True,
            }],
            automation_runbook_receivers=[{
                "name": "action_name_1",
                "automation_account_id": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg-runbooks/providers/Microsoft.Automation/automationAccounts/aaa001",
                "runbook_name": "my runbook",
                "webhook_resource_id": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg-runbooks/providers/Microsoft.Automation/automationAccounts/aaa001/webHooks/webhook_alert",
                "is_global_runbook": True,
                "service_uri": "https://s13events.azure-automation.net/webhooks?token=randomtoken",
                "use_common_alert_schema": True,
            }],
            azure_app_push_receivers=[{
                "name": "pushtoadmin",
                "email_address": "admin@contoso.com",
            }],
            azure_function_receivers=[{
                "name": "funcaction",
                "function_app_resource_id": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg-funcapp/providers/Microsoft.Web/sites/funcapp",
                "function_name": "myfunc",
                "http_trigger_url": "https://example.com/trigger",
                "use_common_alert_schema": True,
            }],
            email_receivers=[
                {
                    "name": "sendtoadmin",
                    "email_address": "admin@contoso.com",
                },
                {
                    "name": "sendtodevops",
                    "email_address": "devops@contoso.com",
                    "use_common_alert_schema": True,
                },
            ],
            event_hub_receivers=[{
                "name": "sendtoeventhub",
                "event_hub_namespace": "eventhubnamespace",
                "event_hub_name": "eventhub1",
                "subscription_id": "00000000-0000-0000-0000-000000000000",
                "use_common_alert_schema": False,
            }],
            itsm_receivers=[{
                "name": "createorupdateticket",
                "workspace_id": example_analytics_workspace.workspace_id.apply(lambda workspace_id: f"{current.subscription_id}|{workspace_id}"),
                "connection_id": "53de6956-42b4-41ba-be3c-b154cdf17b13",
                "ticket_configuration": "{\\"PayloadRevision\\":0,\\"WorkItemType\\":\\"Incident\\",\\"UseTemplate\\":false,\\"WorkItemData\\":\\"{}\\",\\"CreateOneWIPerCI\\":false}",
                "region": "southcentralus",
            }],
            logic_app_receivers=[{
                "name": "logicappaction",
                "resource_id": "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg-logicapp/providers/Microsoft.Logic/workflows/logicapp",
                "callback_url": "https://logicapptriggerurl/...",
                "use_common_alert_schema": True,
            }],
            sms_receivers=[{
                "name": "oncallmsg",
                "country_code": "1",
                "phone_number": "1231231234",
            }],
            voice_receivers=[{
                "name": "remotesupport",
                "country_code": "86",
                "phone_number": "13888888888",
            }],
            webhook_receivers=[{
                "name": "callmyapiaswell",
                "service_uri": "http://example.com/alert",
                "use_common_alert_schema": True,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Insights` - 2023-01-01

        ## Import

        Action Groups can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:monitoring/actionGroup:ActionGroup example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Insights/actionGroups/myagname
        ```

        :param str resource_name: The name of the resource.
        :param ActionGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ActionGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arm_role_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupArmRoleReceiverArgs', 'ActionGroupArmRoleReceiverArgsDict']]]]] = None,
                 automation_runbook_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupAutomationRunbookReceiverArgs', 'ActionGroupAutomationRunbookReceiverArgsDict']]]]] = None,
                 azure_app_push_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupAzureAppPushReceiverArgs', 'ActionGroupAzureAppPushReceiverArgsDict']]]]] = None,
                 azure_function_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupAzureFunctionReceiverArgs', 'ActionGroupAzureFunctionReceiverArgsDict']]]]] = None,
                 email_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupEmailReceiverArgs', 'ActionGroupEmailReceiverArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 event_hub_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupEventHubReceiverArgs', 'ActionGroupEventHubReceiverArgsDict']]]]] = None,
                 itsm_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupItsmReceiverArgs', 'ActionGroupItsmReceiverArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logic_app_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupLogicAppReceiverArgs', 'ActionGroupLogicAppReceiverArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 short_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sms_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupSmsReceiverArgs', 'ActionGroupSmsReceiverArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 voice_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupVoiceReceiverArgs', 'ActionGroupVoiceReceiverArgsDict']]]]] = None,
                 webhook_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupWebhookReceiverArgs', 'ActionGroupWebhookReceiverArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ActionGroupArgs.__new__(ActionGroupArgs)

            __props__.__dict__["arm_role_receivers"] = arm_role_receivers
            __props__.__dict__["automation_runbook_receivers"] = automation_runbook_receivers
            __props__.__dict__["azure_app_push_receivers"] = azure_app_push_receivers
            __props__.__dict__["azure_function_receivers"] = azure_function_receivers
            __props__.__dict__["email_receivers"] = email_receivers
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["event_hub_receivers"] = event_hub_receivers
            __props__.__dict__["itsm_receivers"] = itsm_receivers
            __props__.__dict__["location"] = location
            __props__.__dict__["logic_app_receivers"] = logic_app_receivers
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if short_name is None and not opts.urn:
                raise TypeError("Missing required property 'short_name'")
            __props__.__dict__["short_name"] = short_name
            __props__.__dict__["sms_receivers"] = sms_receivers
            __props__.__dict__["tags"] = tags
            __props__.__dict__["voice_receivers"] = voice_receivers
            __props__.__dict__["webhook_receivers"] = webhook_receivers
        super(ActionGroup, __self__).__init__(
            'azure:monitoring/actionGroup:ActionGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arm_role_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupArmRoleReceiverArgs', 'ActionGroupArmRoleReceiverArgsDict']]]]] = None,
            automation_runbook_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupAutomationRunbookReceiverArgs', 'ActionGroupAutomationRunbookReceiverArgsDict']]]]] = None,
            azure_app_push_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupAzureAppPushReceiverArgs', 'ActionGroupAzureAppPushReceiverArgsDict']]]]] = None,
            azure_function_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupAzureFunctionReceiverArgs', 'ActionGroupAzureFunctionReceiverArgsDict']]]]] = None,
            email_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupEmailReceiverArgs', 'ActionGroupEmailReceiverArgsDict']]]]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            event_hub_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupEventHubReceiverArgs', 'ActionGroupEventHubReceiverArgsDict']]]]] = None,
            itsm_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupItsmReceiverArgs', 'ActionGroupItsmReceiverArgsDict']]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            logic_app_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupLogicAppReceiverArgs', 'ActionGroupLogicAppReceiverArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            short_name: Optional[pulumi.Input[_builtins.str]] = None,
            sms_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupSmsReceiverArgs', 'ActionGroupSmsReceiverArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            voice_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupVoiceReceiverArgs', 'ActionGroupVoiceReceiverArgsDict']]]]] = None,
            webhook_receivers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupWebhookReceiverArgs', 'ActionGroupWebhookReceiverArgsDict']]]]] = None) -> 'ActionGroup':
        """
        Get an existing ActionGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupArmRoleReceiverArgs', 'ActionGroupArmRoleReceiverArgsDict']]]] arm_role_receivers: One or more `arm_role_receiver` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupAutomationRunbookReceiverArgs', 'ActionGroupAutomationRunbookReceiverArgsDict']]]] automation_runbook_receivers: One or more `automation_runbook_receiver` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupAzureAppPushReceiverArgs', 'ActionGroupAzureAppPushReceiverArgsDict']]]] azure_app_push_receivers: One or more `azure_app_push_receiver` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupAzureFunctionReceiverArgs', 'ActionGroupAzureFunctionReceiverArgsDict']]]] azure_function_receivers: One or more `azure_function_receiver` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupEmailReceiverArgs', 'ActionGroupEmailReceiverArgsDict']]]] email_receivers: One or more `email_receiver` blocks as defined below.
        :param pulumi.Input[_builtins.bool] enabled: Whether this action group is enabled. If an action group is not enabled, then none of its receivers will receive communications. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupEventHubReceiverArgs', 'ActionGroupEventHubReceiverArgsDict']]]] event_hub_receivers: One or more `event_hub_receiver` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupItsmReceiverArgs', 'ActionGroupItsmReceiverArgsDict']]]] itsm_receivers: One or more `itsm_receiver` blocks as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Action Group should exist. Changing this forces a new Action Group to be created. Defaults to `global`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupLogicAppReceiverArgs', 'ActionGroupLogicAppReceiverArgsDict']]]] logic_app_receivers: One or more `logic_app_receiver` blocks as defined below.
        :param pulumi.Input[_builtins.str] name: The name of the Action Group. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Action Group instance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] short_name: The short name of the action group. This will be used in SMS messages.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupSmsReceiverArgs', 'ActionGroupSmsReceiverArgsDict']]]] sms_receivers: One or more `sms_receiver` blocks as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupVoiceReceiverArgs', 'ActionGroupVoiceReceiverArgsDict']]]] voice_receivers: One or more `voice_receiver` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ActionGroupWebhookReceiverArgs', 'ActionGroupWebhookReceiverArgsDict']]]] webhook_receivers: One or more `webhook_receiver` blocks as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ActionGroupState.__new__(_ActionGroupState)

        __props__.__dict__["arm_role_receivers"] = arm_role_receivers
        __props__.__dict__["automation_runbook_receivers"] = automation_runbook_receivers
        __props__.__dict__["azure_app_push_receivers"] = azure_app_push_receivers
        __props__.__dict__["azure_function_receivers"] = azure_function_receivers
        __props__.__dict__["email_receivers"] = email_receivers
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["event_hub_receivers"] = event_hub_receivers
        __props__.__dict__["itsm_receivers"] = itsm_receivers
        __props__.__dict__["location"] = location
        __props__.__dict__["logic_app_receivers"] = logic_app_receivers
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["short_name"] = short_name
        __props__.__dict__["sms_receivers"] = sms_receivers
        __props__.__dict__["tags"] = tags
        __props__.__dict__["voice_receivers"] = voice_receivers
        __props__.__dict__["webhook_receivers"] = webhook_receivers
        return ActionGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="armRoleReceivers")
    def arm_role_receivers(self) -> pulumi.Output[Optional[Sequence['outputs.ActionGroupArmRoleReceiver']]]:
        """
        One or more `arm_role_receiver` blocks as defined below.
        """
        return pulumi.get(self, "arm_role_receivers")

    @_builtins.property
    @pulumi.getter(name="automationRunbookReceivers")
    def automation_runbook_receivers(self) -> pulumi.Output[Optional[Sequence['outputs.ActionGroupAutomationRunbookReceiver']]]:
        """
        One or more `automation_runbook_receiver` blocks as defined below.
        """
        return pulumi.get(self, "automation_runbook_receivers")

    @_builtins.property
    @pulumi.getter(name="azureAppPushReceivers")
    def azure_app_push_receivers(self) -> pulumi.Output[Optional[Sequence['outputs.ActionGroupAzureAppPushReceiver']]]:
        """
        One or more `azure_app_push_receiver` blocks as defined below.
        """
        return pulumi.get(self, "azure_app_push_receivers")

    @_builtins.property
    @pulumi.getter(name="azureFunctionReceivers")
    def azure_function_receivers(self) -> pulumi.Output[Optional[Sequence['outputs.ActionGroupAzureFunctionReceiver']]]:
        """
        One or more `azure_function_receiver` blocks as defined below.
        """
        return pulumi.get(self, "azure_function_receivers")

    @_builtins.property
    @pulumi.getter(name="emailReceivers")
    def email_receivers(self) -> pulumi.Output[Optional[Sequence['outputs.ActionGroupEmailReceiver']]]:
        """
        One or more `email_receiver` blocks as defined below.
        """
        return pulumi.get(self, "email_receivers")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether this action group is enabled. If an action group is not enabled, then none of its receivers will receive communications. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="eventHubReceivers")
    def event_hub_receivers(self) -> pulumi.Output[Optional[Sequence['outputs.ActionGroupEventHubReceiver']]]:
        """
        One or more `event_hub_receiver` blocks as defined below.
        """
        return pulumi.get(self, "event_hub_receivers")

    @_builtins.property
    @pulumi.getter(name="itsmReceivers")
    def itsm_receivers(self) -> pulumi.Output[Optional[Sequence['outputs.ActionGroupItsmReceiver']]]:
        """
        One or more `itsm_receiver` blocks as defined below.
        """
        return pulumi.get(self, "itsm_receivers")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Action Group should exist. Changing this forces a new Action Group to be created. Defaults to `global`.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="logicAppReceivers")
    def logic_app_receivers(self) -> pulumi.Output[Optional[Sequence['outputs.ActionGroupLogicAppReceiver']]]:
        """
        One or more `logic_app_receiver` blocks as defined below.
        """
        return pulumi.get(self, "logic_app_receivers")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Action Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the Action Group instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="shortName")
    def short_name(self) -> pulumi.Output[_builtins.str]:
        """
        The short name of the action group. This will be used in SMS messages.
        """
        return pulumi.get(self, "short_name")

    @_builtins.property
    @pulumi.getter(name="smsReceivers")
    def sms_receivers(self) -> pulumi.Output[Optional[Sequence['outputs.ActionGroupSmsReceiver']]]:
        """
        One or more `sms_receiver` blocks as defined below.
        """
        return pulumi.get(self, "sms_receivers")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="voiceReceivers")
    def voice_receivers(self) -> pulumi.Output[Optional[Sequence['outputs.ActionGroupVoiceReceiver']]]:
        """
        One or more `voice_receiver` blocks as defined below.
        """
        return pulumi.get(self, "voice_receivers")

    @_builtins.property
    @pulumi.getter(name="webhookReceivers")
    def webhook_receivers(self) -> pulumi.Output[Optional[Sequence['outputs.ActionGroupWebhookReceiver']]]:
        """
        One or more `webhook_receiver` blocks as defined below.
        """
        return pulumi.get(self, "webhook_receivers")

