# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlertPrometheusRuleGroupArgs', 'AlertPrometheusRuleGroup']

@pulumi.input_type
class AlertPrometheusRuleGroupArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 rules: pulumi.Input[Sequence[pulumi.Input['AlertPrometheusRuleGroupRuleArgs']]],
                 scopes: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 interval: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_group_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a AlertPrometheusRuleGroup resource.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Alert Management Prometheus Rule Group should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['AlertPrometheusRuleGroupRuleArgs']]] rules: One or more `rule` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: Specifies the resource ID of the Azure Monitor Workspace.
        :param pulumi.Input[_builtins.str] cluster_name: Specifies the name of the Managed Kubernetes Cluster.
        :param pulumi.Input[_builtins.str] description: The description of the Alert Management Prometheus Rule Group.
        :param pulumi.Input[_builtins.str] interval: Specifies the interval in which to run the Alert Management Prometheus Rule Group represented in ISO 8601 duration format. Possible values are between `PT1M` and `PT15M`.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Alert Management Prometheus Rule Group should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Alert Management Prometheus Rule Group. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] rule_group_enabled: Is this Alert Management Prometheus Rule Group enabled? Possible values are `true` and `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Alert Management Prometheus Rule Group.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "rules", rules)
        pulumi.set(__self__, "scopes", scopes)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rule_group_enabled is not None:
            pulumi.set(__self__, "rule_group_enabled", rule_group_enabled)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Resource Group where the Alert Management Prometheus Rule Group should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Input[Sequence[pulumi.Input['AlertPrometheusRuleGroupRuleArgs']]]:
        """
        One or more `rule` blocks as defined below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: pulumi.Input[Sequence[pulumi.Input['AlertPrometheusRuleGroupRuleArgs']]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies the resource ID of the Azure Monitor Workspace.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "scopes", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Managed Kubernetes Cluster.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Alert Management Prometheus Rule Group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the interval in which to run the Alert Management Prometheus Rule Group represented in ISO 8601 duration format. Possible values are between `PT1M` and `PT15M`.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Alert Management Prometheus Rule Group should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Alert Management Prometheus Rule Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="ruleGroupEnabled")
    def rule_group_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is this Alert Management Prometheus Rule Group enabled? Possible values are `true` and `false`.
        """
        return pulumi.get(self, "rule_group_enabled")

    @rule_group_enabled.setter
    def rule_group_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "rule_group_enabled", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the Alert Management Prometheus Rule Group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AlertPrometheusRuleGroupState:
    def __init__(__self__, *,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 interval: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_group_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['AlertPrometheusRuleGroupRuleArgs']]]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering AlertPrometheusRuleGroup resources.
        :param pulumi.Input[_builtins.str] cluster_name: Specifies the name of the Managed Kubernetes Cluster.
        :param pulumi.Input[_builtins.str] description: The description of the Alert Management Prometheus Rule Group.
        :param pulumi.Input[_builtins.str] interval: Specifies the interval in which to run the Alert Management Prometheus Rule Group represented in ISO 8601 duration format. Possible values are between `PT1M` and `PT15M`.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Alert Management Prometheus Rule Group should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Alert Management Prometheus Rule Group. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Alert Management Prometheus Rule Group should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] rule_group_enabled: Is this Alert Management Prometheus Rule Group enabled? Possible values are `true` and `false`.
        :param pulumi.Input[Sequence[pulumi.Input['AlertPrometheusRuleGroupRuleArgs']]] rules: One or more `rule` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: Specifies the resource ID of the Azure Monitor Workspace.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Alert Management Prometheus Rule Group.
        """
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if rule_group_enabled is not None:
            pulumi.set(__self__, "rule_group_enabled", rule_group_enabled)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Managed Kubernetes Cluster.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Alert Management Prometheus Rule Group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the interval in which to run the Alert Management Prometheus Rule Group represented in ISO 8601 duration format. Possible values are between `PT1M` and `PT15M`.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "interval", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Alert Management Prometheus Rule Group should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Alert Management Prometheus Rule Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Resource Group where the Alert Management Prometheus Rule Group should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="ruleGroupEnabled")
    def rule_group_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is this Alert Management Prometheus Rule Group enabled? Possible values are `true` and `false`.
        """
        return pulumi.get(self, "rule_group_enabled")

    @rule_group_enabled.setter
    def rule_group_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "rule_group_enabled", value)

    @_builtins.property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlertPrometheusRuleGroupRuleArgs']]]]:
        """
        One or more `rule` blocks as defined below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlertPrometheusRuleGroupRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the resource ID of the Azure Monitor Workspace.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "scopes", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the Alert Management Prometheus Rule Group.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:monitoring/alertPrometheusRuleGroup:AlertPrometheusRuleGroup")
class AlertPrometheusRuleGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 interval: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_group_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertPrometheusRuleGroupRuleArgs', 'AlertPrometheusRuleGroupRuleArgsDict']]]]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an Alert Management Prometheus Rule Group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_action_group = azure.monitoring.ActionGroup("example",
            name="example-mag",
            resource_group_name=example.name,
            short_name="testag")
        example_workspace = azure.monitoring.Workspace("example",
            name="example-amw",
            resource_group_name=example.name,
            location=example.location)
        example_kubernetes_cluster = azure.containerservice.KubernetesCluster("example",
            name="example-cluster",
            location=example.location,
            resource_group_name=example.name,
            dns_prefix="example-aks",
            default_node_pool={
                "name": "default",
                "node_count": 1,
                "vm_size": "Standard_DS2_v2",
                "host_encryption_enabled": True,
            },
            identity={
                "type": "SystemAssigned",
            })
        example_alert_prometheus_rule_group = azure.monitoring.AlertPrometheusRuleGroup("example",
            name="example-amprg",
            location="West Europe",
            resource_group_name=example.name,
            cluster_name=example_kubernetes_cluster.name,
            description="This is the description of the following rule group",
            rule_group_enabled=False,
            interval="PT1M",
            scopes=[example_workspace.id],
            rules=[
                {
                    "enabled": False,
                    "expression": "histogram_quantile(0.99, sum(rate(jobs_duration_seconds_bucket{service=\\"billing-processing\\"}[5m])) by (job_type))\\n",
                    "record": "job_type:billing_jobs_duration_seconds:99p5m",
                    "labels": {
                        "team": "prod",
                    },
                },
                {
                    "alert": "Billing_Processing_Very_Slow",
                    "enabled": True,
                    "expression": "histogram_quantile(0.99, sum(rate(jobs_duration_seconds_bucket{service=\\"billing-processing\\"}[5m])) by (job_type))\\n",
                    "for_": "PT5M",
                    "severity": 2,
                    "actions": [{
                        "action_group_id": example_action_group.id,
                    }],
                    "alert_resolution": {
                        "auto_resolved": True,
                        "time_to_resolve": "PT10M",
                    },
                    "annotations": {
                        "annotationName": "annotationValue",
                    },
                    "labels": {
                        "team": "prod",
                    },
                },
            ],
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AlertsManagement` - 2023-03-01

        ## Import

        Alert Management Prometheus Rule Group can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:monitoring/alertPrometheusRuleGroup:AlertPrometheusRuleGroup example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.AlertsManagement/prometheusRuleGroups/ruleGroup1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_name: Specifies the name of the Managed Kubernetes Cluster.
        :param pulumi.Input[_builtins.str] description: The description of the Alert Management Prometheus Rule Group.
        :param pulumi.Input[_builtins.str] interval: Specifies the interval in which to run the Alert Management Prometheus Rule Group represented in ISO 8601 duration format. Possible values are between `PT1M` and `PT15M`.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Alert Management Prometheus Rule Group should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Alert Management Prometheus Rule Group. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Alert Management Prometheus Rule Group should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] rule_group_enabled: Is this Alert Management Prometheus Rule Group enabled? Possible values are `true` and `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertPrometheusRuleGroupRuleArgs', 'AlertPrometheusRuleGroupRuleArgsDict']]]] rules: One or more `rule` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: Specifies the resource ID of the Azure Monitor Workspace.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Alert Management Prometheus Rule Group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlertPrometheusRuleGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Alert Management Prometheus Rule Group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_action_group = azure.monitoring.ActionGroup("example",
            name="example-mag",
            resource_group_name=example.name,
            short_name="testag")
        example_workspace = azure.monitoring.Workspace("example",
            name="example-amw",
            resource_group_name=example.name,
            location=example.location)
        example_kubernetes_cluster = azure.containerservice.KubernetesCluster("example",
            name="example-cluster",
            location=example.location,
            resource_group_name=example.name,
            dns_prefix="example-aks",
            default_node_pool={
                "name": "default",
                "node_count": 1,
                "vm_size": "Standard_DS2_v2",
                "host_encryption_enabled": True,
            },
            identity={
                "type": "SystemAssigned",
            })
        example_alert_prometheus_rule_group = azure.monitoring.AlertPrometheusRuleGroup("example",
            name="example-amprg",
            location="West Europe",
            resource_group_name=example.name,
            cluster_name=example_kubernetes_cluster.name,
            description="This is the description of the following rule group",
            rule_group_enabled=False,
            interval="PT1M",
            scopes=[example_workspace.id],
            rules=[
                {
                    "enabled": False,
                    "expression": "histogram_quantile(0.99, sum(rate(jobs_duration_seconds_bucket{service=\\"billing-processing\\"}[5m])) by (job_type))\\n",
                    "record": "job_type:billing_jobs_duration_seconds:99p5m",
                    "labels": {
                        "team": "prod",
                    },
                },
                {
                    "alert": "Billing_Processing_Very_Slow",
                    "enabled": True,
                    "expression": "histogram_quantile(0.99, sum(rate(jobs_duration_seconds_bucket{service=\\"billing-processing\\"}[5m])) by (job_type))\\n",
                    "for_": "PT5M",
                    "severity": 2,
                    "actions": [{
                        "action_group_id": example_action_group.id,
                    }],
                    "alert_resolution": {
                        "auto_resolved": True,
                        "time_to_resolve": "PT10M",
                    },
                    "annotations": {
                        "annotationName": "annotationValue",
                    },
                    "labels": {
                        "team": "prod",
                    },
                },
            ],
            tags={
                "key": "value",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.AlertsManagement` - 2023-03-01

        ## Import

        Alert Management Prometheus Rule Group can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:monitoring/alertPrometheusRuleGroup:AlertPrometheusRuleGroup example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.AlertsManagement/prometheusRuleGroups/ruleGroup1
        ```

        :param str resource_name: The name of the resource.
        :param AlertPrometheusRuleGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlertPrometheusRuleGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 interval: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_group_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertPrometheusRuleGroupRuleArgs', 'AlertPrometheusRuleGroupRuleArgsDict']]]]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlertPrometheusRuleGroupArgs.__new__(AlertPrometheusRuleGroupArgs)

            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["description"] = description
            __props__.__dict__["interval"] = interval
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["rule_group_enabled"] = rule_group_enabled
            if rules is None and not opts.urn:
                raise TypeError("Missing required property 'rules'")
            __props__.__dict__["rules"] = rules
            if scopes is None and not opts.urn:
                raise TypeError("Missing required property 'scopes'")
            __props__.__dict__["scopes"] = scopes
            __props__.__dict__["tags"] = tags
        super(AlertPrometheusRuleGroup, __self__).__init__(
            'azure:monitoring/alertPrometheusRuleGroup:AlertPrometheusRuleGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            interval: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            rule_group_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AlertPrometheusRuleGroupRuleArgs', 'AlertPrometheusRuleGroupRuleArgsDict']]]]] = None,
            scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'AlertPrometheusRuleGroup':
        """
        Get an existing AlertPrometheusRuleGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_name: Specifies the name of the Managed Kubernetes Cluster.
        :param pulumi.Input[_builtins.str] description: The description of the Alert Management Prometheus Rule Group.
        :param pulumi.Input[_builtins.str] interval: Specifies the interval in which to run the Alert Management Prometheus Rule Group represented in ISO 8601 duration format. Possible values are between `PT1M` and `PT15M`.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Alert Management Prometheus Rule Group should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Alert Management Prometheus Rule Group. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Alert Management Prometheus Rule Group should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] rule_group_enabled: Is this Alert Management Prometheus Rule Group enabled? Possible values are `true` and `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AlertPrometheusRuleGroupRuleArgs', 'AlertPrometheusRuleGroupRuleArgsDict']]]] rules: One or more `rule` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: Specifies the resource ID of the Azure Monitor Workspace.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Alert Management Prometheus Rule Group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlertPrometheusRuleGroupState.__new__(_AlertPrometheusRuleGroupState)

        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["description"] = description
        __props__.__dict__["interval"] = interval
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["rule_group_enabled"] = rule_group_enabled
        __props__.__dict__["rules"] = rules
        __props__.__dict__["scopes"] = scopes
        __props__.__dict__["tags"] = tags
        return AlertPrometheusRuleGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the name of the Managed Kubernetes Cluster.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the Alert Management Prometheus Rule Group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the interval in which to run the Alert Management Prometheus Rule Group represented in ISO 8601 duration format. Possible values are between `PT1M` and `PT15M`.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Azure Region where the Alert Management Prometheus Rule Group should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name which should be used for this Alert Management Prometheus Rule Group. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Resource Group where the Alert Management Prometheus Rule Group should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="ruleGroupEnabled")
    def rule_group_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is this Alert Management Prometheus Rule Group enabled? Possible values are `true` and `false`.
        """
        return pulumi.get(self, "rule_group_enabled")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Sequence['outputs.AlertPrometheusRuleGroupRule']]:
        """
        One or more `rule` blocks as defined below.
        """
        return pulumi.get(self, "rules")

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the resource ID of the Azure Monitor Workspace.
        """
        return pulumi.get(self, "scopes")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the Alert Management Prometheus Rule Group.
        """
        return pulumi.get(self, "tags")

