# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MetricAlertArgs', 'MetricAlert']

@pulumi.input_type
class MetricAlertArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 scopes: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['MetricAlertActionArgs']]]] = None,
                 application_insights_web_test_location_availability_criteria: Optional[pulumi.Input['MetricAlertApplicationInsightsWebTestLocationAvailabilityCriteriaArgs']] = None,
                 auto_mitigate: Optional[pulumi.Input[_builtins.bool]] = None,
                 criterias: Optional[pulumi.Input[Sequence[pulumi.Input['MetricAlertCriteriaArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic_criteria: Optional[pulumi.Input['MetricAlertDynamicCriteriaArgs']] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 severity: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_resource_location: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 window_size: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MetricAlert resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Metric Alert instance. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: A set of strings of resource IDs at which the metric criteria should be applied.
        :param pulumi.Input[Sequence[pulumi.Input['MetricAlertActionArgs']]] actions: One or more `action` blocks as defined below.
        :param pulumi.Input['MetricAlertApplicationInsightsWebTestLocationAvailabilityCriteriaArgs'] application_insights_web_test_location_availability_criteria: A `application_insights_web_test_location_availability_criteria` block as defined below.
               
               > **Note:** One of either `criteria`, `dynamic_criteria` or `application_insights_web_test_location_availability_criteria` must be specified.
        :param pulumi.Input[_builtins.bool] auto_mitigate: Should the alerts in this Metric Alert be auto resolved? Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['MetricAlertCriteriaArgs']]] criterias: One or more (static) `criteria` blocks as defined below.
               
               > **Note:** One of either `criteria`, `dynamic_criteria` or `application_insights_web_test_location_availability_criteria` must be specified.
        :param pulumi.Input[_builtins.str] description: The description of this Metric Alert.
        :param pulumi.Input['MetricAlertDynamicCriteriaArgs'] dynamic_criteria: A `dynamic_criteria` block as defined below.
               
               > **Note:** One of either `criteria`, `dynamic_criteria` or `application_insights_web_test_location_availability_criteria` must be specified.
        :param pulumi.Input[_builtins.bool] enabled: Should this Metric Alert be enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] frequency: The evaluation frequency of this Metric Alert, represented in ISO 8601 duration format. Possible values are `PT1M`, `PT5M`, `PT15M`, `PT30M` and `PT1H`. Defaults to `PT1M`.
        :param pulumi.Input[_builtins.str] name: The name of the Metric Alert. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] severity: The severity of this Metric Alert. Possible values are `0`, `1`, `2`, `3` and `4`. Defaults to `3`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] target_resource_location: The location of the target resource.
               
               > **Note:** This is Required when using a Subscription as scope, a Resource Group as scope or Multiple Scopes.
        :param pulumi.Input[_builtins.str] target_resource_type: The resource type (e.g. `Microsoft.Compute/virtualMachines`) of the target resource.
               
               > **Note:** This is Required when using a Subscription as scope, a Resource Group as scope or Multiple Scopes.
        :param pulumi.Input[_builtins.str] window_size: The period of time that is used to monitor alert activity, represented in ISO 8601 duration format. This value must be greater than `frequency`. Possible values are `PT1M`, `PT5M`, `PT15M`, `PT30M`, `PT1H`, `PT6H`, `PT12H` and `P1D`. Defaults to `PT5M`.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "scopes", scopes)
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if application_insights_web_test_location_availability_criteria is not None:
            pulumi.set(__self__, "application_insights_web_test_location_availability_criteria", application_insights_web_test_location_availability_criteria)
        if auto_mitigate is not None:
            pulumi.set(__self__, "auto_mitigate", auto_mitigate)
        if criterias is not None:
            pulumi.set(__self__, "criterias", criterias)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dynamic_criteria is not None:
            pulumi.set(__self__, "dynamic_criteria", dynamic_criteria)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_resource_location is not None:
            pulumi.set(__self__, "target_resource_location", target_resource_location)
        if target_resource_type is not None:
            pulumi.set(__self__, "target_resource_type", target_resource_type)
        if window_size is not None:
            pulumi.set(__self__, "window_size", window_size)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the Metric Alert instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A set of strings of resource IDs at which the metric criteria should be applied.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "scopes", value)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricAlertActionArgs']]]]:
        """
        One or more `action` blocks as defined below.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricAlertActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter(name="applicationInsightsWebTestLocationAvailabilityCriteria")
    def application_insights_web_test_location_availability_criteria(self) -> Optional[pulumi.Input['MetricAlertApplicationInsightsWebTestLocationAvailabilityCriteriaArgs']]:
        """
        A `application_insights_web_test_location_availability_criteria` block as defined below.

        > **Note:** One of either `criteria`, `dynamic_criteria` or `application_insights_web_test_location_availability_criteria` must be specified.
        """
        return pulumi.get(self, "application_insights_web_test_location_availability_criteria")

    @application_insights_web_test_location_availability_criteria.setter
    def application_insights_web_test_location_availability_criteria(self, value: Optional[pulumi.Input['MetricAlertApplicationInsightsWebTestLocationAvailabilityCriteriaArgs']]):
        pulumi.set(self, "application_insights_web_test_location_availability_criteria", value)

    @_builtins.property
    @pulumi.getter(name="autoMitigate")
    def auto_mitigate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the alerts in this Metric Alert be auto resolved? Defaults to `true`.
        """
        return pulumi.get(self, "auto_mitigate")

    @auto_mitigate.setter
    def auto_mitigate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_mitigate", value)

    @_builtins.property
    @pulumi.getter
    def criterias(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricAlertCriteriaArgs']]]]:
        """
        One or more (static) `criteria` blocks as defined below.

        > **Note:** One of either `criteria`, `dynamic_criteria` or `application_insights_web_test_location_availability_criteria` must be specified.
        """
        return pulumi.get(self, "criterias")

    @criterias.setter
    def criterias(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricAlertCriteriaArgs']]]]):
        pulumi.set(self, "criterias", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of this Metric Alert.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dynamicCriteria")
    def dynamic_criteria(self) -> Optional[pulumi.Input['MetricAlertDynamicCriteriaArgs']]:
        """
        A `dynamic_criteria` block as defined below.

        > **Note:** One of either `criteria`, `dynamic_criteria` or `application_insights_web_test_location_availability_criteria` must be specified.
        """
        return pulumi.get(self, "dynamic_criteria")

    @dynamic_criteria.setter
    def dynamic_criteria(self, value: Optional[pulumi.Input['MetricAlertDynamicCriteriaArgs']]):
        pulumi.set(self, "dynamic_criteria", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should this Metric Alert be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The evaluation frequency of this Metric Alert, represented in ISO 8601 duration format. Possible values are `PT1M`, `PT5M`, `PT15M`, `PT30M` and `PT1H`. Defaults to `PT1M`.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "frequency", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Metric Alert. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The severity of this Metric Alert. Possible values are `0`, `1`, `2`, `3` and `4`. Defaults to `3`.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "severity", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceLocation")
    def target_resource_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the target resource.

        > **Note:** This is Required when using a Subscription as scope, a Resource Group as scope or Multiple Scopes.
        """
        return pulumi.get(self, "target_resource_location")

    @target_resource_location.setter
    def target_resource_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_resource_location", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceType")
    def target_resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource type (e.g. `Microsoft.Compute/virtualMachines`) of the target resource.

        > **Note:** This is Required when using a Subscription as scope, a Resource Group as scope or Multiple Scopes.
        """
        return pulumi.get(self, "target_resource_type")

    @target_resource_type.setter
    def target_resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_resource_type", value)

    @_builtins.property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The period of time that is used to monitor alert activity, represented in ISO 8601 duration format. This value must be greater than `frequency`. Possible values are `PT1M`, `PT5M`, `PT15M`, `PT30M`, `PT1H`, `PT6H`, `PT12H` and `P1D`. Defaults to `PT5M`.
        """
        return pulumi.get(self, "window_size")

    @window_size.setter
    def window_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "window_size", value)


@pulumi.input_type
class _MetricAlertState:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['MetricAlertActionArgs']]]] = None,
                 application_insights_web_test_location_availability_criteria: Optional[pulumi.Input['MetricAlertApplicationInsightsWebTestLocationAvailabilityCriteriaArgs']] = None,
                 auto_mitigate: Optional[pulumi.Input[_builtins.bool]] = None,
                 criterias: Optional[pulumi.Input[Sequence[pulumi.Input['MetricAlertCriteriaArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic_criteria: Optional[pulumi.Input['MetricAlertDynamicCriteriaArgs']] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 severity: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_resource_location: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 window_size: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MetricAlert resources.
        :param pulumi.Input[Sequence[pulumi.Input['MetricAlertActionArgs']]] actions: One or more `action` blocks as defined below.
        :param pulumi.Input['MetricAlertApplicationInsightsWebTestLocationAvailabilityCriteriaArgs'] application_insights_web_test_location_availability_criteria: A `application_insights_web_test_location_availability_criteria` block as defined below.
               
               > **Note:** One of either `criteria`, `dynamic_criteria` or `application_insights_web_test_location_availability_criteria` must be specified.
        :param pulumi.Input[_builtins.bool] auto_mitigate: Should the alerts in this Metric Alert be auto resolved? Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input['MetricAlertCriteriaArgs']]] criterias: One or more (static) `criteria` blocks as defined below.
               
               > **Note:** One of either `criteria`, `dynamic_criteria` or `application_insights_web_test_location_availability_criteria` must be specified.
        :param pulumi.Input[_builtins.str] description: The description of this Metric Alert.
        :param pulumi.Input['MetricAlertDynamicCriteriaArgs'] dynamic_criteria: A `dynamic_criteria` block as defined below.
               
               > **Note:** One of either `criteria`, `dynamic_criteria` or `application_insights_web_test_location_availability_criteria` must be specified.
        :param pulumi.Input[_builtins.bool] enabled: Should this Metric Alert be enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] frequency: The evaluation frequency of this Metric Alert, represented in ISO 8601 duration format. Possible values are `PT1M`, `PT5M`, `PT15M`, `PT30M` and `PT1H`. Defaults to `PT1M`.
        :param pulumi.Input[_builtins.str] name: The name of the Metric Alert. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Metric Alert instance. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: A set of strings of resource IDs at which the metric criteria should be applied.
        :param pulumi.Input[_builtins.int] severity: The severity of this Metric Alert. Possible values are `0`, `1`, `2`, `3` and `4`. Defaults to `3`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] target_resource_location: The location of the target resource.
               
               > **Note:** This is Required when using a Subscription as scope, a Resource Group as scope or Multiple Scopes.
        :param pulumi.Input[_builtins.str] target_resource_type: The resource type (e.g. `Microsoft.Compute/virtualMachines`) of the target resource.
               
               > **Note:** This is Required when using a Subscription as scope, a Resource Group as scope or Multiple Scopes.
        :param pulumi.Input[_builtins.str] window_size: The period of time that is used to monitor alert activity, represented in ISO 8601 duration format. This value must be greater than `frequency`. Possible values are `PT1M`, `PT5M`, `PT15M`, `PT30M`, `PT1H`, `PT6H`, `PT12H` and `P1D`. Defaults to `PT5M`.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if application_insights_web_test_location_availability_criteria is not None:
            pulumi.set(__self__, "application_insights_web_test_location_availability_criteria", application_insights_web_test_location_availability_criteria)
        if auto_mitigate is not None:
            pulumi.set(__self__, "auto_mitigate", auto_mitigate)
        if criterias is not None:
            pulumi.set(__self__, "criterias", criterias)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dynamic_criteria is not None:
            pulumi.set(__self__, "dynamic_criteria", dynamic_criteria)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if target_resource_location is not None:
            pulumi.set(__self__, "target_resource_location", target_resource_location)
        if target_resource_type is not None:
            pulumi.set(__self__, "target_resource_type", target_resource_type)
        if window_size is not None:
            pulumi.set(__self__, "window_size", window_size)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricAlertActionArgs']]]]:
        """
        One or more `action` blocks as defined below.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricAlertActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter(name="applicationInsightsWebTestLocationAvailabilityCriteria")
    def application_insights_web_test_location_availability_criteria(self) -> Optional[pulumi.Input['MetricAlertApplicationInsightsWebTestLocationAvailabilityCriteriaArgs']]:
        """
        A `application_insights_web_test_location_availability_criteria` block as defined below.

        > **Note:** One of either `criteria`, `dynamic_criteria` or `application_insights_web_test_location_availability_criteria` must be specified.
        """
        return pulumi.get(self, "application_insights_web_test_location_availability_criteria")

    @application_insights_web_test_location_availability_criteria.setter
    def application_insights_web_test_location_availability_criteria(self, value: Optional[pulumi.Input['MetricAlertApplicationInsightsWebTestLocationAvailabilityCriteriaArgs']]):
        pulumi.set(self, "application_insights_web_test_location_availability_criteria", value)

    @_builtins.property
    @pulumi.getter(name="autoMitigate")
    def auto_mitigate(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the alerts in this Metric Alert be auto resolved? Defaults to `true`.
        """
        return pulumi.get(self, "auto_mitigate")

    @auto_mitigate.setter
    def auto_mitigate(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_mitigate", value)

    @_builtins.property
    @pulumi.getter
    def criterias(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricAlertCriteriaArgs']]]]:
        """
        One or more (static) `criteria` blocks as defined below.

        > **Note:** One of either `criteria`, `dynamic_criteria` or `application_insights_web_test_location_availability_criteria` must be specified.
        """
        return pulumi.get(self, "criterias")

    @criterias.setter
    def criterias(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricAlertCriteriaArgs']]]]):
        pulumi.set(self, "criterias", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of this Metric Alert.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dynamicCriteria")
    def dynamic_criteria(self) -> Optional[pulumi.Input['MetricAlertDynamicCriteriaArgs']]:
        """
        A `dynamic_criteria` block as defined below.

        > **Note:** One of either `criteria`, `dynamic_criteria` or `application_insights_web_test_location_availability_criteria` must be specified.
        """
        return pulumi.get(self, "dynamic_criteria")

    @dynamic_criteria.setter
    def dynamic_criteria(self, value: Optional[pulumi.Input['MetricAlertDynamicCriteriaArgs']]):
        pulumi.set(self, "dynamic_criteria", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should this Metric Alert be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The evaluation frequency of this Metric Alert, represented in ISO 8601 duration format. Possible values are `PT1M`, `PT5M`, `PT15M`, `PT30M` and `PT1H`. Defaults to `PT1M`.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "frequency", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Metric Alert. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the Metric Alert instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A set of strings of resource IDs at which the metric criteria should be applied.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "scopes", value)

    @_builtins.property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The severity of this Metric Alert. Possible values are `0`, `1`, `2`, `3` and `4`. Defaults to `3`.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "severity", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceLocation")
    def target_resource_location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location of the target resource.

        > **Note:** This is Required when using a Subscription as scope, a Resource Group as scope or Multiple Scopes.
        """
        return pulumi.get(self, "target_resource_location")

    @target_resource_location.setter
    def target_resource_location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_resource_location", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceType")
    def target_resource_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource type (e.g. `Microsoft.Compute/virtualMachines`) of the target resource.

        > **Note:** This is Required when using a Subscription as scope, a Resource Group as scope or Multiple Scopes.
        """
        return pulumi.get(self, "target_resource_type")

    @target_resource_type.setter
    def target_resource_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_resource_type", value)

    @_builtins.property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The period of time that is used to monitor alert activity, represented in ISO 8601 duration format. This value must be greater than `frequency`. Possible values are `PT1M`, `PT5M`, `PT15M`, `PT30M`, `PT1H`, `PT6H`, `PT12H` and `P1D`. Defaults to `PT5M`.
        """
        return pulumi.get(self, "window_size")

    @window_size.setter
    def window_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "window_size", value)


@pulumi.type_token("azure:monitoring/metricAlert:MetricAlert")
class MetricAlert(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MetricAlertActionArgs', 'MetricAlertActionArgsDict']]]]] = None,
                 application_insights_web_test_location_availability_criteria: Optional[pulumi.Input[Union['MetricAlertApplicationInsightsWebTestLocationAvailabilityCriteriaArgs', 'MetricAlertApplicationInsightsWebTestLocationAvailabilityCriteriaArgsDict']]] = None,
                 auto_mitigate: Optional[pulumi.Input[_builtins.bool]] = None,
                 criterias: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MetricAlertCriteriaArgs', 'MetricAlertCriteriaArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic_criteria: Optional[pulumi.Input[Union['MetricAlertDynamicCriteriaArgs', 'MetricAlertDynamicCriteriaArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 severity: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_resource_location: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 window_size: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Metric Alert within Azure Monitor.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        to_monitor = azure.storage.Account("to_monitor",
            name="examplestorageaccount",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        main = azure.monitoring.ActionGroup("main",
            name="example-actiongroup",
            resource_group_name=example.name,
            short_name="exampleact",
            webhook_receivers=[{
                "name": "callmyapi",
                "service_uri": "http://example.com/alert",
            }])
        example_metric_alert = azure.monitoring.MetricAlert("example",
            name="example-metricalert",
            resource_group_name=example.name,
            scopes=[to_monitor.id],
            description="Action will be triggered when Transactions count is greater than 50.",
            criterias=[{
                "metric_namespace": "Microsoft.Storage/storageAccounts",
                "metric_name": "Transactions",
                "aggregation": "Total",
                "operator": "GreaterThan",
                "threshold": 50,
                "dimensions": [{
                    "name": "ApiName",
                    "operator": "Include",
                    "values": ["*"],
                }],
            }],
            actions=[{
                "action_group_id": main.id,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Insights` - 2018-03-01

        ## Import

        Metric Alerts can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:monitoring/metricAlert:MetricAlert main /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example-resources/providers/Microsoft.Insights/metricAlerts/example-metricalert
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MetricAlertActionArgs', 'MetricAlertActionArgsDict']]]] actions: One or more `action` blocks as defined below.
        :param pulumi.Input[Union['MetricAlertApplicationInsightsWebTestLocationAvailabilityCriteriaArgs', 'MetricAlertApplicationInsightsWebTestLocationAvailabilityCriteriaArgsDict']] application_insights_web_test_location_availability_criteria: A `application_insights_web_test_location_availability_criteria` block as defined below.
               
               > **Note:** One of either `criteria`, `dynamic_criteria` or `application_insights_web_test_location_availability_criteria` must be specified.
        :param pulumi.Input[_builtins.bool] auto_mitigate: Should the alerts in this Metric Alert be auto resolved? Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MetricAlertCriteriaArgs', 'MetricAlertCriteriaArgsDict']]]] criterias: One or more (static) `criteria` blocks as defined below.
               
               > **Note:** One of either `criteria`, `dynamic_criteria` or `application_insights_web_test_location_availability_criteria` must be specified.
        :param pulumi.Input[_builtins.str] description: The description of this Metric Alert.
        :param pulumi.Input[Union['MetricAlertDynamicCriteriaArgs', 'MetricAlertDynamicCriteriaArgsDict']] dynamic_criteria: A `dynamic_criteria` block as defined below.
               
               > **Note:** One of either `criteria`, `dynamic_criteria` or `application_insights_web_test_location_availability_criteria` must be specified.
        :param pulumi.Input[_builtins.bool] enabled: Should this Metric Alert be enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] frequency: The evaluation frequency of this Metric Alert, represented in ISO 8601 duration format. Possible values are `PT1M`, `PT5M`, `PT15M`, `PT30M` and `PT1H`. Defaults to `PT1M`.
        :param pulumi.Input[_builtins.str] name: The name of the Metric Alert. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Metric Alert instance. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: A set of strings of resource IDs at which the metric criteria should be applied.
        :param pulumi.Input[_builtins.int] severity: The severity of this Metric Alert. Possible values are `0`, `1`, `2`, `3` and `4`. Defaults to `3`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] target_resource_location: The location of the target resource.
               
               > **Note:** This is Required when using a Subscription as scope, a Resource Group as scope or Multiple Scopes.
        :param pulumi.Input[_builtins.str] target_resource_type: The resource type (e.g. `Microsoft.Compute/virtualMachines`) of the target resource.
               
               > **Note:** This is Required when using a Subscription as scope, a Resource Group as scope or Multiple Scopes.
        :param pulumi.Input[_builtins.str] window_size: The period of time that is used to monitor alert activity, represented in ISO 8601 duration format. This value must be greater than `frequency`. Possible values are `PT1M`, `PT5M`, `PT15M`, `PT30M`, `PT1H`, `PT6H`, `PT12H` and `P1D`. Defaults to `PT5M`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MetricAlertArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Metric Alert within Azure Monitor.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        to_monitor = azure.storage.Account("to_monitor",
            name="examplestorageaccount",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        main = azure.monitoring.ActionGroup("main",
            name="example-actiongroup",
            resource_group_name=example.name,
            short_name="exampleact",
            webhook_receivers=[{
                "name": "callmyapi",
                "service_uri": "http://example.com/alert",
            }])
        example_metric_alert = azure.monitoring.MetricAlert("example",
            name="example-metricalert",
            resource_group_name=example.name,
            scopes=[to_monitor.id],
            description="Action will be triggered when Transactions count is greater than 50.",
            criterias=[{
                "metric_namespace": "Microsoft.Storage/storageAccounts",
                "metric_name": "Transactions",
                "aggregation": "Total",
                "operator": "GreaterThan",
                "threshold": 50,
                "dimensions": [{
                    "name": "ApiName",
                    "operator": "Include",
                    "values": ["*"],
                }],
            }],
            actions=[{
                "action_group_id": main.id,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Insights` - 2018-03-01

        ## Import

        Metric Alerts can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:monitoring/metricAlert:MetricAlert main /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example-resources/providers/Microsoft.Insights/metricAlerts/example-metricalert
        ```

        :param str resource_name: The name of the resource.
        :param MetricAlertArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MetricAlertArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MetricAlertActionArgs', 'MetricAlertActionArgsDict']]]]] = None,
                 application_insights_web_test_location_availability_criteria: Optional[pulumi.Input[Union['MetricAlertApplicationInsightsWebTestLocationAvailabilityCriteriaArgs', 'MetricAlertApplicationInsightsWebTestLocationAvailabilityCriteriaArgsDict']]] = None,
                 auto_mitigate: Optional[pulumi.Input[_builtins.bool]] = None,
                 criterias: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MetricAlertCriteriaArgs', 'MetricAlertCriteriaArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic_criteria: Optional[pulumi.Input[Union['MetricAlertDynamicCriteriaArgs', 'MetricAlertDynamicCriteriaArgsDict']]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 frequency: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 severity: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 target_resource_location: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_type: Optional[pulumi.Input[_builtins.str]] = None,
                 window_size: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MetricAlertArgs.__new__(MetricAlertArgs)

            __props__.__dict__["actions"] = actions
            __props__.__dict__["application_insights_web_test_location_availability_criteria"] = application_insights_web_test_location_availability_criteria
            __props__.__dict__["auto_mitigate"] = auto_mitigate
            __props__.__dict__["criterias"] = criterias
            __props__.__dict__["description"] = description
            __props__.__dict__["dynamic_criteria"] = dynamic_criteria
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["frequency"] = frequency
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if scopes is None and not opts.urn:
                raise TypeError("Missing required property 'scopes'")
            __props__.__dict__["scopes"] = scopes
            __props__.__dict__["severity"] = severity
            __props__.__dict__["tags"] = tags
            __props__.__dict__["target_resource_location"] = target_resource_location
            __props__.__dict__["target_resource_type"] = target_resource_type
            __props__.__dict__["window_size"] = window_size
        super(MetricAlert, __self__).__init__(
            'azure:monitoring/metricAlert:MetricAlert',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MetricAlertActionArgs', 'MetricAlertActionArgsDict']]]]] = None,
            application_insights_web_test_location_availability_criteria: Optional[pulumi.Input[Union['MetricAlertApplicationInsightsWebTestLocationAvailabilityCriteriaArgs', 'MetricAlertApplicationInsightsWebTestLocationAvailabilityCriteriaArgsDict']]] = None,
            auto_mitigate: Optional[pulumi.Input[_builtins.bool]] = None,
            criterias: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MetricAlertCriteriaArgs', 'MetricAlertCriteriaArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dynamic_criteria: Optional[pulumi.Input[Union['MetricAlertDynamicCriteriaArgs', 'MetricAlertDynamicCriteriaArgsDict']]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            frequency: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            scopes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            severity: Optional[pulumi.Input[_builtins.int]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            target_resource_location: Optional[pulumi.Input[_builtins.str]] = None,
            target_resource_type: Optional[pulumi.Input[_builtins.str]] = None,
            window_size: Optional[pulumi.Input[_builtins.str]] = None) -> 'MetricAlert':
        """
        Get an existing MetricAlert resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MetricAlertActionArgs', 'MetricAlertActionArgsDict']]]] actions: One or more `action` blocks as defined below.
        :param pulumi.Input[Union['MetricAlertApplicationInsightsWebTestLocationAvailabilityCriteriaArgs', 'MetricAlertApplicationInsightsWebTestLocationAvailabilityCriteriaArgsDict']] application_insights_web_test_location_availability_criteria: A `application_insights_web_test_location_availability_criteria` block as defined below.
               
               > **Note:** One of either `criteria`, `dynamic_criteria` or `application_insights_web_test_location_availability_criteria` must be specified.
        :param pulumi.Input[_builtins.bool] auto_mitigate: Should the alerts in this Metric Alert be auto resolved? Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MetricAlertCriteriaArgs', 'MetricAlertCriteriaArgsDict']]]] criterias: One or more (static) `criteria` blocks as defined below.
               
               > **Note:** One of either `criteria`, `dynamic_criteria` or `application_insights_web_test_location_availability_criteria` must be specified.
        :param pulumi.Input[_builtins.str] description: The description of this Metric Alert.
        :param pulumi.Input[Union['MetricAlertDynamicCriteriaArgs', 'MetricAlertDynamicCriteriaArgsDict']] dynamic_criteria: A `dynamic_criteria` block as defined below.
               
               > **Note:** One of either `criteria`, `dynamic_criteria` or `application_insights_web_test_location_availability_criteria` must be specified.
        :param pulumi.Input[_builtins.bool] enabled: Should this Metric Alert be enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.str] frequency: The evaluation frequency of this Metric Alert, represented in ISO 8601 duration format. Possible values are `PT1M`, `PT5M`, `PT15M`, `PT30M` and `PT1H`. Defaults to `PT1M`.
        :param pulumi.Input[_builtins.str] name: The name of the Metric Alert. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Metric Alert instance. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] scopes: A set of strings of resource IDs at which the metric criteria should be applied.
        :param pulumi.Input[_builtins.int] severity: The severity of this Metric Alert. Possible values are `0`, `1`, `2`, `3` and `4`. Defaults to `3`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] target_resource_location: The location of the target resource.
               
               > **Note:** This is Required when using a Subscription as scope, a Resource Group as scope or Multiple Scopes.
        :param pulumi.Input[_builtins.str] target_resource_type: The resource type (e.g. `Microsoft.Compute/virtualMachines`) of the target resource.
               
               > **Note:** This is Required when using a Subscription as scope, a Resource Group as scope or Multiple Scopes.
        :param pulumi.Input[_builtins.str] window_size: The period of time that is used to monitor alert activity, represented in ISO 8601 duration format. This value must be greater than `frequency`. Possible values are `PT1M`, `PT5M`, `PT15M`, `PT30M`, `PT1H`, `PT6H`, `PT12H` and `P1D`. Defaults to `PT5M`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MetricAlertState.__new__(_MetricAlertState)

        __props__.__dict__["actions"] = actions
        __props__.__dict__["application_insights_web_test_location_availability_criteria"] = application_insights_web_test_location_availability_criteria
        __props__.__dict__["auto_mitigate"] = auto_mitigate
        __props__.__dict__["criterias"] = criterias
        __props__.__dict__["description"] = description
        __props__.__dict__["dynamic_criteria"] = dynamic_criteria
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["frequency"] = frequency
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["scopes"] = scopes
        __props__.__dict__["severity"] = severity
        __props__.__dict__["tags"] = tags
        __props__.__dict__["target_resource_location"] = target_resource_location
        __props__.__dict__["target_resource_type"] = target_resource_type
        __props__.__dict__["window_size"] = window_size
        return MetricAlert(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> pulumi.Output[Optional[Sequence['outputs.MetricAlertAction']]]:
        """
        One or more `action` blocks as defined below.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter(name="applicationInsightsWebTestLocationAvailabilityCriteria")
    def application_insights_web_test_location_availability_criteria(self) -> pulumi.Output[Optional['outputs.MetricAlertApplicationInsightsWebTestLocationAvailabilityCriteria']]:
        """
        A `application_insights_web_test_location_availability_criteria` block as defined below.

        > **Note:** One of either `criteria`, `dynamic_criteria` or `application_insights_web_test_location_availability_criteria` must be specified.
        """
        return pulumi.get(self, "application_insights_web_test_location_availability_criteria")

    @_builtins.property
    @pulumi.getter(name="autoMitigate")
    def auto_mitigate(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the alerts in this Metric Alert be auto resolved? Defaults to `true`.
        """
        return pulumi.get(self, "auto_mitigate")

    @_builtins.property
    @pulumi.getter
    def criterias(self) -> pulumi.Output[Optional[Sequence['outputs.MetricAlertCriteria']]]:
        """
        One or more (static) `criteria` blocks as defined below.

        > **Note:** One of either `criteria`, `dynamic_criteria` or `application_insights_web_test_location_availability_criteria` must be specified.
        """
        return pulumi.get(self, "criterias")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of this Metric Alert.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dynamicCriteria")
    def dynamic_criteria(self) -> pulumi.Output[Optional['outputs.MetricAlertDynamicCriteria']]:
        """
        A `dynamic_criteria` block as defined below.

        > **Note:** One of either `criteria`, `dynamic_criteria` or `application_insights_web_test_location_availability_criteria` must be specified.
        """
        return pulumi.get(self, "dynamic_criteria")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should this Metric Alert be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The evaluation frequency of this Metric Alert, represented in ISO 8601 duration format. Possible values are `PT1M`, `PT5M`, `PT15M`, `PT30M` and `PT1H`. Defaults to `PT1M`.
        """
        return pulumi.get(self, "frequency")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Metric Alert. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the Metric Alert instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A set of strings of resource IDs at which the metric criteria should be applied.
        """
        return pulumi.get(self, "scopes")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The severity of this Metric Alert. Possible values are `0`, `1`, `2`, `3` and `4`. Defaults to `3`.
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="targetResourceLocation")
    def target_resource_location(self) -> pulumi.Output[_builtins.str]:
        """
        The location of the target resource.

        > **Note:** This is Required when using a Subscription as scope, a Resource Group as scope or Multiple Scopes.
        """
        return pulumi.get(self, "target_resource_location")

    @_builtins.property
    @pulumi.getter(name="targetResourceType")
    def target_resource_type(self) -> pulumi.Output[_builtins.str]:
        """
        The resource type (e.g. `Microsoft.Compute/virtualMachines`) of the target resource.

        > **Note:** This is Required when using a Subscription as scope, a Resource Group as scope or Multiple Scopes.
        """
        return pulumi.get(self, "target_resource_type")

    @_builtins.property
    @pulumi.getter(name="windowSize")
    def window_size(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The period of time that is used to monitor alert activity, represented in ISO 8601 duration format. This value must be greater than `frequency`. Possible values are `PT1M`, `PT5M`, `PT15M`, `PT30M`, `PT1H`, `PT6H`, `PT12H` and `P1D`. Defaults to `PT5M`.
        """
        return pulumi.get(self, "window_size")

