# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PrivateLinkScopeArgs', 'PrivateLinkScope']

@pulumi.input_type
class PrivateLinkScopeArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 ingestion_access_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_access_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a PrivateLinkScope resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Monitor Private Link Scope should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] ingestion_access_mode: The default ingestion access mode for the associated private endpoints in scope. Possible values are `Open` and `PrivateOnly`. Defaults to `Open`.
        :param pulumi.Input[_builtins.str] name: The name of the Azure Monitor Private Link Scope. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] query_access_mode: The default query access mode for hte associated private endpoints in scope. Possible values are `Open` and `PrivateOnly`. Defaults to `Open`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Monitor Private Link Scope.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if ingestion_access_mode is not None:
            pulumi.set(__self__, "ingestion_access_mode", ingestion_access_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query_access_mode is not None:
            pulumi.set(__self__, "query_access_mode", query_access_mode)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Azure Monitor Private Link Scope should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="ingestionAccessMode")
    def ingestion_access_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default ingestion access mode for the associated private endpoints in scope. Possible values are `Open` and `PrivateOnly`. Defaults to `Open`.
        """
        return pulumi.get(self, "ingestion_access_mode")

    @ingestion_access_mode.setter
    def ingestion_access_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ingestion_access_mode", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Azure Monitor Private Link Scope. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="queryAccessMode")
    def query_access_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default query access mode for hte associated private endpoints in scope. Possible values are `Open` and `PrivateOnly`. Defaults to `Open`.
        """
        return pulumi.get(self, "query_access_mode")

    @query_access_mode.setter
    def query_access_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_access_mode", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Azure Monitor Private Link Scope.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _PrivateLinkScopeState:
    def __init__(__self__, *,
                 ingestion_access_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_access_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering PrivateLinkScope resources.
        :param pulumi.Input[_builtins.str] ingestion_access_mode: The default ingestion access mode for the associated private endpoints in scope. Possible values are `Open` and `PrivateOnly`. Defaults to `Open`.
        :param pulumi.Input[_builtins.str] name: The name of the Azure Monitor Private Link Scope. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] query_access_mode: The default query access mode for hte associated private endpoints in scope. Possible values are `Open` and `PrivateOnly`. Defaults to `Open`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Monitor Private Link Scope should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Monitor Private Link Scope.
        """
        if ingestion_access_mode is not None:
            pulumi.set(__self__, "ingestion_access_mode", ingestion_access_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query_access_mode is not None:
            pulumi.set(__self__, "query_access_mode", query_access_mode)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="ingestionAccessMode")
    def ingestion_access_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default ingestion access mode for the associated private endpoints in scope. Possible values are `Open` and `PrivateOnly`. Defaults to `Open`.
        """
        return pulumi.get(self, "ingestion_access_mode")

    @ingestion_access_mode.setter
    def ingestion_access_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ingestion_access_mode", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Azure Monitor Private Link Scope. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="queryAccessMode")
    def query_access_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default query access mode for hte associated private endpoints in scope. Possible values are `Open` and `PrivateOnly`. Defaults to `Open`.
        """
        return pulumi.get(self, "query_access_mode")

    @query_access_mode.setter
    def query_access_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "query_access_mode", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Azure Monitor Private Link Scope should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Azure Monitor Private Link Scope.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:monitoring/privateLinkScope:PrivateLinkScope")
class PrivateLinkScope(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ingestion_access_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_access_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an Azure Monitor Private Link Scope.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_private_link_scope = azure.monitoring.PrivateLinkScope("example",
            name="example-ampls",
            resource_group_name=example.name,
            ingestion_access_mode="PrivateOnly",
            query_access_mode="Open")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Insights` - 2021-07-01-preview

        ## Import

        Azure Monitor Private Link Scopes can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:monitoring/privateLinkScope:PrivateLinkScope example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Insights/privateLinkScopes/pls1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ingestion_access_mode: The default ingestion access mode for the associated private endpoints in scope. Possible values are `Open` and `PrivateOnly`. Defaults to `Open`.
        :param pulumi.Input[_builtins.str] name: The name of the Azure Monitor Private Link Scope. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] query_access_mode: The default query access mode for hte associated private endpoints in scope. Possible values are `Open` and `PrivateOnly`. Defaults to `Open`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Monitor Private Link Scope should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Monitor Private Link Scope.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PrivateLinkScopeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Monitor Private Link Scope.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_private_link_scope = azure.monitoring.PrivateLinkScope("example",
            name="example-ampls",
            resource_group_name=example.name,
            ingestion_access_mode="PrivateOnly",
            query_access_mode="Open")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Insights` - 2021-07-01-preview

        ## Import

        Azure Monitor Private Link Scopes can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:monitoring/privateLinkScope:PrivateLinkScope example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Insights/privateLinkScopes/pls1
        ```

        :param str resource_name: The name of the resource.
        :param PrivateLinkScopeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PrivateLinkScopeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ingestion_access_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 query_access_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PrivateLinkScopeArgs.__new__(PrivateLinkScopeArgs)

            __props__.__dict__["ingestion_access_mode"] = ingestion_access_mode
            __props__.__dict__["name"] = name
            __props__.__dict__["query_access_mode"] = query_access_mode
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
        super(PrivateLinkScope, __self__).__init__(
            'azure:monitoring/privateLinkScope:PrivateLinkScope',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ingestion_access_mode: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            query_access_mode: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'PrivateLinkScope':
        """
        Get an existing PrivateLinkScope resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ingestion_access_mode: The default ingestion access mode for the associated private endpoints in scope. Possible values are `Open` and `PrivateOnly`. Defaults to `Open`.
        :param pulumi.Input[_builtins.str] name: The name of the Azure Monitor Private Link Scope. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] query_access_mode: The default query access mode for hte associated private endpoints in scope. Possible values are `Open` and `PrivateOnly`. Defaults to `Open`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Azure Monitor Private Link Scope should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Azure Monitor Private Link Scope.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PrivateLinkScopeState.__new__(_PrivateLinkScopeState)

        __props__.__dict__["ingestion_access_mode"] = ingestion_access_mode
        __props__.__dict__["name"] = name
        __props__.__dict__["query_access_mode"] = query_access_mode
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        return PrivateLinkScope(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="ingestionAccessMode")
    def ingestion_access_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The default ingestion access mode for the associated private endpoints in scope. Possible values are `Open` and `PrivateOnly`. Defaults to `Open`.
        """
        return pulumi.get(self, "ingestion_access_mode")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Azure Monitor Private Link Scope. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="queryAccessMode")
    def query_access_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The default query access mode for hte associated private endpoints in scope. Possible values are `Open` and `PrivateOnly`. Defaults to `Open`.
        """
        return pulumi.get(self, "query_access_mode")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Azure Monitor Private Link Scope should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Azure Monitor Private Link Scope.
        """
        return pulumi.get(self, "tags")

