# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ManagedInstanceActiveDirectoryAdministratorArgs', 'ManagedInstanceActiveDirectoryAdministrator']

@pulumi.input_type
class ManagedInstanceActiveDirectoryAdministratorArgs:
    def __init__(__self__, *,
                 login_username: pulumi.Input[_builtins.str],
                 managed_instance_id: pulumi.Input[_builtins.str],
                 object_id: pulumi.Input[_builtins.str],
                 tenant_id: pulumi.Input[_builtins.str],
                 azuread_authentication_only: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ManagedInstanceActiveDirectoryAdministrator resource.
        :param pulumi.Input[_builtins.str] login_username: The login name of the principal to set as the Managed Instance Administrator.
        :param pulumi.Input[_builtins.str] managed_instance_id: The ID of the Azure SQL Managed Instance for which to set the administrator. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] object_id: The Object ID of the principal to set as the Managed Instance Administrator.
        :param pulumi.Input[_builtins.str] tenant_id: The Azure Active Directory Tenant ID.
        :param pulumi.Input[_builtins.bool] azuread_authentication_only: When `true`, only permit logins from AAD users and administrators. When `false`, also allow local database users.
        """
        pulumi.set(__self__, "login_username", login_username)
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        pulumi.set(__self__, "object_id", object_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        if azuread_authentication_only is not None:
            pulumi.set(__self__, "azuread_authentication_only", azuread_authentication_only)

    @_builtins.property
    @pulumi.getter(name="loginUsername")
    def login_username(self) -> pulumi.Input[_builtins.str]:
        """
        The login name of the principal to set as the Managed Instance Administrator.
        """
        return pulumi.get(self, "login_username")

    @login_username.setter
    def login_username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "login_username", value)

    @_builtins.property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Azure SQL Managed Instance for which to set the administrator. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_instance_id")

    @managed_instance_id.setter
    def managed_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "managed_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Object ID of the principal to set as the Managed Instance Administrator.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "object_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Azure Active Directory Tenant ID.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="azureadAuthenticationOnly")
    def azuread_authentication_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When `true`, only permit logins from AAD users and administrators. When `false`, also allow local database users.
        """
        return pulumi.get(self, "azuread_authentication_only")

    @azuread_authentication_only.setter
    def azuread_authentication_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "azuread_authentication_only", value)


@pulumi.input_type
class _ManagedInstanceActiveDirectoryAdministratorState:
    def __init__(__self__, *,
                 azuread_authentication_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 login_username: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagedInstanceActiveDirectoryAdministrator resources.
        :param pulumi.Input[_builtins.bool] azuread_authentication_only: When `true`, only permit logins from AAD users and administrators. When `false`, also allow local database users.
        :param pulumi.Input[_builtins.str] login_username: The login name of the principal to set as the Managed Instance Administrator.
        :param pulumi.Input[_builtins.str] managed_instance_id: The ID of the Azure SQL Managed Instance for which to set the administrator. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] object_id: The Object ID of the principal to set as the Managed Instance Administrator.
        :param pulumi.Input[_builtins.str] tenant_id: The Azure Active Directory Tenant ID.
        """
        if azuread_authentication_only is not None:
            pulumi.set(__self__, "azuread_authentication_only", azuread_authentication_only)
        if login_username is not None:
            pulumi.set(__self__, "login_username", login_username)
        if managed_instance_id is not None:
            pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="azureadAuthenticationOnly")
    def azuread_authentication_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        When `true`, only permit logins from AAD users and administrators. When `false`, also allow local database users.
        """
        return pulumi.get(self, "azuread_authentication_only")

    @azuread_authentication_only.setter
    def azuread_authentication_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "azuread_authentication_only", value)

    @_builtins.property
    @pulumi.getter(name="loginUsername")
    def login_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The login name of the principal to set as the Managed Instance Administrator.
        """
        return pulumi.get(self, "login_username")

    @login_username.setter
    def login_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "login_username", value)

    @_builtins.property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Azure SQL Managed Instance for which to set the administrator. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_instance_id")

    @managed_instance_id.setter
    def managed_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Object ID of the principal to set as the Managed Instance Administrator.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Active Directory Tenant ID.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.type_token("azure:mssql/managedInstanceActiveDirectoryAdministrator:ManagedInstanceActiveDirectoryAdministrator")
class ManagedInstanceActiveDirectoryAdministrator(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 azuread_authentication_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 login_username: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Allows you to set a user, group or service principal as the AAD Administrator for an Azure SQL Managed Instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuread as azuread

        example = azure.core.ResourceGroup("example",
            name="rg-example",
            location="West Europe")
        current = azure.core.get_client_config()
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="example",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_managed_instance = azure.mssql.ManagedInstance("example",
            name="managedsqlinstance",
            resource_group_name=example.name,
            location=example.location,
            license_type="BasePrice",
            sku_name="GP_Gen5",
            storage_size_in_gb=32,
            subnet_id=example_subnet.id,
            vcores=4,
            administrator_login="msadministrator",
            administrator_login_password="thisIsDog11",
            identity={
                "type": "SystemAssigned",
            })
        reader = azuread.DirectoryRole("reader", display_name="Directory Readers")
        example_directory_role_member = azuread.DirectoryRoleMember("example",
            role_object_id=reader.object_id,
            member_object_id=example_managed_instance.identity.principal_id)
        admin = azuread.User("admin",
            user_principal_name="ms.admin@example.com",
            display_name="Ms Admin",
            mail_nickname="ms.admin",
            password="SecretP@sswd99!")
        example_managed_instance_active_directory_administrator = azure.mssql.ManagedInstanceActiveDirectoryAdministrator("example",
            managed_instance_id=example_managed_instance.id,
            login_username="msadmin",
            object_id=admin.object_id,
            tenant_id=current.tenant_id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Sql` - 2023-08-01-preview

        ## Import

        An Azure SQL Active Directory Administrator can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/managedInstanceActiveDirectoryAdministrator:ManagedInstanceActiveDirectoryAdministrator administrator /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myresourcegroup/providers/Microsoft.Sql/managedInstances/mymanagedinstance/administrators/activeDirectory
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] azuread_authentication_only: When `true`, only permit logins from AAD users and administrators. When `false`, also allow local database users.
        :param pulumi.Input[_builtins.str] login_username: The login name of the principal to set as the Managed Instance Administrator.
        :param pulumi.Input[_builtins.str] managed_instance_id: The ID of the Azure SQL Managed Instance for which to set the administrator. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] object_id: The Object ID of the principal to set as the Managed Instance Administrator.
        :param pulumi.Input[_builtins.str] tenant_id: The Azure Active Directory Tenant ID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedInstanceActiveDirectoryAdministratorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows you to set a user, group or service principal as the AAD Administrator for an Azure SQL Managed Instance.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuread as azuread

        example = azure.core.ResourceGroup("example",
            name="rg-example",
            location="West Europe")
        current = azure.core.get_client_config()
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="example",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_managed_instance = azure.mssql.ManagedInstance("example",
            name="managedsqlinstance",
            resource_group_name=example.name,
            location=example.location,
            license_type="BasePrice",
            sku_name="GP_Gen5",
            storage_size_in_gb=32,
            subnet_id=example_subnet.id,
            vcores=4,
            administrator_login="msadministrator",
            administrator_login_password="thisIsDog11",
            identity={
                "type": "SystemAssigned",
            })
        reader = azuread.DirectoryRole("reader", display_name="Directory Readers")
        example_directory_role_member = azuread.DirectoryRoleMember("example",
            role_object_id=reader.object_id,
            member_object_id=example_managed_instance.identity.principal_id)
        admin = azuread.User("admin",
            user_principal_name="ms.admin@example.com",
            display_name="Ms Admin",
            mail_nickname="ms.admin",
            password="SecretP@sswd99!")
        example_managed_instance_active_directory_administrator = azure.mssql.ManagedInstanceActiveDirectoryAdministrator("example",
            managed_instance_id=example_managed_instance.id,
            login_username="msadmin",
            object_id=admin.object_id,
            tenant_id=current.tenant_id)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Sql` - 2023-08-01-preview

        ## Import

        An Azure SQL Active Directory Administrator can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/managedInstanceActiveDirectoryAdministrator:ManagedInstanceActiveDirectoryAdministrator administrator /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myresourcegroup/providers/Microsoft.Sql/managedInstances/mymanagedinstance/administrators/activeDirectory
        ```

        :param str resource_name: The name of the resource.
        :param ManagedInstanceActiveDirectoryAdministratorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedInstanceActiveDirectoryAdministratorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 azuread_authentication_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 login_username: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedInstanceActiveDirectoryAdministratorArgs.__new__(ManagedInstanceActiveDirectoryAdministratorArgs)

            __props__.__dict__["azuread_authentication_only"] = azuread_authentication_only
            if login_username is None and not opts.urn:
                raise TypeError("Missing required property 'login_username'")
            __props__.__dict__["login_username"] = login_username
            if managed_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'managed_instance_id'")
            __props__.__dict__["managed_instance_id"] = managed_instance_id
            if object_id is None and not opts.urn:
                raise TypeError("Missing required property 'object_id'")
            __props__.__dict__["object_id"] = object_id
            if tenant_id is None and not opts.urn:
                raise TypeError("Missing required property 'tenant_id'")
            __props__.__dict__["tenant_id"] = tenant_id
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure:sql/managedInstanceActiveDirectoryAdministrator:ManagedInstanceActiveDirectoryAdministrator")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(ManagedInstanceActiveDirectoryAdministrator, __self__).__init__(
            'azure:mssql/managedInstanceActiveDirectoryAdministrator:ManagedInstanceActiveDirectoryAdministrator',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            azuread_authentication_only: Optional[pulumi.Input[_builtins.bool]] = None,
            login_username: Optional[pulumi.Input[_builtins.str]] = None,
            managed_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            object_id: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ManagedInstanceActiveDirectoryAdministrator':
        """
        Get an existing ManagedInstanceActiveDirectoryAdministrator resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] azuread_authentication_only: When `true`, only permit logins from AAD users and administrators. When `false`, also allow local database users.
        :param pulumi.Input[_builtins.str] login_username: The login name of the principal to set as the Managed Instance Administrator.
        :param pulumi.Input[_builtins.str] managed_instance_id: The ID of the Azure SQL Managed Instance for which to set the administrator. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] object_id: The Object ID of the principal to set as the Managed Instance Administrator.
        :param pulumi.Input[_builtins.str] tenant_id: The Azure Active Directory Tenant ID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedInstanceActiveDirectoryAdministratorState.__new__(_ManagedInstanceActiveDirectoryAdministratorState)

        __props__.__dict__["azuread_authentication_only"] = azuread_authentication_only
        __props__.__dict__["login_username"] = login_username
        __props__.__dict__["managed_instance_id"] = managed_instance_id
        __props__.__dict__["object_id"] = object_id
        __props__.__dict__["tenant_id"] = tenant_id
        return ManagedInstanceActiveDirectoryAdministrator(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="azureadAuthenticationOnly")
    def azuread_authentication_only(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        When `true`, only permit logins from AAD users and administrators. When `false`, also allow local database users.
        """
        return pulumi.get(self, "azuread_authentication_only")

    @_builtins.property
    @pulumi.getter(name="loginUsername")
    def login_username(self) -> pulumi.Output[_builtins.str]:
        """
        The login name of the principal to set as the Managed Instance Administrator.
        """
        return pulumi.get(self, "login_username")

    @_builtins.property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Azure SQL Managed Instance for which to set the administrator. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_instance_id")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Object ID of the principal to set as the Managed Instance Administrator.
        """
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Active Directory Tenant ID.
        """
        return pulumi.get(self, "tenant_id")

