# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedInstanceStartStopScheduleArgs', 'ManagedInstanceStartStopSchedule']

@pulumi.input_type
class ManagedInstanceStartStopScheduleArgs:
    def __init__(__self__, *,
                 managed_instance_id: pulumi.Input[_builtins.str],
                 schedules: pulumi.Input[Sequence[pulumi.Input['ManagedInstanceStartStopScheduleScheduleArgs']]],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 timezone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ManagedInstanceStartStopSchedule resource.
        :param pulumi.Input[_builtins.str] managed_instance_id: Specifies the ID of the Managed Instance. Changing this forces a new Sql Start Stop Managed Instance Schedule to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedInstanceStartStopScheduleScheduleArgs']]] schedules: A `schedule` block as defined below.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the schedule.
        :param pulumi.Input[_builtins.str] timezone_id: Specifies the time zone of the schedule. Defaults to `UTC`.
        """
        pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        pulumi.set(__self__, "schedules", schedules)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if timezone_id is not None:
            pulumi.set(__self__, "timezone_id", timezone_id)

    @_builtins.property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the Managed Instance. Changing this forces a new Sql Start Stop Managed Instance Schedule to be created.
        """
        return pulumi.get(self, "managed_instance_id")

    @managed_instance_id.setter
    def managed_instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "managed_instance_id", value)

    @_builtins.property
    @pulumi.getter
    def schedules(self) -> pulumi.Input[Sequence[pulumi.Input['ManagedInstanceStartStopScheduleScheduleArgs']]]:
        """
        A `schedule` block as defined below.
        """
        return pulumi.get(self, "schedules")

    @schedules.setter
    def schedules(self, value: pulumi.Input[Sequence[pulumi.Input['ManagedInstanceStartStopScheduleScheduleArgs']]]):
        pulumi.set(self, "schedules", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the schedule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="timezoneId")
    def timezone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the time zone of the schedule. Defaults to `UTC`.
        """
        return pulumi.get(self, "timezone_id")

    @timezone_id.setter
    def timezone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone_id", value)


@pulumi.input_type
class _ManagedInstanceStartStopScheduleState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 next_execution_time: Optional[pulumi.Input[_builtins.str]] = None,
                 next_run_action: Optional[pulumi.Input[_builtins.str]] = None,
                 schedules: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceStartStopScheduleScheduleArgs']]]] = None,
                 timezone_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagedInstanceStartStopSchedule resources.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the schedule.
        :param pulumi.Input[_builtins.str] managed_instance_id: Specifies the ID of the Managed Instance. Changing this forces a new Sql Start Stop Managed Instance Schedule to be created.
        :param pulumi.Input[_builtins.str] next_execution_time: Timestamp when the next action will be executed in the corresponding schedule time zone.
        :param pulumi.Input[_builtins.str] next_run_action: Next action to be executed (Start or Stop).
        :param pulumi.Input[Sequence[pulumi.Input['ManagedInstanceStartStopScheduleScheduleArgs']]] schedules: A `schedule` block as defined below.
        :param pulumi.Input[_builtins.str] timezone_id: Specifies the time zone of the schedule. Defaults to `UTC`.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if managed_instance_id is not None:
            pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if next_execution_time is not None:
            pulumi.set(__self__, "next_execution_time", next_execution_time)
        if next_run_action is not None:
            pulumi.set(__self__, "next_run_action", next_run_action)
        if schedules is not None:
            pulumi.set(__self__, "schedules", schedules)
        if timezone_id is not None:
            pulumi.set(__self__, "timezone_id", timezone_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the schedule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the Managed Instance. Changing this forces a new Sql Start Stop Managed Instance Schedule to be created.
        """
        return pulumi.get(self, "managed_instance_id")

    @managed_instance_id.setter
    def managed_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="nextExecutionTime")
    def next_execution_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Timestamp when the next action will be executed in the corresponding schedule time zone.
        """
        return pulumi.get(self, "next_execution_time")

    @next_execution_time.setter
    def next_execution_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "next_execution_time", value)

    @_builtins.property
    @pulumi.getter(name="nextRunAction")
    def next_run_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Next action to be executed (Start or Stop).
        """
        return pulumi.get(self, "next_run_action")

    @next_run_action.setter
    def next_run_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "next_run_action", value)

    @_builtins.property
    @pulumi.getter
    def schedules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceStartStopScheduleScheduleArgs']]]]:
        """
        A `schedule` block as defined below.
        """
        return pulumi.get(self, "schedules")

    @schedules.setter
    def schedules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceStartStopScheduleScheduleArgs']]]]):
        pulumi.set(self, "schedules", value)

    @_builtins.property
    @pulumi.getter(name="timezoneId")
    def timezone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the time zone of the schedule. Defaults to `UTC`.
        """
        return pulumi.get(self, "timezone_id")

    @timezone_id.setter
    def timezone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timezone_id", value)


@pulumi.type_token("azure:mssql/managedInstanceStartStopSchedule:ManagedInstanceStartStopSchedule")
class ManagedInstanceStartStopSchedule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 schedules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceStartStopScheduleScheduleArgs', 'ManagedInstanceStartStopScheduleScheduleArgsDict']]]]] = None,
                 timezone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages Start Stop Schedules for an MS SQL Managed Instance.

        ## Import

        MS SQL Managed Instance Start Stop Schedule can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/managedInstanceStartStopSchedule:ManagedInstanceStartStopSchedule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Sql/managedInstances/managedInstance1/startStopSchedules/default
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the schedule.
        :param pulumi.Input[_builtins.str] managed_instance_id: Specifies the ID of the Managed Instance. Changing this forces a new Sql Start Stop Managed Instance Schedule to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceStartStopScheduleScheduleArgs', 'ManagedInstanceStartStopScheduleScheduleArgsDict']]]] schedules: A `schedule` block as defined below.
        :param pulumi.Input[_builtins.str] timezone_id: Specifies the time zone of the schedule. Defaults to `UTC`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedInstanceStartStopScheduleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Start Stop Schedules for an MS SQL Managed Instance.

        ## Import

        MS SQL Managed Instance Start Stop Schedule can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mssql/managedInstanceStartStopSchedule:ManagedInstanceStartStopSchedule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.Sql/managedInstances/managedInstance1/startStopSchedules/default
        ```

        :param str resource_name: The name of the resource.
        :param ManagedInstanceStartStopScheduleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedInstanceStartStopScheduleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 schedules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceStartStopScheduleScheduleArgs', 'ManagedInstanceStartStopScheduleScheduleArgsDict']]]]] = None,
                 timezone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedInstanceStartStopScheduleArgs.__new__(ManagedInstanceStartStopScheduleArgs)

            __props__.__dict__["description"] = description
            if managed_instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'managed_instance_id'")
            __props__.__dict__["managed_instance_id"] = managed_instance_id
            if schedules is None and not opts.urn:
                raise TypeError("Missing required property 'schedules'")
            __props__.__dict__["schedules"] = schedules
            __props__.__dict__["timezone_id"] = timezone_id
            __props__.__dict__["next_execution_time"] = None
            __props__.__dict__["next_run_action"] = None
        super(ManagedInstanceStartStopSchedule, __self__).__init__(
            'azure:mssql/managedInstanceStartStopSchedule:ManagedInstanceStartStopSchedule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            managed_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            next_execution_time: Optional[pulumi.Input[_builtins.str]] = None,
            next_run_action: Optional[pulumi.Input[_builtins.str]] = None,
            schedules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceStartStopScheduleScheduleArgs', 'ManagedInstanceStartStopScheduleScheduleArgsDict']]]]] = None,
            timezone_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ManagedInstanceStartStopSchedule':
        """
        Get an existing ManagedInstanceStartStopSchedule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the schedule.
        :param pulumi.Input[_builtins.str] managed_instance_id: Specifies the ID of the Managed Instance. Changing this forces a new Sql Start Stop Managed Instance Schedule to be created.
        :param pulumi.Input[_builtins.str] next_execution_time: Timestamp when the next action will be executed in the corresponding schedule time zone.
        :param pulumi.Input[_builtins.str] next_run_action: Next action to be executed (Start or Stop).
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceStartStopScheduleScheduleArgs', 'ManagedInstanceStartStopScheduleScheduleArgsDict']]]] schedules: A `schedule` block as defined below.
        :param pulumi.Input[_builtins.str] timezone_id: Specifies the time zone of the schedule. Defaults to `UTC`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedInstanceStartStopScheduleState.__new__(_ManagedInstanceStartStopScheduleState)

        __props__.__dict__["description"] = description
        __props__.__dict__["managed_instance_id"] = managed_instance_id
        __props__.__dict__["next_execution_time"] = next_execution_time
        __props__.__dict__["next_run_action"] = next_run_action
        __props__.__dict__["schedules"] = schedules
        __props__.__dict__["timezone_id"] = timezone_id
        return ManagedInstanceStartStopSchedule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description of the schedule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the Managed Instance. Changing this forces a new Sql Start Stop Managed Instance Schedule to be created.
        """
        return pulumi.get(self, "managed_instance_id")

    @_builtins.property
    @pulumi.getter(name="nextExecutionTime")
    def next_execution_time(self) -> pulumi.Output[_builtins.str]:
        """
        Timestamp when the next action will be executed in the corresponding schedule time zone.
        """
        return pulumi.get(self, "next_execution_time")

    @_builtins.property
    @pulumi.getter(name="nextRunAction")
    def next_run_action(self) -> pulumi.Output[_builtins.str]:
        """
        Next action to be executed (Start or Stop).
        """
        return pulumi.get(self, "next_run_action")

    @_builtins.property
    @pulumi.getter
    def schedules(self) -> pulumi.Output[Sequence['outputs.ManagedInstanceStartStopScheduleSchedule']]:
        """
        A `schedule` block as defined below.
        """
        return pulumi.get(self, "schedules")

    @_builtins.property
    @pulumi.getter(name="timezoneId")
    def timezone_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the time zone of the schedule. Defaults to `UTC`.
        """
        return pulumi.get(self, "timezone_id")

