# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AccountEncryptionArgs', 'AccountEncryption']

@pulumi.input_type
class AccountEncryptionArgs:
    def __init__(__self__, *,
                 encryption_key: pulumi.Input[_builtins.str],
                 netapp_account_id: pulumi.Input[_builtins.str],
                 cross_tenant_key_vault_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 federated_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_assigned_identity_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_assigned_identity_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AccountEncryption resource.
        :param pulumi.Input[_builtins.str] encryption_key: Specify the versionless ID of the encryption key.
        :param pulumi.Input[_builtins.str] netapp_account_id: The ID of the NetApp account where volume under it will have customer managed keys-based encryption enabled.
        :param pulumi.Input[_builtins.str] cross_tenant_key_vault_resource_id: The full resource ID of the cross-tenant key vault. This is recommended when using `federated_client_id` for cross-tenant scenarios to ensure proper validation by Azure APIs.
        :param pulumi.Input[_builtins.str] federated_client_id: The Client ID of the multi-tenant Entra ID application used to access cross-tenant key vaults. This is only required when accessing a key vault in a different tenant than the NetApp account.
        :param pulumi.Input[_builtins.str] system_assigned_identity_principal_id: The ID of the System Assigned Manged Identity. Conflicts with `user_assigned_identity_id`.
        :param pulumi.Input[_builtins.str] user_assigned_identity_id: The ID of the User Assigned Managed Identity. Conflicts with `system_assigned_identity_principal_id`.
        """
        pulumi.set(__self__, "encryption_key", encryption_key)
        pulumi.set(__self__, "netapp_account_id", netapp_account_id)
        if cross_tenant_key_vault_resource_id is not None:
            pulumi.set(__self__, "cross_tenant_key_vault_resource_id", cross_tenant_key_vault_resource_id)
        if federated_client_id is not None:
            pulumi.set(__self__, "federated_client_id", federated_client_id)
        if system_assigned_identity_principal_id is not None:
            pulumi.set(__self__, "system_assigned_identity_principal_id", system_assigned_identity_principal_id)
        if user_assigned_identity_id is not None:
            pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> pulumi.Input[_builtins.str]:
        """
        Specify the versionless ID of the encryption key.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "encryption_key", value)

    @_builtins.property
    @pulumi.getter(name="netappAccountId")
    def netapp_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the NetApp account where volume under it will have customer managed keys-based encryption enabled.
        """
        return pulumi.get(self, "netapp_account_id")

    @netapp_account_id.setter
    def netapp_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "netapp_account_id", value)

    @_builtins.property
    @pulumi.getter(name="crossTenantKeyVaultResourceId")
    def cross_tenant_key_vault_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full resource ID of the cross-tenant key vault. This is recommended when using `federated_client_id` for cross-tenant scenarios to ensure proper validation by Azure APIs.
        """
        return pulumi.get(self, "cross_tenant_key_vault_resource_id")

    @cross_tenant_key_vault_resource_id.setter
    def cross_tenant_key_vault_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_tenant_key_vault_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="federatedClientId")
    def federated_client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Client ID of the multi-tenant Entra ID application used to access cross-tenant key vaults. This is only required when accessing a key vault in a different tenant than the NetApp account.
        """
        return pulumi.get(self, "federated_client_id")

    @federated_client_id.setter
    def federated_client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "federated_client_id", value)

    @_builtins.property
    @pulumi.getter(name="systemAssignedIdentityPrincipalId")
    def system_assigned_identity_principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the System Assigned Manged Identity. Conflicts with `user_assigned_identity_id`.
        """
        return pulumi.get(self, "system_assigned_identity_principal_id")

    @system_assigned_identity_principal_id.setter
    def system_assigned_identity_principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_assigned_identity_principal_id", value)

    @_builtins.property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the User Assigned Managed Identity. Conflicts with `system_assigned_identity_principal_id`.
        """
        return pulumi.get(self, "user_assigned_identity_id")

    @user_assigned_identity_id.setter
    def user_assigned_identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_assigned_identity_id", value)


@pulumi.input_type
class _AccountEncryptionState:
    def __init__(__self__, *,
                 cross_tenant_key_vault_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 federated_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 netapp_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_assigned_identity_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_assigned_identity_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AccountEncryption resources.
        :param pulumi.Input[_builtins.str] cross_tenant_key_vault_resource_id: The full resource ID of the cross-tenant key vault. This is recommended when using `federated_client_id` for cross-tenant scenarios to ensure proper validation by Azure APIs.
        :param pulumi.Input[_builtins.str] encryption_key: Specify the versionless ID of the encryption key.
        :param pulumi.Input[_builtins.str] federated_client_id: The Client ID of the multi-tenant Entra ID application used to access cross-tenant key vaults. This is only required when accessing a key vault in a different tenant than the NetApp account.
        :param pulumi.Input[_builtins.str] netapp_account_id: The ID of the NetApp account where volume under it will have customer managed keys-based encryption enabled.
        :param pulumi.Input[_builtins.str] system_assigned_identity_principal_id: The ID of the System Assigned Manged Identity. Conflicts with `user_assigned_identity_id`.
        :param pulumi.Input[_builtins.str] user_assigned_identity_id: The ID of the User Assigned Managed Identity. Conflicts with `system_assigned_identity_principal_id`.
        """
        if cross_tenant_key_vault_resource_id is not None:
            pulumi.set(__self__, "cross_tenant_key_vault_resource_id", cross_tenant_key_vault_resource_id)
        if encryption_key is not None:
            pulumi.set(__self__, "encryption_key", encryption_key)
        if federated_client_id is not None:
            pulumi.set(__self__, "federated_client_id", federated_client_id)
        if netapp_account_id is not None:
            pulumi.set(__self__, "netapp_account_id", netapp_account_id)
        if system_assigned_identity_principal_id is not None:
            pulumi.set(__self__, "system_assigned_identity_principal_id", system_assigned_identity_principal_id)
        if user_assigned_identity_id is not None:
            pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)

    @_builtins.property
    @pulumi.getter(name="crossTenantKeyVaultResourceId")
    def cross_tenant_key_vault_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The full resource ID of the cross-tenant key vault. This is recommended when using `federated_client_id` for cross-tenant scenarios to ensure proper validation by Azure APIs.
        """
        return pulumi.get(self, "cross_tenant_key_vault_resource_id")

    @cross_tenant_key_vault_resource_id.setter
    def cross_tenant_key_vault_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cross_tenant_key_vault_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the versionless ID of the encryption key.
        """
        return pulumi.get(self, "encryption_key")

    @encryption_key.setter
    def encryption_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_key", value)

    @_builtins.property
    @pulumi.getter(name="federatedClientId")
    def federated_client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Client ID of the multi-tenant Entra ID application used to access cross-tenant key vaults. This is only required when accessing a key vault in a different tenant than the NetApp account.
        """
        return pulumi.get(self, "federated_client_id")

    @federated_client_id.setter
    def federated_client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "federated_client_id", value)

    @_builtins.property
    @pulumi.getter(name="netappAccountId")
    def netapp_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the NetApp account where volume under it will have customer managed keys-based encryption enabled.
        """
        return pulumi.get(self, "netapp_account_id")

    @netapp_account_id.setter
    def netapp_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "netapp_account_id", value)

    @_builtins.property
    @pulumi.getter(name="systemAssignedIdentityPrincipalId")
    def system_assigned_identity_principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the System Assigned Manged Identity. Conflicts with `user_assigned_identity_id`.
        """
        return pulumi.get(self, "system_assigned_identity_principal_id")

    @system_assigned_identity_principal_id.setter
    def system_assigned_identity_principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_assigned_identity_principal_id", value)

    @_builtins.property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the User Assigned Managed Identity. Conflicts with `system_assigned_identity_principal_id`.
        """
        return pulumi.get(self, "user_assigned_identity_id")

    @user_assigned_identity_id.setter
    def user_assigned_identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_assigned_identity_id", value)


@pulumi.type_token("azure:netapp/accountEncryption:AccountEncryption")
class AccountEncryption(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cross_tenant_key_vault_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 federated_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 netapp_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_assigned_identity_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_assigned_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a NetApp Account Encryption Resource.

        For more information about Azure NetApp Files Customer-Managed Keys feature, please refer to [Configure customer-managed keys for Azure NetApp Files volume encryption](https://learn.microsoft.com/en-us/azure/azure-netapp-files/configure-customer-managed-keys)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        current = azure.core.get_client_config()
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="anf-user-assigned-identity",
            location=example.location,
            resource_group_name=example.name)
        example_key_vault = azure.keyvault.KeyVault("example",
            name="anfcmkakv",
            location=example.location,
            resource_group_name=example.name,
            enabled_for_disk_encryption=True,
            enabled_for_deployment=True,
            enabled_for_template_deployment=True,
            purge_protection_enabled=True,
            tenant_id="00000000-0000-0000-0000-000000000000",
            sku_name="standard",
            access_policies=[
                {
                    "tenant_id": "00000000-0000-0000-0000-000000000000",
                    "object_id": current.object_id,
                    "key_permissions": [
                        "Get",
                        "Create",
                        "Delete",
                        "WrapKey",
                        "UnwrapKey",
                        "GetRotationPolicy",
                        "SetRotationPolicy",
                    ],
                },
                {
                    "tenant_id": "00000000-0000-0000-0000-000000000000",
                    "object_id": example_user_assigned_identity.principal_id,
                    "key_permissions": [
                        "Get",
                        "Encrypt",
                        "Decrypt",
                    ],
                },
            ])
        example_key = azure.keyvault.Key("example",
            name="anfencryptionkey",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "decrypt",
                "encrypt",
                "sign",
                "unwrapKey",
                "verify",
                "wrapKey",
            ])
        example_account = azure.netapp.Account("example",
            name="netappaccount",
            location=example.location,
            resource_group_name=example.name,
            identity={
                "type": "UserAssigned",
                "identity_ids": [example_user_assigned_identity.id],
            })
        example_account_encryption = azure.netapp.AccountEncryption("example",
            netapp_account_id=example_account.id,
            user_assigned_identity_id=example_user_assigned_identity.id,
            encryption_key=example_key.versionless_id,
            federated_client_id=example_user_assigned_identity.client_id)
        ```

        ## Cross-Tenant Usage

        For scenarios where the key vault is in a different Entra ID tenant:

        ```python
        import pulumi
        import pulumi_azure as azure

        cross_tenant = azure.netapp.AccountEncryption("cross_tenant",
            netapp_account_id=example["id"],
            user_assigned_identity_id=example_azurerm_user_assigned_identity["id"],
            encryption_key="https://keyvault-in-other-tenant.vault.azure.net/keys/encryption-key",
            federated_client_id="12345678-1234-1234-1234-123456789012",
            cross_tenant_key_vault_resource_id="/subscriptions/11111111-1111-1111-1111-111111111111/resourceGroups/remote-rg/providers/Microsoft.KeyVault/vaults/keyvault-in-other-tenant")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.NetApp` - 2025-06-01

        ## Import

        Account Encryption Resources can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:netapp/accountEncryption:AccountEncryption example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.NetApp/netAppAccounts/account1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cross_tenant_key_vault_resource_id: The full resource ID of the cross-tenant key vault. This is recommended when using `federated_client_id` for cross-tenant scenarios to ensure proper validation by Azure APIs.
        :param pulumi.Input[_builtins.str] encryption_key: Specify the versionless ID of the encryption key.
        :param pulumi.Input[_builtins.str] federated_client_id: The Client ID of the multi-tenant Entra ID application used to access cross-tenant key vaults. This is only required when accessing a key vault in a different tenant than the NetApp account.
        :param pulumi.Input[_builtins.str] netapp_account_id: The ID of the NetApp account where volume under it will have customer managed keys-based encryption enabled.
        :param pulumi.Input[_builtins.str] system_assigned_identity_principal_id: The ID of the System Assigned Manged Identity. Conflicts with `user_assigned_identity_id`.
        :param pulumi.Input[_builtins.str] user_assigned_identity_id: The ID of the User Assigned Managed Identity. Conflicts with `system_assigned_identity_principal_id`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AccountEncryptionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a NetApp Account Encryption Resource.

        For more information about Azure NetApp Files Customer-Managed Keys feature, please refer to [Configure customer-managed keys for Azure NetApp Files volume encryption](https://learn.microsoft.com/en-us/azure/azure-netapp-files/configure-customer-managed-keys)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        current = azure.core.get_client_config()
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="anf-user-assigned-identity",
            location=example.location,
            resource_group_name=example.name)
        example_key_vault = azure.keyvault.KeyVault("example",
            name="anfcmkakv",
            location=example.location,
            resource_group_name=example.name,
            enabled_for_disk_encryption=True,
            enabled_for_deployment=True,
            enabled_for_template_deployment=True,
            purge_protection_enabled=True,
            tenant_id="00000000-0000-0000-0000-000000000000",
            sku_name="standard",
            access_policies=[
                {
                    "tenant_id": "00000000-0000-0000-0000-000000000000",
                    "object_id": current.object_id,
                    "key_permissions": [
                        "Get",
                        "Create",
                        "Delete",
                        "WrapKey",
                        "UnwrapKey",
                        "GetRotationPolicy",
                        "SetRotationPolicy",
                    ],
                },
                {
                    "tenant_id": "00000000-0000-0000-0000-000000000000",
                    "object_id": example_user_assigned_identity.principal_id,
                    "key_permissions": [
                        "Get",
                        "Encrypt",
                        "Decrypt",
                    ],
                },
            ])
        example_key = azure.keyvault.Key("example",
            name="anfencryptionkey",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "decrypt",
                "encrypt",
                "sign",
                "unwrapKey",
                "verify",
                "wrapKey",
            ])
        example_account = azure.netapp.Account("example",
            name="netappaccount",
            location=example.location,
            resource_group_name=example.name,
            identity={
                "type": "UserAssigned",
                "identity_ids": [example_user_assigned_identity.id],
            })
        example_account_encryption = azure.netapp.AccountEncryption("example",
            netapp_account_id=example_account.id,
            user_assigned_identity_id=example_user_assigned_identity.id,
            encryption_key=example_key.versionless_id,
            federated_client_id=example_user_assigned_identity.client_id)
        ```

        ## Cross-Tenant Usage

        For scenarios where the key vault is in a different Entra ID tenant:

        ```python
        import pulumi
        import pulumi_azure as azure

        cross_tenant = azure.netapp.AccountEncryption("cross_tenant",
            netapp_account_id=example["id"],
            user_assigned_identity_id=example_azurerm_user_assigned_identity["id"],
            encryption_key="https://keyvault-in-other-tenant.vault.azure.net/keys/encryption-key",
            federated_client_id="12345678-1234-1234-1234-123456789012",
            cross_tenant_key_vault_resource_id="/subscriptions/11111111-1111-1111-1111-111111111111/resourceGroups/remote-rg/providers/Microsoft.KeyVault/vaults/keyvault-in-other-tenant")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.NetApp` - 2025-06-01

        ## Import

        Account Encryption Resources can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:netapp/accountEncryption:AccountEncryption example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.NetApp/netAppAccounts/account1
        ```

        :param str resource_name: The name of the resource.
        :param AccountEncryptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountEncryptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cross_tenant_key_vault_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
                 federated_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 netapp_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_assigned_identity_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_assigned_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountEncryptionArgs.__new__(AccountEncryptionArgs)

            __props__.__dict__["cross_tenant_key_vault_resource_id"] = cross_tenant_key_vault_resource_id
            if encryption_key is None and not opts.urn:
                raise TypeError("Missing required property 'encryption_key'")
            __props__.__dict__["encryption_key"] = encryption_key
            __props__.__dict__["federated_client_id"] = federated_client_id
            if netapp_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'netapp_account_id'")
            __props__.__dict__["netapp_account_id"] = netapp_account_id
            __props__.__dict__["system_assigned_identity_principal_id"] = system_assigned_identity_principal_id
            __props__.__dict__["user_assigned_identity_id"] = user_assigned_identity_id
        super(AccountEncryption, __self__).__init__(
            'azure:netapp/accountEncryption:AccountEncryption',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cross_tenant_key_vault_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            encryption_key: Optional[pulumi.Input[_builtins.str]] = None,
            federated_client_id: Optional[pulumi.Input[_builtins.str]] = None,
            netapp_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            system_assigned_identity_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
            user_assigned_identity_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AccountEncryption':
        """
        Get an existing AccountEncryption resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cross_tenant_key_vault_resource_id: The full resource ID of the cross-tenant key vault. This is recommended when using `federated_client_id` for cross-tenant scenarios to ensure proper validation by Azure APIs.
        :param pulumi.Input[_builtins.str] encryption_key: Specify the versionless ID of the encryption key.
        :param pulumi.Input[_builtins.str] federated_client_id: The Client ID of the multi-tenant Entra ID application used to access cross-tenant key vaults. This is only required when accessing a key vault in a different tenant than the NetApp account.
        :param pulumi.Input[_builtins.str] netapp_account_id: The ID of the NetApp account where volume under it will have customer managed keys-based encryption enabled.
        :param pulumi.Input[_builtins.str] system_assigned_identity_principal_id: The ID of the System Assigned Manged Identity. Conflicts with `user_assigned_identity_id`.
        :param pulumi.Input[_builtins.str] user_assigned_identity_id: The ID of the User Assigned Managed Identity. Conflicts with `system_assigned_identity_principal_id`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountEncryptionState.__new__(_AccountEncryptionState)

        __props__.__dict__["cross_tenant_key_vault_resource_id"] = cross_tenant_key_vault_resource_id
        __props__.__dict__["encryption_key"] = encryption_key
        __props__.__dict__["federated_client_id"] = federated_client_id
        __props__.__dict__["netapp_account_id"] = netapp_account_id
        __props__.__dict__["system_assigned_identity_principal_id"] = system_assigned_identity_principal_id
        __props__.__dict__["user_assigned_identity_id"] = user_assigned_identity_id
        return AccountEncryption(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="crossTenantKeyVaultResourceId")
    def cross_tenant_key_vault_resource_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The full resource ID of the cross-tenant key vault. This is recommended when using `federated_client_id` for cross-tenant scenarios to ensure proper validation by Azure APIs.
        """
        return pulumi.get(self, "cross_tenant_key_vault_resource_id")

    @_builtins.property
    @pulumi.getter(name="encryptionKey")
    def encryption_key(self) -> pulumi.Output[_builtins.str]:
        """
        Specify the versionless ID of the encryption key.
        """
        return pulumi.get(self, "encryption_key")

    @_builtins.property
    @pulumi.getter(name="federatedClientId")
    def federated_client_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Client ID of the multi-tenant Entra ID application used to access cross-tenant key vaults. This is only required when accessing a key vault in a different tenant than the NetApp account.
        """
        return pulumi.get(self, "federated_client_id")

    @_builtins.property
    @pulumi.getter(name="netappAccountId")
    def netapp_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the NetApp account where volume under it will have customer managed keys-based encryption enabled.
        """
        return pulumi.get(self, "netapp_account_id")

    @_builtins.property
    @pulumi.getter(name="systemAssignedIdentityPrincipalId")
    def system_assigned_identity_principal_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the System Assigned Manged Identity. Conflicts with `user_assigned_identity_id`.
        """
        return pulumi.get(self, "system_assigned_identity_principal_id")

    @_builtins.property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the User Assigned Managed Identity. Conflicts with `system_assigned_identity_principal_id`.
        """
        return pulumi.get(self, "user_assigned_identity_id")

