# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplicationGatewayArgs', 'ApplicationGateway']

@pulumi.input_type
class ApplicationGatewayArgs:
    def __init__(__self__, *,
                 backend_address_pools: pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayBackendAddressPoolArgs']]],
                 backend_http_settings: pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayBackendHttpSettingArgs']]],
                 frontend_ip_configurations: pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayFrontendIpConfigurationArgs']]],
                 frontend_ports: pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayFrontendPortArgs']]],
                 gateway_ip_configurations: pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayGatewayIpConfigurationArgs']]],
                 http_listeners: pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayHttpListenerArgs']]],
                 request_routing_rules: pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRequestRoutingRuleArgs']]],
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku: pulumi.Input['ApplicationGatewaySkuArgs'],
                 authentication_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayAuthenticationCertificateArgs']]]] = None,
                 autoscale_configuration: Optional[pulumi.Input['ApplicationGatewayAutoscaleConfigurationArgs']] = None,
                 custom_error_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayCustomErrorConfigurationArgs']]]] = None,
                 enable_http2: Optional[pulumi.Input[_builtins.bool]] = None,
                 fips_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_firewall_policy_association: Optional[pulumi.Input[_builtins.bool]] = None,
                 global_: Optional[pulumi.Input['ApplicationGatewayGlobalArgs']] = None,
                 identity: Optional[pulumi.Input['ApplicationGatewayIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_link_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayPrivateLinkConfigurationArgs']]]] = None,
                 probes: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayProbeArgs']]]] = None,
                 redirect_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRedirectConfigurationArgs']]]] = None,
                 rewrite_rule_sets: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRewriteRuleSetArgs']]]] = None,
                 ssl_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewaySslCertificateArgs']]]] = None,
                 ssl_policy: Optional[pulumi.Input['ApplicationGatewaySslPolicyArgs']] = None,
                 ssl_profiles: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewaySslProfileArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 trusted_client_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayTrustedClientCertificateArgs']]]] = None,
                 trusted_root_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayTrustedRootCertificateArgs']]]] = None,
                 url_path_maps: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayUrlPathMapArgs']]]] = None,
                 waf_configuration: Optional[pulumi.Input['ApplicationGatewayWafConfigurationArgs']] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ApplicationGateway resource.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayBackendAddressPoolArgs']]] backend_address_pools: One or more `backend_address_pool` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayBackendHttpSettingArgs']]] backend_http_settings: One or more `backend_http_settings` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayFrontendIpConfigurationArgs']]] frontend_ip_configurations: One or more `frontend_ip_configuration` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayFrontendPortArgs']]] frontend_ports: One or more `frontend_port` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayGatewayIpConfigurationArgs']]] gateway_ip_configurations: One or more `gateway_ip_configuration` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayHttpListenerArgs']]] http_listeners: One or more `http_listener` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRequestRoutingRuleArgs']]] request_routing_rules: One or more `request_routing_rule` blocks as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to the Application Gateway should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['ApplicationGatewaySkuArgs'] sku: A `sku` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayAuthenticationCertificateArgs']]] authentication_certificates: One or more `authentication_certificate` blocks as defined below.
        :param pulumi.Input['ApplicationGatewayAutoscaleConfigurationArgs'] autoscale_configuration: An `autoscale_configuration` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayCustomErrorConfigurationArgs']]] custom_error_configurations: One or more `custom_error_configuration` blocks as defined below.
        :param pulumi.Input[_builtins.bool] enable_http2: Is HTTP2 enabled on the application gateway resource? Defaults to `false`.
        :param pulumi.Input[_builtins.bool] fips_enabled: Is FIPS enabled on the Application Gateway?
        :param pulumi.Input[_builtins.str] firewall_policy_id: The ID of the Web Application Firewall Policy.
        :param pulumi.Input[_builtins.bool] force_firewall_policy_association: Is the Firewall Policy associated with the Application Gateway?
        :param pulumi.Input['ApplicationGatewayGlobalArgs'] global_: A `global` block as defined below.
        :param pulumi.Input['ApplicationGatewayIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure region where the Application Gateway should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Application Gateway. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayPrivateLinkConfigurationArgs']]] private_link_configurations: One or more `private_link_configuration` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayProbeArgs']]] probes: One or more `probe` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRedirectConfigurationArgs']]] redirect_configurations: One or more `redirect_configuration` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRewriteRuleSetArgs']]] rewrite_rule_sets: One or more `rewrite_rule_set` blocks as defined below. Only valid for v2 WAF and Standard SKUs.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewaySslCertificateArgs']]] ssl_certificates: One or more `ssl_certificate` blocks as defined below.
        :param pulumi.Input['ApplicationGatewaySslPolicyArgs'] ssl_policy: a `ssl_policy` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewaySslProfileArgs']]] ssl_profiles: One or more `ssl_profile` blocks as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayTrustedClientCertificateArgs']]] trusted_client_certificates: One or more `trusted_client_certificate` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayTrustedRootCertificateArgs']]] trusted_root_certificates: One or more `trusted_root_certificate` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayUrlPathMapArgs']]] url_path_maps: One or more `url_path_map` blocks as defined below.
        :param pulumi.Input['ApplicationGatewayWafConfigurationArgs'] waf_configuration: A `waf_configuration` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this Application Gateway should be located. Changing this forces a new Application Gateway to be created.
               
               > **Note:** Availability Zones are not supported in all regions at this time, please check the [official documentation](https://docs.microsoft.com/azure/availability-zones/az-overview) for more information. They are also only supported for [v2 SKUs](https://docs.microsoft.com/azure/application-gateway/application-gateway-autoscaling-zone-redundant)
        """
        pulumi.set(__self__, "backend_address_pools", backend_address_pools)
        pulumi.set(__self__, "backend_http_settings", backend_http_settings)
        pulumi.set(__self__, "frontend_ip_configurations", frontend_ip_configurations)
        pulumi.set(__self__, "frontend_ports", frontend_ports)
        pulumi.set(__self__, "gateway_ip_configurations", gateway_ip_configurations)
        pulumi.set(__self__, "http_listeners", http_listeners)
        pulumi.set(__self__, "request_routing_rules", request_routing_rules)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku", sku)
        if authentication_certificates is not None:
            pulumi.set(__self__, "authentication_certificates", authentication_certificates)
        if autoscale_configuration is not None:
            pulumi.set(__self__, "autoscale_configuration", autoscale_configuration)
        if custom_error_configurations is not None:
            pulumi.set(__self__, "custom_error_configurations", custom_error_configurations)
        if enable_http2 is not None:
            pulumi.set(__self__, "enable_http2", enable_http2)
        if fips_enabled is not None:
            pulumi.set(__self__, "fips_enabled", fips_enabled)
        if firewall_policy_id is not None:
            pulumi.set(__self__, "firewall_policy_id", firewall_policy_id)
        if force_firewall_policy_association is not None:
            pulumi.set(__self__, "force_firewall_policy_association", force_firewall_policy_association)
        if global_ is not None:
            pulumi.set(__self__, "global_", global_)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_link_configurations is not None:
            pulumi.set(__self__, "private_link_configurations", private_link_configurations)
        if probes is not None:
            pulumi.set(__self__, "probes", probes)
        if redirect_configurations is not None:
            pulumi.set(__self__, "redirect_configurations", redirect_configurations)
        if rewrite_rule_sets is not None:
            pulumi.set(__self__, "rewrite_rule_sets", rewrite_rule_sets)
        if ssl_certificates is not None:
            pulumi.set(__self__, "ssl_certificates", ssl_certificates)
        if ssl_policy is not None:
            pulumi.set(__self__, "ssl_policy", ssl_policy)
        if ssl_profiles is not None:
            pulumi.set(__self__, "ssl_profiles", ssl_profiles)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if trusted_client_certificates is not None:
            pulumi.set(__self__, "trusted_client_certificates", trusted_client_certificates)
        if trusted_root_certificates is not None:
            pulumi.set(__self__, "trusted_root_certificates", trusted_root_certificates)
        if url_path_maps is not None:
            pulumi.set(__self__, "url_path_maps", url_path_maps)
        if waf_configuration is not None:
            pulumi.set(__self__, "waf_configuration", waf_configuration)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="backendAddressPools")
    def backend_address_pools(self) -> pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayBackendAddressPoolArgs']]]:
        """
        One or more `backend_address_pool` blocks as defined below.
        """
        return pulumi.get(self, "backend_address_pools")

    @backend_address_pools.setter
    def backend_address_pools(self, value: pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayBackendAddressPoolArgs']]]):
        pulumi.set(self, "backend_address_pools", value)

    @_builtins.property
    @pulumi.getter(name="backendHttpSettings")
    def backend_http_settings(self) -> pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayBackendHttpSettingArgs']]]:
        """
        One or more `backend_http_settings` blocks as defined below.
        """
        return pulumi.get(self, "backend_http_settings")

    @backend_http_settings.setter
    def backend_http_settings(self, value: pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayBackendHttpSettingArgs']]]):
        pulumi.set(self, "backend_http_settings", value)

    @_builtins.property
    @pulumi.getter(name="frontendIpConfigurations")
    def frontend_ip_configurations(self) -> pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayFrontendIpConfigurationArgs']]]:
        """
        One or more `frontend_ip_configuration` blocks as defined below.
        """
        return pulumi.get(self, "frontend_ip_configurations")

    @frontend_ip_configurations.setter
    def frontend_ip_configurations(self, value: pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayFrontendIpConfigurationArgs']]]):
        pulumi.set(self, "frontend_ip_configurations", value)

    @_builtins.property
    @pulumi.getter(name="frontendPorts")
    def frontend_ports(self) -> pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayFrontendPortArgs']]]:
        """
        One or more `frontend_port` blocks as defined below.
        """
        return pulumi.get(self, "frontend_ports")

    @frontend_ports.setter
    def frontend_ports(self, value: pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayFrontendPortArgs']]]):
        pulumi.set(self, "frontend_ports", value)

    @_builtins.property
    @pulumi.getter(name="gatewayIpConfigurations")
    def gateway_ip_configurations(self) -> pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayGatewayIpConfigurationArgs']]]:
        """
        One or more `gateway_ip_configuration` blocks as defined below.
        """
        return pulumi.get(self, "gateway_ip_configurations")

    @gateway_ip_configurations.setter
    def gateway_ip_configurations(self, value: pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayGatewayIpConfigurationArgs']]]):
        pulumi.set(self, "gateway_ip_configurations", value)

    @_builtins.property
    @pulumi.getter(name="httpListeners")
    def http_listeners(self) -> pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayHttpListenerArgs']]]:
        """
        One or more `http_listener` blocks as defined below.
        """
        return pulumi.get(self, "http_listeners")

    @http_listeners.setter
    def http_listeners(self, value: pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayHttpListenerArgs']]]):
        pulumi.set(self, "http_listeners", value)

    @_builtins.property
    @pulumi.getter(name="requestRoutingRules")
    def request_routing_rules(self) -> pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRequestRoutingRuleArgs']]]:
        """
        One or more `request_routing_rule` blocks as defined below.
        """
        return pulumi.get(self, "request_routing_rules")

    @request_routing_rules.setter
    def request_routing_rules(self, value: pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRequestRoutingRuleArgs']]]):
        pulumi.set(self, "request_routing_rules", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to the Application Gateway should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Input['ApplicationGatewaySkuArgs']:
        """
        A `sku` block as defined below.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input['ApplicationGatewaySkuArgs']):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="authenticationCertificates")
    def authentication_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayAuthenticationCertificateArgs']]]]:
        """
        One or more `authentication_certificate` blocks as defined below.
        """
        return pulumi.get(self, "authentication_certificates")

    @authentication_certificates.setter
    def authentication_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayAuthenticationCertificateArgs']]]]):
        pulumi.set(self, "authentication_certificates", value)

    @_builtins.property
    @pulumi.getter(name="autoscaleConfiguration")
    def autoscale_configuration(self) -> Optional[pulumi.Input['ApplicationGatewayAutoscaleConfigurationArgs']]:
        """
        An `autoscale_configuration` block as defined below.
        """
        return pulumi.get(self, "autoscale_configuration")

    @autoscale_configuration.setter
    def autoscale_configuration(self, value: Optional[pulumi.Input['ApplicationGatewayAutoscaleConfigurationArgs']]):
        pulumi.set(self, "autoscale_configuration", value)

    @_builtins.property
    @pulumi.getter(name="customErrorConfigurations")
    def custom_error_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayCustomErrorConfigurationArgs']]]]:
        """
        One or more `custom_error_configuration` blocks as defined below.
        """
        return pulumi.get(self, "custom_error_configurations")

    @custom_error_configurations.setter
    def custom_error_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayCustomErrorConfigurationArgs']]]]):
        pulumi.set(self, "custom_error_configurations", value)

    @_builtins.property
    @pulumi.getter(name="enableHttp2")
    def enable_http2(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is HTTP2 enabled on the application gateway resource? Defaults to `false`.
        """
        return pulumi.get(self, "enable_http2")

    @enable_http2.setter
    def enable_http2(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_http2", value)

    @_builtins.property
    @pulumi.getter(name="fipsEnabled")
    def fips_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is FIPS enabled on the Application Gateway?
        """
        return pulumi.get(self, "fips_enabled")

    @fips_enabled.setter
    def fips_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "fips_enabled", value)

    @_builtins.property
    @pulumi.getter(name="firewallPolicyId")
    def firewall_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Web Application Firewall Policy.
        """
        return pulumi.get(self, "firewall_policy_id")

    @firewall_policy_id.setter
    def firewall_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "firewall_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="forceFirewallPolicyAssociation")
    def force_firewall_policy_association(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the Firewall Policy associated with the Application Gateway?
        """
        return pulumi.get(self, "force_firewall_policy_association")

    @force_firewall_policy_association.setter
    def force_firewall_policy_association(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_firewall_policy_association", value)

    @_builtins.property
    @pulumi.getter(name="global")
    def global_(self) -> Optional[pulumi.Input['ApplicationGatewayGlobalArgs']]:
        """
        A `global` block as defined below.
        """
        return pulumi.get(self, "global_")

    @global_.setter
    def global_(self, value: Optional[pulumi.Input['ApplicationGatewayGlobalArgs']]):
        pulumi.set(self, "global_", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ApplicationGatewayIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ApplicationGatewayIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure region where the Application Gateway should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Application Gateway. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateLinkConfigurations")
    def private_link_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayPrivateLinkConfigurationArgs']]]]:
        """
        One or more `private_link_configuration` blocks as defined below.
        """
        return pulumi.get(self, "private_link_configurations")

    @private_link_configurations.setter
    def private_link_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayPrivateLinkConfigurationArgs']]]]):
        pulumi.set(self, "private_link_configurations", value)

    @_builtins.property
    @pulumi.getter
    def probes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayProbeArgs']]]]:
        """
        One or more `probe` blocks as defined below.
        """
        return pulumi.get(self, "probes")

    @probes.setter
    def probes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayProbeArgs']]]]):
        pulumi.set(self, "probes", value)

    @_builtins.property
    @pulumi.getter(name="redirectConfigurations")
    def redirect_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRedirectConfigurationArgs']]]]:
        """
        One or more `redirect_configuration` blocks as defined below.
        """
        return pulumi.get(self, "redirect_configurations")

    @redirect_configurations.setter
    def redirect_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRedirectConfigurationArgs']]]]):
        pulumi.set(self, "redirect_configurations", value)

    @_builtins.property
    @pulumi.getter(name="rewriteRuleSets")
    def rewrite_rule_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRewriteRuleSetArgs']]]]:
        """
        One or more `rewrite_rule_set` blocks as defined below. Only valid for v2 WAF and Standard SKUs.
        """
        return pulumi.get(self, "rewrite_rule_sets")

    @rewrite_rule_sets.setter
    def rewrite_rule_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRewriteRuleSetArgs']]]]):
        pulumi.set(self, "rewrite_rule_sets", value)

    @_builtins.property
    @pulumi.getter(name="sslCertificates")
    def ssl_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewaySslCertificateArgs']]]]:
        """
        One or more `ssl_certificate` blocks as defined below.
        """
        return pulumi.get(self, "ssl_certificates")

    @ssl_certificates.setter
    def ssl_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewaySslCertificateArgs']]]]):
        pulumi.set(self, "ssl_certificates", value)

    @_builtins.property
    @pulumi.getter(name="sslPolicy")
    def ssl_policy(self) -> Optional[pulumi.Input['ApplicationGatewaySslPolicyArgs']]:
        """
        a `ssl_policy` block as defined below.
        """
        return pulumi.get(self, "ssl_policy")

    @ssl_policy.setter
    def ssl_policy(self, value: Optional[pulumi.Input['ApplicationGatewaySslPolicyArgs']]):
        pulumi.set(self, "ssl_policy", value)

    @_builtins.property
    @pulumi.getter(name="sslProfiles")
    def ssl_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewaySslProfileArgs']]]]:
        """
        One or more `ssl_profile` blocks as defined below.
        """
        return pulumi.get(self, "ssl_profiles")

    @ssl_profiles.setter
    def ssl_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewaySslProfileArgs']]]]):
        pulumi.set(self, "ssl_profiles", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="trustedClientCertificates")
    def trusted_client_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayTrustedClientCertificateArgs']]]]:
        """
        One or more `trusted_client_certificate` blocks as defined below.
        """
        return pulumi.get(self, "trusted_client_certificates")

    @trusted_client_certificates.setter
    def trusted_client_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayTrustedClientCertificateArgs']]]]):
        pulumi.set(self, "trusted_client_certificates", value)

    @_builtins.property
    @pulumi.getter(name="trustedRootCertificates")
    def trusted_root_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayTrustedRootCertificateArgs']]]]:
        """
        One or more `trusted_root_certificate` blocks as defined below.
        """
        return pulumi.get(self, "trusted_root_certificates")

    @trusted_root_certificates.setter
    def trusted_root_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayTrustedRootCertificateArgs']]]]):
        pulumi.set(self, "trusted_root_certificates", value)

    @_builtins.property
    @pulumi.getter(name="urlPathMaps")
    def url_path_maps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayUrlPathMapArgs']]]]:
        """
        One or more `url_path_map` blocks as defined below.
        """
        return pulumi.get(self, "url_path_maps")

    @url_path_maps.setter
    def url_path_maps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayUrlPathMapArgs']]]]):
        pulumi.set(self, "url_path_maps", value)

    @_builtins.property
    @pulumi.getter(name="wafConfiguration")
    def waf_configuration(self) -> Optional[pulumi.Input['ApplicationGatewayWafConfigurationArgs']]:
        """
        A `waf_configuration` block as defined below.
        """
        return pulumi.get(self, "waf_configuration")

    @waf_configuration.setter
    def waf_configuration(self, value: Optional[pulumi.Input['ApplicationGatewayWafConfigurationArgs']]):
        pulumi.set(self, "waf_configuration", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Availability Zones in which this Application Gateway should be located. Changing this forces a new Application Gateway to be created.

        > **Note:** Availability Zones are not supported in all regions at this time, please check the [official documentation](https://docs.microsoft.com/azure/availability-zones/az-overview) for more information. They are also only supported for [v2 SKUs](https://docs.microsoft.com/azure/application-gateway/application-gateway-autoscaling-zone-redundant)
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.input_type
class _ApplicationGatewayState:
    def __init__(__self__, *,
                 authentication_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayAuthenticationCertificateArgs']]]] = None,
                 autoscale_configuration: Optional[pulumi.Input['ApplicationGatewayAutoscaleConfigurationArgs']] = None,
                 backend_address_pools: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayBackendAddressPoolArgs']]]] = None,
                 backend_http_settings: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayBackendHttpSettingArgs']]]] = None,
                 custom_error_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayCustomErrorConfigurationArgs']]]] = None,
                 enable_http2: Optional[pulumi.Input[_builtins.bool]] = None,
                 fips_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_firewall_policy_association: Optional[pulumi.Input[_builtins.bool]] = None,
                 frontend_ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayFrontendIpConfigurationArgs']]]] = None,
                 frontend_ports: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayFrontendPortArgs']]]] = None,
                 gateway_ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayGatewayIpConfigurationArgs']]]] = None,
                 global_: Optional[pulumi.Input['ApplicationGatewayGlobalArgs']] = None,
                 http_listeners: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayHttpListenerArgs']]]] = None,
                 identity: Optional[pulumi.Input['ApplicationGatewayIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_endpoint_connections: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayPrivateEndpointConnectionArgs']]]] = None,
                 private_link_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayPrivateLinkConfigurationArgs']]]] = None,
                 probes: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayProbeArgs']]]] = None,
                 redirect_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRedirectConfigurationArgs']]]] = None,
                 request_routing_rules: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRequestRoutingRuleArgs']]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rewrite_rule_sets: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRewriteRuleSetArgs']]]] = None,
                 sku: Optional[pulumi.Input['ApplicationGatewaySkuArgs']] = None,
                 ssl_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewaySslCertificateArgs']]]] = None,
                 ssl_policy: Optional[pulumi.Input['ApplicationGatewaySslPolicyArgs']] = None,
                 ssl_profiles: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewaySslProfileArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 trusted_client_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayTrustedClientCertificateArgs']]]] = None,
                 trusted_root_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayTrustedRootCertificateArgs']]]] = None,
                 url_path_maps: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayUrlPathMapArgs']]]] = None,
                 waf_configuration: Optional[pulumi.Input['ApplicationGatewayWafConfigurationArgs']] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ApplicationGateway resources.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayAuthenticationCertificateArgs']]] authentication_certificates: One or more `authentication_certificate` blocks as defined below.
        :param pulumi.Input['ApplicationGatewayAutoscaleConfigurationArgs'] autoscale_configuration: An `autoscale_configuration` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayBackendAddressPoolArgs']]] backend_address_pools: One or more `backend_address_pool` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayBackendHttpSettingArgs']]] backend_http_settings: One or more `backend_http_settings` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayCustomErrorConfigurationArgs']]] custom_error_configurations: One or more `custom_error_configuration` blocks as defined below.
        :param pulumi.Input[_builtins.bool] enable_http2: Is HTTP2 enabled on the application gateway resource? Defaults to `false`.
        :param pulumi.Input[_builtins.bool] fips_enabled: Is FIPS enabled on the Application Gateway?
        :param pulumi.Input[_builtins.str] firewall_policy_id: The ID of the Web Application Firewall Policy.
        :param pulumi.Input[_builtins.bool] force_firewall_policy_association: Is the Firewall Policy associated with the Application Gateway?
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayFrontendIpConfigurationArgs']]] frontend_ip_configurations: One or more `frontend_ip_configuration` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayFrontendPortArgs']]] frontend_ports: One or more `frontend_port` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayGatewayIpConfigurationArgs']]] gateway_ip_configurations: One or more `gateway_ip_configuration` blocks as defined below.
        :param pulumi.Input['ApplicationGatewayGlobalArgs'] global_: A `global` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayHttpListenerArgs']]] http_listeners: One or more `http_listener` blocks as defined below.
        :param pulumi.Input['ApplicationGatewayIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure region where the Application Gateway should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Application Gateway. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayPrivateEndpointConnectionArgs']]] private_endpoint_connections: A list of `private_endpoint_connection` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayPrivateLinkConfigurationArgs']]] private_link_configurations: One or more `private_link_configuration` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayProbeArgs']]] probes: One or more `probe` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRedirectConfigurationArgs']]] redirect_configurations: One or more `redirect_configuration` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRequestRoutingRuleArgs']]] request_routing_rules: One or more `request_routing_rule` blocks as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to the Application Gateway should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRewriteRuleSetArgs']]] rewrite_rule_sets: One or more `rewrite_rule_set` blocks as defined below. Only valid for v2 WAF and Standard SKUs.
        :param pulumi.Input['ApplicationGatewaySkuArgs'] sku: A `sku` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewaySslCertificateArgs']]] ssl_certificates: One or more `ssl_certificate` blocks as defined below.
        :param pulumi.Input['ApplicationGatewaySslPolicyArgs'] ssl_policy: a `ssl_policy` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewaySslProfileArgs']]] ssl_profiles: One or more `ssl_profile` blocks as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayTrustedClientCertificateArgs']]] trusted_client_certificates: One or more `trusted_client_certificate` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayTrustedRootCertificateArgs']]] trusted_root_certificates: One or more `trusted_root_certificate` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayUrlPathMapArgs']]] url_path_maps: One or more `url_path_map` blocks as defined below.
        :param pulumi.Input['ApplicationGatewayWafConfigurationArgs'] waf_configuration: A `waf_configuration` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this Application Gateway should be located. Changing this forces a new Application Gateway to be created.
               
               > **Note:** Availability Zones are not supported in all regions at this time, please check the [official documentation](https://docs.microsoft.com/azure/availability-zones/az-overview) for more information. They are also only supported for [v2 SKUs](https://docs.microsoft.com/azure/application-gateway/application-gateway-autoscaling-zone-redundant)
        """
        if authentication_certificates is not None:
            pulumi.set(__self__, "authentication_certificates", authentication_certificates)
        if autoscale_configuration is not None:
            pulumi.set(__self__, "autoscale_configuration", autoscale_configuration)
        if backend_address_pools is not None:
            pulumi.set(__self__, "backend_address_pools", backend_address_pools)
        if backend_http_settings is not None:
            pulumi.set(__self__, "backend_http_settings", backend_http_settings)
        if custom_error_configurations is not None:
            pulumi.set(__self__, "custom_error_configurations", custom_error_configurations)
        if enable_http2 is not None:
            pulumi.set(__self__, "enable_http2", enable_http2)
        if fips_enabled is not None:
            pulumi.set(__self__, "fips_enabled", fips_enabled)
        if firewall_policy_id is not None:
            pulumi.set(__self__, "firewall_policy_id", firewall_policy_id)
        if force_firewall_policy_association is not None:
            pulumi.set(__self__, "force_firewall_policy_association", force_firewall_policy_association)
        if frontend_ip_configurations is not None:
            pulumi.set(__self__, "frontend_ip_configurations", frontend_ip_configurations)
        if frontend_ports is not None:
            pulumi.set(__self__, "frontend_ports", frontend_ports)
        if gateway_ip_configurations is not None:
            pulumi.set(__self__, "gateway_ip_configurations", gateway_ip_configurations)
        if global_ is not None:
            pulumi.set(__self__, "global_", global_)
        if http_listeners is not None:
            pulumi.set(__self__, "http_listeners", http_listeners)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_endpoint_connections is not None:
            pulumi.set(__self__, "private_endpoint_connections", private_endpoint_connections)
        if private_link_configurations is not None:
            pulumi.set(__self__, "private_link_configurations", private_link_configurations)
        if probes is not None:
            pulumi.set(__self__, "probes", probes)
        if redirect_configurations is not None:
            pulumi.set(__self__, "redirect_configurations", redirect_configurations)
        if request_routing_rules is not None:
            pulumi.set(__self__, "request_routing_rules", request_routing_rules)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if rewrite_rule_sets is not None:
            pulumi.set(__self__, "rewrite_rule_sets", rewrite_rule_sets)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if ssl_certificates is not None:
            pulumi.set(__self__, "ssl_certificates", ssl_certificates)
        if ssl_policy is not None:
            pulumi.set(__self__, "ssl_policy", ssl_policy)
        if ssl_profiles is not None:
            pulumi.set(__self__, "ssl_profiles", ssl_profiles)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if trusted_client_certificates is not None:
            pulumi.set(__self__, "trusted_client_certificates", trusted_client_certificates)
        if trusted_root_certificates is not None:
            pulumi.set(__self__, "trusted_root_certificates", trusted_root_certificates)
        if url_path_maps is not None:
            pulumi.set(__self__, "url_path_maps", url_path_maps)
        if waf_configuration is not None:
            pulumi.set(__self__, "waf_configuration", waf_configuration)
        if zones is not None:
            pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="authenticationCertificates")
    def authentication_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayAuthenticationCertificateArgs']]]]:
        """
        One or more `authentication_certificate` blocks as defined below.
        """
        return pulumi.get(self, "authentication_certificates")

    @authentication_certificates.setter
    def authentication_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayAuthenticationCertificateArgs']]]]):
        pulumi.set(self, "authentication_certificates", value)

    @_builtins.property
    @pulumi.getter(name="autoscaleConfiguration")
    def autoscale_configuration(self) -> Optional[pulumi.Input['ApplicationGatewayAutoscaleConfigurationArgs']]:
        """
        An `autoscale_configuration` block as defined below.
        """
        return pulumi.get(self, "autoscale_configuration")

    @autoscale_configuration.setter
    def autoscale_configuration(self, value: Optional[pulumi.Input['ApplicationGatewayAutoscaleConfigurationArgs']]):
        pulumi.set(self, "autoscale_configuration", value)

    @_builtins.property
    @pulumi.getter(name="backendAddressPools")
    def backend_address_pools(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayBackendAddressPoolArgs']]]]:
        """
        One or more `backend_address_pool` blocks as defined below.
        """
        return pulumi.get(self, "backend_address_pools")

    @backend_address_pools.setter
    def backend_address_pools(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayBackendAddressPoolArgs']]]]):
        pulumi.set(self, "backend_address_pools", value)

    @_builtins.property
    @pulumi.getter(name="backendHttpSettings")
    def backend_http_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayBackendHttpSettingArgs']]]]:
        """
        One or more `backend_http_settings` blocks as defined below.
        """
        return pulumi.get(self, "backend_http_settings")

    @backend_http_settings.setter
    def backend_http_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayBackendHttpSettingArgs']]]]):
        pulumi.set(self, "backend_http_settings", value)

    @_builtins.property
    @pulumi.getter(name="customErrorConfigurations")
    def custom_error_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayCustomErrorConfigurationArgs']]]]:
        """
        One or more `custom_error_configuration` blocks as defined below.
        """
        return pulumi.get(self, "custom_error_configurations")

    @custom_error_configurations.setter
    def custom_error_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayCustomErrorConfigurationArgs']]]]):
        pulumi.set(self, "custom_error_configurations", value)

    @_builtins.property
    @pulumi.getter(name="enableHttp2")
    def enable_http2(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is HTTP2 enabled on the application gateway resource? Defaults to `false`.
        """
        return pulumi.get(self, "enable_http2")

    @enable_http2.setter
    def enable_http2(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_http2", value)

    @_builtins.property
    @pulumi.getter(name="fipsEnabled")
    def fips_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is FIPS enabled on the Application Gateway?
        """
        return pulumi.get(self, "fips_enabled")

    @fips_enabled.setter
    def fips_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "fips_enabled", value)

    @_builtins.property
    @pulumi.getter(name="firewallPolicyId")
    def firewall_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Web Application Firewall Policy.
        """
        return pulumi.get(self, "firewall_policy_id")

    @firewall_policy_id.setter
    def firewall_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "firewall_policy_id", value)

    @_builtins.property
    @pulumi.getter(name="forceFirewallPolicyAssociation")
    def force_firewall_policy_association(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the Firewall Policy associated with the Application Gateway?
        """
        return pulumi.get(self, "force_firewall_policy_association")

    @force_firewall_policy_association.setter
    def force_firewall_policy_association(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_firewall_policy_association", value)

    @_builtins.property
    @pulumi.getter(name="frontendIpConfigurations")
    def frontend_ip_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayFrontendIpConfigurationArgs']]]]:
        """
        One or more `frontend_ip_configuration` blocks as defined below.
        """
        return pulumi.get(self, "frontend_ip_configurations")

    @frontend_ip_configurations.setter
    def frontend_ip_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayFrontendIpConfigurationArgs']]]]):
        pulumi.set(self, "frontend_ip_configurations", value)

    @_builtins.property
    @pulumi.getter(name="frontendPorts")
    def frontend_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayFrontendPortArgs']]]]:
        """
        One or more `frontend_port` blocks as defined below.
        """
        return pulumi.get(self, "frontend_ports")

    @frontend_ports.setter
    def frontend_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayFrontendPortArgs']]]]):
        pulumi.set(self, "frontend_ports", value)

    @_builtins.property
    @pulumi.getter(name="gatewayIpConfigurations")
    def gateway_ip_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayGatewayIpConfigurationArgs']]]]:
        """
        One or more `gateway_ip_configuration` blocks as defined below.
        """
        return pulumi.get(self, "gateway_ip_configurations")

    @gateway_ip_configurations.setter
    def gateway_ip_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayGatewayIpConfigurationArgs']]]]):
        pulumi.set(self, "gateway_ip_configurations", value)

    @_builtins.property
    @pulumi.getter(name="global")
    def global_(self) -> Optional[pulumi.Input['ApplicationGatewayGlobalArgs']]:
        """
        A `global` block as defined below.
        """
        return pulumi.get(self, "global_")

    @global_.setter
    def global_(self, value: Optional[pulumi.Input['ApplicationGatewayGlobalArgs']]):
        pulumi.set(self, "global_", value)

    @_builtins.property
    @pulumi.getter(name="httpListeners")
    def http_listeners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayHttpListenerArgs']]]]:
        """
        One or more `http_listener` blocks as defined below.
        """
        return pulumi.get(self, "http_listeners")

    @http_listeners.setter
    def http_listeners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayHttpListenerArgs']]]]):
        pulumi.set(self, "http_listeners", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ApplicationGatewayIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ApplicationGatewayIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure region where the Application Gateway should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Application Gateway. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateEndpointConnections")
    def private_endpoint_connections(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayPrivateEndpointConnectionArgs']]]]:
        """
        A list of `private_endpoint_connection` blocks as defined below.
        """
        return pulumi.get(self, "private_endpoint_connections")

    @private_endpoint_connections.setter
    def private_endpoint_connections(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayPrivateEndpointConnectionArgs']]]]):
        pulumi.set(self, "private_endpoint_connections", value)

    @_builtins.property
    @pulumi.getter(name="privateLinkConfigurations")
    def private_link_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayPrivateLinkConfigurationArgs']]]]:
        """
        One or more `private_link_configuration` blocks as defined below.
        """
        return pulumi.get(self, "private_link_configurations")

    @private_link_configurations.setter
    def private_link_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayPrivateLinkConfigurationArgs']]]]):
        pulumi.set(self, "private_link_configurations", value)

    @_builtins.property
    @pulumi.getter
    def probes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayProbeArgs']]]]:
        """
        One or more `probe` blocks as defined below.
        """
        return pulumi.get(self, "probes")

    @probes.setter
    def probes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayProbeArgs']]]]):
        pulumi.set(self, "probes", value)

    @_builtins.property
    @pulumi.getter(name="redirectConfigurations")
    def redirect_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRedirectConfigurationArgs']]]]:
        """
        One or more `redirect_configuration` blocks as defined below.
        """
        return pulumi.get(self, "redirect_configurations")

    @redirect_configurations.setter
    def redirect_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRedirectConfigurationArgs']]]]):
        pulumi.set(self, "redirect_configurations", value)

    @_builtins.property
    @pulumi.getter(name="requestRoutingRules")
    def request_routing_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRequestRoutingRuleArgs']]]]:
        """
        One or more `request_routing_rule` blocks as defined below.
        """
        return pulumi.get(self, "request_routing_rules")

    @request_routing_rules.setter
    def request_routing_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRequestRoutingRuleArgs']]]]):
        pulumi.set(self, "request_routing_rules", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to the Application Gateway should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="rewriteRuleSets")
    def rewrite_rule_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRewriteRuleSetArgs']]]]:
        """
        One or more `rewrite_rule_set` blocks as defined below. Only valid for v2 WAF and Standard SKUs.
        """
        return pulumi.get(self, "rewrite_rule_sets")

    @rewrite_rule_sets.setter
    def rewrite_rule_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayRewriteRuleSetArgs']]]]):
        pulumi.set(self, "rewrite_rule_sets", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input['ApplicationGatewaySkuArgs']]:
        """
        A `sku` block as defined below.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input['ApplicationGatewaySkuArgs']]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="sslCertificates")
    def ssl_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewaySslCertificateArgs']]]]:
        """
        One or more `ssl_certificate` blocks as defined below.
        """
        return pulumi.get(self, "ssl_certificates")

    @ssl_certificates.setter
    def ssl_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewaySslCertificateArgs']]]]):
        pulumi.set(self, "ssl_certificates", value)

    @_builtins.property
    @pulumi.getter(name="sslPolicy")
    def ssl_policy(self) -> Optional[pulumi.Input['ApplicationGatewaySslPolicyArgs']]:
        """
        a `ssl_policy` block as defined below.
        """
        return pulumi.get(self, "ssl_policy")

    @ssl_policy.setter
    def ssl_policy(self, value: Optional[pulumi.Input['ApplicationGatewaySslPolicyArgs']]):
        pulumi.set(self, "ssl_policy", value)

    @_builtins.property
    @pulumi.getter(name="sslProfiles")
    def ssl_profiles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewaySslProfileArgs']]]]:
        """
        One or more `ssl_profile` blocks as defined below.
        """
        return pulumi.get(self, "ssl_profiles")

    @ssl_profiles.setter
    def ssl_profiles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewaySslProfileArgs']]]]):
        pulumi.set(self, "ssl_profiles", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="trustedClientCertificates")
    def trusted_client_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayTrustedClientCertificateArgs']]]]:
        """
        One or more `trusted_client_certificate` blocks as defined below.
        """
        return pulumi.get(self, "trusted_client_certificates")

    @trusted_client_certificates.setter
    def trusted_client_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayTrustedClientCertificateArgs']]]]):
        pulumi.set(self, "trusted_client_certificates", value)

    @_builtins.property
    @pulumi.getter(name="trustedRootCertificates")
    def trusted_root_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayTrustedRootCertificateArgs']]]]:
        """
        One or more `trusted_root_certificate` blocks as defined below.
        """
        return pulumi.get(self, "trusted_root_certificates")

    @trusted_root_certificates.setter
    def trusted_root_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayTrustedRootCertificateArgs']]]]):
        pulumi.set(self, "trusted_root_certificates", value)

    @_builtins.property
    @pulumi.getter(name="urlPathMaps")
    def url_path_maps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayUrlPathMapArgs']]]]:
        """
        One or more `url_path_map` blocks as defined below.
        """
        return pulumi.get(self, "url_path_maps")

    @url_path_maps.setter
    def url_path_maps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApplicationGatewayUrlPathMapArgs']]]]):
        pulumi.set(self, "url_path_maps", value)

    @_builtins.property
    @pulumi.getter(name="wafConfiguration")
    def waf_configuration(self) -> Optional[pulumi.Input['ApplicationGatewayWafConfigurationArgs']]:
        """
        A `waf_configuration` block as defined below.
        """
        return pulumi.get(self, "waf_configuration")

    @waf_configuration.setter
    def waf_configuration(self, value: Optional[pulumi.Input['ApplicationGatewayWafConfigurationArgs']]):
        pulumi.set(self, "waf_configuration", value)

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of Availability Zones in which this Application Gateway should be located. Changing this forces a new Application Gateway to be created.

        > **Note:** Availability Zones are not supported in all regions at this time, please check the [official documentation](https://docs.microsoft.com/azure/availability-zones/az-overview) for more information. They are also only supported for [v2 SKUs](https://docs.microsoft.com/azure/application-gateway/application-gateway-autoscaling-zone-redundant)
        """
        return pulumi.get(self, "zones")

    @zones.setter
    def zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "zones", value)


@pulumi.type_token("azure:network/applicationGateway:ApplicationGateway")
class ApplicationGateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayAuthenticationCertificateArgs', 'ApplicationGatewayAuthenticationCertificateArgsDict']]]]] = None,
                 autoscale_configuration: Optional[pulumi.Input[Union['ApplicationGatewayAutoscaleConfigurationArgs', 'ApplicationGatewayAutoscaleConfigurationArgsDict']]] = None,
                 backend_address_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayBackendAddressPoolArgs', 'ApplicationGatewayBackendAddressPoolArgsDict']]]]] = None,
                 backend_http_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayBackendHttpSettingArgs', 'ApplicationGatewayBackendHttpSettingArgsDict']]]]] = None,
                 custom_error_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayCustomErrorConfigurationArgs', 'ApplicationGatewayCustomErrorConfigurationArgsDict']]]]] = None,
                 enable_http2: Optional[pulumi.Input[_builtins.bool]] = None,
                 fips_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_firewall_policy_association: Optional[pulumi.Input[_builtins.bool]] = None,
                 frontend_ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayFrontendIpConfigurationArgs', 'ApplicationGatewayFrontendIpConfigurationArgsDict']]]]] = None,
                 frontend_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayFrontendPortArgs', 'ApplicationGatewayFrontendPortArgsDict']]]]] = None,
                 gateway_ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayGatewayIpConfigurationArgs', 'ApplicationGatewayGatewayIpConfigurationArgsDict']]]]] = None,
                 global_: Optional[pulumi.Input[Union['ApplicationGatewayGlobalArgs', 'ApplicationGatewayGlobalArgsDict']]] = None,
                 http_listeners: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayHttpListenerArgs', 'ApplicationGatewayHttpListenerArgsDict']]]]] = None,
                 identity: Optional[pulumi.Input[Union['ApplicationGatewayIdentityArgs', 'ApplicationGatewayIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_link_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayPrivateLinkConfigurationArgs', 'ApplicationGatewayPrivateLinkConfigurationArgsDict']]]]] = None,
                 probes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayProbeArgs', 'ApplicationGatewayProbeArgsDict']]]]] = None,
                 redirect_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayRedirectConfigurationArgs', 'ApplicationGatewayRedirectConfigurationArgsDict']]]]] = None,
                 request_routing_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayRequestRoutingRuleArgs', 'ApplicationGatewayRequestRoutingRuleArgsDict']]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rewrite_rule_sets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayRewriteRuleSetArgs', 'ApplicationGatewayRewriteRuleSetArgsDict']]]]] = None,
                 sku: Optional[pulumi.Input[Union['ApplicationGatewaySkuArgs', 'ApplicationGatewaySkuArgsDict']]] = None,
                 ssl_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewaySslCertificateArgs', 'ApplicationGatewaySslCertificateArgsDict']]]]] = None,
                 ssl_policy: Optional[pulumi.Input[Union['ApplicationGatewaySslPolicyArgs', 'ApplicationGatewaySslPolicyArgsDict']]] = None,
                 ssl_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewaySslProfileArgs', 'ApplicationGatewaySslProfileArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 trusted_client_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayTrustedClientCertificateArgs', 'ApplicationGatewayTrustedClientCertificateArgsDict']]]]] = None,
                 trusted_root_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayTrustedRootCertificateArgs', 'ApplicationGatewayTrustedRootCertificateArgsDict']]]]] = None,
                 url_path_maps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayUrlPathMapArgs', 'ApplicationGatewayUrlPathMapArgsDict']]]]] = None,
                 waf_configuration: Optional[pulumi.Input[Union['ApplicationGatewayWafConfigurationArgs', 'ApplicationGatewayWafConfigurationArgsDict']]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            resource_group_name=example.name,
            location=example.location,
            address_spaces=["10.254.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="example",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.254.0.0/24"])
        example_public_ip = azure.network.PublicIp("example",
            name="example-pip",
            resource_group_name=example.name,
            location=example.location,
            allocation_method="Static")
        backend_address_pool_name = example_virtual_network.name.apply(lambda name: f"{name}-beap")
        frontend_port_name = example_virtual_network.name.apply(lambda name: f"{name}-feport")
        frontend_ip_configuration_name = example_virtual_network.name.apply(lambda name: f"{name}-feip")
        http_setting_name = example_virtual_network.name.apply(lambda name: f"{name}-be-htst")
        listener_name = example_virtual_network.name.apply(lambda name: f"{name}-httplstn")
        request_routing_rule_name = example_virtual_network.name.apply(lambda name: f"{name}-rqrt")
        redirect_configuration_name = example_virtual_network.name.apply(lambda name: f"{name}-rdrcfg")
        network = azure.network.ApplicationGateway("network",
            name="example-appgateway",
            resource_group_name=example.name,
            location=example.location,
            sku={
                "name": "Standard_v2",
                "tier": "Standard_v2",
                "capacity": 2,
            },
            gateway_ip_configurations=[{
                "name": "my-gateway-ip-configuration",
                "subnet_id": example_subnet.id,
            }],
            frontend_ports=[{
                "name": frontend_port_name,
                "port": 80,
            }],
            frontend_ip_configurations=[{
                "name": frontend_ip_configuration_name,
                "public_ip_address_id": example_public_ip.id,
            }],
            backend_address_pools=[{
                "name": backend_address_pool_name,
            }],
            backend_http_settings=[{
                "name": http_setting_name,
                "cookie_based_affinity": "Disabled",
                "path": "/path1/",
                "port": 80,
                "protocol": "Http",
                "request_timeout": 60,
            }],
            http_listeners=[{
                "name": listener_name,
                "frontend_ip_configuration_name": frontend_ip_configuration_name,
                "frontend_port_name": frontend_port_name,
                "protocol": "Http",
            }],
            request_routing_rules=[{
                "name": request_routing_rule_name,
                "priority": 9,
                "rule_type": "Basic",
                "http_listener_name": listener_name,
                "backend_address_pool_name": backend_address_pool_name,
                "backend_http_settings_name": http_setting_name,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2024-05-01

        ## Import

        Application Gateway's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/applicationGateway:ApplicationGateway example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/applicationGateways/myGateway1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayAuthenticationCertificateArgs', 'ApplicationGatewayAuthenticationCertificateArgsDict']]]] authentication_certificates: One or more `authentication_certificate` blocks as defined below.
        :param pulumi.Input[Union['ApplicationGatewayAutoscaleConfigurationArgs', 'ApplicationGatewayAutoscaleConfigurationArgsDict']] autoscale_configuration: An `autoscale_configuration` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayBackendAddressPoolArgs', 'ApplicationGatewayBackendAddressPoolArgsDict']]]] backend_address_pools: One or more `backend_address_pool` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayBackendHttpSettingArgs', 'ApplicationGatewayBackendHttpSettingArgsDict']]]] backend_http_settings: One or more `backend_http_settings` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayCustomErrorConfigurationArgs', 'ApplicationGatewayCustomErrorConfigurationArgsDict']]]] custom_error_configurations: One or more `custom_error_configuration` blocks as defined below.
        :param pulumi.Input[_builtins.bool] enable_http2: Is HTTP2 enabled on the application gateway resource? Defaults to `false`.
        :param pulumi.Input[_builtins.bool] fips_enabled: Is FIPS enabled on the Application Gateway?
        :param pulumi.Input[_builtins.str] firewall_policy_id: The ID of the Web Application Firewall Policy.
        :param pulumi.Input[_builtins.bool] force_firewall_policy_association: Is the Firewall Policy associated with the Application Gateway?
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayFrontendIpConfigurationArgs', 'ApplicationGatewayFrontendIpConfigurationArgsDict']]]] frontend_ip_configurations: One or more `frontend_ip_configuration` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayFrontendPortArgs', 'ApplicationGatewayFrontendPortArgsDict']]]] frontend_ports: One or more `frontend_port` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayGatewayIpConfigurationArgs', 'ApplicationGatewayGatewayIpConfigurationArgsDict']]]] gateway_ip_configurations: One or more `gateway_ip_configuration` blocks as defined below.
        :param pulumi.Input[Union['ApplicationGatewayGlobalArgs', 'ApplicationGatewayGlobalArgsDict']] global_: A `global` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayHttpListenerArgs', 'ApplicationGatewayHttpListenerArgsDict']]]] http_listeners: One or more `http_listener` blocks as defined below.
        :param pulumi.Input[Union['ApplicationGatewayIdentityArgs', 'ApplicationGatewayIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure region where the Application Gateway should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Application Gateway. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayPrivateLinkConfigurationArgs', 'ApplicationGatewayPrivateLinkConfigurationArgsDict']]]] private_link_configurations: One or more `private_link_configuration` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayProbeArgs', 'ApplicationGatewayProbeArgsDict']]]] probes: One or more `probe` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayRedirectConfigurationArgs', 'ApplicationGatewayRedirectConfigurationArgsDict']]]] redirect_configurations: One or more `redirect_configuration` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayRequestRoutingRuleArgs', 'ApplicationGatewayRequestRoutingRuleArgsDict']]]] request_routing_rules: One or more `request_routing_rule` blocks as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to the Application Gateway should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayRewriteRuleSetArgs', 'ApplicationGatewayRewriteRuleSetArgsDict']]]] rewrite_rule_sets: One or more `rewrite_rule_set` blocks as defined below. Only valid for v2 WAF and Standard SKUs.
        :param pulumi.Input[Union['ApplicationGatewaySkuArgs', 'ApplicationGatewaySkuArgsDict']] sku: A `sku` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewaySslCertificateArgs', 'ApplicationGatewaySslCertificateArgsDict']]]] ssl_certificates: One or more `ssl_certificate` blocks as defined below.
        :param pulumi.Input[Union['ApplicationGatewaySslPolicyArgs', 'ApplicationGatewaySslPolicyArgsDict']] ssl_policy: a `ssl_policy` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewaySslProfileArgs', 'ApplicationGatewaySslProfileArgsDict']]]] ssl_profiles: One or more `ssl_profile` blocks as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayTrustedClientCertificateArgs', 'ApplicationGatewayTrustedClientCertificateArgsDict']]]] trusted_client_certificates: One or more `trusted_client_certificate` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayTrustedRootCertificateArgs', 'ApplicationGatewayTrustedRootCertificateArgsDict']]]] trusted_root_certificates: One or more `trusted_root_certificate` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayUrlPathMapArgs', 'ApplicationGatewayUrlPathMapArgsDict']]]] url_path_maps: One or more `url_path_map` blocks as defined below.
        :param pulumi.Input[Union['ApplicationGatewayWafConfigurationArgs', 'ApplicationGatewayWafConfigurationArgsDict']] waf_configuration: A `waf_configuration` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this Application Gateway should be located. Changing this forces a new Application Gateway to be created.
               
               > **Note:** Availability Zones are not supported in all regions at this time, please check the [official documentation](https://docs.microsoft.com/azure/availability-zones/az-overview) for more information. They are also only supported for [v2 SKUs](https://docs.microsoft.com/azure/application-gateway/application-gateway-autoscaling-zone-redundant)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationGatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            resource_group_name=example.name,
            location=example.location,
            address_spaces=["10.254.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="example",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.254.0.0/24"])
        example_public_ip = azure.network.PublicIp("example",
            name="example-pip",
            resource_group_name=example.name,
            location=example.location,
            allocation_method="Static")
        backend_address_pool_name = example_virtual_network.name.apply(lambda name: f"{name}-beap")
        frontend_port_name = example_virtual_network.name.apply(lambda name: f"{name}-feport")
        frontend_ip_configuration_name = example_virtual_network.name.apply(lambda name: f"{name}-feip")
        http_setting_name = example_virtual_network.name.apply(lambda name: f"{name}-be-htst")
        listener_name = example_virtual_network.name.apply(lambda name: f"{name}-httplstn")
        request_routing_rule_name = example_virtual_network.name.apply(lambda name: f"{name}-rqrt")
        redirect_configuration_name = example_virtual_network.name.apply(lambda name: f"{name}-rdrcfg")
        network = azure.network.ApplicationGateway("network",
            name="example-appgateway",
            resource_group_name=example.name,
            location=example.location,
            sku={
                "name": "Standard_v2",
                "tier": "Standard_v2",
                "capacity": 2,
            },
            gateway_ip_configurations=[{
                "name": "my-gateway-ip-configuration",
                "subnet_id": example_subnet.id,
            }],
            frontend_ports=[{
                "name": frontend_port_name,
                "port": 80,
            }],
            frontend_ip_configurations=[{
                "name": frontend_ip_configuration_name,
                "public_ip_address_id": example_public_ip.id,
            }],
            backend_address_pools=[{
                "name": backend_address_pool_name,
            }],
            backend_http_settings=[{
                "name": http_setting_name,
                "cookie_based_affinity": "Disabled",
                "path": "/path1/",
                "port": 80,
                "protocol": "Http",
                "request_timeout": 60,
            }],
            http_listeners=[{
                "name": listener_name,
                "frontend_ip_configuration_name": frontend_ip_configuration_name,
                "frontend_port_name": frontend_port_name,
                "protocol": "Http",
            }],
            request_routing_rules=[{
                "name": request_routing_rule_name,
                "priority": 9,
                "rule_type": "Basic",
                "http_listener_name": listener_name,
                "backend_address_pool_name": backend_address_pool_name,
                "backend_http_settings_name": http_setting_name,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2024-05-01

        ## Import

        Application Gateway's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/applicationGateway:ApplicationGateway example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/applicationGateways/myGateway1
        ```

        :param str resource_name: The name of the resource.
        :param ApplicationGatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationGatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayAuthenticationCertificateArgs', 'ApplicationGatewayAuthenticationCertificateArgsDict']]]]] = None,
                 autoscale_configuration: Optional[pulumi.Input[Union['ApplicationGatewayAutoscaleConfigurationArgs', 'ApplicationGatewayAutoscaleConfigurationArgsDict']]] = None,
                 backend_address_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayBackendAddressPoolArgs', 'ApplicationGatewayBackendAddressPoolArgsDict']]]]] = None,
                 backend_http_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayBackendHttpSettingArgs', 'ApplicationGatewayBackendHttpSettingArgsDict']]]]] = None,
                 custom_error_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayCustomErrorConfigurationArgs', 'ApplicationGatewayCustomErrorConfigurationArgsDict']]]]] = None,
                 enable_http2: Optional[pulumi.Input[_builtins.bool]] = None,
                 fips_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_firewall_policy_association: Optional[pulumi.Input[_builtins.bool]] = None,
                 frontend_ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayFrontendIpConfigurationArgs', 'ApplicationGatewayFrontendIpConfigurationArgsDict']]]]] = None,
                 frontend_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayFrontendPortArgs', 'ApplicationGatewayFrontendPortArgsDict']]]]] = None,
                 gateway_ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayGatewayIpConfigurationArgs', 'ApplicationGatewayGatewayIpConfigurationArgsDict']]]]] = None,
                 global_: Optional[pulumi.Input[Union['ApplicationGatewayGlobalArgs', 'ApplicationGatewayGlobalArgsDict']]] = None,
                 http_listeners: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayHttpListenerArgs', 'ApplicationGatewayHttpListenerArgsDict']]]]] = None,
                 identity: Optional[pulumi.Input[Union['ApplicationGatewayIdentityArgs', 'ApplicationGatewayIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_link_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayPrivateLinkConfigurationArgs', 'ApplicationGatewayPrivateLinkConfigurationArgsDict']]]]] = None,
                 probes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayProbeArgs', 'ApplicationGatewayProbeArgsDict']]]]] = None,
                 redirect_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayRedirectConfigurationArgs', 'ApplicationGatewayRedirectConfigurationArgsDict']]]]] = None,
                 request_routing_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayRequestRoutingRuleArgs', 'ApplicationGatewayRequestRoutingRuleArgsDict']]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 rewrite_rule_sets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayRewriteRuleSetArgs', 'ApplicationGatewayRewriteRuleSetArgsDict']]]]] = None,
                 sku: Optional[pulumi.Input[Union['ApplicationGatewaySkuArgs', 'ApplicationGatewaySkuArgsDict']]] = None,
                 ssl_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewaySslCertificateArgs', 'ApplicationGatewaySslCertificateArgsDict']]]]] = None,
                 ssl_policy: Optional[pulumi.Input[Union['ApplicationGatewaySslPolicyArgs', 'ApplicationGatewaySslPolicyArgsDict']]] = None,
                 ssl_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewaySslProfileArgs', 'ApplicationGatewaySslProfileArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 trusted_client_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayTrustedClientCertificateArgs', 'ApplicationGatewayTrustedClientCertificateArgsDict']]]]] = None,
                 trusted_root_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayTrustedRootCertificateArgs', 'ApplicationGatewayTrustedRootCertificateArgsDict']]]]] = None,
                 url_path_maps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayUrlPathMapArgs', 'ApplicationGatewayUrlPathMapArgsDict']]]]] = None,
                 waf_configuration: Optional[pulumi.Input[Union['ApplicationGatewayWafConfigurationArgs', 'ApplicationGatewayWafConfigurationArgsDict']]] = None,
                 zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationGatewayArgs.__new__(ApplicationGatewayArgs)

            __props__.__dict__["authentication_certificates"] = authentication_certificates
            __props__.__dict__["autoscale_configuration"] = autoscale_configuration
            if backend_address_pools is None and not opts.urn:
                raise TypeError("Missing required property 'backend_address_pools'")
            __props__.__dict__["backend_address_pools"] = backend_address_pools
            if backend_http_settings is None and not opts.urn:
                raise TypeError("Missing required property 'backend_http_settings'")
            __props__.__dict__["backend_http_settings"] = backend_http_settings
            __props__.__dict__["custom_error_configurations"] = custom_error_configurations
            __props__.__dict__["enable_http2"] = enable_http2
            __props__.__dict__["fips_enabled"] = fips_enabled
            __props__.__dict__["firewall_policy_id"] = firewall_policy_id
            __props__.__dict__["force_firewall_policy_association"] = force_firewall_policy_association
            if frontend_ip_configurations is None and not opts.urn:
                raise TypeError("Missing required property 'frontend_ip_configurations'")
            __props__.__dict__["frontend_ip_configurations"] = frontend_ip_configurations
            if frontend_ports is None and not opts.urn:
                raise TypeError("Missing required property 'frontend_ports'")
            __props__.__dict__["frontend_ports"] = frontend_ports
            if gateway_ip_configurations is None and not opts.urn:
                raise TypeError("Missing required property 'gateway_ip_configurations'")
            __props__.__dict__["gateway_ip_configurations"] = gateway_ip_configurations
            __props__.__dict__["global_"] = global_
            if http_listeners is None and not opts.urn:
                raise TypeError("Missing required property 'http_listeners'")
            __props__.__dict__["http_listeners"] = http_listeners
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["private_link_configurations"] = private_link_configurations
            __props__.__dict__["probes"] = probes
            __props__.__dict__["redirect_configurations"] = redirect_configurations
            if request_routing_rules is None and not opts.urn:
                raise TypeError("Missing required property 'request_routing_rules'")
            __props__.__dict__["request_routing_rules"] = request_routing_rules
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["rewrite_rule_sets"] = rewrite_rule_sets
            if sku is None and not opts.urn:
                raise TypeError("Missing required property 'sku'")
            __props__.__dict__["sku"] = sku
            __props__.__dict__["ssl_certificates"] = ssl_certificates
            __props__.__dict__["ssl_policy"] = ssl_policy
            __props__.__dict__["ssl_profiles"] = ssl_profiles
            __props__.__dict__["tags"] = tags
            __props__.__dict__["trusted_client_certificates"] = trusted_client_certificates
            __props__.__dict__["trusted_root_certificates"] = trusted_root_certificates
            __props__.__dict__["url_path_maps"] = url_path_maps
            __props__.__dict__["waf_configuration"] = waf_configuration
            __props__.__dict__["zones"] = zones
            __props__.__dict__["private_endpoint_connections"] = None
        super(ApplicationGateway, __self__).__init__(
            'azure:network/applicationGateway:ApplicationGateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayAuthenticationCertificateArgs', 'ApplicationGatewayAuthenticationCertificateArgsDict']]]]] = None,
            autoscale_configuration: Optional[pulumi.Input[Union['ApplicationGatewayAutoscaleConfigurationArgs', 'ApplicationGatewayAutoscaleConfigurationArgsDict']]] = None,
            backend_address_pools: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayBackendAddressPoolArgs', 'ApplicationGatewayBackendAddressPoolArgsDict']]]]] = None,
            backend_http_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayBackendHttpSettingArgs', 'ApplicationGatewayBackendHttpSettingArgsDict']]]]] = None,
            custom_error_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayCustomErrorConfigurationArgs', 'ApplicationGatewayCustomErrorConfigurationArgsDict']]]]] = None,
            enable_http2: Optional[pulumi.Input[_builtins.bool]] = None,
            fips_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            firewall_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            force_firewall_policy_association: Optional[pulumi.Input[_builtins.bool]] = None,
            frontend_ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayFrontendIpConfigurationArgs', 'ApplicationGatewayFrontendIpConfigurationArgsDict']]]]] = None,
            frontend_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayFrontendPortArgs', 'ApplicationGatewayFrontendPortArgsDict']]]]] = None,
            gateway_ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayGatewayIpConfigurationArgs', 'ApplicationGatewayGatewayIpConfigurationArgsDict']]]]] = None,
            global_: Optional[pulumi.Input[Union['ApplicationGatewayGlobalArgs', 'ApplicationGatewayGlobalArgsDict']]] = None,
            http_listeners: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayHttpListenerArgs', 'ApplicationGatewayHttpListenerArgsDict']]]]] = None,
            identity: Optional[pulumi.Input[Union['ApplicationGatewayIdentityArgs', 'ApplicationGatewayIdentityArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            private_endpoint_connections: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayPrivateEndpointConnectionArgs', 'ApplicationGatewayPrivateEndpointConnectionArgsDict']]]]] = None,
            private_link_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayPrivateLinkConfigurationArgs', 'ApplicationGatewayPrivateLinkConfigurationArgsDict']]]]] = None,
            probes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayProbeArgs', 'ApplicationGatewayProbeArgsDict']]]]] = None,
            redirect_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayRedirectConfigurationArgs', 'ApplicationGatewayRedirectConfigurationArgsDict']]]]] = None,
            request_routing_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayRequestRoutingRuleArgs', 'ApplicationGatewayRequestRoutingRuleArgsDict']]]]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            rewrite_rule_sets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayRewriteRuleSetArgs', 'ApplicationGatewayRewriteRuleSetArgsDict']]]]] = None,
            sku: Optional[pulumi.Input[Union['ApplicationGatewaySkuArgs', 'ApplicationGatewaySkuArgsDict']]] = None,
            ssl_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewaySslCertificateArgs', 'ApplicationGatewaySslCertificateArgsDict']]]]] = None,
            ssl_policy: Optional[pulumi.Input[Union['ApplicationGatewaySslPolicyArgs', 'ApplicationGatewaySslPolicyArgsDict']]] = None,
            ssl_profiles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewaySslProfileArgs', 'ApplicationGatewaySslProfileArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            trusted_client_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayTrustedClientCertificateArgs', 'ApplicationGatewayTrustedClientCertificateArgsDict']]]]] = None,
            trusted_root_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayTrustedRootCertificateArgs', 'ApplicationGatewayTrustedRootCertificateArgsDict']]]]] = None,
            url_path_maps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayUrlPathMapArgs', 'ApplicationGatewayUrlPathMapArgsDict']]]]] = None,
            waf_configuration: Optional[pulumi.Input[Union['ApplicationGatewayWafConfigurationArgs', 'ApplicationGatewayWafConfigurationArgsDict']]] = None,
            zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'ApplicationGateway':
        """
        Get an existing ApplicationGateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayAuthenticationCertificateArgs', 'ApplicationGatewayAuthenticationCertificateArgsDict']]]] authentication_certificates: One or more `authentication_certificate` blocks as defined below.
        :param pulumi.Input[Union['ApplicationGatewayAutoscaleConfigurationArgs', 'ApplicationGatewayAutoscaleConfigurationArgsDict']] autoscale_configuration: An `autoscale_configuration` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayBackendAddressPoolArgs', 'ApplicationGatewayBackendAddressPoolArgsDict']]]] backend_address_pools: One or more `backend_address_pool` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayBackendHttpSettingArgs', 'ApplicationGatewayBackendHttpSettingArgsDict']]]] backend_http_settings: One or more `backend_http_settings` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayCustomErrorConfigurationArgs', 'ApplicationGatewayCustomErrorConfigurationArgsDict']]]] custom_error_configurations: One or more `custom_error_configuration` blocks as defined below.
        :param pulumi.Input[_builtins.bool] enable_http2: Is HTTP2 enabled on the application gateway resource? Defaults to `false`.
        :param pulumi.Input[_builtins.bool] fips_enabled: Is FIPS enabled on the Application Gateway?
        :param pulumi.Input[_builtins.str] firewall_policy_id: The ID of the Web Application Firewall Policy.
        :param pulumi.Input[_builtins.bool] force_firewall_policy_association: Is the Firewall Policy associated with the Application Gateway?
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayFrontendIpConfigurationArgs', 'ApplicationGatewayFrontendIpConfigurationArgsDict']]]] frontend_ip_configurations: One or more `frontend_ip_configuration` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayFrontendPortArgs', 'ApplicationGatewayFrontendPortArgsDict']]]] frontend_ports: One or more `frontend_port` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayGatewayIpConfigurationArgs', 'ApplicationGatewayGatewayIpConfigurationArgsDict']]]] gateway_ip_configurations: One or more `gateway_ip_configuration` blocks as defined below.
        :param pulumi.Input[Union['ApplicationGatewayGlobalArgs', 'ApplicationGatewayGlobalArgsDict']] global_: A `global` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayHttpListenerArgs', 'ApplicationGatewayHttpListenerArgsDict']]]] http_listeners: One or more `http_listener` blocks as defined below.
        :param pulumi.Input[Union['ApplicationGatewayIdentityArgs', 'ApplicationGatewayIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure region where the Application Gateway should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Application Gateway. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayPrivateEndpointConnectionArgs', 'ApplicationGatewayPrivateEndpointConnectionArgsDict']]]] private_endpoint_connections: A list of `private_endpoint_connection` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayPrivateLinkConfigurationArgs', 'ApplicationGatewayPrivateLinkConfigurationArgsDict']]]] private_link_configurations: One or more `private_link_configuration` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayProbeArgs', 'ApplicationGatewayProbeArgsDict']]]] probes: One or more `probe` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayRedirectConfigurationArgs', 'ApplicationGatewayRedirectConfigurationArgsDict']]]] redirect_configurations: One or more `redirect_configuration` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayRequestRoutingRuleArgs', 'ApplicationGatewayRequestRoutingRuleArgsDict']]]] request_routing_rules: One or more `request_routing_rule` blocks as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to the Application Gateway should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayRewriteRuleSetArgs', 'ApplicationGatewayRewriteRuleSetArgsDict']]]] rewrite_rule_sets: One or more `rewrite_rule_set` blocks as defined below. Only valid for v2 WAF and Standard SKUs.
        :param pulumi.Input[Union['ApplicationGatewaySkuArgs', 'ApplicationGatewaySkuArgsDict']] sku: A `sku` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewaySslCertificateArgs', 'ApplicationGatewaySslCertificateArgsDict']]]] ssl_certificates: One or more `ssl_certificate` blocks as defined below.
        :param pulumi.Input[Union['ApplicationGatewaySslPolicyArgs', 'ApplicationGatewaySslPolicyArgsDict']] ssl_policy: a `ssl_policy` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewaySslProfileArgs', 'ApplicationGatewaySslProfileArgsDict']]]] ssl_profiles: One or more `ssl_profile` blocks as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayTrustedClientCertificateArgs', 'ApplicationGatewayTrustedClientCertificateArgsDict']]]] trusted_client_certificates: One or more `trusted_client_certificate` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayTrustedRootCertificateArgs', 'ApplicationGatewayTrustedRootCertificateArgsDict']]]] trusted_root_certificates: One or more `trusted_root_certificate` blocks as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApplicationGatewayUrlPathMapArgs', 'ApplicationGatewayUrlPathMapArgsDict']]]] url_path_maps: One or more `url_path_map` blocks as defined below.
        :param pulumi.Input[Union['ApplicationGatewayWafConfigurationArgs', 'ApplicationGatewayWafConfigurationArgsDict']] waf_configuration: A `waf_configuration` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] zones: Specifies a list of Availability Zones in which this Application Gateway should be located. Changing this forces a new Application Gateway to be created.
               
               > **Note:** Availability Zones are not supported in all regions at this time, please check the [official documentation](https://docs.microsoft.com/azure/availability-zones/az-overview) for more information. They are also only supported for [v2 SKUs](https://docs.microsoft.com/azure/application-gateway/application-gateway-autoscaling-zone-redundant)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplicationGatewayState.__new__(_ApplicationGatewayState)

        __props__.__dict__["authentication_certificates"] = authentication_certificates
        __props__.__dict__["autoscale_configuration"] = autoscale_configuration
        __props__.__dict__["backend_address_pools"] = backend_address_pools
        __props__.__dict__["backend_http_settings"] = backend_http_settings
        __props__.__dict__["custom_error_configurations"] = custom_error_configurations
        __props__.__dict__["enable_http2"] = enable_http2
        __props__.__dict__["fips_enabled"] = fips_enabled
        __props__.__dict__["firewall_policy_id"] = firewall_policy_id
        __props__.__dict__["force_firewall_policy_association"] = force_firewall_policy_association
        __props__.__dict__["frontend_ip_configurations"] = frontend_ip_configurations
        __props__.__dict__["frontend_ports"] = frontend_ports
        __props__.__dict__["gateway_ip_configurations"] = gateway_ip_configurations
        __props__.__dict__["global_"] = global_
        __props__.__dict__["http_listeners"] = http_listeners
        __props__.__dict__["identity"] = identity
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["private_endpoint_connections"] = private_endpoint_connections
        __props__.__dict__["private_link_configurations"] = private_link_configurations
        __props__.__dict__["probes"] = probes
        __props__.__dict__["redirect_configurations"] = redirect_configurations
        __props__.__dict__["request_routing_rules"] = request_routing_rules
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["rewrite_rule_sets"] = rewrite_rule_sets
        __props__.__dict__["sku"] = sku
        __props__.__dict__["ssl_certificates"] = ssl_certificates
        __props__.__dict__["ssl_policy"] = ssl_policy
        __props__.__dict__["ssl_profiles"] = ssl_profiles
        __props__.__dict__["tags"] = tags
        __props__.__dict__["trusted_client_certificates"] = trusted_client_certificates
        __props__.__dict__["trusted_root_certificates"] = trusted_root_certificates
        __props__.__dict__["url_path_maps"] = url_path_maps
        __props__.__dict__["waf_configuration"] = waf_configuration
        __props__.__dict__["zones"] = zones
        return ApplicationGateway(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authenticationCertificates")
    def authentication_certificates(self) -> pulumi.Output[Optional[Sequence['outputs.ApplicationGatewayAuthenticationCertificate']]]:
        """
        One or more `authentication_certificate` blocks as defined below.
        """
        return pulumi.get(self, "authentication_certificates")

    @_builtins.property
    @pulumi.getter(name="autoscaleConfiguration")
    def autoscale_configuration(self) -> pulumi.Output[Optional['outputs.ApplicationGatewayAutoscaleConfiguration']]:
        """
        An `autoscale_configuration` block as defined below.
        """
        return pulumi.get(self, "autoscale_configuration")

    @_builtins.property
    @pulumi.getter(name="backendAddressPools")
    def backend_address_pools(self) -> pulumi.Output[Sequence['outputs.ApplicationGatewayBackendAddressPool']]:
        """
        One or more `backend_address_pool` blocks as defined below.
        """
        return pulumi.get(self, "backend_address_pools")

    @_builtins.property
    @pulumi.getter(name="backendHttpSettings")
    def backend_http_settings(self) -> pulumi.Output[Sequence['outputs.ApplicationGatewayBackendHttpSetting']]:
        """
        One or more `backend_http_settings` blocks as defined below.
        """
        return pulumi.get(self, "backend_http_settings")

    @_builtins.property
    @pulumi.getter(name="customErrorConfigurations")
    def custom_error_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.ApplicationGatewayCustomErrorConfiguration']]]:
        """
        One or more `custom_error_configuration` blocks as defined below.
        """
        return pulumi.get(self, "custom_error_configurations")

    @_builtins.property
    @pulumi.getter(name="enableHttp2")
    def enable_http2(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is HTTP2 enabled on the application gateway resource? Defaults to `false`.
        """
        return pulumi.get(self, "enable_http2")

    @_builtins.property
    @pulumi.getter(name="fipsEnabled")
    def fips_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is FIPS enabled on the Application Gateway?
        """
        return pulumi.get(self, "fips_enabled")

    @_builtins.property
    @pulumi.getter(name="firewallPolicyId")
    def firewall_policy_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Web Application Firewall Policy.
        """
        return pulumi.get(self, "firewall_policy_id")

    @_builtins.property
    @pulumi.getter(name="forceFirewallPolicyAssociation")
    def force_firewall_policy_association(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is the Firewall Policy associated with the Application Gateway?
        """
        return pulumi.get(self, "force_firewall_policy_association")

    @_builtins.property
    @pulumi.getter(name="frontendIpConfigurations")
    def frontend_ip_configurations(self) -> pulumi.Output[Sequence['outputs.ApplicationGatewayFrontendIpConfiguration']]:
        """
        One or more `frontend_ip_configuration` blocks as defined below.
        """
        return pulumi.get(self, "frontend_ip_configurations")

    @_builtins.property
    @pulumi.getter(name="frontendPorts")
    def frontend_ports(self) -> pulumi.Output[Sequence['outputs.ApplicationGatewayFrontendPort']]:
        """
        One or more `frontend_port` blocks as defined below.
        """
        return pulumi.get(self, "frontend_ports")

    @_builtins.property
    @pulumi.getter(name="gatewayIpConfigurations")
    def gateway_ip_configurations(self) -> pulumi.Output[Sequence['outputs.ApplicationGatewayGatewayIpConfiguration']]:
        """
        One or more `gateway_ip_configuration` blocks as defined below.
        """
        return pulumi.get(self, "gateway_ip_configurations")

    @_builtins.property
    @pulumi.getter(name="global")
    def global_(self) -> pulumi.Output[Optional['outputs.ApplicationGatewayGlobal']]:
        """
        A `global` block as defined below.
        """
        return pulumi.get(self, "global_")

    @_builtins.property
    @pulumi.getter(name="httpListeners")
    def http_listeners(self) -> pulumi.Output[Sequence['outputs.ApplicationGatewayHttpListener']]:
        """
        One or more `http_listener` blocks as defined below.
        """
        return pulumi.get(self, "http_listeners")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.ApplicationGatewayIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure region where the Application Gateway should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Application Gateway. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateEndpointConnections")
    def private_endpoint_connections(self) -> pulumi.Output[Sequence['outputs.ApplicationGatewayPrivateEndpointConnection']]:
        """
        A list of `private_endpoint_connection` blocks as defined below.
        """
        return pulumi.get(self, "private_endpoint_connections")

    @_builtins.property
    @pulumi.getter(name="privateLinkConfigurations")
    def private_link_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.ApplicationGatewayPrivateLinkConfiguration']]]:
        """
        One or more `private_link_configuration` blocks as defined below.
        """
        return pulumi.get(self, "private_link_configurations")

    @_builtins.property
    @pulumi.getter
    def probes(self) -> pulumi.Output[Optional[Sequence['outputs.ApplicationGatewayProbe']]]:
        """
        One or more `probe` blocks as defined below.
        """
        return pulumi.get(self, "probes")

    @_builtins.property
    @pulumi.getter(name="redirectConfigurations")
    def redirect_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.ApplicationGatewayRedirectConfiguration']]]:
        """
        One or more `redirect_configuration` blocks as defined below.
        """
        return pulumi.get(self, "redirect_configurations")

    @_builtins.property
    @pulumi.getter(name="requestRoutingRules")
    def request_routing_rules(self) -> pulumi.Output[Sequence['outputs.ApplicationGatewayRequestRoutingRule']]:
        """
        One or more `request_routing_rule` blocks as defined below.
        """
        return pulumi.get(self, "request_routing_rules")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to the Application Gateway should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="rewriteRuleSets")
    def rewrite_rule_sets(self) -> pulumi.Output[Optional[Sequence['outputs.ApplicationGatewayRewriteRuleSet']]]:
        """
        One or more `rewrite_rule_set` blocks as defined below. Only valid for v2 WAF and Standard SKUs.
        """
        return pulumi.get(self, "rewrite_rule_sets")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Output['outputs.ApplicationGatewaySku']:
        """
        A `sku` block as defined below.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter(name="sslCertificates")
    def ssl_certificates(self) -> pulumi.Output[Optional[Sequence['outputs.ApplicationGatewaySslCertificate']]]:
        """
        One or more `ssl_certificate` blocks as defined below.
        """
        return pulumi.get(self, "ssl_certificates")

    @_builtins.property
    @pulumi.getter(name="sslPolicy")
    def ssl_policy(self) -> pulumi.Output['outputs.ApplicationGatewaySslPolicy']:
        """
        a `ssl_policy` block as defined below.
        """
        return pulumi.get(self, "ssl_policy")

    @_builtins.property
    @pulumi.getter(name="sslProfiles")
    def ssl_profiles(self) -> pulumi.Output[Optional[Sequence['outputs.ApplicationGatewaySslProfile']]]:
        """
        One or more `ssl_profile` blocks as defined below.
        """
        return pulumi.get(self, "ssl_profiles")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="trustedClientCertificates")
    def trusted_client_certificates(self) -> pulumi.Output[Optional[Sequence['outputs.ApplicationGatewayTrustedClientCertificate']]]:
        """
        One or more `trusted_client_certificate` blocks as defined below.
        """
        return pulumi.get(self, "trusted_client_certificates")

    @_builtins.property
    @pulumi.getter(name="trustedRootCertificates")
    def trusted_root_certificates(self) -> pulumi.Output[Optional[Sequence['outputs.ApplicationGatewayTrustedRootCertificate']]]:
        """
        One or more `trusted_root_certificate` blocks as defined below.
        """
        return pulumi.get(self, "trusted_root_certificates")

    @_builtins.property
    @pulumi.getter(name="urlPathMaps")
    def url_path_maps(self) -> pulumi.Output[Optional[Sequence['outputs.ApplicationGatewayUrlPathMap']]]:
        """
        One or more `url_path_map` blocks as defined below.
        """
        return pulumi.get(self, "url_path_maps")

    @_builtins.property
    @pulumi.getter(name="wafConfiguration")
    def waf_configuration(self) -> pulumi.Output[Optional['outputs.ApplicationGatewayWafConfiguration']]:
        """
        A `waf_configuration` block as defined below.
        """
        return pulumi.get(self, "waf_configuration")

    @_builtins.property
    @pulumi.getter
    def zones(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of Availability Zones in which this Application Gateway should be located. Changing this forces a new Application Gateway to be created.

        > **Note:** Availability Zones are not supported in all regions at this time, please check the [official documentation](https://docs.microsoft.com/azure/availability-zones/az-overview) for more information. They are also only supported for [v2 SKUs](https://docs.microsoft.com/azure/application-gateway/application-gateway-autoscaling-zone-redundant)
        """
        return pulumi.get(self, "zones")

