# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetPublicIPResult',
    'AwaitableGetPublicIPResult',
    'get_public_ip',
    'get_public_ip_output',
]

@pulumi.output_type
class GetPublicIPResult:
    """
    A collection of values returned by getPublicIP.
    """
    def __init__(__self__, allocation_method=None, ddos_protection_mode=None, ddos_protection_plan_id=None, domain_name_label=None, fqdn=None, id=None, idle_timeout_in_minutes=None, ip_address=None, ip_tags=None, ip_version=None, location=None, name=None, resource_group_name=None, reverse_fqdn=None, sku=None, tags=None, zones=None):
        if allocation_method and not isinstance(allocation_method, str):
            raise TypeError("Expected argument 'allocation_method' to be a str")
        pulumi.set(__self__, "allocation_method", allocation_method)
        if ddos_protection_mode and not isinstance(ddos_protection_mode, str):
            raise TypeError("Expected argument 'ddos_protection_mode' to be a str")
        pulumi.set(__self__, "ddos_protection_mode", ddos_protection_mode)
        if ddos_protection_plan_id and not isinstance(ddos_protection_plan_id, str):
            raise TypeError("Expected argument 'ddos_protection_plan_id' to be a str")
        pulumi.set(__self__, "ddos_protection_plan_id", ddos_protection_plan_id)
        if domain_name_label and not isinstance(domain_name_label, str):
            raise TypeError("Expected argument 'domain_name_label' to be a str")
        pulumi.set(__self__, "domain_name_label", domain_name_label)
        if fqdn and not isinstance(fqdn, str):
            raise TypeError("Expected argument 'fqdn' to be a str")
        pulumi.set(__self__, "fqdn", fqdn)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if idle_timeout_in_minutes and not isinstance(idle_timeout_in_minutes, int):
            raise TypeError("Expected argument 'idle_timeout_in_minutes' to be a int")
        pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if ip_address and not isinstance(ip_address, str):
            raise TypeError("Expected argument 'ip_address' to be a str")
        pulumi.set(__self__, "ip_address", ip_address)
        if ip_tags and not isinstance(ip_tags, dict):
            raise TypeError("Expected argument 'ip_tags' to be a dict")
        pulumi.set(__self__, "ip_tags", ip_tags)
        if ip_version and not isinstance(ip_version, str):
            raise TypeError("Expected argument 'ip_version' to be a str")
        pulumi.set(__self__, "ip_version", ip_version)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if reverse_fqdn and not isinstance(reverse_fqdn, str):
            raise TypeError("Expected argument 'reverse_fqdn' to be a str")
        pulumi.set(__self__, "reverse_fqdn", reverse_fqdn)
        if sku and not isinstance(sku, str):
            raise TypeError("Expected argument 'sku' to be a str")
        pulumi.set(__self__, "sku", sku)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if zones and not isinstance(zones, list):
            raise TypeError("Expected argument 'zones' to be a list")
        pulumi.set(__self__, "zones", zones)

    @_builtins.property
    @pulumi.getter(name="allocationMethod")
    def allocation_method(self) -> _builtins.str:
        """
        The allocation method for this IP address. Possible values are `Static` or `Dynamic`.
        """
        return pulumi.get(self, "allocation_method")

    @_builtins.property
    @pulumi.getter(name="ddosProtectionMode")
    def ddos_protection_mode(self) -> _builtins.str:
        """
        The DDoS protection mode of the public IP.
        """
        return pulumi.get(self, "ddos_protection_mode")

    @_builtins.property
    @pulumi.getter(name="ddosProtectionPlanId")
    def ddos_protection_plan_id(self) -> _builtins.str:
        """
        The ID of DDoS protection plan associated with the public IP.
        """
        return pulumi.get(self, "ddos_protection_plan_id")

    @_builtins.property
    @pulumi.getter(name="domainNameLabel")
    def domain_name_label(self) -> _builtins.str:
        """
        The label for the Domain Name.
        """
        return pulumi.get(self, "domain_name_label")

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> _builtins.str:
        """
        Fully qualified domain name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> _builtins.int:
        """
        Specifies the timeout for the TCP idle connection.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> _builtins.str:
        """
        The IP address value that was allocated.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter(name="ipTags")
    def ip_tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags to assigned to the resource.
        """
        return pulumi.get(self, "ip_tags")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> _builtins.str:
        """
        The IP version being used, for example `IPv4` or `IPv6`.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The region that this public ip exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="reverseFqdn")
    def reverse_fqdn(self) -> _builtins.str:
        """
        The fully qualified domain name that resolves to this public IP address.
        """
        return pulumi.get(self, "reverse_fqdn")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> _builtins.str:
        """
        The SKU of the Public IP.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags to assigned to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def zones(self) -> Sequence[_builtins.str]:
        """
        A list of Availability Zones in which this Public IP is located.
        """
        return pulumi.get(self, "zones")


class AwaitableGetPublicIPResult(GetPublicIPResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPublicIPResult(
            allocation_method=self.allocation_method,
            ddos_protection_mode=self.ddos_protection_mode,
            ddos_protection_plan_id=self.ddos_protection_plan_id,
            domain_name_label=self.domain_name_label,
            fqdn=self.fqdn,
            id=self.id,
            idle_timeout_in_minutes=self.idle_timeout_in_minutes,
            ip_address=self.ip_address,
            ip_tags=self.ip_tags,
            ip_version=self.ip_version,
            location=self.location,
            name=self.name,
            resource_group_name=self.resource_group_name,
            reverse_fqdn=self.reverse_fqdn,
            sku=self.sku,
            tags=self.tags,
            zones=self.zones)


def get_public_ip(name: Optional[_builtins.str] = None,
                  resource_group_name: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPublicIPResult:
    """
    Use this data source to access information about an existing Public IP Address.

    ## Example Usage

    ### Reference An Existing)

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_public_ip(name="name_of_public_ip",
        resource_group_name="name_of_resource_group")
    pulumi.export("domainNameLabel", example.domain_name_label)
    pulumi.export("publicIpAddress", example.ip_address)
    ```

    ### Retrieve The Dynamic Public IP Of A New VM)

    ```python
    import pulumi
    import pulumi_azure as azure

    example_resource_group = azure.core.ResourceGroup("example",
        name="test-resources",
        location="West Europe")
    example_virtual_network = azure.network.VirtualNetwork("example",
        name="test-network",
        address_spaces=["10.0.0.0/16"],
        location=example_resource_group.location,
        resource_group_name=example_resource_group.name)
    example_subnet = azure.network.Subnet("example",
        name="acctsub",
        resource_group_name=example_resource_group.name,
        virtual_network_name=example_virtual_network.name,
        address_prefixes=["10.0.2.0/24"])
    example_public_ip = azure.network.PublicIp("example",
        name="test-pip",
        location=example_resource_group.location,
        resource_group_name=example_resource_group.name,
        allocation_method="Dynamic",
        idle_timeout_in_minutes=30,
        tags={
            "environment": "test",
        })
    example_network_interface = azure.network.NetworkInterface("example",
        name="test-nic",
        location=example_resource_group.location,
        resource_group_name=example_resource_group.name,
        ip_configurations=[{
            "name": "testconfiguration1",
            "subnet_id": example_subnet.id,
            "private_ip_address_allocation": "Static",
            "private_ip_address": "10.0.2.5",
            "public_ip_address_id": example_public_ip.id,
        }])
    example_virtual_machine = azure.compute.VirtualMachine("example",
        name="test-vm",
        location=example_resource_group.location,
        resource_group_name=example_resource_group.name,
        network_interface_ids=[example_network_interface.id])
    example = azure.network.get_public_ip_output(name=example_public_ip.name,
        resource_group_name=example_virtual_machine.resource_group_name)
    pulumi.export("publicIpAddress", example.ip_address)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2024-05-01


    :param _builtins.str name: Specifies the name of the public IP address.
    :param _builtins.str resource_group_name: Specifies the name of the resource group.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:network/getPublicIP:getPublicIP', __args__, opts=opts, typ=GetPublicIPResult).value

    return AwaitableGetPublicIPResult(
        allocation_method=pulumi.get(__ret__, 'allocation_method'),
        ddos_protection_mode=pulumi.get(__ret__, 'ddos_protection_mode'),
        ddos_protection_plan_id=pulumi.get(__ret__, 'ddos_protection_plan_id'),
        domain_name_label=pulumi.get(__ret__, 'domain_name_label'),
        fqdn=pulumi.get(__ret__, 'fqdn'),
        id=pulumi.get(__ret__, 'id'),
        idle_timeout_in_minutes=pulumi.get(__ret__, 'idle_timeout_in_minutes'),
        ip_address=pulumi.get(__ret__, 'ip_address'),
        ip_tags=pulumi.get(__ret__, 'ip_tags'),
        ip_version=pulumi.get(__ret__, 'ip_version'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        reverse_fqdn=pulumi.get(__ret__, 'reverse_fqdn'),
        sku=pulumi.get(__ret__, 'sku'),
        tags=pulumi.get(__ret__, 'tags'),
        zones=pulumi.get(__ret__, 'zones'))
def get_public_ip_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                         resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetPublicIPResult]:
    """
    Use this data source to access information about an existing Public IP Address.

    ## Example Usage

    ### Reference An Existing)

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_public_ip(name="name_of_public_ip",
        resource_group_name="name_of_resource_group")
    pulumi.export("domainNameLabel", example.domain_name_label)
    pulumi.export("publicIpAddress", example.ip_address)
    ```

    ### Retrieve The Dynamic Public IP Of A New VM)

    ```python
    import pulumi
    import pulumi_azure as azure

    example_resource_group = azure.core.ResourceGroup("example",
        name="test-resources",
        location="West Europe")
    example_virtual_network = azure.network.VirtualNetwork("example",
        name="test-network",
        address_spaces=["10.0.0.0/16"],
        location=example_resource_group.location,
        resource_group_name=example_resource_group.name)
    example_subnet = azure.network.Subnet("example",
        name="acctsub",
        resource_group_name=example_resource_group.name,
        virtual_network_name=example_virtual_network.name,
        address_prefixes=["10.0.2.0/24"])
    example_public_ip = azure.network.PublicIp("example",
        name="test-pip",
        location=example_resource_group.location,
        resource_group_name=example_resource_group.name,
        allocation_method="Dynamic",
        idle_timeout_in_minutes=30,
        tags={
            "environment": "test",
        })
    example_network_interface = azure.network.NetworkInterface("example",
        name="test-nic",
        location=example_resource_group.location,
        resource_group_name=example_resource_group.name,
        ip_configurations=[{
            "name": "testconfiguration1",
            "subnet_id": example_subnet.id,
            "private_ip_address_allocation": "Static",
            "private_ip_address": "10.0.2.5",
            "public_ip_address_id": example_public_ip.id,
        }])
    example_virtual_machine = azure.compute.VirtualMachine("example",
        name="test-vm",
        location=example_resource_group.location,
        resource_group_name=example_resource_group.name,
        network_interface_ids=[example_network_interface.id])
    example = azure.network.get_public_ip_output(name=example_public_ip.name,
        resource_group_name=example_virtual_machine.resource_group_name)
    pulumi.export("publicIpAddress", example.ip_address)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2024-05-01


    :param _builtins.str name: Specifies the name of the public IP address.
    :param _builtins.str resource_group_name: Specifies the name of the resource group.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:network/getPublicIP:getPublicIP', __args__, opts=opts, typ=GetPublicIPResult)
    return __ret__.apply(lambda __response__: GetPublicIPResult(
        allocation_method=pulumi.get(__response__, 'allocation_method'),
        ddos_protection_mode=pulumi.get(__response__, 'ddos_protection_mode'),
        ddos_protection_plan_id=pulumi.get(__response__, 'ddos_protection_plan_id'),
        domain_name_label=pulumi.get(__response__, 'domain_name_label'),
        fqdn=pulumi.get(__response__, 'fqdn'),
        id=pulumi.get(__response__, 'id'),
        idle_timeout_in_minutes=pulumi.get(__response__, 'idle_timeout_in_minutes'),
        ip_address=pulumi.get(__response__, 'ip_address'),
        ip_tags=pulumi.get(__response__, 'ip_tags'),
        ip_version=pulumi.get(__response__, 'ip_version'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        reverse_fqdn=pulumi.get(__response__, 'reverse_fqdn'),
        sku=pulumi.get(__response__, 'sku'),
        tags=pulumi.get(__response__, 'tags'),
        zones=pulumi.get(__response__, 'zones')))
