# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVirtualHubConnectionResult',
    'AwaitableGetVirtualHubConnectionResult',
    'get_virtual_hub_connection',
    'get_virtual_hub_connection_output',
]

@pulumi.output_type
class GetVirtualHubConnectionResult:
    """
    A collection of values returned by getVirtualHubConnection.
    """
    def __init__(__self__, id=None, internet_security_enabled=None, name=None, remote_virtual_network_id=None, resource_group_name=None, routings=None, virtual_hub_id=None, virtual_hub_name=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if internet_security_enabled and not isinstance(internet_security_enabled, bool):
            raise TypeError("Expected argument 'internet_security_enabled' to be a bool")
        pulumi.set(__self__, "internet_security_enabled", internet_security_enabled)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if remote_virtual_network_id and not isinstance(remote_virtual_network_id, str):
            raise TypeError("Expected argument 'remote_virtual_network_id' to be a str")
        pulumi.set(__self__, "remote_virtual_network_id", remote_virtual_network_id)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if routings and not isinstance(routings, list):
            raise TypeError("Expected argument 'routings' to be a list")
        pulumi.set(__self__, "routings", routings)
        if virtual_hub_id and not isinstance(virtual_hub_id, str):
            raise TypeError("Expected argument 'virtual_hub_id' to be a str")
        pulumi.set(__self__, "virtual_hub_id", virtual_hub_id)
        if virtual_hub_name and not isinstance(virtual_hub_name, str):
            raise TypeError("Expected argument 'virtual_hub_name' to be a str")
        pulumi.set(__self__, "virtual_hub_name", virtual_hub_name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="internetSecurityEnabled")
    def internet_security_enabled(self) -> _builtins.bool:
        """
        Whether Internet Security is enabled to secure internet traffic on this connection
        """
        return pulumi.get(self, "internet_security_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name which is used for this Static Route.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="remoteVirtualNetworkId")
    def remote_virtual_network_id(self) -> _builtins.str:
        """
        The ID of the Virtual Network which the Virtual Hub is connected
        """
        return pulumi.get(self, "remote_virtual_network_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def routings(self) -> Sequence['outputs.GetVirtualHubConnectionRoutingResult']:
        """
        A `routing` block as defined below.
        """
        return pulumi.get(self, "routings")

    @_builtins.property
    @pulumi.getter(name="virtualHubId")
    def virtual_hub_id(self) -> _builtins.str:
        """
        The ID of the Virtual Hub within which this connection is created
        """
        return pulumi.get(self, "virtual_hub_id")

    @_builtins.property
    @pulumi.getter(name="virtualHubName")
    def virtual_hub_name(self) -> _builtins.str:
        return pulumi.get(self, "virtual_hub_name")


class AwaitableGetVirtualHubConnectionResult(GetVirtualHubConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVirtualHubConnectionResult(
            id=self.id,
            internet_security_enabled=self.internet_security_enabled,
            name=self.name,
            remote_virtual_network_id=self.remote_virtual_network_id,
            resource_group_name=self.resource_group_name,
            routings=self.routings,
            virtual_hub_id=self.virtual_hub_id,
            virtual_hub_name=self.virtual_hub_name)


def get_virtual_hub_connection(name: Optional[_builtins.str] = None,
                               resource_group_name: Optional[_builtins.str] = None,
                               virtual_hub_name: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVirtualHubConnectionResult:
    """
    Uses this data source to access information about an existing Virtual Hub Connection.

    ## Virtual Hub Connection Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_virtual_hub_connection(name="example-connection",
        resource_group_name="example-resources",
        virtual_hub_name="example-hub-name")
    pulumi.export("virtualHubConnectionId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2024-05-01


    :param _builtins.str name: The name of the Connection which should be retrieved.
    :param _builtins.str resource_group_name: The Name of the Resource Group where the Virtual Hub Connection exists.
    :param _builtins.str virtual_hub_name: The name of the Virtual Hub where this Connection exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    __args__['virtualHubName'] = virtual_hub_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:network/getVirtualHubConnection:getVirtualHubConnection', __args__, opts=opts, typ=GetVirtualHubConnectionResult).value

    return AwaitableGetVirtualHubConnectionResult(
        id=pulumi.get(__ret__, 'id'),
        internet_security_enabled=pulumi.get(__ret__, 'internet_security_enabled'),
        name=pulumi.get(__ret__, 'name'),
        remote_virtual_network_id=pulumi.get(__ret__, 'remote_virtual_network_id'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        routings=pulumi.get(__ret__, 'routings'),
        virtual_hub_id=pulumi.get(__ret__, 'virtual_hub_id'),
        virtual_hub_name=pulumi.get(__ret__, 'virtual_hub_name'))
def get_virtual_hub_connection_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                      resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                                      virtual_hub_name: Optional[pulumi.Input[_builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVirtualHubConnectionResult]:
    """
    Uses this data source to access information about an existing Virtual Hub Connection.

    ## Virtual Hub Connection Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_virtual_hub_connection(name="example-connection",
        resource_group_name="example-resources",
        virtual_hub_name="example-hub-name")
    pulumi.export("virtualHubConnectionId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2024-05-01


    :param _builtins.str name: The name of the Connection which should be retrieved.
    :param _builtins.str resource_group_name: The Name of the Resource Group where the Virtual Hub Connection exists.
    :param _builtins.str virtual_hub_name: The name of the Virtual Hub where this Connection exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    __args__['virtualHubName'] = virtual_hub_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:network/getVirtualHubConnection:getVirtualHubConnection', __args__, opts=opts, typ=GetVirtualHubConnectionResult)
    return __ret__.apply(lambda __response__: GetVirtualHubConnectionResult(
        id=pulumi.get(__response__, 'id'),
        internet_security_enabled=pulumi.get(__response__, 'internet_security_enabled'),
        name=pulumi.get(__response__, 'name'),
        remote_virtual_network_id=pulumi.get(__response__, 'remote_virtual_network_id'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        routings=pulumi.get(__response__, 'routings'),
        virtual_hub_id=pulumi.get(__response__, 'virtual_hub_id'),
        virtual_hub_name=pulumi.get(__response__, 'virtual_hub_name')))
