# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetVpnGatewayResult',
    'AwaitableGetVpnGatewayResult',
    'get_vpn_gateway',
    'get_vpn_gateway_output',
]

@pulumi.output_type
class GetVpnGatewayResult:
    """
    A collection of values returned by getVpnGateway.
    """
    def __init__(__self__, bgp_settings=None, id=None, ip_configurations=None, location=None, name=None, resource_group_name=None, scale_unit=None, tags=None, virtual_hub_id=None):
        if bgp_settings and not isinstance(bgp_settings, list):
            raise TypeError("Expected argument 'bgp_settings' to be a list")
        pulumi.set(__self__, "bgp_settings", bgp_settings)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_configurations and not isinstance(ip_configurations, list):
            raise TypeError("Expected argument 'ip_configurations' to be a list")
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if scale_unit and not isinstance(scale_unit, int):
            raise TypeError("Expected argument 'scale_unit' to be a int")
        pulumi.set(__self__, "scale_unit", scale_unit)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if virtual_hub_id and not isinstance(virtual_hub_id, str):
            raise TypeError("Expected argument 'virtual_hub_id' to be a str")
        pulumi.set(__self__, "virtual_hub_id", virtual_hub_id)

    @_builtins.property
    @pulumi.getter(name="bgpSettings")
    def bgp_settings(self) -> Sequence['outputs.GetVpnGatewayBgpSettingResult']:
        """
        A `bgp_settings` block as defined below.
        """
        return pulumi.get(self, "bgp_settings")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Sequence['outputs.GetVpnGatewayIpConfigurationResult']:
        """
        An `ip_configuration` block as defined below.
        """
        return pulumi.get(self, "ip_configurations")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure location where the VPN Gateway exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="scaleUnit")
    def scale_unit(self) -> _builtins.int:
        """
        The Scale Unit of this VPN Gateway.
        """
        return pulumi.get(self, "scale_unit")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the VPN Gateway.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="virtualHubId")
    def virtual_hub_id(self) -> _builtins.str:
        """
        The ID of the Virtual Hub within which this VPN Gateway has been created.
        """
        return pulumi.get(self, "virtual_hub_id")


class AwaitableGetVpnGatewayResult(GetVpnGatewayResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpnGatewayResult(
            bgp_settings=self.bgp_settings,
            id=self.id,
            ip_configurations=self.ip_configurations,
            location=self.location,
            name=self.name,
            resource_group_name=self.resource_group_name,
            scale_unit=self.scale_unit,
            tags=self.tags,
            virtual_hub_id=self.virtual_hub_id)


def get_vpn_gateway(name: Optional[_builtins.str] = None,
                    resource_group_name: Optional[_builtins.str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpnGatewayResult:
    """
    Use this data source to access information about an existing VPN Gateway within a Virtual Hub.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_vpn_gateway(name="existing-local-vpn_gateway",
        resource_group_name="existing-vpn_gateway")
    pulumi.export("azurermVpnGatewayId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2024-05-01


    :param _builtins.str name: The Name of the VPN Gateway.
    :param _builtins.str resource_group_name: The name of the Resource Group where the VPN Gateway exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:network/getVpnGateway:getVpnGateway', __args__, opts=opts, typ=GetVpnGatewayResult).value

    return AwaitableGetVpnGatewayResult(
        bgp_settings=pulumi.get(__ret__, 'bgp_settings'),
        id=pulumi.get(__ret__, 'id'),
        ip_configurations=pulumi.get(__ret__, 'ip_configurations'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        scale_unit=pulumi.get(__ret__, 'scale_unit'),
        tags=pulumi.get(__ret__, 'tags'),
        virtual_hub_id=pulumi.get(__ret__, 'virtual_hub_id'))
def get_vpn_gateway_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                           resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpnGatewayResult]:
    """
    Use this data source to access information about an existing VPN Gateway within a Virtual Hub.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_vpn_gateway(name="existing-local-vpn_gateway",
        resource_group_name="existing-vpn_gateway")
    pulumi.export("azurermVpnGatewayId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2024-05-01


    :param _builtins.str name: The Name of the VPN Gateway.
    :param _builtins.str resource_group_name: The name of the Resource Group where the VPN Gateway exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:network/getVpnGateway:getVpnGateway', __args__, opts=opts, typ=GetVpnGatewayResult)
    return __ret__.apply(lambda __response__: GetVpnGatewayResult(
        bgp_settings=pulumi.get(__response__, 'bgp_settings'),
        id=pulumi.get(__response__, 'id'),
        ip_configurations=pulumi.get(__response__, 'ip_configurations'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        scale_unit=pulumi.get(__response__, 'scale_unit'),
        tags=pulumi.get(__response__, 'tags'),
        virtual_hub_id=pulumi.get(__response__, 'virtual_hub_id')))
