# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NetworkManagerRoutingRuleCollectionArgs', 'NetworkManagerRoutingRuleCollection']

@pulumi.input_type
class NetworkManagerRoutingRuleCollectionArgs:
    def __init__(__self__, *,
                 network_group_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 routing_configuration_id: pulumi.Input[_builtins.str],
                 bgp_route_propagation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkManagerRoutingRuleCollection resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_group_ids: A list of Network Group IDs which this Network Manager Routing Rule Collection applies to.
        :param pulumi.Input[_builtins.str] routing_configuration_id: The ID of the Network Manager Routing Configuration. Changing this forces a new Network Manager Routing Rule Collection to be created.
        :param pulumi.Input[_builtins.bool] bgp_route_propagation_enabled: Whether to enable the BGP route propagation. Defaults to `false`.
        :param pulumi.Input[_builtins.str] description: The description of the Network Manager Routing Rule Collection.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Network Manager Routing Rule Collection. Changing this forces a new Network Manager Routing Rule Collection to be created.
        """
        pulumi.set(__self__, "network_group_ids", network_group_ids)
        pulumi.set(__self__, "routing_configuration_id", routing_configuration_id)
        if bgp_route_propagation_enabled is not None:
            pulumi.set(__self__, "bgp_route_propagation_enabled", bgp_route_propagation_enabled)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="networkGroupIds")
    def network_group_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of Network Group IDs which this Network Manager Routing Rule Collection applies to.
        """
        return pulumi.get(self, "network_group_ids")

    @network_group_ids.setter
    def network_group_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "network_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="routingConfigurationId")
    def routing_configuration_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Network Manager Routing Configuration. Changing this forces a new Network Manager Routing Rule Collection to be created.
        """
        return pulumi.get(self, "routing_configuration_id")

    @routing_configuration_id.setter
    def routing_configuration_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "routing_configuration_id", value)

    @_builtins.property
    @pulumi.getter(name="bgpRoutePropagationEnabled")
    def bgp_route_propagation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the BGP route propagation. Defaults to `false`.
        """
        return pulumi.get(self, "bgp_route_propagation_enabled")

    @bgp_route_propagation_enabled.setter
    def bgp_route_propagation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bgp_route_propagation_enabled", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Network Manager Routing Rule Collection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Network Manager Routing Rule Collection. Changing this forces a new Network Manager Routing Rule Collection to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NetworkManagerRoutingRuleCollectionState:
    def __init__(__self__, *,
                 bgp_route_propagation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 routing_configuration_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkManagerRoutingRuleCollection resources.
        :param pulumi.Input[_builtins.bool] bgp_route_propagation_enabled: Whether to enable the BGP route propagation. Defaults to `false`.
        :param pulumi.Input[_builtins.str] description: The description of the Network Manager Routing Rule Collection.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Network Manager Routing Rule Collection. Changing this forces a new Network Manager Routing Rule Collection to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_group_ids: A list of Network Group IDs which this Network Manager Routing Rule Collection applies to.
        :param pulumi.Input[_builtins.str] routing_configuration_id: The ID of the Network Manager Routing Configuration. Changing this forces a new Network Manager Routing Rule Collection to be created.
        """
        if bgp_route_propagation_enabled is not None:
            pulumi.set(__self__, "bgp_route_propagation_enabled", bgp_route_propagation_enabled)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_group_ids is not None:
            pulumi.set(__self__, "network_group_ids", network_group_ids)
        if routing_configuration_id is not None:
            pulumi.set(__self__, "routing_configuration_id", routing_configuration_id)

    @_builtins.property
    @pulumi.getter(name="bgpRoutePropagationEnabled")
    def bgp_route_propagation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the BGP route propagation. Defaults to `false`.
        """
        return pulumi.get(self, "bgp_route_propagation_enabled")

    @bgp_route_propagation_enabled.setter
    def bgp_route_propagation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "bgp_route_propagation_enabled", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Network Manager Routing Rule Collection.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Network Manager Routing Rule Collection. Changing this forces a new Network Manager Routing Rule Collection to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkGroupIds")
    def network_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of Network Group IDs which this Network Manager Routing Rule Collection applies to.
        """
        return pulumi.get(self, "network_group_ids")

    @network_group_ids.setter
    def network_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "network_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="routingConfigurationId")
    def routing_configuration_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Network Manager Routing Configuration. Changing this forces a new Network Manager Routing Rule Collection to be created.
        """
        return pulumi.get(self, "routing_configuration_id")

    @routing_configuration_id.setter
    def routing_configuration_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routing_configuration_id", value)


@pulumi.type_token("azure:network/networkManagerRoutingRuleCollection:NetworkManagerRoutingRuleCollection")
class NetworkManagerRoutingRuleCollection(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bgp_route_propagation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 routing_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        current = azure.core.get_subscription()
        example_network_manager = azure.network.NetworkManager("example",
            name="example-network-manager",
            location=example.location,
            resource_group_name=example.name,
            scope={
                "subscription_ids": [current.id],
            },
            scope_accesses=["Routing"])
        example_network_manager_network_group = azure.network.NetworkManagerNetworkGroup("example",
            name="example-network-group",
            network_manager_id=example_network_manager.id)
        example_network_manager_routing_configuration = azure.network.NetworkManagerRoutingConfiguration("example",
            name="example-routing-configuration",
            network_manager_id=example_network_manager.id)
        example_network_manager_routing_rule_collection = azure.network.NetworkManagerRoutingRuleCollection("example",
            name="example-routing-rule-collection",
            routing_configuration_id=example_network_manager_routing_configuration.id,
            network_group_ids=["azurerm_network_manager_network_group.example.id"],
            description="example routing rule collection")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2024-05-01

        ## Import

        Network Manager Routing Rule Collections can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/networkManagerRoutingRuleCollection:NetworkManagerRoutingRuleCollection example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Network/networkManagers/manager1/routingConfigurations/conf1/ruleCollections/collection1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] bgp_route_propagation_enabled: Whether to enable the BGP route propagation. Defaults to `false`.
        :param pulumi.Input[_builtins.str] description: The description of the Network Manager Routing Rule Collection.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Network Manager Routing Rule Collection. Changing this forces a new Network Manager Routing Rule Collection to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_group_ids: A list of Network Group IDs which this Network Manager Routing Rule Collection applies to.
        :param pulumi.Input[_builtins.str] routing_configuration_id: The ID of the Network Manager Routing Configuration. Changing this forces a new Network Manager Routing Rule Collection to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkManagerRoutingRuleCollectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        current = azure.core.get_subscription()
        example_network_manager = azure.network.NetworkManager("example",
            name="example-network-manager",
            location=example.location,
            resource_group_name=example.name,
            scope={
                "subscription_ids": [current.id],
            },
            scope_accesses=["Routing"])
        example_network_manager_network_group = azure.network.NetworkManagerNetworkGroup("example",
            name="example-network-group",
            network_manager_id=example_network_manager.id)
        example_network_manager_routing_configuration = azure.network.NetworkManagerRoutingConfiguration("example",
            name="example-routing-configuration",
            network_manager_id=example_network_manager.id)
        example_network_manager_routing_rule_collection = azure.network.NetworkManagerRoutingRuleCollection("example",
            name="example-routing-rule-collection",
            routing_configuration_id=example_network_manager_routing_configuration.id,
            network_group_ids=["azurerm_network_manager_network_group.example.id"],
            description="example routing rule collection")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2024-05-01

        ## Import

        Network Manager Routing Rule Collections can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/networkManagerRoutingRuleCollection:NetworkManagerRoutingRuleCollection example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.Network/networkManagers/manager1/routingConfigurations/conf1/ruleCollections/collection1
        ```

        :param str resource_name: The name of the resource.
        :param NetworkManagerRoutingRuleCollectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkManagerRoutingRuleCollectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bgp_route_propagation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 routing_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkManagerRoutingRuleCollectionArgs.__new__(NetworkManagerRoutingRuleCollectionArgs)

            __props__.__dict__["bgp_route_propagation_enabled"] = bgp_route_propagation_enabled
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if network_group_ids is None and not opts.urn:
                raise TypeError("Missing required property 'network_group_ids'")
            __props__.__dict__["network_group_ids"] = network_group_ids
            if routing_configuration_id is None and not opts.urn:
                raise TypeError("Missing required property 'routing_configuration_id'")
            __props__.__dict__["routing_configuration_id"] = routing_configuration_id
        super(NetworkManagerRoutingRuleCollection, __self__).__init__(
            'azure:network/networkManagerRoutingRuleCollection:NetworkManagerRoutingRuleCollection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bgp_route_propagation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            routing_configuration_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'NetworkManagerRoutingRuleCollection':
        """
        Get an existing NetworkManagerRoutingRuleCollection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] bgp_route_propagation_enabled: Whether to enable the BGP route propagation. Defaults to `false`.
        :param pulumi.Input[_builtins.str] description: The description of the Network Manager Routing Rule Collection.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Network Manager Routing Rule Collection. Changing this forces a new Network Manager Routing Rule Collection to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] network_group_ids: A list of Network Group IDs which this Network Manager Routing Rule Collection applies to.
        :param pulumi.Input[_builtins.str] routing_configuration_id: The ID of the Network Manager Routing Configuration. Changing this forces a new Network Manager Routing Rule Collection to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkManagerRoutingRuleCollectionState.__new__(_NetworkManagerRoutingRuleCollectionState)

        __props__.__dict__["bgp_route_propagation_enabled"] = bgp_route_propagation_enabled
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["network_group_ids"] = network_group_ids
        __props__.__dict__["routing_configuration_id"] = routing_configuration_id
        return NetworkManagerRoutingRuleCollection(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bgpRoutePropagationEnabled")
    def bgp_route_propagation_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable the BGP route propagation. Defaults to `false`.
        """
        return pulumi.get(self, "bgp_route_propagation_enabled")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the Network Manager Routing Rule Collection.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Network Manager Routing Rule Collection. Changing this forces a new Network Manager Routing Rule Collection to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkGroupIds")
    def network_group_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of Network Group IDs which this Network Manager Routing Rule Collection applies to.
        """
        return pulumi.get(self, "network_group_ids")

    @_builtins.property
    @pulumi.getter(name="routingConfigurationId")
    def routing_configuration_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Network Manager Routing Configuration. Changing this forces a new Network Manager Routing Rule Collection to be created.
        """
        return pulumi.get(self, "routing_configuration_id")

