# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AutonomousDatabaseBackupArgs', 'AutonomousDatabaseBackup']

@pulumi.input_type
class AutonomousDatabaseBackupArgs:
    def __init__(__self__, *,
                 autonomous_database_id: pulumi.Input[_builtins.str],
                 retention_period_in_days: pulumi.Input[_builtins.int],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AutonomousDatabaseBackup resource.
        :param pulumi.Input[_builtins.str] autonomous_database_id: The azureId of the Autonomous Database that this backup is for. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] retention_period_in_days: (Updatable) The number of days to retain the backup. Must be between 90 and 3650 days.
        :param pulumi.Input[_builtins.str] name: The display name of the Autonomous Database Backup. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] type: The type of backup to create.Currently, only `LongTerm` backup operations are supported through the Oracle database At azure service.
        """
        pulumi.set(__self__, "autonomous_database_id", autonomous_database_id)
        pulumi.set(__self__, "retention_period_in_days", retention_period_in_days)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> pulumi.Input[_builtins.str]:
        """
        The azureId of the Autonomous Database that this backup is for. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "autonomous_database_id")

    @autonomous_database_id.setter
    def autonomous_database_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "autonomous_database_id", value)

    @_builtins.property
    @pulumi.getter(name="retentionPeriodInDays")
    def retention_period_in_days(self) -> pulumi.Input[_builtins.int]:
        """
        (Updatable) The number of days to retain the backup. Must be between 90 and 3650 days.
        """
        return pulumi.get(self, "retention_period_in_days")

    @retention_period_in_days.setter
    def retention_period_in_days(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "retention_period_in_days", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the Autonomous Database Backup. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of backup to create.Currently, only `LongTerm` backup operations are supported through the Oracle database At azure service.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _AutonomousDatabaseBackupState:
    def __init__(__self__, *,
                 autonomous_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AutonomousDatabaseBackup resources.
        :param pulumi.Input[_builtins.str] autonomous_database_id: The azureId of the Autonomous Database that this backup is for. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The display name of the Autonomous Database Backup. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] retention_period_in_days: (Updatable) The number of days to retain the backup. Must be between 90 and 3650 days.
        :param pulumi.Input[_builtins.str] type: The type of backup to create.Currently, only `LongTerm` backup operations are supported through the Oracle database At azure service.
        """
        if autonomous_database_id is not None:
            pulumi.set(__self__, "autonomous_database_id", autonomous_database_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if retention_period_in_days is not None:
            pulumi.set(__self__, "retention_period_in_days", retention_period_in_days)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The azureId of the Autonomous Database that this backup is for. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "autonomous_database_id")

    @autonomous_database_id.setter
    def autonomous_database_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "autonomous_database_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the Autonomous Database Backup. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="retentionPeriodInDays")
    def retention_period_in_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (Updatable) The number of days to retain the backup. Must be between 90 and 3650 days.
        """
        return pulumi.get(self, "retention_period_in_days")

    @retention_period_in_days.setter
    def retention_period_in_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_period_in_days", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of backup to create.Currently, only `LongTerm` backup operations are supported through the Oracle database At azure service.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("azure:oracle/autonomousDatabaseBackup:AutonomousDatabaseBackup")
class AutonomousDatabaseBackup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autonomous_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Oracle Autonomous Database Backup in Azure.

        ## Import

        Autonomous Database Backups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import azure:oracle/autonomousDatabaseBackup:AutonomousDatabaseBackup example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup/providers/Oracle.Database/autonomousDatabases/autonomousDatabase1/autonomousDatabaseBackups/autonomousDatabaseBackup1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] autonomous_database_id: The azureId of the Autonomous Database that this backup is for. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The display name of the Autonomous Database Backup. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] retention_period_in_days: (Updatable) The number of days to retain the backup. Must be between 90 and 3650 days.
        :param pulumi.Input[_builtins.str] type: The type of backup to create.Currently, only `LongTerm` backup operations are supported through the Oracle database At azure service.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AutonomousDatabaseBackupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Oracle Autonomous Database Backup in Azure.

        ## Import

        Autonomous Database Backups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import azure:oracle/autonomousDatabaseBackup:AutonomousDatabaseBackup example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup/providers/Oracle.Database/autonomousDatabases/autonomousDatabase1/autonomousDatabaseBackups/autonomousDatabaseBackup1
        ```

        :param str resource_name: The name of the resource.
        :param AutonomousDatabaseBackupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AutonomousDatabaseBackupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autonomous_database_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period_in_days: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AutonomousDatabaseBackupArgs.__new__(AutonomousDatabaseBackupArgs)

            if autonomous_database_id is None and not opts.urn:
                raise TypeError("Missing required property 'autonomous_database_id'")
            __props__.__dict__["autonomous_database_id"] = autonomous_database_id
            __props__.__dict__["name"] = name
            if retention_period_in_days is None and not opts.urn:
                raise TypeError("Missing required property 'retention_period_in_days'")
            __props__.__dict__["retention_period_in_days"] = retention_period_in_days
            __props__.__dict__["type"] = type
        super(AutonomousDatabaseBackup, __self__).__init__(
            'azure:oracle/autonomousDatabaseBackup:AutonomousDatabaseBackup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autonomous_database_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            retention_period_in_days: Optional[pulumi.Input[_builtins.int]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'AutonomousDatabaseBackup':
        """
        Get an existing AutonomousDatabaseBackup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] autonomous_database_id: The azureId of the Autonomous Database that this backup is for. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The display name of the Autonomous Database Backup. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] retention_period_in_days: (Updatable) The number of days to retain the backup. Must be between 90 and 3650 days.
        :param pulumi.Input[_builtins.str] type: The type of backup to create.Currently, only `LongTerm` backup operations are supported through the Oracle database At azure service.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AutonomousDatabaseBackupState.__new__(_AutonomousDatabaseBackupState)

        __props__.__dict__["autonomous_database_id"] = autonomous_database_id
        __props__.__dict__["name"] = name
        __props__.__dict__["retention_period_in_days"] = retention_period_in_days
        __props__.__dict__["type"] = type
        return AutonomousDatabaseBackup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autonomousDatabaseId")
    def autonomous_database_id(self) -> pulumi.Output[_builtins.str]:
        """
        The azureId of the Autonomous Database that this backup is for. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "autonomous_database_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The display name of the Autonomous Database Backup. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="retentionPeriodInDays")
    def retention_period_in_days(self) -> pulumi.Output[_builtins.int]:
        """
        (Updatable) The number of days to retain the backup. Must be between 90 and 3650 days.
        """
        return pulumi.get(self, "retention_period_in_days")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of backup to create.Currently, only `LongTerm` backup operations are supported through the Oracle database At azure service.
        """
        return pulumi.get(self, "type")

