# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDbServersResult',
    'AwaitableGetDbServersResult',
    'get_db_servers',
    'get_db_servers_output',
]

@pulumi.output_type
class GetDbServersResult:
    """
    A collection of values returned by getDbServers.
    """
    def __init__(__self__, cloud_exadata_infrastructure_name=None, db_servers=None, id=None, resource_group_name=None):
        if cloud_exadata_infrastructure_name and not isinstance(cloud_exadata_infrastructure_name, str):
            raise TypeError("Expected argument 'cloud_exadata_infrastructure_name' to be a str")
        pulumi.set(__self__, "cloud_exadata_infrastructure_name", cloud_exadata_infrastructure_name)
        if db_servers and not isinstance(db_servers, list):
            raise TypeError("Expected argument 'db_servers' to be a list")
        pulumi.set(__self__, "db_servers", db_servers)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)

    @_builtins.property
    @pulumi.getter(name="cloudExadataInfrastructureName")
    def cloud_exadata_infrastructure_name(self) -> _builtins.str:
        return pulumi.get(self, "cloud_exadata_infrastructure_name")

    @_builtins.property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> Sequence['outputs.GetDbServersDbServerResult']:
        """
        A `db_servers` block as defined below.
        """
        return pulumi.get(self, "db_servers")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")


class AwaitableGetDbServersResult(GetDbServersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDbServersResult(
            cloud_exadata_infrastructure_name=self.cloud_exadata_infrastructure_name,
            db_servers=self.db_servers,
            id=self.id,
            resource_group_name=self.resource_group_name)


def get_db_servers(cloud_exadata_infrastructure_name: Optional[_builtins.str] = None,
                   resource_group_name: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDbServersResult:
    """
    Use this data source to access information about existing DB Servers.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.oracle.get_db_servers(resource_group_name="existing",
        cloud_exadata_infrastructure_name="existing")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Oracle.Database` - 2025-03-01


    :param _builtins.str cloud_exadata_infrastructure_name: The name of the Cloud Exadata Infrastructure.
    :param _builtins.str resource_group_name: The name of the Resource Group where the DB Server exists.
    """
    __args__ = dict()
    __args__['cloudExadataInfrastructureName'] = cloud_exadata_infrastructure_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:oracle/getDbServers:getDbServers', __args__, opts=opts, typ=GetDbServersResult).value

    return AwaitableGetDbServersResult(
        cloud_exadata_infrastructure_name=pulumi.get(__ret__, 'cloud_exadata_infrastructure_name'),
        db_servers=pulumi.get(__ret__, 'db_servers'),
        id=pulumi.get(__ret__, 'id'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'))
def get_db_servers_output(cloud_exadata_infrastructure_name: Optional[pulumi.Input[_builtins.str]] = None,
                          resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDbServersResult]:
    """
    Use this data source to access information about existing DB Servers.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.oracle.get_db_servers(resource_group_name="existing",
        cloud_exadata_infrastructure_name="existing")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Oracle.Database` - 2025-03-01


    :param _builtins.str cloud_exadata_infrastructure_name: The name of the Cloud Exadata Infrastructure.
    :param _builtins.str resource_group_name: The name of the Resource Group where the DB Server exists.
    """
    __args__ = dict()
    __args__['cloudExadataInfrastructureName'] = cloud_exadata_infrastructure_name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:oracle/getDbServers:getDbServers', __args__, opts=opts, typ=GetDbServersResult)
    return __ret__.apply(lambda __response__: GetDbServersResult(
        cloud_exadata_infrastructure_name=pulumi.get(__response__, 'cloud_exadata_infrastructure_name'),
        db_servers=pulumi.get(__response__, 'db_servers'),
        id=pulumi.get(__response__, 'id'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name')))
