# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LinkServiceArgs', 'LinkService']

@pulumi.input_type
class LinkServiceArgs:
    def __init__(__self__, *,
                 nat_ip_configurations: pulumi.Input[Sequence[pulumi.Input['LinkServiceNatIpConfigurationArgs']]],
                 resource_group_name: pulumi.Input[_builtins.str],
                 auto_approval_subscription_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 destination_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_proxy_protocol: Optional[pulumi.Input[_builtins.bool]] = None,
                 fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 load_balancer_frontend_ip_configuration_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 visibility_subscription_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a LinkService resource.
        :param pulumi.Input[Sequence[pulumi.Input['LinkServiceNatIpConfigurationArgs']]] nat_ip_configurations: One or more (up to 8) `nat_ip_configuration` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Private Link Service should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] auto_approval_subscription_ids: A list of Subscription UUID/GUID's that will be automatically be able to use this Private Link Service.
        :param pulumi.Input[_builtins.str] destination_ip_address: The destination IP address of the Private Link Service.
        :param pulumi.Input[_builtins.bool] enable_proxy_protocol: Should the Private Link Service support the Proxy Protocol?
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fqdns: List of FQDNs allowed for the Private Link Service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] load_balancer_frontend_ip_configuration_ids: A list of Frontend IP Configuration IDs from a Standard Load Balancer, where traffic from the Private Link Service should be routed. You can use Load Balancer Rules to direct this traffic to appropriate backend pools where your applications are running. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Private Link Service. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] visibility_subscription_ids: A list of Subscription UUID/GUID's that will be able to see this Private Link Service.
               
               > **Note:** If no Subscription IDs are specified then Azure allows every Subscription to see this Private Link Service.
        """
        pulumi.set(__self__, "nat_ip_configurations", nat_ip_configurations)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if auto_approval_subscription_ids is not None:
            pulumi.set(__self__, "auto_approval_subscription_ids", auto_approval_subscription_ids)
        if destination_ip_address is not None:
            pulumi.set(__self__, "destination_ip_address", destination_ip_address)
        if enable_proxy_protocol is not None:
            pulumi.set(__self__, "enable_proxy_protocol", enable_proxy_protocol)
        if fqdns is not None:
            pulumi.set(__self__, "fqdns", fqdns)
        if load_balancer_frontend_ip_configuration_ids is not None:
            pulumi.set(__self__, "load_balancer_frontend_ip_configuration_ids", load_balancer_frontend_ip_configuration_ids)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if visibility_subscription_ids is not None:
            pulumi.set(__self__, "visibility_subscription_ids", visibility_subscription_ids)

    @_builtins.property
    @pulumi.getter(name="natIpConfigurations")
    def nat_ip_configurations(self) -> pulumi.Input[Sequence[pulumi.Input['LinkServiceNatIpConfigurationArgs']]]:
        """
        One or more (up to 8) `nat_ip_configuration` block as defined below.
        """
        return pulumi.get(self, "nat_ip_configurations")

    @nat_ip_configurations.setter
    def nat_ip_configurations(self, value: pulumi.Input[Sequence[pulumi.Input['LinkServiceNatIpConfigurationArgs']]]):
        pulumi.set(self, "nat_ip_configurations", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Private Link Service should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="autoApprovalSubscriptionIds")
    def auto_approval_subscription_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of Subscription UUID/GUID's that will be automatically be able to use this Private Link Service.
        """
        return pulumi.get(self, "auto_approval_subscription_ids")

    @auto_approval_subscription_ids.setter
    def auto_approval_subscription_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "auto_approval_subscription_ids", value)

    @_builtins.property
    @pulumi.getter(name="destinationIpAddress")
    def destination_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination IP address of the Private Link Service.
        """
        return pulumi.get(self, "destination_ip_address")

    @destination_ip_address.setter
    def destination_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="enableProxyProtocol")
    def enable_proxy_protocol(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Private Link Service support the Proxy Protocol?
        """
        return pulumi.get(self, "enable_proxy_protocol")

    @enable_proxy_protocol.setter
    def enable_proxy_protocol(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_proxy_protocol", value)

    @_builtins.property
    @pulumi.getter
    def fqdns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of FQDNs allowed for the Private Link Service.
        """
        return pulumi.get(self, "fqdns")

    @fqdns.setter
    def fqdns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "fqdns", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerFrontendIpConfigurationIds")
    def load_balancer_frontend_ip_configuration_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of Frontend IP Configuration IDs from a Standard Load Balancer, where traffic from the Private Link Service should be routed. You can use Load Balancer Rules to direct this traffic to appropriate backend pools where your applications are running. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "load_balancer_frontend_ip_configuration_ids")

    @load_balancer_frontend_ip_configuration_ids.setter
    def load_balancer_frontend_ip_configuration_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "load_balancer_frontend_ip_configuration_ids", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Private Link Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="visibilitySubscriptionIds")
    def visibility_subscription_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of Subscription UUID/GUID's that will be able to see this Private Link Service.

        > **Note:** If no Subscription IDs are specified then Azure allows every Subscription to see this Private Link Service.
        """
        return pulumi.get(self, "visibility_subscription_ids")

    @visibility_subscription_ids.setter
    def visibility_subscription_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "visibility_subscription_ids", value)


@pulumi.input_type
class _LinkServiceState:
    def __init__(__self__, *,
                 alias: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_approval_subscription_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 destination_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_proxy_protocol: Optional[pulumi.Input[_builtins.bool]] = None,
                 fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 load_balancer_frontend_ip_configuration_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['LinkServiceNatIpConfigurationArgs']]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 visibility_subscription_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering LinkService resources.
        :param pulumi.Input[_builtins.str] alias: A globally unique DNS Name for your Private Link Service. You can use this alias to request a connection to your Private Link Service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] auto_approval_subscription_ids: A list of Subscription UUID/GUID's that will be automatically be able to use this Private Link Service.
        :param pulumi.Input[_builtins.str] destination_ip_address: The destination IP address of the Private Link Service.
        :param pulumi.Input[_builtins.bool] enable_proxy_protocol: Should the Private Link Service support the Proxy Protocol?
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fqdns: List of FQDNs allowed for the Private Link Service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] load_balancer_frontend_ip_configuration_ids: A list of Frontend IP Configuration IDs from a Standard Load Balancer, where traffic from the Private Link Service should be routed. You can use Load Balancer Rules to direct this traffic to appropriate backend pools where your applications are running. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Private Link Service. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['LinkServiceNatIpConfigurationArgs']]] nat_ip_configurations: One or more (up to 8) `nat_ip_configuration` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Private Link Service should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] visibility_subscription_ids: A list of Subscription UUID/GUID's that will be able to see this Private Link Service.
               
               > **Note:** If no Subscription IDs are specified then Azure allows every Subscription to see this Private Link Service.
        """
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if auto_approval_subscription_ids is not None:
            pulumi.set(__self__, "auto_approval_subscription_ids", auto_approval_subscription_ids)
        if destination_ip_address is not None:
            pulumi.set(__self__, "destination_ip_address", destination_ip_address)
        if enable_proxy_protocol is not None:
            pulumi.set(__self__, "enable_proxy_protocol", enable_proxy_protocol)
        if fqdns is not None:
            pulumi.set(__self__, "fqdns", fqdns)
        if load_balancer_frontend_ip_configuration_ids is not None:
            pulumi.set(__self__, "load_balancer_frontend_ip_configuration_ids", load_balancer_frontend_ip_configuration_ids)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat_ip_configurations is not None:
            pulumi.set(__self__, "nat_ip_configurations", nat_ip_configurations)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if visibility_subscription_ids is not None:
            pulumi.set(__self__, "visibility_subscription_ids", visibility_subscription_ids)

    @_builtins.property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A globally unique DNS Name for your Private Link Service. You can use this alias to request a connection to your Private Link Service.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "alias", value)

    @_builtins.property
    @pulumi.getter(name="autoApprovalSubscriptionIds")
    def auto_approval_subscription_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of Subscription UUID/GUID's that will be automatically be able to use this Private Link Service.
        """
        return pulumi.get(self, "auto_approval_subscription_ids")

    @auto_approval_subscription_ids.setter
    def auto_approval_subscription_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "auto_approval_subscription_ids", value)

    @_builtins.property
    @pulumi.getter(name="destinationIpAddress")
    def destination_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination IP address of the Private Link Service.
        """
        return pulumi.get(self, "destination_ip_address")

    @destination_ip_address.setter
    def destination_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="enableProxyProtocol")
    def enable_proxy_protocol(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Private Link Service support the Proxy Protocol?
        """
        return pulumi.get(self, "enable_proxy_protocol")

    @enable_proxy_protocol.setter
    def enable_proxy_protocol(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_proxy_protocol", value)

    @_builtins.property
    @pulumi.getter
    def fqdns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of FQDNs allowed for the Private Link Service.
        """
        return pulumi.get(self, "fqdns")

    @fqdns.setter
    def fqdns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "fqdns", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerFrontendIpConfigurationIds")
    def load_balancer_frontend_ip_configuration_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of Frontend IP Configuration IDs from a Standard Load Balancer, where traffic from the Private Link Service should be routed. You can use Load Balancer Rules to direct this traffic to appropriate backend pools where your applications are running. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "load_balancer_frontend_ip_configuration_ids")

    @load_balancer_frontend_ip_configuration_ids.setter
    def load_balancer_frontend_ip_configuration_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "load_balancer_frontend_ip_configuration_ids", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Private Link Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="natIpConfigurations")
    def nat_ip_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LinkServiceNatIpConfigurationArgs']]]]:
        """
        One or more (up to 8) `nat_ip_configuration` block as defined below.
        """
        return pulumi.get(self, "nat_ip_configurations")

    @nat_ip_configurations.setter
    def nat_ip_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LinkServiceNatIpConfigurationArgs']]]]):
        pulumi.set(self, "nat_ip_configurations", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Private Link Service should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="visibilitySubscriptionIds")
    def visibility_subscription_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of Subscription UUID/GUID's that will be able to see this Private Link Service.

        > **Note:** If no Subscription IDs are specified then Azure allows every Subscription to see this Private Link Service.
        """
        return pulumi.get(self, "visibility_subscription_ids")

    @visibility_subscription_ids.setter
    def visibility_subscription_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "visibility_subscription_ids", value)


@pulumi.type_token("azure:privatedns/linkService:LinkService")
class LinkService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_approval_subscription_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 destination_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_proxy_protocol: Optional[pulumi.Input[_builtins.bool]] = None,
                 fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 load_balancer_frontend_ip_configuration_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinkServiceNatIpConfigurationArgs', 'LinkServiceNatIpConfigurationArgsDict']]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 visibility_subscription_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Private Link Service.

        > **Note:** Private Link is now in [GA](https://docs.microsoft.com/en-gb/azure/private-link/).

        ## Import

        Private Link Services can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:privatedns/linkService:LinkService example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/privateLinkServices/service1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] auto_approval_subscription_ids: A list of Subscription UUID/GUID's that will be automatically be able to use this Private Link Service.
        :param pulumi.Input[_builtins.str] destination_ip_address: The destination IP address of the Private Link Service.
        :param pulumi.Input[_builtins.bool] enable_proxy_protocol: Should the Private Link Service support the Proxy Protocol?
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fqdns: List of FQDNs allowed for the Private Link Service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] load_balancer_frontend_ip_configuration_ids: A list of Frontend IP Configuration IDs from a Standard Load Balancer, where traffic from the Private Link Service should be routed. You can use Load Balancer Rules to direct this traffic to appropriate backend pools where your applications are running. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Private Link Service. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LinkServiceNatIpConfigurationArgs', 'LinkServiceNatIpConfigurationArgsDict']]]] nat_ip_configurations: One or more (up to 8) `nat_ip_configuration` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Private Link Service should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] visibility_subscription_ids: A list of Subscription UUID/GUID's that will be able to see this Private Link Service.
               
               > **Note:** If no Subscription IDs are specified then Azure allows every Subscription to see this Private Link Service.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LinkServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Private Link Service.

        > **Note:** Private Link is now in [GA](https://docs.microsoft.com/en-gb/azure/private-link/).

        ## Import

        Private Link Services can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:privatedns/linkService:LinkService example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/privateLinkServices/service1
        ```

        :param str resource_name: The name of the resource.
        :param LinkServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LinkServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_approval_subscription_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 destination_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_proxy_protocol: Optional[pulumi.Input[_builtins.bool]] = None,
                 fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 load_balancer_frontend_ip_configuration_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinkServiceNatIpConfigurationArgs', 'LinkServiceNatIpConfigurationArgsDict']]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 visibility_subscription_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LinkServiceArgs.__new__(LinkServiceArgs)

            __props__.__dict__["auto_approval_subscription_ids"] = auto_approval_subscription_ids
            __props__.__dict__["destination_ip_address"] = destination_ip_address
            __props__.__dict__["enable_proxy_protocol"] = enable_proxy_protocol
            __props__.__dict__["fqdns"] = fqdns
            __props__.__dict__["load_balancer_frontend_ip_configuration_ids"] = load_balancer_frontend_ip_configuration_ids
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if nat_ip_configurations is None and not opts.urn:
                raise TypeError("Missing required property 'nat_ip_configurations'")
            __props__.__dict__["nat_ip_configurations"] = nat_ip_configurations
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["visibility_subscription_ids"] = visibility_subscription_ids
            __props__.__dict__["alias"] = None
        super(LinkService, __self__).__init__(
            'azure:privatedns/linkService:LinkService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alias: Optional[pulumi.Input[_builtins.str]] = None,
            auto_approval_subscription_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            destination_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            enable_proxy_protocol: Optional[pulumi.Input[_builtins.bool]] = None,
            fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            load_balancer_frontend_ip_configuration_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nat_ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LinkServiceNatIpConfigurationArgs', 'LinkServiceNatIpConfigurationArgsDict']]]]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            visibility_subscription_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'LinkService':
        """
        Get an existing LinkService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] alias: A globally unique DNS Name for your Private Link Service. You can use this alias to request a connection to your Private Link Service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] auto_approval_subscription_ids: A list of Subscription UUID/GUID's that will be automatically be able to use this Private Link Service.
        :param pulumi.Input[_builtins.str] destination_ip_address: The destination IP address of the Private Link Service.
        :param pulumi.Input[_builtins.bool] enable_proxy_protocol: Should the Private Link Service support the Proxy Protocol?
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fqdns: List of FQDNs allowed for the Private Link Service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] load_balancer_frontend_ip_configuration_ids: A list of Frontend IP Configuration IDs from a Standard Load Balancer, where traffic from the Private Link Service should be routed. You can use Load Balancer Rules to direct this traffic to appropriate backend pools where your applications are running. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Private Link Service. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LinkServiceNatIpConfigurationArgs', 'LinkServiceNatIpConfigurationArgsDict']]]] nat_ip_configurations: One or more (up to 8) `nat_ip_configuration` block as defined below.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Private Link Service should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] visibility_subscription_ids: A list of Subscription UUID/GUID's that will be able to see this Private Link Service.
               
               > **Note:** If no Subscription IDs are specified then Azure allows every Subscription to see this Private Link Service.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LinkServiceState.__new__(_LinkServiceState)

        __props__.__dict__["alias"] = alias
        __props__.__dict__["auto_approval_subscription_ids"] = auto_approval_subscription_ids
        __props__.__dict__["destination_ip_address"] = destination_ip_address
        __props__.__dict__["enable_proxy_protocol"] = enable_proxy_protocol
        __props__.__dict__["fqdns"] = fqdns
        __props__.__dict__["load_balancer_frontend_ip_configuration_ids"] = load_balancer_frontend_ip_configuration_ids
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["nat_ip_configurations"] = nat_ip_configurations
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["visibility_subscription_ids"] = visibility_subscription_ids
        return LinkService(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def alias(self) -> pulumi.Output[_builtins.str]:
        """
        A globally unique DNS Name for your Private Link Service. You can use this alias to request a connection to your Private Link Service.
        """
        return pulumi.get(self, "alias")

    @_builtins.property
    @pulumi.getter(name="autoApprovalSubscriptionIds")
    def auto_approval_subscription_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of Subscription UUID/GUID's that will be automatically be able to use this Private Link Service.
        """
        return pulumi.get(self, "auto_approval_subscription_ids")

    @_builtins.property
    @pulumi.getter(name="destinationIpAddress")
    def destination_ip_address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The destination IP address of the Private Link Service.
        """
        return pulumi.get(self, "destination_ip_address")

    @_builtins.property
    @pulumi.getter(name="enableProxyProtocol")
    def enable_proxy_protocol(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the Private Link Service support the Proxy Protocol?
        """
        return pulumi.get(self, "enable_proxy_protocol")

    @_builtins.property
    @pulumi.getter
    def fqdns(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of FQDNs allowed for the Private Link Service.
        """
        return pulumi.get(self, "fqdns")

    @_builtins.property
    @pulumi.getter(name="loadBalancerFrontendIpConfigurationIds")
    def load_balancer_frontend_ip_configuration_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of Frontend IP Configuration IDs from a Standard Load Balancer, where traffic from the Private Link Service should be routed. You can use Load Balancer Rules to direct this traffic to appropriate backend pools where your applications are running. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "load_balancer_frontend_ip_configuration_ids")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of this Private Link Service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="natIpConfigurations")
    def nat_ip_configurations(self) -> pulumi.Output[Sequence['outputs.LinkServiceNatIpConfiguration']]:
        """
        One or more (up to 8) `nat_ip_configuration` block as defined below.
        """
        return pulumi.get(self, "nat_ip_configurations")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Private Link Service should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="visibilitySubscriptionIds")
    def visibility_subscription_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of Subscription UUID/GUID's that will be able to see this Private Link Service.

        > **Note:** If no Subscription IDs are specified then Azure allows every Subscription to see this Private Link Service.
        """
        return pulumi.get(self, "visibility_subscription_ids")

