# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ZoneArgs', 'Zone']

@pulumi.input_type
class ZoneArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 soa_record: Optional[pulumi.Input['ZoneSoaRecordArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Zone resource.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the resource group where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Private DNS Zone. Must be a valid domain name. Changing this forces a new resource to be created.
               
               > **Note:** If you are going to be using the Private DNS Zone with a Private Endpoint the name of the Private DNS Zone must follow the **Private DNS Zone name** schema in the [product documentation](https://docs.microsoft.com/azure/private-link/private-endpoint-dns#virtual-network-and-on-premises-workloads-using-a-dns-forwarder) in order for the two resources to be connected successfully.
        :param pulumi.Input['ZoneSoaRecordArgs'] soa_record: An `soa_record` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if soa_record is not None:
            pulumi.set(__self__, "soa_record", soa_record)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the resource group where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Private DNS Zone. Must be a valid domain name. Changing this forces a new resource to be created.

        > **Note:** If you are going to be using the Private DNS Zone with a Private Endpoint the name of the Private DNS Zone must follow the **Private DNS Zone name** schema in the [product documentation](https://docs.microsoft.com/azure/private-link/private-endpoint-dns#virtual-network-and-on-premises-workloads-using-a-dns-forwarder) in order for the two resources to be connected successfully.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="soaRecord")
    def soa_record(self) -> Optional[pulumi.Input['ZoneSoaRecordArgs']]:
        """
        An `soa_record` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "soa_record")

    @soa_record.setter
    def soa_record(self, value: Optional[pulumi.Input['ZoneSoaRecordArgs']]):
        pulumi.set(self, "soa_record", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ZoneState:
    def __init__(__self__, *,
                 max_number_of_record_sets: Optional[pulumi.Input[_builtins.int]] = None,
                 max_number_of_virtual_network_links: Optional[pulumi.Input[_builtins.int]] = None,
                 max_number_of_virtual_network_links_with_registration: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_record_sets: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 soa_record: Optional[pulumi.Input['ZoneSoaRecordArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Zone resources.
        :param pulumi.Input[_builtins.int] max_number_of_record_sets: The maximum number of record sets that can be created in this Private DNS zone.
        :param pulumi.Input[_builtins.int] max_number_of_virtual_network_links: The maximum number of virtual networks that can be linked to this Private DNS zone.
        :param pulumi.Input[_builtins.int] max_number_of_virtual_network_links_with_registration: The maximum number of virtual networks that can be linked to this Private DNS zone with registration enabled.
        :param pulumi.Input[_builtins.str] name: The name of the Private DNS Zone. Must be a valid domain name. Changing this forces a new resource to be created.
               
               > **Note:** If you are going to be using the Private DNS Zone with a Private Endpoint the name of the Private DNS Zone must follow the **Private DNS Zone name** schema in the [product documentation](https://docs.microsoft.com/azure/private-link/private-endpoint-dns#virtual-network-and-on-premises-workloads-using-a-dns-forwarder) in order for the two resources to be connected successfully.
        :param pulumi.Input[_builtins.int] number_of_record_sets: The current number of record sets in this Private DNS zone.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the resource group where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input['ZoneSoaRecordArgs'] soa_record: An `soa_record` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if max_number_of_record_sets is not None:
            pulumi.set(__self__, "max_number_of_record_sets", max_number_of_record_sets)
        if max_number_of_virtual_network_links is not None:
            pulumi.set(__self__, "max_number_of_virtual_network_links", max_number_of_virtual_network_links)
        if max_number_of_virtual_network_links_with_registration is not None:
            pulumi.set(__self__, "max_number_of_virtual_network_links_with_registration", max_number_of_virtual_network_links_with_registration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_record_sets is not None:
            pulumi.set(__self__, "number_of_record_sets", number_of_record_sets)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if soa_record is not None:
            pulumi.set(__self__, "soa_record", soa_record)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="maxNumberOfRecordSets")
    def max_number_of_record_sets(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of record sets that can be created in this Private DNS zone.
        """
        return pulumi.get(self, "max_number_of_record_sets")

    @max_number_of_record_sets.setter
    def max_number_of_record_sets(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_number_of_record_sets", value)

    @_builtins.property
    @pulumi.getter(name="maxNumberOfVirtualNetworkLinks")
    def max_number_of_virtual_network_links(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of virtual networks that can be linked to this Private DNS zone.
        """
        return pulumi.get(self, "max_number_of_virtual_network_links")

    @max_number_of_virtual_network_links.setter
    def max_number_of_virtual_network_links(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_number_of_virtual_network_links", value)

    @_builtins.property
    @pulumi.getter(name="maxNumberOfVirtualNetworkLinksWithRegistration")
    def max_number_of_virtual_network_links_with_registration(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of virtual networks that can be linked to this Private DNS zone with registration enabled.
        """
        return pulumi.get(self, "max_number_of_virtual_network_links_with_registration")

    @max_number_of_virtual_network_links_with_registration.setter
    def max_number_of_virtual_network_links_with_registration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_number_of_virtual_network_links_with_registration", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Private DNS Zone. Must be a valid domain name. Changing this forces a new resource to be created.

        > **Note:** If you are going to be using the Private DNS Zone with a Private Endpoint the name of the Private DNS Zone must follow the **Private DNS Zone name** schema in the [product documentation](https://docs.microsoft.com/azure/private-link/private-endpoint-dns#virtual-network-and-on-premises-workloads-using-a-dns-forwarder) in order for the two resources to be connected successfully.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="numberOfRecordSets")
    def number_of_record_sets(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The current number of record sets in this Private DNS zone.
        """
        return pulumi.get(self, "number_of_record_sets")

    @number_of_record_sets.setter
    def number_of_record_sets(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "number_of_record_sets", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the resource group where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="soaRecord")
    def soa_record(self) -> Optional[pulumi.Input['ZoneSoaRecordArgs']]:
        """
        An `soa_record` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "soa_record")

    @soa_record.setter
    def soa_record(self, value: Optional[pulumi.Input['ZoneSoaRecordArgs']]):
        pulumi.set(self, "soa_record", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:privatedns/zone:Zone")
class Zone(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 soa_record: Optional[pulumi.Input[Union['ZoneSoaRecordArgs', 'ZoneSoaRecordArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Enables you to manage Private DNS zones within Azure DNS. These zones are hosted on Azure's name servers.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_zone = azure.privatedns.Zone("example",
            name="mydomain.com",
            resource_group_name=example.name)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2024-06-01

        ## Import

        Private DNS Zones can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:privatedns/zone:Zone zone1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/privateDnsZones/zone1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name of the Private DNS Zone. Must be a valid domain name. Changing this forces a new resource to be created.
               
               > **Note:** If you are going to be using the Private DNS Zone with a Private Endpoint the name of the Private DNS Zone must follow the **Private DNS Zone name** schema in the [product documentation](https://docs.microsoft.com/azure/private-link/private-endpoint-dns#virtual-network-and-on-premises-workloads-using-a-dns-forwarder) in order for the two resources to be connected successfully.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the resource group where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ZoneSoaRecordArgs', 'ZoneSoaRecordArgsDict']] soa_record: An `soa_record` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZoneArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Enables you to manage Private DNS zones within Azure DNS. These zones are hosted on Azure's name servers.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_zone = azure.privatedns.Zone("example",
            name="mydomain.com",
            resource_group_name=example.name)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2024-06-01

        ## Import

        Private DNS Zones can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:privatedns/zone:Zone zone1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/privateDnsZones/zone1
        ```

        :param str resource_name: The name of the resource.
        :param ZoneArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZoneArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 soa_record: Optional[pulumi.Input[Union['ZoneSoaRecordArgs', 'ZoneSoaRecordArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZoneArgs.__new__(ZoneArgs)

            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["soa_record"] = soa_record
            __props__.__dict__["tags"] = tags
            __props__.__dict__["max_number_of_record_sets"] = None
            __props__.__dict__["max_number_of_virtual_network_links"] = None
            __props__.__dict__["max_number_of_virtual_network_links_with_registration"] = None
            __props__.__dict__["number_of_record_sets"] = None
        super(Zone, __self__).__init__(
            'azure:privatedns/zone:Zone',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            max_number_of_record_sets: Optional[pulumi.Input[_builtins.int]] = None,
            max_number_of_virtual_network_links: Optional[pulumi.Input[_builtins.int]] = None,
            max_number_of_virtual_network_links_with_registration: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            number_of_record_sets: Optional[pulumi.Input[_builtins.int]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            soa_record: Optional[pulumi.Input[Union['ZoneSoaRecordArgs', 'ZoneSoaRecordArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Zone':
        """
        Get an existing Zone resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] max_number_of_record_sets: The maximum number of record sets that can be created in this Private DNS zone.
        :param pulumi.Input[_builtins.int] max_number_of_virtual_network_links: The maximum number of virtual networks that can be linked to this Private DNS zone.
        :param pulumi.Input[_builtins.int] max_number_of_virtual_network_links_with_registration: The maximum number of virtual networks that can be linked to this Private DNS zone with registration enabled.
        :param pulumi.Input[_builtins.str] name: The name of the Private DNS Zone. Must be a valid domain name. Changing this forces a new resource to be created.
               
               > **Note:** If you are going to be using the Private DNS Zone with a Private Endpoint the name of the Private DNS Zone must follow the **Private DNS Zone name** schema in the [product documentation](https://docs.microsoft.com/azure/private-link/private-endpoint-dns#virtual-network-and-on-premises-workloads-using-a-dns-forwarder) in order for the two resources to be connected successfully.
        :param pulumi.Input[_builtins.int] number_of_record_sets: The current number of record sets in this Private DNS zone.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the resource group where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ZoneSoaRecordArgs', 'ZoneSoaRecordArgsDict']] soa_record: An `soa_record` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZoneState.__new__(_ZoneState)

        __props__.__dict__["max_number_of_record_sets"] = max_number_of_record_sets
        __props__.__dict__["max_number_of_virtual_network_links"] = max_number_of_virtual_network_links
        __props__.__dict__["max_number_of_virtual_network_links_with_registration"] = max_number_of_virtual_network_links_with_registration
        __props__.__dict__["name"] = name
        __props__.__dict__["number_of_record_sets"] = number_of_record_sets
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["soa_record"] = soa_record
        __props__.__dict__["tags"] = tags
        return Zone(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="maxNumberOfRecordSets")
    def max_number_of_record_sets(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum number of record sets that can be created in this Private DNS zone.
        """
        return pulumi.get(self, "max_number_of_record_sets")

    @_builtins.property
    @pulumi.getter(name="maxNumberOfVirtualNetworkLinks")
    def max_number_of_virtual_network_links(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum number of virtual networks that can be linked to this Private DNS zone.
        """
        return pulumi.get(self, "max_number_of_virtual_network_links")

    @_builtins.property
    @pulumi.getter(name="maxNumberOfVirtualNetworkLinksWithRegistration")
    def max_number_of_virtual_network_links_with_registration(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum number of virtual networks that can be linked to this Private DNS zone with registration enabled.
        """
        return pulumi.get(self, "max_number_of_virtual_network_links_with_registration")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Private DNS Zone. Must be a valid domain name. Changing this forces a new resource to be created.

        > **Note:** If you are going to be using the Private DNS Zone with a Private Endpoint the name of the Private DNS Zone must follow the **Private DNS Zone name** schema in the [product documentation](https://docs.microsoft.com/azure/private-link/private-endpoint-dns#virtual-network-and-on-premises-workloads-using-a-dns-forwarder) in order for the two resources to be connected successfully.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="numberOfRecordSets")
    def number_of_record_sets(self) -> pulumi.Output[_builtins.int]:
        """
        The current number of record sets in this Private DNS zone.
        """
        return pulumi.get(self, "number_of_record_sets")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the resource group where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="soaRecord")
    def soa_record(self) -> pulumi.Output['outputs.ZoneSoaRecord']:
        """
        An `soa_record` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "soa_record")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

