# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetServiceEndpointConnectionsResult',
    'AwaitableGetServiceEndpointConnectionsResult',
    'get_service_endpoint_connections',
    'get_service_endpoint_connections_output',
]

@pulumi.output_type
class GetServiceEndpointConnectionsResult:
    """
    A collection of values returned by getServiceEndpointConnections.
    """
    def __init__(__self__, id=None, location=None, private_endpoint_connections=None, resource_group_name=None, service_id=None, service_name=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if private_endpoint_connections and not isinstance(private_endpoint_connections, list):
            raise TypeError("Expected argument 'private_endpoint_connections' to be a list")
        pulumi.set(__self__, "private_endpoint_connections", private_endpoint_connections)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if service_id and not isinstance(service_id, str):
            raise TypeError("Expected argument 'service_id' to be a str")
        pulumi.set(__self__, "service_id", service_id)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="privateEndpointConnections")
    def private_endpoint_connections(self) -> Sequence['outputs.GetServiceEndpointConnectionsPrivateEndpointConnectionResult']:
        return pulumi.get(self, "private_endpoint_connections")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> _builtins.str:
        return pulumi.get(self, "service_id")

    @_builtins.property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> _builtins.str:
        """
        The name of the private link service.
        """
        return pulumi.get(self, "service_name")


class AwaitableGetServiceEndpointConnectionsResult(GetServiceEndpointConnectionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceEndpointConnectionsResult(
            id=self.id,
            location=self.location,
            private_endpoint_connections=self.private_endpoint_connections,
            resource_group_name=self.resource_group_name,
            service_id=self.service_id,
            service_name=self.service_name)


def get_service_endpoint_connections(resource_group_name: Optional[_builtins.str] = None,
                                     service_id: Optional[_builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceEndpointConnectionsResult:
    """
    Use this data source to access endpoint connection information about an existing Private Link Service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.privatelink.get_service_endpoint_connections(service_id=example_azurerm_private_link_service["id"],
        resource_group_name=example_azurerm_resource_group["name"])
    pulumi.export("privateEndpointStatus", example.private_endpoint_connections[0].status)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2024-05-01


    :param _builtins.str resource_group_name: The name of the resource group in which the private link service resides.
    :param _builtins.str service_id: The resource ID of the private link service.
    """
    __args__ = dict()
    __args__['resourceGroupName'] = resource_group_name
    __args__['serviceId'] = service_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:privatelink/getServiceEndpointConnections:getServiceEndpointConnections', __args__, opts=opts, typ=GetServiceEndpointConnectionsResult).value

    return AwaitableGetServiceEndpointConnectionsResult(
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        private_endpoint_connections=pulumi.get(__ret__, 'private_endpoint_connections'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        service_id=pulumi.get(__ret__, 'service_id'),
        service_name=pulumi.get(__ret__, 'service_name'))
def get_service_endpoint_connections_output(resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                                            service_id: Optional[pulumi.Input[_builtins.str]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceEndpointConnectionsResult]:
    """
    Use this data source to access endpoint connection information about an existing Private Link Service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.privatelink.get_service_endpoint_connections(service_id=example_azurerm_private_link_service["id"],
        resource_group_name=example_azurerm_resource_group["name"])
    pulumi.export("privateEndpointStatus", example.private_endpoint_connections[0].status)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2024-05-01


    :param _builtins.str resource_group_name: The name of the resource group in which the private link service resides.
    :param _builtins.str service_id: The resource ID of the private link service.
    """
    __args__ = dict()
    __args__['resourceGroupName'] = resource_group_name
    __args__['serviceId'] = service_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:privatelink/getServiceEndpointConnections:getServiceEndpointConnections', __args__, opts=opts, typ=GetServiceEndpointConnectionsResult)
    return __ret__.apply(lambda __response__: GetServiceEndpointConnectionsResult(
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        private_endpoint_connections=pulumi.get(__response__, 'private_endpoint_connections'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        service_id=pulumi.get(__response__, 'service_id'),
        service_name=pulumi.get(__response__, 'service_name')))
