# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VaultArgs', 'Vault']

@pulumi.input_type
class VaultArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku: pulumi.Input[_builtins.str],
                 classic_vmware_replication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cross_region_restore_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption: Optional[pulumi.Input['VaultEncryptionArgs']] = None,
                 identity: Optional[pulumi.Input['VaultIdentityArgs']] = None,
                 immutability: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 monitoring: Optional[pulumi.Input['VaultMonitoringArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 soft_delete_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_mode_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Vault resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Recovery Services Vault. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: Sets the vault's SKU. Possible values include: `Standard`, `RS0`.
        :param pulumi.Input[_builtins.bool] classic_vmware_replication_enabled: Whether to enable the Classic experience for VMware replication. If set to `false` VMware machines will be protected using the new stateless ASR replication appliance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] cross_region_restore_enabled: Is cross region restore enabled for this Vault? Only can be `true`, when `storage_mode_type` is `GeoRedundant`. Defaults to `false`.
               
               > **Note:** Once `cross_region_restore_enabled` is set to `true`, changing it back to `false` forces a new Recovery Service Vault to be created.
        :param pulumi.Input['VaultEncryptionArgs'] encryption: An `encryption` block as defined below. Required with `identity`.
               
               !> **Note:** Once Encryption with your own key has been Enabled it's not possible to Disable it.
        :param pulumi.Input['VaultIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] immutability: Immutability Settings of vault, possible values include: `Locked`, `Unlocked` and `Disabled`.
               
               > **Note:** Once `immutability` is set to `Locked`, changing it to other values forces a new Recovery Services Vault to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input['VaultMonitoringArgs'] monitoring: A `monitoring` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Recovery Services Vault. Recovery Service Vault name must be 2 - 50 characters long, start with a letter, contain only letters, numbers and hyphens. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Is it enabled to access the vault from public networks. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] soft_delete_enabled: Is soft delete enable for this Vault? Defaults to `true`.
        :param pulumi.Input[_builtins.str] storage_mode_type: The storage type of the Recovery Services Vault. Possible values are `GeoRedundant`, `LocallyRedundant` and `ZoneRedundant`. Defaults to `GeoRedundant`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku", sku)
        if classic_vmware_replication_enabled is not None:
            pulumi.set(__self__, "classic_vmware_replication_enabled", classic_vmware_replication_enabled)
        if cross_region_restore_enabled is not None:
            pulumi.set(__self__, "cross_region_restore_enabled", cross_region_restore_enabled)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if immutability is not None:
            pulumi.set(__self__, "immutability", immutability)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if monitoring is not None:
            pulumi.set(__self__, "monitoring", monitoring)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if soft_delete_enabled is not None:
            pulumi.set(__self__, "soft_delete_enabled", soft_delete_enabled)
        if storage_mode_type is not None:
            pulumi.set(__self__, "storage_mode_type", storage_mode_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the Recovery Services Vault. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Input[_builtins.str]:
        """
        Sets the vault's SKU. Possible values include: `Standard`, `RS0`.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="classicVmwareReplicationEnabled")
    def classic_vmware_replication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the Classic experience for VMware replication. If set to `false` VMware machines will be protected using the new stateless ASR replication appliance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "classic_vmware_replication_enabled")

    @classic_vmware_replication_enabled.setter
    def classic_vmware_replication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "classic_vmware_replication_enabled", value)

    @_builtins.property
    @pulumi.getter(name="crossRegionRestoreEnabled")
    def cross_region_restore_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is cross region restore enabled for this Vault? Only can be `true`, when `storage_mode_type` is `GeoRedundant`. Defaults to `false`.

        > **Note:** Once `cross_region_restore_enabled` is set to `true`, changing it back to `false` forces a new Recovery Service Vault to be created.
        """
        return pulumi.get(self, "cross_region_restore_enabled")

    @cross_region_restore_enabled.setter
    def cross_region_restore_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cross_region_restore_enabled", value)

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['VaultEncryptionArgs']]:
        """
        An `encryption` block as defined below. Required with `identity`.

        !> **Note:** Once Encryption with your own key has been Enabled it's not possible to Disable it.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['VaultEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['VaultIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['VaultIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def immutability(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Immutability Settings of vault, possible values include: `Locked`, `Unlocked` and `Disabled`.

        > **Note:** Once `immutability` is set to `Locked`, changing it to other values forces a new Recovery Services Vault to be created.
        """
        return pulumi.get(self, "immutability")

    @immutability.setter
    def immutability(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "immutability", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def monitoring(self) -> Optional[pulumi.Input['VaultMonitoringArgs']]:
        """
        A `monitoring` block as defined below.
        """
        return pulumi.get(self, "monitoring")

    @monitoring.setter
    def monitoring(self, value: Optional[pulumi.Input['VaultMonitoringArgs']]):
        pulumi.set(self, "monitoring", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Recovery Services Vault. Recovery Service Vault name must be 2 - 50 characters long, start with a letter, contain only letters, numbers and hyphens. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is it enabled to access the vault from public networks. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="softDeleteEnabled")
    def soft_delete_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is soft delete enable for this Vault? Defaults to `true`.
        """
        return pulumi.get(self, "soft_delete_enabled")

    @soft_delete_enabled.setter
    def soft_delete_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "soft_delete_enabled", value)

    @_builtins.property
    @pulumi.getter(name="storageModeType")
    def storage_mode_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage type of the Recovery Services Vault. Possible values are `GeoRedundant`, `LocallyRedundant` and `ZoneRedundant`. Defaults to `GeoRedundant`.
        """
        return pulumi.get(self, "storage_mode_type")

    @storage_mode_type.setter
    def storage_mode_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_mode_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _VaultState:
    def __init__(__self__, *,
                 classic_vmware_replication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cross_region_restore_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption: Optional[pulumi.Input['VaultEncryptionArgs']] = None,
                 identity: Optional[pulumi.Input['VaultIdentityArgs']] = None,
                 immutability: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 monitoring: Optional[pulumi.Input['VaultMonitoringArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 soft_delete_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_mode_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Vault resources.
        :param pulumi.Input[_builtins.bool] classic_vmware_replication_enabled: Whether to enable the Classic experience for VMware replication. If set to `false` VMware machines will be protected using the new stateless ASR replication appliance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] cross_region_restore_enabled: Is cross region restore enabled for this Vault? Only can be `true`, when `storage_mode_type` is `GeoRedundant`. Defaults to `false`.
               
               > **Note:** Once `cross_region_restore_enabled` is set to `true`, changing it back to `false` forces a new Recovery Service Vault to be created.
        :param pulumi.Input['VaultEncryptionArgs'] encryption: An `encryption` block as defined below. Required with `identity`.
               
               !> **Note:** Once Encryption with your own key has been Enabled it's not possible to Disable it.
        :param pulumi.Input['VaultIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] immutability: Immutability Settings of vault, possible values include: `Locked`, `Unlocked` and `Disabled`.
               
               > **Note:** Once `immutability` is set to `Locked`, changing it to other values forces a new Recovery Services Vault to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input['VaultMonitoringArgs'] monitoring: A `monitoring` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Recovery Services Vault. Recovery Service Vault name must be 2 - 50 characters long, start with a letter, contain only letters, numbers and hyphens. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Is it enabled to access the vault from public networks. Defaults to `true`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Recovery Services Vault. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: Sets the vault's SKU. Possible values include: `Standard`, `RS0`.
        :param pulumi.Input[_builtins.bool] soft_delete_enabled: Is soft delete enable for this Vault? Defaults to `true`.
        :param pulumi.Input[_builtins.str] storage_mode_type: The storage type of the Recovery Services Vault. Possible values are `GeoRedundant`, `LocallyRedundant` and `ZoneRedundant`. Defaults to `GeoRedundant`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if classic_vmware_replication_enabled is not None:
            pulumi.set(__self__, "classic_vmware_replication_enabled", classic_vmware_replication_enabled)
        if cross_region_restore_enabled is not None:
            pulumi.set(__self__, "cross_region_restore_enabled", cross_region_restore_enabled)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if immutability is not None:
            pulumi.set(__self__, "immutability", immutability)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if monitoring is not None:
            pulumi.set(__self__, "monitoring", monitoring)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if soft_delete_enabled is not None:
            pulumi.set(__self__, "soft_delete_enabled", soft_delete_enabled)
        if storage_mode_type is not None:
            pulumi.set(__self__, "storage_mode_type", storage_mode_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="classicVmwareReplicationEnabled")
    def classic_vmware_replication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable the Classic experience for VMware replication. If set to `false` VMware machines will be protected using the new stateless ASR replication appliance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "classic_vmware_replication_enabled")

    @classic_vmware_replication_enabled.setter
    def classic_vmware_replication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "classic_vmware_replication_enabled", value)

    @_builtins.property
    @pulumi.getter(name="crossRegionRestoreEnabled")
    def cross_region_restore_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is cross region restore enabled for this Vault? Only can be `true`, when `storage_mode_type` is `GeoRedundant`. Defaults to `false`.

        > **Note:** Once `cross_region_restore_enabled` is set to `true`, changing it back to `false` forces a new Recovery Service Vault to be created.
        """
        return pulumi.get(self, "cross_region_restore_enabled")

    @cross_region_restore_enabled.setter
    def cross_region_restore_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cross_region_restore_enabled", value)

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['VaultEncryptionArgs']]:
        """
        An `encryption` block as defined below. Required with `identity`.

        !> **Note:** Once Encryption with your own key has been Enabled it's not possible to Disable it.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['VaultEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['VaultIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['VaultIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def immutability(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Immutability Settings of vault, possible values include: `Locked`, `Unlocked` and `Disabled`.

        > **Note:** Once `immutability` is set to `Locked`, changing it to other values forces a new Recovery Services Vault to be created.
        """
        return pulumi.get(self, "immutability")

    @immutability.setter
    def immutability(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "immutability", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def monitoring(self) -> Optional[pulumi.Input['VaultMonitoringArgs']]:
        """
        A `monitoring` block as defined below.
        """
        return pulumi.get(self, "monitoring")

    @monitoring.setter
    def monitoring(self, value: Optional[pulumi.Input['VaultMonitoringArgs']]):
        pulumi.set(self, "monitoring", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Recovery Services Vault. Recovery Service Vault name must be 2 - 50 characters long, start with a letter, contain only letters, numbers and hyphens. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is it enabled to access the vault from public networks. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the Recovery Services Vault. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sets the vault's SKU. Possible values include: `Standard`, `RS0`.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="softDeleteEnabled")
    def soft_delete_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is soft delete enable for this Vault? Defaults to `true`.
        """
        return pulumi.get(self, "soft_delete_enabled")

    @soft_delete_enabled.setter
    def soft_delete_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "soft_delete_enabled", value)

    @_builtins.property
    @pulumi.getter(name="storageModeType")
    def storage_mode_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The storage type of the Recovery Services Vault. Possible values are `GeoRedundant`, `LocallyRedundant` and `ZoneRedundant`. Defaults to `GeoRedundant`.
        """
        return pulumi.get(self, "storage_mode_type")

    @storage_mode_type.setter
    def storage_mode_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_mode_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:recoveryservices/vault:Vault")
class Vault(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 classic_vmware_replication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cross_region_restore_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption: Optional[pulumi.Input[Union['VaultEncryptionArgs', 'VaultEncryptionArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['VaultIdentityArgs', 'VaultIdentityArgsDict']]] = None,
                 immutability: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 monitoring: Optional[pulumi.Input[Union['VaultMonitoringArgs', 'VaultMonitoringArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 soft_delete_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_mode_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Recovery Services Vault.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="tfex-recovery_vault",
            location="West Europe")
        vault = azure.recoveryservices.Vault("vault",
            name="example-recovery-vault",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard",
            soft_delete_enabled=True)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.RecoveryServices` - 2024-04-01, 2024-01-01

        ## Import

        Recovery Services Vaults can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:recoveryservices/vault:Vault vault1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.RecoveryServices/vaults/vault1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] classic_vmware_replication_enabled: Whether to enable the Classic experience for VMware replication. If set to `false` VMware machines will be protected using the new stateless ASR replication appliance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] cross_region_restore_enabled: Is cross region restore enabled for this Vault? Only can be `true`, when `storage_mode_type` is `GeoRedundant`. Defaults to `false`.
               
               > **Note:** Once `cross_region_restore_enabled` is set to `true`, changing it back to `false` forces a new Recovery Service Vault to be created.
        :param pulumi.Input[Union['VaultEncryptionArgs', 'VaultEncryptionArgsDict']] encryption: An `encryption` block as defined below. Required with `identity`.
               
               !> **Note:** Once Encryption with your own key has been Enabled it's not possible to Disable it.
        :param pulumi.Input[Union['VaultIdentityArgs', 'VaultIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] immutability: Immutability Settings of vault, possible values include: `Locked`, `Unlocked` and `Disabled`.
               
               > **Note:** Once `immutability` is set to `Locked`, changing it to other values forces a new Recovery Services Vault to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['VaultMonitoringArgs', 'VaultMonitoringArgsDict']] monitoring: A `monitoring` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Recovery Services Vault. Recovery Service Vault name must be 2 - 50 characters long, start with a letter, contain only letters, numbers and hyphens. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Is it enabled to access the vault from public networks. Defaults to `true`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Recovery Services Vault. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: Sets the vault's SKU. Possible values include: `Standard`, `RS0`.
        :param pulumi.Input[_builtins.bool] soft_delete_enabled: Is soft delete enable for this Vault? Defaults to `true`.
        :param pulumi.Input[_builtins.str] storage_mode_type: The storage type of the Recovery Services Vault. Possible values are `GeoRedundant`, `LocallyRedundant` and `ZoneRedundant`. Defaults to `GeoRedundant`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VaultArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Recovery Services Vault.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="tfex-recovery_vault",
            location="West Europe")
        vault = azure.recoveryservices.Vault("vault",
            name="example-recovery-vault",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard",
            soft_delete_enabled=True)
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.RecoveryServices` - 2024-04-01, 2024-01-01

        ## Import

        Recovery Services Vaults can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:recoveryservices/vault:Vault vault1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.RecoveryServices/vaults/vault1
        ```

        :param str resource_name: The name of the resource.
        :param VaultArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VaultArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 classic_vmware_replication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 cross_region_restore_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 encryption: Optional[pulumi.Input[Union['VaultEncryptionArgs', 'VaultEncryptionArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['VaultIdentityArgs', 'VaultIdentityArgsDict']]] = None,
                 immutability: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 monitoring: Optional[pulumi.Input[Union['VaultMonitoringArgs', 'VaultMonitoringArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 soft_delete_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_mode_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VaultArgs.__new__(VaultArgs)

            __props__.__dict__["classic_vmware_replication_enabled"] = classic_vmware_replication_enabled
            __props__.__dict__["cross_region_restore_enabled"] = cross_region_restore_enabled
            __props__.__dict__["encryption"] = encryption
            __props__.__dict__["identity"] = identity
            __props__.__dict__["immutability"] = immutability
            __props__.__dict__["location"] = location
            __props__.__dict__["monitoring"] = monitoring
            __props__.__dict__["name"] = name
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sku is None and not opts.urn:
                raise TypeError("Missing required property 'sku'")
            __props__.__dict__["sku"] = sku
            __props__.__dict__["soft_delete_enabled"] = soft_delete_enabled
            __props__.__dict__["storage_mode_type"] = storage_mode_type
            __props__.__dict__["tags"] = tags
        super(Vault, __self__).__init__(
            'azure:recoveryservices/vault:Vault',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            classic_vmware_replication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            cross_region_restore_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            encryption: Optional[pulumi.Input[Union['VaultEncryptionArgs', 'VaultEncryptionArgsDict']]] = None,
            identity: Optional[pulumi.Input[Union['VaultIdentityArgs', 'VaultIdentityArgsDict']]] = None,
            immutability: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            monitoring: Optional[pulumi.Input[Union['VaultMonitoringArgs', 'VaultMonitoringArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            sku: Optional[pulumi.Input[_builtins.str]] = None,
            soft_delete_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            storage_mode_type: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Vault':
        """
        Get an existing Vault resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] classic_vmware_replication_enabled: Whether to enable the Classic experience for VMware replication. If set to `false` VMware machines will be protected using the new stateless ASR replication appliance. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] cross_region_restore_enabled: Is cross region restore enabled for this Vault? Only can be `true`, when `storage_mode_type` is `GeoRedundant`. Defaults to `false`.
               
               > **Note:** Once `cross_region_restore_enabled` is set to `true`, changing it back to `false` forces a new Recovery Service Vault to be created.
        :param pulumi.Input[Union['VaultEncryptionArgs', 'VaultEncryptionArgsDict']] encryption: An `encryption` block as defined below. Required with `identity`.
               
               !> **Note:** Once Encryption with your own key has been Enabled it's not possible to Disable it.
        :param pulumi.Input[Union['VaultIdentityArgs', 'VaultIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] immutability: Immutability Settings of vault, possible values include: `Locked`, `Unlocked` and `Disabled`.
               
               > **Note:** Once `immutability` is set to `Locked`, changing it to other values forces a new Recovery Services Vault to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['VaultMonitoringArgs', 'VaultMonitoringArgsDict']] monitoring: A `monitoring` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Recovery Services Vault. Recovery Service Vault name must be 2 - 50 characters long, start with a letter, contain only letters, numbers and hyphens. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Is it enabled to access the vault from public networks. Defaults to `true`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Recovery Services Vault. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: Sets the vault's SKU. Possible values include: `Standard`, `RS0`.
        :param pulumi.Input[_builtins.bool] soft_delete_enabled: Is soft delete enable for this Vault? Defaults to `true`.
        :param pulumi.Input[_builtins.str] storage_mode_type: The storage type of the Recovery Services Vault. Possible values are `GeoRedundant`, `LocallyRedundant` and `ZoneRedundant`. Defaults to `GeoRedundant`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VaultState.__new__(_VaultState)

        __props__.__dict__["classic_vmware_replication_enabled"] = classic_vmware_replication_enabled
        __props__.__dict__["cross_region_restore_enabled"] = cross_region_restore_enabled
        __props__.__dict__["encryption"] = encryption
        __props__.__dict__["identity"] = identity
        __props__.__dict__["immutability"] = immutability
        __props__.__dict__["location"] = location
        __props__.__dict__["monitoring"] = monitoring
        __props__.__dict__["name"] = name
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sku"] = sku
        __props__.__dict__["soft_delete_enabled"] = soft_delete_enabled
        __props__.__dict__["storage_mode_type"] = storage_mode_type
        __props__.__dict__["tags"] = tags
        return Vault(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="classicVmwareReplicationEnabled")
    def classic_vmware_replication_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable the Classic experience for VMware replication. If set to `false` VMware machines will be protected using the new stateless ASR replication appliance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "classic_vmware_replication_enabled")

    @_builtins.property
    @pulumi.getter(name="crossRegionRestoreEnabled")
    def cross_region_restore_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is cross region restore enabled for this Vault? Only can be `true`, when `storage_mode_type` is `GeoRedundant`. Defaults to `false`.

        > **Note:** Once `cross_region_restore_enabled` is set to `true`, changing it back to `false` forces a new Recovery Service Vault to be created.
        """
        return pulumi.get(self, "cross_region_restore_enabled")

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> pulumi.Output[Optional['outputs.VaultEncryption']]:
        """
        An `encryption` block as defined below. Required with `identity`.

        !> **Note:** Once Encryption with your own key has been Enabled it's not possible to Disable it.
        """
        return pulumi.get(self, "encryption")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.VaultIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def immutability(self) -> pulumi.Output[_builtins.str]:
        """
        Immutability Settings of vault, possible values include: `Locked`, `Unlocked` and `Disabled`.

        > **Note:** Once `immutability` is set to `Locked`, changing it to other values forces a new Recovery Services Vault to be created.
        """
        return pulumi.get(self, "immutability")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def monitoring(self) -> pulumi.Output[Optional['outputs.VaultMonitoring']]:
        """
        A `monitoring` block as defined below.
        """
        return pulumi.get(self, "monitoring")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Recovery Services Vault. Recovery Service Vault name must be 2 - 50 characters long, start with a letter, contain only letters, numbers and hyphens. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is it enabled to access the vault from public networks. Defaults to `true`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the Recovery Services Vault. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Output[_builtins.str]:
        """
        Sets the vault's SKU. Possible values include: `Standard`, `RS0`.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter(name="softDeleteEnabled")
    def soft_delete_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is soft delete enable for this Vault? Defaults to `true`.
        """
        return pulumi.get(self, "soft_delete_enabled")

    @_builtins.property
    @pulumi.getter(name="storageModeType")
    def storage_mode_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The storage type of the Recovery Services Vault. Possible values are `GeoRedundant`, `LocallyRedundant` and `ZoneRedundant`. Defaults to `GeoRedundant`.
        """
        return pulumi.get(self, "storage_mode_type")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

