# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 management_endpoint: pulumi.Input[_builtins.str],
                 node_types: pulumi.Input[Sequence[pulumi.Input['ClusterNodeTypeArgs']]],
                 reliability_level: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 upgrade_mode: pulumi.Input[_builtins.str],
                 vm_image: pulumi.Input[_builtins.str],
                 add_on_features: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 azure_active_directory: Optional[pulumi.Input['ClusterAzureActiveDirectoryArgs']] = None,
                 certificate: Optional[pulumi.Input['ClusterCertificateArgs']] = None,
                 certificate_common_names: Optional[pulumi.Input['ClusterCertificateCommonNamesArgs']] = None,
                 client_certificate_common_names: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClientCertificateCommonNameArgs']]]] = None,
                 client_certificate_thumbprints: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClientCertificateThumbprintArgs']]]] = None,
                 cluster_code_version: Optional[pulumi.Input[_builtins.str]] = None,
                 diagnostics_config: Optional[pulumi.Input['ClusterDiagnosticsConfigArgs']] = None,
                 fabric_settings: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterFabricSettingArgs']]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 reverse_proxy_certificate: Optional[pulumi.Input['ClusterReverseProxyCertificateArgs']] = None,
                 reverse_proxy_certificate_common_names: Optional[pulumi.Input['ClusterReverseProxyCertificateCommonNamesArgs']] = None,
                 service_fabric_zonal_upgrade_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 upgrade_policy: Optional[pulumi.Input['ClusterUpgradePolicyArgs']] = None,
                 vmss_zonal_upgrade_mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[_builtins.str] management_endpoint: Specifies the Management Endpoint of the cluster such as `http://example.com`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeTypeArgs']]] node_types: One or more `node_type` blocks as defined below.
        :param pulumi.Input[_builtins.str] reliability_level: Specifies the Reliability Level of the Cluster. Possible values include `None`, `Bronze`, `Silver`, `Gold` and `Platinum`.
               
               > **Note:** The Reliability Level of the Cluster depends on the number of nodes in the Cluster: `Platinum` requires at least 9 VM's, `Gold` requires at least 7 VM's, `Silver` requires at least 5 VM's, `Bronze` requires at least 3 VM's.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Service Fabric Cluster exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] upgrade_mode: Specifies the Upgrade Mode of the cluster. Possible values are `Automatic` or `Manual`.
        :param pulumi.Input[_builtins.str] vm_image: Specifies the Image expected for the Service Fabric Cluster, such as `Windows`. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] add_on_features: A List of one or more features which should be enabled, such as `DnsService`.
        :param pulumi.Input['ClusterAzureActiveDirectoryArgs'] azure_active_directory: An `azure_active_directory` block as defined below.
        :param pulumi.Input['ClusterCertificateArgs'] certificate: A `certificate` block as defined below. Conflicts with `certificate_common_names`.
        :param pulumi.Input['ClusterCertificateCommonNamesArgs'] certificate_common_names: A `certificate_common_names` block as defined below. Conflicts with `certificate`.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterClientCertificateCommonNameArgs']]] client_certificate_common_names: A `client_certificate_common_name` block as defined below.
               
               > **Note:** If Client Certificates are enabled then at a Certificate must be configured on the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterClientCertificateThumbprintArgs']]] client_certificate_thumbprints: One or more `client_certificate_thumbprint` blocks as defined below.
        :param pulumi.Input[_builtins.str] cluster_code_version: Required if Upgrade Mode set to `Manual`, Specifies the Version of the Cluster Code of the cluster.
        :param pulumi.Input['ClusterDiagnosticsConfigArgs'] diagnostics_config: A `diagnostics_config` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterFabricSettingArgs']]] fabric_settings: One or more `fabric_settings` blocks as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Service Fabric Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Service Fabric Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input['ClusterReverseProxyCertificateArgs'] reverse_proxy_certificate: A `reverse_proxy_certificate` block as defined below. Conflicts with `reverse_proxy_certificate_common_names`.
        :param pulumi.Input['ClusterReverseProxyCertificateCommonNamesArgs'] reverse_proxy_certificate_common_names: A `reverse_proxy_certificate_common_names` block as defined below. Conflicts with `reverse_proxy_certificate`.
        :param pulumi.Input[_builtins.str] service_fabric_zonal_upgrade_mode: Specifies the logical grouping of VMs in upgrade domains. Possible values are `Hierarchical` or `Parallel`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input['ClusterUpgradePolicyArgs'] upgrade_policy: A `upgrade_policy` block as defined below.
        :param pulumi.Input[_builtins.str] vmss_zonal_upgrade_mode: Specifies the upgrade mode for the virtual machine scale set updates that happen in all availability zones at once. Possible values are `Hierarchical` or `Parallel`.
        """
        pulumi.set(__self__, "management_endpoint", management_endpoint)
        pulumi.set(__self__, "node_types", node_types)
        pulumi.set(__self__, "reliability_level", reliability_level)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "upgrade_mode", upgrade_mode)
        pulumi.set(__self__, "vm_image", vm_image)
        if add_on_features is not None:
            pulumi.set(__self__, "add_on_features", add_on_features)
        if azure_active_directory is not None:
            pulumi.set(__self__, "azure_active_directory", azure_active_directory)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_common_names is not None:
            pulumi.set(__self__, "certificate_common_names", certificate_common_names)
        if client_certificate_common_names is not None:
            pulumi.set(__self__, "client_certificate_common_names", client_certificate_common_names)
        if client_certificate_thumbprints is not None:
            pulumi.set(__self__, "client_certificate_thumbprints", client_certificate_thumbprints)
        if cluster_code_version is not None:
            pulumi.set(__self__, "cluster_code_version", cluster_code_version)
        if diagnostics_config is not None:
            pulumi.set(__self__, "diagnostics_config", diagnostics_config)
        if fabric_settings is not None:
            pulumi.set(__self__, "fabric_settings", fabric_settings)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if reverse_proxy_certificate is not None:
            pulumi.set(__self__, "reverse_proxy_certificate", reverse_proxy_certificate)
        if reverse_proxy_certificate_common_names is not None:
            pulumi.set(__self__, "reverse_proxy_certificate_common_names", reverse_proxy_certificate_common_names)
        if service_fabric_zonal_upgrade_mode is not None:
            pulumi.set(__self__, "service_fabric_zonal_upgrade_mode", service_fabric_zonal_upgrade_mode)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if upgrade_policy is not None:
            pulumi.set(__self__, "upgrade_policy", upgrade_policy)
        if vmss_zonal_upgrade_mode is not None:
            pulumi.set(__self__, "vmss_zonal_upgrade_mode", vmss_zonal_upgrade_mode)

    @_builtins.property
    @pulumi.getter(name="managementEndpoint")
    def management_endpoint(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Management Endpoint of the cluster such as `http://example.com`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "management_endpoint")

    @management_endpoint.setter
    def management_endpoint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "management_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="nodeTypes")
    def node_types(self) -> pulumi.Input[Sequence[pulumi.Input['ClusterNodeTypeArgs']]]:
        """
        One or more `node_type` blocks as defined below.
        """
        return pulumi.get(self, "node_types")

    @node_types.setter
    def node_types(self, value: pulumi.Input[Sequence[pulumi.Input['ClusterNodeTypeArgs']]]):
        pulumi.set(self, "node_types", value)

    @_builtins.property
    @pulumi.getter(name="reliabilityLevel")
    def reliability_level(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Reliability Level of the Cluster. Possible values include `None`, `Bronze`, `Silver`, `Gold` and `Platinum`.

        > **Note:** The Reliability Level of the Cluster depends on the number of nodes in the Cluster: `Platinum` requires at least 9 VM's, `Gold` requires at least 7 VM's, `Silver` requires at least 5 VM's, `Bronze` requires at least 3 VM's.
        """
        return pulumi.get(self, "reliability_level")

    @reliability_level.setter
    def reliability_level(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "reliability_level", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group in which the Service Fabric Cluster exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="upgradeMode")
    def upgrade_mode(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Upgrade Mode of the cluster. Possible values are `Automatic` or `Manual`.
        """
        return pulumi.get(self, "upgrade_mode")

    @upgrade_mode.setter
    def upgrade_mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "upgrade_mode", value)

    @_builtins.property
    @pulumi.getter(name="vmImage")
    def vm_image(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Image expected for the Service Fabric Cluster, such as `Windows`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vm_image")

    @vm_image.setter
    def vm_image(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vm_image", value)

    @_builtins.property
    @pulumi.getter(name="addOnFeatures")
    def add_on_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A List of one or more features which should be enabled, such as `DnsService`.
        """
        return pulumi.get(self, "add_on_features")

    @add_on_features.setter
    def add_on_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "add_on_features", value)

    @_builtins.property
    @pulumi.getter(name="azureActiveDirectory")
    def azure_active_directory(self) -> Optional[pulumi.Input['ClusterAzureActiveDirectoryArgs']]:
        """
        An `azure_active_directory` block as defined below.
        """
        return pulumi.get(self, "azure_active_directory")

    @azure_active_directory.setter
    def azure_active_directory(self, value: Optional[pulumi.Input['ClusterAzureActiveDirectoryArgs']]):
        pulumi.set(self, "azure_active_directory", value)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input['ClusterCertificateArgs']]:
        """
        A `certificate` block as defined below. Conflicts with `certificate_common_names`.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input['ClusterCertificateArgs']]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="certificateCommonNames")
    def certificate_common_names(self) -> Optional[pulumi.Input['ClusterCertificateCommonNamesArgs']]:
        """
        A `certificate_common_names` block as defined below. Conflicts with `certificate`.
        """
        return pulumi.get(self, "certificate_common_names")

    @certificate_common_names.setter
    def certificate_common_names(self, value: Optional[pulumi.Input['ClusterCertificateCommonNamesArgs']]):
        pulumi.set(self, "certificate_common_names", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificateCommonNames")
    def client_certificate_common_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClientCertificateCommonNameArgs']]]]:
        """
        A `client_certificate_common_name` block as defined below.

        > **Note:** If Client Certificates are enabled then at a Certificate must be configured on the cluster.
        """
        return pulumi.get(self, "client_certificate_common_names")

    @client_certificate_common_names.setter
    def client_certificate_common_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClientCertificateCommonNameArgs']]]]):
        pulumi.set(self, "client_certificate_common_names", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificateThumbprints")
    def client_certificate_thumbprints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClientCertificateThumbprintArgs']]]]:
        """
        One or more `client_certificate_thumbprint` blocks as defined below.
        """
        return pulumi.get(self, "client_certificate_thumbprints")

    @client_certificate_thumbprints.setter
    def client_certificate_thumbprints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClientCertificateThumbprintArgs']]]]):
        pulumi.set(self, "client_certificate_thumbprints", value)

    @_builtins.property
    @pulumi.getter(name="clusterCodeVersion")
    def cluster_code_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required if Upgrade Mode set to `Manual`, Specifies the Version of the Cluster Code of the cluster.
        """
        return pulumi.get(self, "cluster_code_version")

    @cluster_code_version.setter
    def cluster_code_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_code_version", value)

    @_builtins.property
    @pulumi.getter(name="diagnosticsConfig")
    def diagnostics_config(self) -> Optional[pulumi.Input['ClusterDiagnosticsConfigArgs']]:
        """
        A `diagnostics_config` block as defined below.
        """
        return pulumi.get(self, "diagnostics_config")

    @diagnostics_config.setter
    def diagnostics_config(self, value: Optional[pulumi.Input['ClusterDiagnosticsConfigArgs']]):
        pulumi.set(self, "diagnostics_config", value)

    @_builtins.property
    @pulumi.getter(name="fabricSettings")
    def fabric_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterFabricSettingArgs']]]]:
        """
        One or more `fabric_settings` blocks as defined below.
        """
        return pulumi.get(self, "fabric_settings")

    @fabric_settings.setter
    def fabric_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterFabricSettingArgs']]]]):
        pulumi.set(self, "fabric_settings", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Service Fabric Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Service Fabric Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="reverseProxyCertificate")
    def reverse_proxy_certificate(self) -> Optional[pulumi.Input['ClusterReverseProxyCertificateArgs']]:
        """
        A `reverse_proxy_certificate` block as defined below. Conflicts with `reverse_proxy_certificate_common_names`.
        """
        return pulumi.get(self, "reverse_proxy_certificate")

    @reverse_proxy_certificate.setter
    def reverse_proxy_certificate(self, value: Optional[pulumi.Input['ClusterReverseProxyCertificateArgs']]):
        pulumi.set(self, "reverse_proxy_certificate", value)

    @_builtins.property
    @pulumi.getter(name="reverseProxyCertificateCommonNames")
    def reverse_proxy_certificate_common_names(self) -> Optional[pulumi.Input['ClusterReverseProxyCertificateCommonNamesArgs']]:
        """
        A `reverse_proxy_certificate_common_names` block as defined below. Conflicts with `reverse_proxy_certificate`.
        """
        return pulumi.get(self, "reverse_proxy_certificate_common_names")

    @reverse_proxy_certificate_common_names.setter
    def reverse_proxy_certificate_common_names(self, value: Optional[pulumi.Input['ClusterReverseProxyCertificateCommonNamesArgs']]):
        pulumi.set(self, "reverse_proxy_certificate_common_names", value)

    @_builtins.property
    @pulumi.getter(name="serviceFabricZonalUpgradeMode")
    def service_fabric_zonal_upgrade_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the logical grouping of VMs in upgrade domains. Possible values are `Hierarchical` or `Parallel`.
        """
        return pulumi.get(self, "service_fabric_zonal_upgrade_mode")

    @service_fabric_zonal_upgrade_mode.setter
    def service_fabric_zonal_upgrade_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_fabric_zonal_upgrade_mode", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="upgradePolicy")
    def upgrade_policy(self) -> Optional[pulumi.Input['ClusterUpgradePolicyArgs']]:
        """
        A `upgrade_policy` block as defined below.
        """
        return pulumi.get(self, "upgrade_policy")

    @upgrade_policy.setter
    def upgrade_policy(self, value: Optional[pulumi.Input['ClusterUpgradePolicyArgs']]):
        pulumi.set(self, "upgrade_policy", value)

    @_builtins.property
    @pulumi.getter(name="vmssZonalUpgradeMode")
    def vmss_zonal_upgrade_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the upgrade mode for the virtual machine scale set updates that happen in all availability zones at once. Possible values are `Hierarchical` or `Parallel`.
        """
        return pulumi.get(self, "vmss_zonal_upgrade_mode")

    @vmss_zonal_upgrade_mode.setter
    def vmss_zonal_upgrade_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vmss_zonal_upgrade_mode", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 add_on_features: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 azure_active_directory: Optional[pulumi.Input['ClusterAzureActiveDirectoryArgs']] = None,
                 certificate: Optional[pulumi.Input['ClusterCertificateArgs']] = None,
                 certificate_common_names: Optional[pulumi.Input['ClusterCertificateCommonNamesArgs']] = None,
                 client_certificate_common_names: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClientCertificateCommonNameArgs']]]] = None,
                 client_certificate_thumbprints: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClientCertificateThumbprintArgs']]]] = None,
                 cluster_code_version: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 diagnostics_config: Optional[pulumi.Input['ClusterDiagnosticsConfigArgs']] = None,
                 fabric_settings: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterFabricSettingArgs']]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 management_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_types: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeTypeArgs']]]] = None,
                 reliability_level: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 reverse_proxy_certificate: Optional[pulumi.Input['ClusterReverseProxyCertificateArgs']] = None,
                 reverse_proxy_certificate_common_names: Optional[pulumi.Input['ClusterReverseProxyCertificateCommonNamesArgs']] = None,
                 service_fabric_zonal_upgrade_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 upgrade_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 upgrade_policy: Optional[pulumi.Input['ClusterUpgradePolicyArgs']] = None,
                 vm_image: Optional[pulumi.Input[_builtins.str]] = None,
                 vmss_zonal_upgrade_mode: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] add_on_features: A List of one or more features which should be enabled, such as `DnsService`.
        :param pulumi.Input['ClusterAzureActiveDirectoryArgs'] azure_active_directory: An `azure_active_directory` block as defined below.
        :param pulumi.Input['ClusterCertificateArgs'] certificate: A `certificate` block as defined below. Conflicts with `certificate_common_names`.
        :param pulumi.Input['ClusterCertificateCommonNamesArgs'] certificate_common_names: A `certificate_common_names` block as defined below. Conflicts with `certificate`.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterClientCertificateCommonNameArgs']]] client_certificate_common_names: A `client_certificate_common_name` block as defined below.
               
               > **Note:** If Client Certificates are enabled then at a Certificate must be configured on the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterClientCertificateThumbprintArgs']]] client_certificate_thumbprints: One or more `client_certificate_thumbprint` blocks as defined below.
        :param pulumi.Input[_builtins.str] cluster_code_version: Required if Upgrade Mode set to `Manual`, Specifies the Version of the Cluster Code of the cluster.
        :param pulumi.Input[_builtins.str] cluster_endpoint: The Cluster Endpoint for this Service Fabric Cluster.
        :param pulumi.Input['ClusterDiagnosticsConfigArgs'] diagnostics_config: A `diagnostics_config` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterFabricSettingArgs']]] fabric_settings: One or more `fabric_settings` blocks as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Service Fabric Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] management_endpoint: Specifies the Management Endpoint of the cluster such as `http://example.com`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Service Fabric Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeTypeArgs']]] node_types: One or more `node_type` blocks as defined below.
        :param pulumi.Input[_builtins.str] reliability_level: Specifies the Reliability Level of the Cluster. Possible values include `None`, `Bronze`, `Silver`, `Gold` and `Platinum`.
               
               > **Note:** The Reliability Level of the Cluster depends on the number of nodes in the Cluster: `Platinum` requires at least 9 VM's, `Gold` requires at least 7 VM's, `Silver` requires at least 5 VM's, `Bronze` requires at least 3 VM's.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Service Fabric Cluster exists. Changing this forces a new resource to be created.
        :param pulumi.Input['ClusterReverseProxyCertificateArgs'] reverse_proxy_certificate: A `reverse_proxy_certificate` block as defined below. Conflicts with `reverse_proxy_certificate_common_names`.
        :param pulumi.Input['ClusterReverseProxyCertificateCommonNamesArgs'] reverse_proxy_certificate_common_names: A `reverse_proxy_certificate_common_names` block as defined below. Conflicts with `reverse_proxy_certificate`.
        :param pulumi.Input[_builtins.str] service_fabric_zonal_upgrade_mode: Specifies the logical grouping of VMs in upgrade domains. Possible values are `Hierarchical` or `Parallel`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] upgrade_mode: Specifies the Upgrade Mode of the cluster. Possible values are `Automatic` or `Manual`.
        :param pulumi.Input['ClusterUpgradePolicyArgs'] upgrade_policy: A `upgrade_policy` block as defined below.
        :param pulumi.Input[_builtins.str] vm_image: Specifies the Image expected for the Service Fabric Cluster, such as `Windows`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] vmss_zonal_upgrade_mode: Specifies the upgrade mode for the virtual machine scale set updates that happen in all availability zones at once. Possible values are `Hierarchical` or `Parallel`.
        """
        if add_on_features is not None:
            pulumi.set(__self__, "add_on_features", add_on_features)
        if azure_active_directory is not None:
            pulumi.set(__self__, "azure_active_directory", azure_active_directory)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_common_names is not None:
            pulumi.set(__self__, "certificate_common_names", certificate_common_names)
        if client_certificate_common_names is not None:
            pulumi.set(__self__, "client_certificate_common_names", client_certificate_common_names)
        if client_certificate_thumbprints is not None:
            pulumi.set(__self__, "client_certificate_thumbprints", client_certificate_thumbprints)
        if cluster_code_version is not None:
            pulumi.set(__self__, "cluster_code_version", cluster_code_version)
        if cluster_endpoint is not None:
            pulumi.set(__self__, "cluster_endpoint", cluster_endpoint)
        if diagnostics_config is not None:
            pulumi.set(__self__, "diagnostics_config", diagnostics_config)
        if fabric_settings is not None:
            pulumi.set(__self__, "fabric_settings", fabric_settings)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if management_endpoint is not None:
            pulumi.set(__self__, "management_endpoint", management_endpoint)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_types is not None:
            pulumi.set(__self__, "node_types", node_types)
        if reliability_level is not None:
            pulumi.set(__self__, "reliability_level", reliability_level)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if reverse_proxy_certificate is not None:
            pulumi.set(__self__, "reverse_proxy_certificate", reverse_proxy_certificate)
        if reverse_proxy_certificate_common_names is not None:
            pulumi.set(__self__, "reverse_proxy_certificate_common_names", reverse_proxy_certificate_common_names)
        if service_fabric_zonal_upgrade_mode is not None:
            pulumi.set(__self__, "service_fabric_zonal_upgrade_mode", service_fabric_zonal_upgrade_mode)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if upgrade_mode is not None:
            pulumi.set(__self__, "upgrade_mode", upgrade_mode)
        if upgrade_policy is not None:
            pulumi.set(__self__, "upgrade_policy", upgrade_policy)
        if vm_image is not None:
            pulumi.set(__self__, "vm_image", vm_image)
        if vmss_zonal_upgrade_mode is not None:
            pulumi.set(__self__, "vmss_zonal_upgrade_mode", vmss_zonal_upgrade_mode)

    @_builtins.property
    @pulumi.getter(name="addOnFeatures")
    def add_on_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A List of one or more features which should be enabled, such as `DnsService`.
        """
        return pulumi.get(self, "add_on_features")

    @add_on_features.setter
    def add_on_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "add_on_features", value)

    @_builtins.property
    @pulumi.getter(name="azureActiveDirectory")
    def azure_active_directory(self) -> Optional[pulumi.Input['ClusterAzureActiveDirectoryArgs']]:
        """
        An `azure_active_directory` block as defined below.
        """
        return pulumi.get(self, "azure_active_directory")

    @azure_active_directory.setter
    def azure_active_directory(self, value: Optional[pulumi.Input['ClusterAzureActiveDirectoryArgs']]):
        pulumi.set(self, "azure_active_directory", value)

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input['ClusterCertificateArgs']]:
        """
        A `certificate` block as defined below. Conflicts with `certificate_common_names`.
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input['ClusterCertificateArgs']]):
        pulumi.set(self, "certificate", value)

    @_builtins.property
    @pulumi.getter(name="certificateCommonNames")
    def certificate_common_names(self) -> Optional[pulumi.Input['ClusterCertificateCommonNamesArgs']]:
        """
        A `certificate_common_names` block as defined below. Conflicts with `certificate`.
        """
        return pulumi.get(self, "certificate_common_names")

    @certificate_common_names.setter
    def certificate_common_names(self, value: Optional[pulumi.Input['ClusterCertificateCommonNamesArgs']]):
        pulumi.set(self, "certificate_common_names", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificateCommonNames")
    def client_certificate_common_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClientCertificateCommonNameArgs']]]]:
        """
        A `client_certificate_common_name` block as defined below.

        > **Note:** If Client Certificates are enabled then at a Certificate must be configured on the cluster.
        """
        return pulumi.get(self, "client_certificate_common_names")

    @client_certificate_common_names.setter
    def client_certificate_common_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClientCertificateCommonNameArgs']]]]):
        pulumi.set(self, "client_certificate_common_names", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificateThumbprints")
    def client_certificate_thumbprints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClientCertificateThumbprintArgs']]]]:
        """
        One or more `client_certificate_thumbprint` blocks as defined below.
        """
        return pulumi.get(self, "client_certificate_thumbprints")

    @client_certificate_thumbprints.setter
    def client_certificate_thumbprints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterClientCertificateThumbprintArgs']]]]):
        pulumi.set(self, "client_certificate_thumbprints", value)

    @_builtins.property
    @pulumi.getter(name="clusterCodeVersion")
    def cluster_code_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required if Upgrade Mode set to `Manual`, Specifies the Version of the Cluster Code of the cluster.
        """
        return pulumi.get(self, "cluster_code_version")

    @cluster_code_version.setter
    def cluster_code_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_code_version", value)

    @_builtins.property
    @pulumi.getter(name="clusterEndpoint")
    def cluster_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Cluster Endpoint for this Service Fabric Cluster.
        """
        return pulumi.get(self, "cluster_endpoint")

    @cluster_endpoint.setter
    def cluster_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="diagnosticsConfig")
    def diagnostics_config(self) -> Optional[pulumi.Input['ClusterDiagnosticsConfigArgs']]:
        """
        A `diagnostics_config` block as defined below.
        """
        return pulumi.get(self, "diagnostics_config")

    @diagnostics_config.setter
    def diagnostics_config(self, value: Optional[pulumi.Input['ClusterDiagnosticsConfigArgs']]):
        pulumi.set(self, "diagnostics_config", value)

    @_builtins.property
    @pulumi.getter(name="fabricSettings")
    def fabric_settings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterFabricSettingArgs']]]]:
        """
        One or more `fabric_settings` blocks as defined below.
        """
        return pulumi.get(self, "fabric_settings")

    @fabric_settings.setter
    def fabric_settings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterFabricSettingArgs']]]]):
        pulumi.set(self, "fabric_settings", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Service Fabric Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managementEndpoint")
    def management_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Management Endpoint of the cluster such as `http://example.com`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "management_endpoint")

    @management_endpoint.setter
    def management_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "management_endpoint", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Service Fabric Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeTypes")
    def node_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeTypeArgs']]]]:
        """
        One or more `node_type` blocks as defined below.
        """
        return pulumi.get(self, "node_types")

    @node_types.setter
    def node_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeTypeArgs']]]]):
        pulumi.set(self, "node_types", value)

    @_builtins.property
    @pulumi.getter(name="reliabilityLevel")
    def reliability_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Reliability Level of the Cluster. Possible values include `None`, `Bronze`, `Silver`, `Gold` and `Platinum`.

        > **Note:** The Reliability Level of the Cluster depends on the number of nodes in the Cluster: `Platinum` requires at least 9 VM's, `Gold` requires at least 7 VM's, `Silver` requires at least 5 VM's, `Bronze` requires at least 3 VM's.
        """
        return pulumi.get(self, "reliability_level")

    @reliability_level.setter
    def reliability_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reliability_level", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group in which the Service Fabric Cluster exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="reverseProxyCertificate")
    def reverse_proxy_certificate(self) -> Optional[pulumi.Input['ClusterReverseProxyCertificateArgs']]:
        """
        A `reverse_proxy_certificate` block as defined below. Conflicts with `reverse_proxy_certificate_common_names`.
        """
        return pulumi.get(self, "reverse_proxy_certificate")

    @reverse_proxy_certificate.setter
    def reverse_proxy_certificate(self, value: Optional[pulumi.Input['ClusterReverseProxyCertificateArgs']]):
        pulumi.set(self, "reverse_proxy_certificate", value)

    @_builtins.property
    @pulumi.getter(name="reverseProxyCertificateCommonNames")
    def reverse_proxy_certificate_common_names(self) -> Optional[pulumi.Input['ClusterReverseProxyCertificateCommonNamesArgs']]:
        """
        A `reverse_proxy_certificate_common_names` block as defined below. Conflicts with `reverse_proxy_certificate`.
        """
        return pulumi.get(self, "reverse_proxy_certificate_common_names")

    @reverse_proxy_certificate_common_names.setter
    def reverse_proxy_certificate_common_names(self, value: Optional[pulumi.Input['ClusterReverseProxyCertificateCommonNamesArgs']]):
        pulumi.set(self, "reverse_proxy_certificate_common_names", value)

    @_builtins.property
    @pulumi.getter(name="serviceFabricZonalUpgradeMode")
    def service_fabric_zonal_upgrade_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the logical grouping of VMs in upgrade domains. Possible values are `Hierarchical` or `Parallel`.
        """
        return pulumi.get(self, "service_fabric_zonal_upgrade_mode")

    @service_fabric_zonal_upgrade_mode.setter
    def service_fabric_zonal_upgrade_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_fabric_zonal_upgrade_mode", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="upgradeMode")
    def upgrade_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Upgrade Mode of the cluster. Possible values are `Automatic` or `Manual`.
        """
        return pulumi.get(self, "upgrade_mode")

    @upgrade_mode.setter
    def upgrade_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "upgrade_mode", value)

    @_builtins.property
    @pulumi.getter(name="upgradePolicy")
    def upgrade_policy(self) -> Optional[pulumi.Input['ClusterUpgradePolicyArgs']]:
        """
        A `upgrade_policy` block as defined below.
        """
        return pulumi.get(self, "upgrade_policy")

    @upgrade_policy.setter
    def upgrade_policy(self, value: Optional[pulumi.Input['ClusterUpgradePolicyArgs']]):
        pulumi.set(self, "upgrade_policy", value)

    @_builtins.property
    @pulumi.getter(name="vmImage")
    def vm_image(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Image expected for the Service Fabric Cluster, such as `Windows`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vm_image")

    @vm_image.setter
    def vm_image(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_image", value)

    @_builtins.property
    @pulumi.getter(name="vmssZonalUpgradeMode")
    def vmss_zonal_upgrade_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the upgrade mode for the virtual machine scale set updates that happen in all availability zones at once. Possible values are `Hierarchical` or `Parallel`.
        """
        return pulumi.get(self, "vmss_zonal_upgrade_mode")

    @vmss_zonal_upgrade_mode.setter
    def vmss_zonal_upgrade_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vmss_zonal_upgrade_mode", value)


@pulumi.type_token("azure:servicefabric/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 add_on_features: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 azure_active_directory: Optional[pulumi.Input[Union['ClusterAzureActiveDirectoryArgs', 'ClusterAzureActiveDirectoryArgsDict']]] = None,
                 certificate: Optional[pulumi.Input[Union['ClusterCertificateArgs', 'ClusterCertificateArgsDict']]] = None,
                 certificate_common_names: Optional[pulumi.Input[Union['ClusterCertificateCommonNamesArgs', 'ClusterCertificateCommonNamesArgsDict']]] = None,
                 client_certificate_common_names: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterClientCertificateCommonNameArgs', 'ClusterClientCertificateCommonNameArgsDict']]]]] = None,
                 client_certificate_thumbprints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterClientCertificateThumbprintArgs', 'ClusterClientCertificateThumbprintArgsDict']]]]] = None,
                 cluster_code_version: Optional[pulumi.Input[_builtins.str]] = None,
                 diagnostics_config: Optional[pulumi.Input[Union['ClusterDiagnosticsConfigArgs', 'ClusterDiagnosticsConfigArgsDict']]] = None,
                 fabric_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterFabricSettingArgs', 'ClusterFabricSettingArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 management_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_types: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterNodeTypeArgs', 'ClusterNodeTypeArgsDict']]]]] = None,
                 reliability_level: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 reverse_proxy_certificate: Optional[pulumi.Input[Union['ClusterReverseProxyCertificateArgs', 'ClusterReverseProxyCertificateArgsDict']]] = None,
                 reverse_proxy_certificate_common_names: Optional[pulumi.Input[Union['ClusterReverseProxyCertificateCommonNamesArgs', 'ClusterReverseProxyCertificateCommonNamesArgsDict']]] = None,
                 service_fabric_zonal_upgrade_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 upgrade_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 upgrade_policy: Optional[pulumi.Input[Union['ClusterUpgradePolicyArgs', 'ClusterUpgradePolicyArgsDict']]] = None,
                 vm_image: Optional[pulumi.Input[_builtins.str]] = None,
                 vmss_zonal_upgrade_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Service Fabric Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_cluster = azure.servicefabric.Cluster("example",
            name="example-servicefabric",
            resource_group_name=example.name,
            location=example.location,
            reliability_level="Bronze",
            upgrade_mode="Manual",
            cluster_code_version="7.1.456.959",
            vm_image="Windows",
            management_endpoint="https://example:80",
            node_types=[{
                "name": "first",
                "instance_count": 3,
                "is_primary": True,
                "client_endpoint_port": 2020,
                "http_endpoint_port": 80,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ServiceFabric` - 2021-06-01

        ## Import

        Service Fabric Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:servicefabric/cluster:Cluster cluster1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ServiceFabric/clusters/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] add_on_features: A List of one or more features which should be enabled, such as `DnsService`.
        :param pulumi.Input[Union['ClusterAzureActiveDirectoryArgs', 'ClusterAzureActiveDirectoryArgsDict']] azure_active_directory: An `azure_active_directory` block as defined below.
        :param pulumi.Input[Union['ClusterCertificateArgs', 'ClusterCertificateArgsDict']] certificate: A `certificate` block as defined below. Conflicts with `certificate_common_names`.
        :param pulumi.Input[Union['ClusterCertificateCommonNamesArgs', 'ClusterCertificateCommonNamesArgsDict']] certificate_common_names: A `certificate_common_names` block as defined below. Conflicts with `certificate`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterClientCertificateCommonNameArgs', 'ClusterClientCertificateCommonNameArgsDict']]]] client_certificate_common_names: A `client_certificate_common_name` block as defined below.
               
               > **Note:** If Client Certificates are enabled then at a Certificate must be configured on the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterClientCertificateThumbprintArgs', 'ClusterClientCertificateThumbprintArgsDict']]]] client_certificate_thumbprints: One or more `client_certificate_thumbprint` blocks as defined below.
        :param pulumi.Input[_builtins.str] cluster_code_version: Required if Upgrade Mode set to `Manual`, Specifies the Version of the Cluster Code of the cluster.
        :param pulumi.Input[Union['ClusterDiagnosticsConfigArgs', 'ClusterDiagnosticsConfigArgsDict']] diagnostics_config: A `diagnostics_config` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterFabricSettingArgs', 'ClusterFabricSettingArgsDict']]]] fabric_settings: One or more `fabric_settings` blocks as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Service Fabric Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] management_endpoint: Specifies the Management Endpoint of the cluster such as `http://example.com`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Service Fabric Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterNodeTypeArgs', 'ClusterNodeTypeArgsDict']]]] node_types: One or more `node_type` blocks as defined below.
        :param pulumi.Input[_builtins.str] reliability_level: Specifies the Reliability Level of the Cluster. Possible values include `None`, `Bronze`, `Silver`, `Gold` and `Platinum`.
               
               > **Note:** The Reliability Level of the Cluster depends on the number of nodes in the Cluster: `Platinum` requires at least 9 VM's, `Gold` requires at least 7 VM's, `Silver` requires at least 5 VM's, `Bronze` requires at least 3 VM's.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Service Fabric Cluster exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ClusterReverseProxyCertificateArgs', 'ClusterReverseProxyCertificateArgsDict']] reverse_proxy_certificate: A `reverse_proxy_certificate` block as defined below. Conflicts with `reverse_proxy_certificate_common_names`.
        :param pulumi.Input[Union['ClusterReverseProxyCertificateCommonNamesArgs', 'ClusterReverseProxyCertificateCommonNamesArgsDict']] reverse_proxy_certificate_common_names: A `reverse_proxy_certificate_common_names` block as defined below. Conflicts with `reverse_proxy_certificate`.
        :param pulumi.Input[_builtins.str] service_fabric_zonal_upgrade_mode: Specifies the logical grouping of VMs in upgrade domains. Possible values are `Hierarchical` or `Parallel`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] upgrade_mode: Specifies the Upgrade Mode of the cluster. Possible values are `Automatic` or `Manual`.
        :param pulumi.Input[Union['ClusterUpgradePolicyArgs', 'ClusterUpgradePolicyArgsDict']] upgrade_policy: A `upgrade_policy` block as defined below.
        :param pulumi.Input[_builtins.str] vm_image: Specifies the Image expected for the Service Fabric Cluster, such as `Windows`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] vmss_zonal_upgrade_mode: Specifies the upgrade mode for the virtual machine scale set updates that happen in all availability zones at once. Possible values are `Hierarchical` or `Parallel`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Service Fabric Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_cluster = azure.servicefabric.Cluster("example",
            name="example-servicefabric",
            resource_group_name=example.name,
            location=example.location,
            reliability_level="Bronze",
            upgrade_mode="Manual",
            cluster_code_version="7.1.456.959",
            vm_image="Windows",
            management_endpoint="https://example:80",
            node_types=[{
                "name": "first",
                "instance_count": 3,
                "is_primary": True,
                "client_endpoint_port": 2020,
                "http_endpoint_port": 80,
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ServiceFabric` - 2021-06-01

        ## Import

        Service Fabric Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:servicefabric/cluster:Cluster cluster1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ServiceFabric/clusters/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 add_on_features: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 azure_active_directory: Optional[pulumi.Input[Union['ClusterAzureActiveDirectoryArgs', 'ClusterAzureActiveDirectoryArgsDict']]] = None,
                 certificate: Optional[pulumi.Input[Union['ClusterCertificateArgs', 'ClusterCertificateArgsDict']]] = None,
                 certificate_common_names: Optional[pulumi.Input[Union['ClusterCertificateCommonNamesArgs', 'ClusterCertificateCommonNamesArgsDict']]] = None,
                 client_certificate_common_names: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterClientCertificateCommonNameArgs', 'ClusterClientCertificateCommonNameArgsDict']]]]] = None,
                 client_certificate_thumbprints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterClientCertificateThumbprintArgs', 'ClusterClientCertificateThumbprintArgsDict']]]]] = None,
                 cluster_code_version: Optional[pulumi.Input[_builtins.str]] = None,
                 diagnostics_config: Optional[pulumi.Input[Union['ClusterDiagnosticsConfigArgs', 'ClusterDiagnosticsConfigArgsDict']]] = None,
                 fabric_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterFabricSettingArgs', 'ClusterFabricSettingArgsDict']]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 management_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_types: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterNodeTypeArgs', 'ClusterNodeTypeArgsDict']]]]] = None,
                 reliability_level: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 reverse_proxy_certificate: Optional[pulumi.Input[Union['ClusterReverseProxyCertificateArgs', 'ClusterReverseProxyCertificateArgsDict']]] = None,
                 reverse_proxy_certificate_common_names: Optional[pulumi.Input[Union['ClusterReverseProxyCertificateCommonNamesArgs', 'ClusterReverseProxyCertificateCommonNamesArgsDict']]] = None,
                 service_fabric_zonal_upgrade_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 upgrade_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 upgrade_policy: Optional[pulumi.Input[Union['ClusterUpgradePolicyArgs', 'ClusterUpgradePolicyArgsDict']]] = None,
                 vm_image: Optional[pulumi.Input[_builtins.str]] = None,
                 vmss_zonal_upgrade_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["add_on_features"] = add_on_features
            __props__.__dict__["azure_active_directory"] = azure_active_directory
            __props__.__dict__["certificate"] = certificate
            __props__.__dict__["certificate_common_names"] = certificate_common_names
            __props__.__dict__["client_certificate_common_names"] = client_certificate_common_names
            __props__.__dict__["client_certificate_thumbprints"] = client_certificate_thumbprints
            __props__.__dict__["cluster_code_version"] = cluster_code_version
            __props__.__dict__["diagnostics_config"] = diagnostics_config
            __props__.__dict__["fabric_settings"] = fabric_settings
            __props__.__dict__["location"] = location
            if management_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'management_endpoint'")
            __props__.__dict__["management_endpoint"] = management_endpoint
            __props__.__dict__["name"] = name
            if node_types is None and not opts.urn:
                raise TypeError("Missing required property 'node_types'")
            __props__.__dict__["node_types"] = node_types
            if reliability_level is None and not opts.urn:
                raise TypeError("Missing required property 'reliability_level'")
            __props__.__dict__["reliability_level"] = reliability_level
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["reverse_proxy_certificate"] = reverse_proxy_certificate
            __props__.__dict__["reverse_proxy_certificate_common_names"] = reverse_proxy_certificate_common_names
            __props__.__dict__["service_fabric_zonal_upgrade_mode"] = service_fabric_zonal_upgrade_mode
            __props__.__dict__["tags"] = tags
            if upgrade_mode is None and not opts.urn:
                raise TypeError("Missing required property 'upgrade_mode'")
            __props__.__dict__["upgrade_mode"] = upgrade_mode
            __props__.__dict__["upgrade_policy"] = upgrade_policy
            if vm_image is None and not opts.urn:
                raise TypeError("Missing required property 'vm_image'")
            __props__.__dict__["vm_image"] = vm_image
            __props__.__dict__["vmss_zonal_upgrade_mode"] = vmss_zonal_upgrade_mode
            __props__.__dict__["cluster_endpoint"] = None
        super(Cluster, __self__).__init__(
            'azure:servicefabric/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            add_on_features: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            azure_active_directory: Optional[pulumi.Input[Union['ClusterAzureActiveDirectoryArgs', 'ClusterAzureActiveDirectoryArgsDict']]] = None,
            certificate: Optional[pulumi.Input[Union['ClusterCertificateArgs', 'ClusterCertificateArgsDict']]] = None,
            certificate_common_names: Optional[pulumi.Input[Union['ClusterCertificateCommonNamesArgs', 'ClusterCertificateCommonNamesArgsDict']]] = None,
            client_certificate_common_names: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterClientCertificateCommonNameArgs', 'ClusterClientCertificateCommonNameArgsDict']]]]] = None,
            client_certificate_thumbprints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterClientCertificateThumbprintArgs', 'ClusterClientCertificateThumbprintArgsDict']]]]] = None,
            cluster_code_version: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            diagnostics_config: Optional[pulumi.Input[Union['ClusterDiagnosticsConfigArgs', 'ClusterDiagnosticsConfigArgsDict']]] = None,
            fabric_settings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterFabricSettingArgs', 'ClusterFabricSettingArgsDict']]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            management_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            node_types: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterNodeTypeArgs', 'ClusterNodeTypeArgsDict']]]]] = None,
            reliability_level: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            reverse_proxy_certificate: Optional[pulumi.Input[Union['ClusterReverseProxyCertificateArgs', 'ClusterReverseProxyCertificateArgsDict']]] = None,
            reverse_proxy_certificate_common_names: Optional[pulumi.Input[Union['ClusterReverseProxyCertificateCommonNamesArgs', 'ClusterReverseProxyCertificateCommonNamesArgsDict']]] = None,
            service_fabric_zonal_upgrade_mode: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            upgrade_mode: Optional[pulumi.Input[_builtins.str]] = None,
            upgrade_policy: Optional[pulumi.Input[Union['ClusterUpgradePolicyArgs', 'ClusterUpgradePolicyArgsDict']]] = None,
            vm_image: Optional[pulumi.Input[_builtins.str]] = None,
            vmss_zonal_upgrade_mode: Optional[pulumi.Input[_builtins.str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] add_on_features: A List of one or more features which should be enabled, such as `DnsService`.
        :param pulumi.Input[Union['ClusterAzureActiveDirectoryArgs', 'ClusterAzureActiveDirectoryArgsDict']] azure_active_directory: An `azure_active_directory` block as defined below.
        :param pulumi.Input[Union['ClusterCertificateArgs', 'ClusterCertificateArgsDict']] certificate: A `certificate` block as defined below. Conflicts with `certificate_common_names`.
        :param pulumi.Input[Union['ClusterCertificateCommonNamesArgs', 'ClusterCertificateCommonNamesArgsDict']] certificate_common_names: A `certificate_common_names` block as defined below. Conflicts with `certificate`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterClientCertificateCommonNameArgs', 'ClusterClientCertificateCommonNameArgsDict']]]] client_certificate_common_names: A `client_certificate_common_name` block as defined below.
               
               > **Note:** If Client Certificates are enabled then at a Certificate must be configured on the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterClientCertificateThumbprintArgs', 'ClusterClientCertificateThumbprintArgsDict']]]] client_certificate_thumbprints: One or more `client_certificate_thumbprint` blocks as defined below.
        :param pulumi.Input[_builtins.str] cluster_code_version: Required if Upgrade Mode set to `Manual`, Specifies the Version of the Cluster Code of the cluster.
        :param pulumi.Input[_builtins.str] cluster_endpoint: The Cluster Endpoint for this Service Fabric Cluster.
        :param pulumi.Input[Union['ClusterDiagnosticsConfigArgs', 'ClusterDiagnosticsConfigArgsDict']] diagnostics_config: A `diagnostics_config` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterFabricSettingArgs', 'ClusterFabricSettingArgsDict']]]] fabric_settings: One or more `fabric_settings` blocks as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Service Fabric Cluster should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] management_endpoint: Specifies the Management Endpoint of the cluster such as `http://example.com`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Service Fabric Cluster. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterNodeTypeArgs', 'ClusterNodeTypeArgsDict']]]] node_types: One or more `node_type` blocks as defined below.
        :param pulumi.Input[_builtins.str] reliability_level: Specifies the Reliability Level of the Cluster. Possible values include `None`, `Bronze`, `Silver`, `Gold` and `Platinum`.
               
               > **Note:** The Reliability Level of the Cluster depends on the number of nodes in the Cluster: `Platinum` requires at least 9 VM's, `Gold` requires at least 7 VM's, `Silver` requires at least 5 VM's, `Bronze` requires at least 3 VM's.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group in which the Service Fabric Cluster exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ClusterReverseProxyCertificateArgs', 'ClusterReverseProxyCertificateArgsDict']] reverse_proxy_certificate: A `reverse_proxy_certificate` block as defined below. Conflicts with `reverse_proxy_certificate_common_names`.
        :param pulumi.Input[Union['ClusterReverseProxyCertificateCommonNamesArgs', 'ClusterReverseProxyCertificateCommonNamesArgsDict']] reverse_proxy_certificate_common_names: A `reverse_proxy_certificate_common_names` block as defined below. Conflicts with `reverse_proxy_certificate`.
        :param pulumi.Input[_builtins.str] service_fabric_zonal_upgrade_mode: Specifies the logical grouping of VMs in upgrade domains. Possible values are `Hierarchical` or `Parallel`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] upgrade_mode: Specifies the Upgrade Mode of the cluster. Possible values are `Automatic` or `Manual`.
        :param pulumi.Input[Union['ClusterUpgradePolicyArgs', 'ClusterUpgradePolicyArgsDict']] upgrade_policy: A `upgrade_policy` block as defined below.
        :param pulumi.Input[_builtins.str] vm_image: Specifies the Image expected for the Service Fabric Cluster, such as `Windows`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] vmss_zonal_upgrade_mode: Specifies the upgrade mode for the virtual machine scale set updates that happen in all availability zones at once. Possible values are `Hierarchical` or `Parallel`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["add_on_features"] = add_on_features
        __props__.__dict__["azure_active_directory"] = azure_active_directory
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["certificate_common_names"] = certificate_common_names
        __props__.__dict__["client_certificate_common_names"] = client_certificate_common_names
        __props__.__dict__["client_certificate_thumbprints"] = client_certificate_thumbprints
        __props__.__dict__["cluster_code_version"] = cluster_code_version
        __props__.__dict__["cluster_endpoint"] = cluster_endpoint
        __props__.__dict__["diagnostics_config"] = diagnostics_config
        __props__.__dict__["fabric_settings"] = fabric_settings
        __props__.__dict__["location"] = location
        __props__.__dict__["management_endpoint"] = management_endpoint
        __props__.__dict__["name"] = name
        __props__.__dict__["node_types"] = node_types
        __props__.__dict__["reliability_level"] = reliability_level
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["reverse_proxy_certificate"] = reverse_proxy_certificate
        __props__.__dict__["reverse_proxy_certificate_common_names"] = reverse_proxy_certificate_common_names
        __props__.__dict__["service_fabric_zonal_upgrade_mode"] = service_fabric_zonal_upgrade_mode
        __props__.__dict__["tags"] = tags
        __props__.__dict__["upgrade_mode"] = upgrade_mode
        __props__.__dict__["upgrade_policy"] = upgrade_policy
        __props__.__dict__["vm_image"] = vm_image
        __props__.__dict__["vmss_zonal_upgrade_mode"] = vmss_zonal_upgrade_mode
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="addOnFeatures")
    def add_on_features(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A List of one or more features which should be enabled, such as `DnsService`.
        """
        return pulumi.get(self, "add_on_features")

    @_builtins.property
    @pulumi.getter(name="azureActiveDirectory")
    def azure_active_directory(self) -> pulumi.Output[Optional['outputs.ClusterAzureActiveDirectory']]:
        """
        An `azure_active_directory` block as defined below.
        """
        return pulumi.get(self, "azure_active_directory")

    @_builtins.property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[Optional['outputs.ClusterCertificate']]:
        """
        A `certificate` block as defined below. Conflicts with `certificate_common_names`.
        """
        return pulumi.get(self, "certificate")

    @_builtins.property
    @pulumi.getter(name="certificateCommonNames")
    def certificate_common_names(self) -> pulumi.Output[Optional['outputs.ClusterCertificateCommonNames']]:
        """
        A `certificate_common_names` block as defined below. Conflicts with `certificate`.
        """
        return pulumi.get(self, "certificate_common_names")

    @_builtins.property
    @pulumi.getter(name="clientCertificateCommonNames")
    def client_certificate_common_names(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterClientCertificateCommonName']]]:
        """
        A `client_certificate_common_name` block as defined below.

        > **Note:** If Client Certificates are enabled then at a Certificate must be configured on the cluster.
        """
        return pulumi.get(self, "client_certificate_common_names")

    @_builtins.property
    @pulumi.getter(name="clientCertificateThumbprints")
    def client_certificate_thumbprints(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterClientCertificateThumbprint']]]:
        """
        One or more `client_certificate_thumbprint` blocks as defined below.
        """
        return pulumi.get(self, "client_certificate_thumbprints")

    @_builtins.property
    @pulumi.getter(name="clusterCodeVersion")
    def cluster_code_version(self) -> pulumi.Output[_builtins.str]:
        """
        Required if Upgrade Mode set to `Manual`, Specifies the Version of the Cluster Code of the cluster.
        """
        return pulumi.get(self, "cluster_code_version")

    @_builtins.property
    @pulumi.getter(name="clusterEndpoint")
    def cluster_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The Cluster Endpoint for this Service Fabric Cluster.
        """
        return pulumi.get(self, "cluster_endpoint")

    @_builtins.property
    @pulumi.getter(name="diagnosticsConfig")
    def diagnostics_config(self) -> pulumi.Output[Optional['outputs.ClusterDiagnosticsConfig']]:
        """
        A `diagnostics_config` block as defined below.
        """
        return pulumi.get(self, "diagnostics_config")

    @_builtins.property
    @pulumi.getter(name="fabricSettings")
    def fabric_settings(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterFabricSetting']]]:
        """
        One or more `fabric_settings` blocks as defined below.
        """
        return pulumi.get(self, "fabric_settings")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Azure Region where the Service Fabric Cluster should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="managementEndpoint")
    def management_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Management Endpoint of the cluster such as `http://example.com`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "management_endpoint")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Service Fabric Cluster. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodeTypes")
    def node_types(self) -> pulumi.Output[Sequence['outputs.ClusterNodeType']]:
        """
        One or more `node_type` blocks as defined below.
        """
        return pulumi.get(self, "node_types")

    @_builtins.property
    @pulumi.getter(name="reliabilityLevel")
    def reliability_level(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Reliability Level of the Cluster. Possible values include `None`, `Bronze`, `Silver`, `Gold` and `Platinum`.

        > **Note:** The Reliability Level of the Cluster depends on the number of nodes in the Cluster: `Platinum` requires at least 9 VM's, `Gold` requires at least 7 VM's, `Silver` requires at least 5 VM's, `Bronze` requires at least 3 VM's.
        """
        return pulumi.get(self, "reliability_level")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group in which the Service Fabric Cluster exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="reverseProxyCertificate")
    def reverse_proxy_certificate(self) -> pulumi.Output[Optional['outputs.ClusterReverseProxyCertificate']]:
        """
        A `reverse_proxy_certificate` block as defined below. Conflicts with `reverse_proxy_certificate_common_names`.
        """
        return pulumi.get(self, "reverse_proxy_certificate")

    @_builtins.property
    @pulumi.getter(name="reverseProxyCertificateCommonNames")
    def reverse_proxy_certificate_common_names(self) -> pulumi.Output[Optional['outputs.ClusterReverseProxyCertificateCommonNames']]:
        """
        A `reverse_proxy_certificate_common_names` block as defined below. Conflicts with `reverse_proxy_certificate`.
        """
        return pulumi.get(self, "reverse_proxy_certificate_common_names")

    @_builtins.property
    @pulumi.getter(name="serviceFabricZonalUpgradeMode")
    def service_fabric_zonal_upgrade_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the logical grouping of VMs in upgrade domains. Possible values are `Hierarchical` or `Parallel`.
        """
        return pulumi.get(self, "service_fabric_zonal_upgrade_mode")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="upgradeMode")
    def upgrade_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Upgrade Mode of the cluster. Possible values are `Automatic` or `Manual`.
        """
        return pulumi.get(self, "upgrade_mode")

    @_builtins.property
    @pulumi.getter(name="upgradePolicy")
    def upgrade_policy(self) -> pulumi.Output[Optional['outputs.ClusterUpgradePolicy']]:
        """
        A `upgrade_policy` block as defined below.
        """
        return pulumi.get(self, "upgrade_policy")

    @_builtins.property
    @pulumi.getter(name="vmImage")
    def vm_image(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Image expected for the Service Fabric Cluster, such as `Windows`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vm_image")

    @_builtins.property
    @pulumi.getter(name="vmssZonalUpgradeMode")
    def vmss_zonal_upgrade_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the upgrade mode for the virtual machine scale set updates that happen in all availability zones at once. Possible values are `Hierarchical` or `Parallel`.
        """
        return pulumi.get(self, "vmss_zonal_upgrade_mode")

