# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSyncResult',
    'AwaitableGetSyncResult',
    'get_sync',
    'get_sync_output',
]

@pulumi.output_type
class GetSyncResult:
    """
    A collection of values returned by getSync.
    """
    def __init__(__self__, id=None, incoming_traffic_policy=None, location=None, name=None, resource_group_name=None, tags=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if incoming_traffic_policy and not isinstance(incoming_traffic_policy, str):
            raise TypeError("Expected argument 'incoming_traffic_policy' to be a str")
        pulumi.set(__self__, "incoming_traffic_policy", incoming_traffic_policy)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="incomingTrafficPolicy")
    def incoming_traffic_policy(self) -> _builtins.str:
        """
        Incoming traffic policy.
        """
        return pulumi.get(self, "incoming_traffic_policy")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Storage Sync exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the Storage Sync.
        """
        return pulumi.get(self, "tags")


class AwaitableGetSyncResult(GetSyncResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSyncResult(
            id=self.id,
            incoming_traffic_policy=self.incoming_traffic_policy,
            location=self.location,
            name=self.name,
            resource_group_name=self.resource_group_name,
            tags=self.tags)


def get_sync(name: Optional[_builtins.str] = None,
             resource_group_name: Optional[_builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSyncResult:
    """
    Use this data source to access information about an existing Storage Sync.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.storage.get_sync(name="existingStorageSyncName",
        resource_group_name="existingResGroup")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.StorageSync` - 2020-03-01


    :param _builtins.str name: The name of this Storage Sync.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Storage Sync exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:storage/getSync:getSync', __args__, opts=opts, typ=GetSyncResult).value

    return AwaitableGetSyncResult(
        id=pulumi.get(__ret__, 'id'),
        incoming_traffic_policy=pulumi.get(__ret__, 'incoming_traffic_policy'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_sync_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                    resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSyncResult]:
    """
    Use this data source to access information about an existing Storage Sync.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.storage.get_sync(name="existingStorageSyncName",
        resource_group_name="existingResGroup")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.StorageSync` - 2020-03-01


    :param _builtins.str name: The name of this Storage Sync.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Storage Sync exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:storage/getSync:getSync', __args__, opts=opts, typ=GetSyncResult)
    return __ret__.apply(lambda __response__: GetSyncResult(
        id=pulumi.get(__response__, 'id'),
        incoming_traffic_policy=pulumi.get(__response__, 'incoming_traffic_policy'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags')))
