# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MoverSourceEndpointArgs', 'MoverSourceEndpoint']

@pulumi.input_type
class MoverSourceEndpointArgs:
    def __init__(__self__, *,
                 host: pulumi.Input[_builtins.str],
                 storage_mover_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 export: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nfs_version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MoverSourceEndpoint resource.
        :param pulumi.Input[_builtins.str] host: Specifies the host name or IP address of the server exporting the file system. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_mover_id: Specifies the ID of the Storage Mover for this Storage Mover Source Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: Specifies a description for the Storage Mover Source Endpoint.
        :param pulumi.Input[_builtins.str] export: Specifies the directory being exported from the server. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Storage Mover Source Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] nfs_version: Specifies the NFS protocol version. Possible values are `NFSauto`, `NFSv3` and `NFSv4`. Defaults to `NFSauto`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "storage_mover_id", storage_mover_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if export is not None:
            pulumi.set(__self__, "export", export)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nfs_version is not None:
            pulumi.set(__self__, "nfs_version", nfs_version)

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the host name or IP address of the server exporting the file system. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter(name="storageMoverId")
    def storage_mover_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the Storage Mover for this Storage Mover Source Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_mover_id")

    @storage_mover_id.setter
    def storage_mover_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_mover_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a description for the Storage Mover Source Endpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def export(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the directory being exported from the server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "export")

    @export.setter
    def export(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "export", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Storage Mover Source Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nfsVersion")
    def nfs_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the NFS protocol version. Possible values are `NFSauto`, `NFSv3` and `NFSv4`. Defaults to `NFSauto`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "nfs_version")

    @nfs_version.setter
    def nfs_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nfs_version", value)


@pulumi.input_type
class _MoverSourceEndpointState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 export: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nfs_version: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_mover_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MoverSourceEndpoint resources.
        :param pulumi.Input[_builtins.str] description: Specifies a description for the Storage Mover Source Endpoint.
        :param pulumi.Input[_builtins.str] export: Specifies the directory being exported from the server. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] host: Specifies the host name or IP address of the server exporting the file system. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Storage Mover Source Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] nfs_version: Specifies the NFS protocol version. Possible values are `NFSauto`, `NFSv3` and `NFSv4`. Defaults to `NFSauto`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_mover_id: Specifies the ID of the Storage Mover for this Storage Mover Source Endpoint. Changing this forces a new resource to be created.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if export is not None:
            pulumi.set(__self__, "export", export)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nfs_version is not None:
            pulumi.set(__self__, "nfs_version", nfs_version)
        if storage_mover_id is not None:
            pulumi.set(__self__, "storage_mover_id", storage_mover_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a description for the Storage Mover Source Endpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def export(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the directory being exported from the server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "export")

    @export.setter
    def export(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "export", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the host name or IP address of the server exporting the file system. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this Storage Mover Source Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nfsVersion")
    def nfs_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the NFS protocol version. Possible values are `NFSauto`, `NFSv3` and `NFSv4`. Defaults to `NFSauto`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "nfs_version")

    @nfs_version.setter
    def nfs_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nfs_version", value)

    @_builtins.property
    @pulumi.getter(name="storageMoverId")
    def storage_mover_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the Storage Mover for this Storage Mover Source Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_mover_id")

    @storage_mover_id.setter
    def storage_mover_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_mover_id", value)


@pulumi.type_token("azure:storage/moverSourceEndpoint:MoverSourceEndpoint")
class MoverSourceEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 export: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nfs_version: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_mover_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Storage Mover Source Endpoint.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_mover = azure.storage.Mover("example",
            name="example-ssm",
            resource_group_name=example.name,
            location="West Europe")
        example_mover_source_endpoint = azure.storage.MoverSourceEndpoint("example",
            name="example-se",
            storage_mover_id=example_mover.id,
            export="/",
            host="192.168.0.1",
            nfs_version="NFSv3")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StorageMover` - 2023-03-01

        ## Import

        Storage Mover Source Endpoint can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/moverSourceEndpoint:MoverSourceEndpoint example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.StorageMover/storageMovers/storageMover1/endpoints/endpoint1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies a description for the Storage Mover Source Endpoint.
        :param pulumi.Input[_builtins.str] export: Specifies the directory being exported from the server. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] host: Specifies the host name or IP address of the server exporting the file system. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Storage Mover Source Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] nfs_version: Specifies the NFS protocol version. Possible values are `NFSauto`, `NFSv3` and `NFSv4`. Defaults to `NFSauto`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_mover_id: Specifies the ID of the Storage Mover for this Storage Mover Source Endpoint. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MoverSourceEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Storage Mover Source Endpoint.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_mover = azure.storage.Mover("example",
            name="example-ssm",
            resource_group_name=example.name,
            location="West Europe")
        example_mover_source_endpoint = azure.storage.MoverSourceEndpoint("example",
            name="example-se",
            storage_mover_id=example_mover.id,
            export="/",
            host="192.168.0.1",
            nfs_version="NFSv3")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StorageMover` - 2023-03-01

        ## Import

        Storage Mover Source Endpoint can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:storage/moverSourceEndpoint:MoverSourceEndpoint example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.StorageMover/storageMovers/storageMover1/endpoints/endpoint1
        ```

        :param str resource_name: The name of the resource.
        :param MoverSourceEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MoverSourceEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 export: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nfs_version: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_mover_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MoverSourceEndpointArgs.__new__(MoverSourceEndpointArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["export"] = export
            if host is None and not opts.urn:
                raise TypeError("Missing required property 'host'")
            __props__.__dict__["host"] = host
            __props__.__dict__["name"] = name
            __props__.__dict__["nfs_version"] = nfs_version
            if storage_mover_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_mover_id'")
            __props__.__dict__["storage_mover_id"] = storage_mover_id
        super(MoverSourceEndpoint, __self__).__init__(
            'azure:storage/moverSourceEndpoint:MoverSourceEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            export: Optional[pulumi.Input[_builtins.str]] = None,
            host: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nfs_version: Optional[pulumi.Input[_builtins.str]] = None,
            storage_mover_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'MoverSourceEndpoint':
        """
        Get an existing MoverSourceEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies a description for the Storage Mover Source Endpoint.
        :param pulumi.Input[_builtins.str] export: Specifies the directory being exported from the server. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] host: Specifies the host name or IP address of the server exporting the file system. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this Storage Mover Source Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] nfs_version: Specifies the NFS protocol version. Possible values are `NFSauto`, `NFSv3` and `NFSv4`. Defaults to `NFSauto`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_mover_id: Specifies the ID of the Storage Mover for this Storage Mover Source Endpoint. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MoverSourceEndpointState.__new__(_MoverSourceEndpointState)

        __props__.__dict__["description"] = description
        __props__.__dict__["export"] = export
        __props__.__dict__["host"] = host
        __props__.__dict__["name"] = name
        __props__.__dict__["nfs_version"] = nfs_version
        __props__.__dict__["storage_mover_id"] = storage_mover_id
        return MoverSourceEndpoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a description for the Storage Mover Source Endpoint.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def export(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the directory being exported from the server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "export")

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the host name or IP address of the server exporting the file system. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name which should be used for this Storage Mover Source Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nfsVersion")
    def nfs_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the NFS protocol version. Possible values are `NFSauto`, `NFSv3` and `NFSv4`. Defaults to `NFSauto`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "nfs_version")

    @_builtins.property
    @pulumi.getter(name="storageMoverId")
    def storage_mover_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the Storage Mover for this Storage Mover Source Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_mover_id")

