# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'AccountAzureFilesAuthentication',
    'AccountAzureFilesAuthenticationActiveDirectory',
    'AccountBlobProperties',
    'AccountBlobPropertiesContainerDeleteRetentionPolicy',
    'AccountBlobPropertiesCorsRule',
    'AccountBlobPropertiesDeleteRetentionPolicy',
    'AccountBlobPropertiesRestorePolicy',
    'AccountCustomDomain',
    'AccountCustomerManagedKey',
    'AccountIdentity',
    'AccountImmutabilityPolicy',
    'AccountNetworkRules',
    'AccountNetworkRulesPrivateLinkAccess',
    'AccountNetworkRulesPrivateLinkAccessRule',
    'AccountQueueProperties',
    'AccountQueuePropertiesCorsRule',
    'AccountQueuePropertiesHourMetrics',
    'AccountQueuePropertiesLogging',
    'AccountQueuePropertiesMinuteMetrics',
    'AccountRouting',
    'AccountSasPolicy',
    'AccountShareProperties',
    'AccountSharePropertiesCorsRule',
    'AccountSharePropertiesRetentionPolicy',
    'AccountSharePropertiesSmb',
    'AccountStaticWebsite',
    'BlobInventoryPolicyRule',
    'BlobInventoryPolicyRuleFilter',
    'DataLakeGen2FilesystemAce',
    'DataLakeGen2PathAce',
    'LocalUserPermissionScope',
    'LocalUserPermissionScopePermissions',
    'LocalUserSshAuthorizedKey',
    'ManagementPolicyRule',
    'ManagementPolicyRuleActions',
    'ManagementPolicyRuleActionsBaseBlob',
    'ManagementPolicyRuleActionsSnapshot',
    'ManagementPolicyRuleActionsVersion',
    'ManagementPolicyRuleFilters',
    'ManagementPolicyRuleFiltersMatchBlobIndexTag',
    'ObjectReplicationRule',
    'ShareAcl',
    'ShareAclAccessPolicy',
    'TableAcl',
    'TableAclAccessPolicy',
    'GetAccountAzureFilesAuthenticationResult',
    'GetAccountAzureFilesAuthenticationActiveDirectoryResult',
    'GetAccountBlobContainerSASPermissionsResult',
    'GetAccountCustomDomainResult',
    'GetAccountIdentityResult',
    'GetAccountSASPermissionsResult',
    'GetAccountSASResourceTypesResult',
    'GetAccountSASServicesResult',
    'GetContainersContainerResult',
    'GetPolicyRuleResult',
    'GetPolicyRuleActionResult',
    'GetPolicyRuleActionBaseBlobResult',
    'GetPolicyRuleActionSnapshotResult',
    'GetPolicyRuleActionVersionResult',
    'GetPolicyRuleFilterResult',
    'GetPolicyRuleFilterMatchBlobIndexTagResult',
    'GetShareAclResult',
    'GetShareAclAccessPolicyResult',
    'GetTableAclResult',
    'GetTableAclAccessPolicyResult',
    'GetTableEntitiesItemResult',
]

@pulumi.output_type
class AccountAzureFilesAuthentication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "directoryType":
            suggest = "directory_type"
        elif key == "activeDirectory":
            suggest = "active_directory"
        elif key == "defaultShareLevelPermission":
            suggest = "default_share_level_permission"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountAzureFilesAuthentication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountAzureFilesAuthentication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountAzureFilesAuthentication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 directory_type: _builtins.str,
                 active_directory: Optional['outputs.AccountAzureFilesAuthenticationActiveDirectory'] = None,
                 default_share_level_permission: Optional[_builtins.str] = None):
        """
        :param _builtins.str directory_type: Specifies the directory service used. Possible values are `AADDS`, `AD` and `AADKERB`.
        :param 'AccountAzureFilesAuthenticationActiveDirectoryArgs' active_directory: A `active_directory` block as defined below. Required when `directory_type` is `AD`.
        :param _builtins.str default_share_level_permission: Specifies the default share level permissions applied to all users. Possible values are `StorageFileDataSmbShareReader`, `StorageFileDataSmbShareContributor`, `StorageFileDataSmbShareElevatedContributor`, or `None`.
        """
        pulumi.set(__self__, "directory_type", directory_type)
        if active_directory is not None:
            pulumi.set(__self__, "active_directory", active_directory)
        if default_share_level_permission is not None:
            pulumi.set(__self__, "default_share_level_permission", default_share_level_permission)

    @_builtins.property
    @pulumi.getter(name="directoryType")
    def directory_type(self) -> _builtins.str:
        """
        Specifies the directory service used. Possible values are `AADDS`, `AD` and `AADKERB`.
        """
        return pulumi.get(self, "directory_type")

    @_builtins.property
    @pulumi.getter(name="activeDirectory")
    def active_directory(self) -> Optional['outputs.AccountAzureFilesAuthenticationActiveDirectory']:
        """
        A `active_directory` block as defined below. Required when `directory_type` is `AD`.
        """
        return pulumi.get(self, "active_directory")

    @_builtins.property
    @pulumi.getter(name="defaultShareLevelPermission")
    def default_share_level_permission(self) -> Optional[_builtins.str]:
        """
        Specifies the default share level permissions applied to all users. Possible values are `StorageFileDataSmbShareReader`, `StorageFileDataSmbShareContributor`, `StorageFileDataSmbShareElevatedContributor`, or `None`.
        """
        return pulumi.get(self, "default_share_level_permission")


@pulumi.output_type
class AccountAzureFilesAuthenticationActiveDirectory(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainGuid":
            suggest = "domain_guid"
        elif key == "domainName":
            suggest = "domain_name"
        elif key == "domainSid":
            suggest = "domain_sid"
        elif key == "forestName":
            suggest = "forest_name"
        elif key == "netbiosDomainName":
            suggest = "netbios_domain_name"
        elif key == "storageSid":
            suggest = "storage_sid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountAzureFilesAuthenticationActiveDirectory. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountAzureFilesAuthenticationActiveDirectory.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountAzureFilesAuthenticationActiveDirectory.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_guid: _builtins.str,
                 domain_name: _builtins.str,
                 domain_sid: Optional[_builtins.str] = None,
                 forest_name: Optional[_builtins.str] = None,
                 netbios_domain_name: Optional[_builtins.str] = None,
                 storage_sid: Optional[_builtins.str] = None):
        """
        :param _builtins.str domain_guid: Specifies the domain GUID.
        :param _builtins.str domain_name: Specifies the primary domain that the AD DNS server is authoritative for.
        :param _builtins.str domain_sid: Specifies the security identifier (SID). This is required when `directory_type` is set to `AD`.
        :param _builtins.str forest_name: Specifies the Active Directory forest. This is required when `directory_type` is set to `AD`.
        :param _builtins.str netbios_domain_name: Specifies the NetBIOS domain name. This is required when `directory_type` is set to `AD`.
        :param _builtins.str storage_sid: Specifies the security identifier (SID) for Azure Storage. This is required when `directory_type` is set to `AD`.
        """
        pulumi.set(__self__, "domain_guid", domain_guid)
        pulumi.set(__self__, "domain_name", domain_name)
        if domain_sid is not None:
            pulumi.set(__self__, "domain_sid", domain_sid)
        if forest_name is not None:
            pulumi.set(__self__, "forest_name", forest_name)
        if netbios_domain_name is not None:
            pulumi.set(__self__, "netbios_domain_name", netbios_domain_name)
        if storage_sid is not None:
            pulumi.set(__self__, "storage_sid", storage_sid)

    @_builtins.property
    @pulumi.getter(name="domainGuid")
    def domain_guid(self) -> _builtins.str:
        """
        Specifies the domain GUID.
        """
        return pulumi.get(self, "domain_guid")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        """
        Specifies the primary domain that the AD DNS server is authoritative for.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="domainSid")
    def domain_sid(self) -> Optional[_builtins.str]:
        """
        Specifies the security identifier (SID). This is required when `directory_type` is set to `AD`.
        """
        return pulumi.get(self, "domain_sid")

    @_builtins.property
    @pulumi.getter(name="forestName")
    def forest_name(self) -> Optional[_builtins.str]:
        """
        Specifies the Active Directory forest. This is required when `directory_type` is set to `AD`.
        """
        return pulumi.get(self, "forest_name")

    @_builtins.property
    @pulumi.getter(name="netbiosDomainName")
    def netbios_domain_name(self) -> Optional[_builtins.str]:
        """
        Specifies the NetBIOS domain name. This is required when `directory_type` is set to `AD`.
        """
        return pulumi.get(self, "netbios_domain_name")

    @_builtins.property
    @pulumi.getter(name="storageSid")
    def storage_sid(self) -> Optional[_builtins.str]:
        """
        Specifies the security identifier (SID) for Azure Storage. This is required when `directory_type` is set to `AD`.
        """
        return pulumi.get(self, "storage_sid")


@pulumi.output_type
class AccountBlobProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "changeFeedEnabled":
            suggest = "change_feed_enabled"
        elif key == "changeFeedRetentionInDays":
            suggest = "change_feed_retention_in_days"
        elif key == "containerDeleteRetentionPolicy":
            suggest = "container_delete_retention_policy"
        elif key == "corsRules":
            suggest = "cors_rules"
        elif key == "defaultServiceVersion":
            suggest = "default_service_version"
        elif key == "deleteRetentionPolicy":
            suggest = "delete_retention_policy"
        elif key == "lastAccessTimeEnabled":
            suggest = "last_access_time_enabled"
        elif key == "restorePolicy":
            suggest = "restore_policy"
        elif key == "versioningEnabled":
            suggest = "versioning_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountBlobProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountBlobProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountBlobProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 change_feed_enabled: Optional[_builtins.bool] = None,
                 change_feed_retention_in_days: Optional[_builtins.int] = None,
                 container_delete_retention_policy: Optional['outputs.AccountBlobPropertiesContainerDeleteRetentionPolicy'] = None,
                 cors_rules: Optional[Sequence['outputs.AccountBlobPropertiesCorsRule']] = None,
                 default_service_version: Optional[_builtins.str] = None,
                 delete_retention_policy: Optional['outputs.AccountBlobPropertiesDeleteRetentionPolicy'] = None,
                 last_access_time_enabled: Optional[_builtins.bool] = None,
                 restore_policy: Optional['outputs.AccountBlobPropertiesRestorePolicy'] = None,
                 versioning_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool change_feed_enabled: Is the blob service properties for change feed events enabled? Default to `false`.
               
               > **Note:** This field cannot be configured when `kind` is set to `Storage` (V1).
        :param _builtins.int change_feed_retention_in_days: The duration of change feed events retention in days. The possible values are between 1 and 146000 days (400 years). Setting this to null (or omit this in the configuration file) indicates an infinite retention of the change feed.
               
               > **Note:** This field cannot be configured when `kind` is set to `Storage` (V1).
        :param 'AccountBlobPropertiesContainerDeleteRetentionPolicyArgs' container_delete_retention_policy: A `container_delete_retention_policy` block as defined below.
        :param Sequence['AccountBlobPropertiesCorsRuleArgs'] cors_rules: A `cors_rule` block as defined below.
        :param _builtins.str default_service_version: The API Version which should be used by default for requests to the Data Plane API if an incoming request doesn't specify an API Version.
        :param 'AccountBlobPropertiesDeleteRetentionPolicyArgs' delete_retention_policy: A `delete_retention_policy` block as defined below.
        :param _builtins.bool last_access_time_enabled: Is the last access time based tracking enabled? Default to `false`.
               
               > **Note:** This field cannot be configured when `kind` is set to `Storage` (V1).
        :param 'AccountBlobPropertiesRestorePolicyArgs' restore_policy: A `restore_policy` block as defined below. This must be used together with `delete_retention_policy` set, `versioning_enabled` and `change_feed_enabled` set to `true`.
               
               > **Note:** This field cannot be configured when `kind` is set to `Storage` (V1).
               
               > **Note:** `restore_policy` can not be configured when `dns_endpoint_type` is `AzureDnsZone`.
        :param _builtins.bool versioning_enabled: Is versioning enabled? Default to `false`.
               
               > **Note:** This field cannot be configured when `kind` is set to `Storage` (V1).
        """
        if change_feed_enabled is not None:
            pulumi.set(__self__, "change_feed_enabled", change_feed_enabled)
        if change_feed_retention_in_days is not None:
            pulumi.set(__self__, "change_feed_retention_in_days", change_feed_retention_in_days)
        if container_delete_retention_policy is not None:
            pulumi.set(__self__, "container_delete_retention_policy", container_delete_retention_policy)
        if cors_rules is not None:
            pulumi.set(__self__, "cors_rules", cors_rules)
        if default_service_version is not None:
            pulumi.set(__self__, "default_service_version", default_service_version)
        if delete_retention_policy is not None:
            pulumi.set(__self__, "delete_retention_policy", delete_retention_policy)
        if last_access_time_enabled is not None:
            pulumi.set(__self__, "last_access_time_enabled", last_access_time_enabled)
        if restore_policy is not None:
            pulumi.set(__self__, "restore_policy", restore_policy)
        if versioning_enabled is not None:
            pulumi.set(__self__, "versioning_enabled", versioning_enabled)

    @_builtins.property
    @pulumi.getter(name="changeFeedEnabled")
    def change_feed_enabled(self) -> Optional[_builtins.bool]:
        """
        Is the blob service properties for change feed events enabled? Default to `false`.

        > **Note:** This field cannot be configured when `kind` is set to `Storage` (V1).
        """
        return pulumi.get(self, "change_feed_enabled")

    @_builtins.property
    @pulumi.getter(name="changeFeedRetentionInDays")
    def change_feed_retention_in_days(self) -> Optional[_builtins.int]:
        """
        The duration of change feed events retention in days. The possible values are between 1 and 146000 days (400 years). Setting this to null (or omit this in the configuration file) indicates an infinite retention of the change feed.

        > **Note:** This field cannot be configured when `kind` is set to `Storage` (V1).
        """
        return pulumi.get(self, "change_feed_retention_in_days")

    @_builtins.property
    @pulumi.getter(name="containerDeleteRetentionPolicy")
    def container_delete_retention_policy(self) -> Optional['outputs.AccountBlobPropertiesContainerDeleteRetentionPolicy']:
        """
        A `container_delete_retention_policy` block as defined below.
        """
        return pulumi.get(self, "container_delete_retention_policy")

    @_builtins.property
    @pulumi.getter(name="corsRules")
    def cors_rules(self) -> Optional[Sequence['outputs.AccountBlobPropertiesCorsRule']]:
        """
        A `cors_rule` block as defined below.
        """
        return pulumi.get(self, "cors_rules")

    @_builtins.property
    @pulumi.getter(name="defaultServiceVersion")
    def default_service_version(self) -> Optional[_builtins.str]:
        """
        The API Version which should be used by default for requests to the Data Plane API if an incoming request doesn't specify an API Version.
        """
        return pulumi.get(self, "default_service_version")

    @_builtins.property
    @pulumi.getter(name="deleteRetentionPolicy")
    def delete_retention_policy(self) -> Optional['outputs.AccountBlobPropertiesDeleteRetentionPolicy']:
        """
        A `delete_retention_policy` block as defined below.
        """
        return pulumi.get(self, "delete_retention_policy")

    @_builtins.property
    @pulumi.getter(name="lastAccessTimeEnabled")
    def last_access_time_enabled(self) -> Optional[_builtins.bool]:
        """
        Is the last access time based tracking enabled? Default to `false`.

        > **Note:** This field cannot be configured when `kind` is set to `Storage` (V1).
        """
        return pulumi.get(self, "last_access_time_enabled")

    @_builtins.property
    @pulumi.getter(name="restorePolicy")
    def restore_policy(self) -> Optional['outputs.AccountBlobPropertiesRestorePolicy']:
        """
        A `restore_policy` block as defined below. This must be used together with `delete_retention_policy` set, `versioning_enabled` and `change_feed_enabled` set to `true`.

        > **Note:** This field cannot be configured when `kind` is set to `Storage` (V1).

        > **Note:** `restore_policy` can not be configured when `dns_endpoint_type` is `AzureDnsZone`.
        """
        return pulumi.get(self, "restore_policy")

    @_builtins.property
    @pulumi.getter(name="versioningEnabled")
    def versioning_enabled(self) -> Optional[_builtins.bool]:
        """
        Is versioning enabled? Default to `false`.

        > **Note:** This field cannot be configured when `kind` is set to `Storage` (V1).
        """
        return pulumi.get(self, "versioning_enabled")


@pulumi.output_type
class AccountBlobPropertiesContainerDeleteRetentionPolicy(dict):
    def __init__(__self__, *,
                 days: Optional[_builtins.int] = None):
        """
        :param _builtins.int days: Specifies the number of days that the container should be retained, between `1` and `365` days. Defaults to `7`.
        """
        if days is not None:
            pulumi.set(__self__, "days", days)

    @_builtins.property
    @pulumi.getter
    def days(self) -> Optional[_builtins.int]:
        """
        Specifies the number of days that the container should be retained, between `1` and `365` days. Defaults to `7`.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class AccountBlobPropertiesCorsRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "exposedHeaders":
            suggest = "exposed_headers"
        elif key == "maxAgeInSeconds":
            suggest = "max_age_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountBlobPropertiesCorsRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountBlobPropertiesCorsRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountBlobPropertiesCorsRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_headers: Sequence[_builtins.str],
                 allowed_methods: Sequence[_builtins.str],
                 allowed_origins: Sequence[_builtins.str],
                 exposed_headers: Sequence[_builtins.str],
                 max_age_in_seconds: _builtins.int):
        """
        :param Sequence[_builtins.str] allowed_headers: A list of headers that are allowed to be a part of the cross-origin request.
        :param Sequence[_builtins.str] allowed_methods: A list of HTTP methods that are allowed to be executed by the origin. Valid options are
               `DELETE`, `GET`, `HEAD`, `MERGE`, `POST`, `OPTIONS`, `PUT` or `PATCH`.
        :param Sequence[_builtins.str] allowed_origins: A list of origin domains that will be allowed by CORS.
        :param Sequence[_builtins.str] exposed_headers: A list of response headers that are exposed to CORS clients.
        :param _builtins.int max_age_in_seconds: The number of seconds the client should cache a preflight response.
        """
        pulumi.set(__self__, "allowed_headers", allowed_headers)
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        pulumi.set(__self__, "exposed_headers", exposed_headers)
        pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)

    @_builtins.property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Sequence[_builtins.str]:
        """
        A list of headers that are allowed to be a part of the cross-origin request.
        """
        return pulumi.get(self, "allowed_headers")

    @_builtins.property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[_builtins.str]:
        """
        A list of HTTP methods that are allowed to be executed by the origin. Valid options are
        `DELETE`, `GET`, `HEAD`, `MERGE`, `POST`, `OPTIONS`, `PUT` or `PATCH`.
        """
        return pulumi.get(self, "allowed_methods")

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[_builtins.str]:
        """
        A list of origin domains that will be allowed by CORS.
        """
        return pulumi.get(self, "allowed_origins")

    @_builtins.property
    @pulumi.getter(name="exposedHeaders")
    def exposed_headers(self) -> Sequence[_builtins.str]:
        """
        A list of response headers that are exposed to CORS clients.
        """
        return pulumi.get(self, "exposed_headers")

    @_builtins.property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> _builtins.int:
        """
        The number of seconds the client should cache a preflight response.
        """
        return pulumi.get(self, "max_age_in_seconds")


@pulumi.output_type
class AccountBlobPropertiesDeleteRetentionPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "permanentDeleteEnabled":
            suggest = "permanent_delete_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountBlobPropertiesDeleteRetentionPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountBlobPropertiesDeleteRetentionPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountBlobPropertiesDeleteRetentionPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 days: Optional[_builtins.int] = None,
                 permanent_delete_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.int days: Specifies the number of days that the blob should be retained, between `1` and `365` days. Defaults to `7`.
        :param _builtins.bool permanent_delete_enabled: Indicates whether permanent deletion of the soft deleted blob versions and snapshots is allowed. Defaults to `false`.
               
               > **Note:** `permanent_delete_enabled` cannot be set to true if a `restore_policy` block is defined.
        """
        if days is not None:
            pulumi.set(__self__, "days", days)
        if permanent_delete_enabled is not None:
            pulumi.set(__self__, "permanent_delete_enabled", permanent_delete_enabled)

    @_builtins.property
    @pulumi.getter
    def days(self) -> Optional[_builtins.int]:
        """
        Specifies the number of days that the blob should be retained, between `1` and `365` days. Defaults to `7`.
        """
        return pulumi.get(self, "days")

    @_builtins.property
    @pulumi.getter(name="permanentDeleteEnabled")
    def permanent_delete_enabled(self) -> Optional[_builtins.bool]:
        """
        Indicates whether permanent deletion of the soft deleted blob versions and snapshots is allowed. Defaults to `false`.

        > **Note:** `permanent_delete_enabled` cannot be set to true if a `restore_policy` block is defined.
        """
        return pulumi.get(self, "permanent_delete_enabled")


@pulumi.output_type
class AccountBlobPropertiesRestorePolicy(dict):
    def __init__(__self__, *,
                 days: _builtins.int):
        """
        :param _builtins.int days: Specifies the number of days that the blob can be restored, between `1` and `365` days. This must be less than the `days` specified for `delete_retention_policy`.
        """
        pulumi.set(__self__, "days", days)

    @_builtins.property
    @pulumi.getter
    def days(self) -> _builtins.int:
        """
        Specifies the number of days that the blob can be restored, between `1` and `365` days. This must be less than the `days` specified for `delete_retention_policy`.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class AccountCustomDomain(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "useSubdomain":
            suggest = "use_subdomain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountCustomDomain. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountCustomDomain.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountCustomDomain.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 use_subdomain: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: The Custom Domain Name to use for the Storage Account, which will be validated by Azure.
        :param _builtins.bool use_subdomain: Should the Custom Domain Name be validated by using indirect CNAME validation?
        """
        pulumi.set(__self__, "name", name)
        if use_subdomain is not None:
            pulumi.set(__self__, "use_subdomain", use_subdomain)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The Custom Domain Name to use for the Storage Account, which will be validated by Azure.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="useSubdomain")
    def use_subdomain(self) -> Optional[_builtins.bool]:
        """
        Should the Custom Domain Name be validated by using indirect CNAME validation?
        """
        return pulumi.get(self, "use_subdomain")


@pulumi.output_type
class AccountCustomerManagedKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userAssignedIdentityId":
            suggest = "user_assigned_identity_id"
        elif key == "keyVaultKeyId":
            suggest = "key_vault_key_id"
        elif key == "managedHsmKeyId":
            suggest = "managed_hsm_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountCustomerManagedKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountCustomerManagedKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountCustomerManagedKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_assigned_identity_id: _builtins.str,
                 key_vault_key_id: Optional[_builtins.str] = None,
                 managed_hsm_key_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str user_assigned_identity_id: The ID of a user assigned identity.
               
               > **Note:** `customer_managed_key` can only be set when the `account_kind` is set to `StorageV2` or `account_tier` set to `Premium`, and the identity type is `UserAssigned`.
        :param _builtins.str key_vault_key_id: The ID of the Key Vault Key, supplying a version-less key ID will enable auto-rotation of this key. Exactly one of `key_vault_key_id` and `managed_hsm_key_id` may be specified.
        :param _builtins.str managed_hsm_key_id: The ID of the managed HSM Key. Exactly one of `key_vault_key_id` and `managed_hsm_key_id` may be specified.
        """
        pulumi.set(__self__, "user_assigned_identity_id", user_assigned_identity_id)
        if key_vault_key_id is not None:
            pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if managed_hsm_key_id is not None:
            pulumi.set(__self__, "managed_hsm_key_id", managed_hsm_key_id)

    @_builtins.property
    @pulumi.getter(name="userAssignedIdentityId")
    def user_assigned_identity_id(self) -> _builtins.str:
        """
        The ID of a user assigned identity.

        > **Note:** `customer_managed_key` can only be set when the `account_kind` is set to `StorageV2` or `account_tier` set to `Premium`, and the identity type is `UserAssigned`.
        """
        return pulumi.get(self, "user_assigned_identity_id")

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Key Vault Key, supplying a version-less key ID will enable auto-rotation of this key. Exactly one of `key_vault_key_id` and `managed_hsm_key_id` may be specified.
        """
        return pulumi.get(self, "key_vault_key_id")

    @_builtins.property
    @pulumi.getter(name="managedHsmKeyId")
    def managed_hsm_key_id(self) -> Optional[_builtins.str]:
        """
        The ID of the managed HSM Key. Exactly one of `key_vault_key_id` and `managed_hsm_key_id` may be specified.
        """
        return pulumi.get(self, "managed_hsm_key_id")


@pulumi.output_type
class AccountIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Storage Account. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        :param Sequence[_builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Storage Account.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
               
               > **Note:** The assigned `principal_id` and `tenant_id` can be retrieved after the identity `type` has been set to `SystemAssigned`  and Storage Account has been created. More details are available below.
        :param _builtins.str principal_id: The Principal ID for the Service Principal associated with the Identity of this Storage Account.
        :param _builtins.str tenant_id: The Tenant ID for the Service Principal associated with the Identity of this Storage Account.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Storage Account. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Storage Account.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.

        > **Note:** The assigned `principal_id` and `tenant_id` can be retrieved after the identity `type` has been set to `SystemAssigned`  and Storage Account has been created. More details are available below.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID for the Service Principal associated with the Identity of this Storage Account.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID for the Service Principal associated with the Identity of this Storage Account.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class AccountImmutabilityPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowProtectedAppendWrites":
            suggest = "allow_protected_append_writes"
        elif key == "periodSinceCreationInDays":
            suggest = "period_since_creation_in_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountImmutabilityPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountImmutabilityPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountImmutabilityPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_protected_append_writes: _builtins.bool,
                 period_since_creation_in_days: _builtins.int,
                 state: _builtins.str):
        """
        :param _builtins.bool allow_protected_append_writes: When enabled, new blocks can be written to an append blob while maintaining immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted.
        :param _builtins.int period_since_creation_in_days: The immutability period for the blobs in the container since the policy creation, in days.
        :param _builtins.str state: Defines the mode of the policy. `Disabled` state disables the policy, `Unlocked` state allows increase and decrease of immutability retention time and also allows toggling allowProtectedAppendWrites property, `Locked` state only allows the increase of the immutability retention time. A policy can only be created in a Disabled or Unlocked state and can be toggled between the two states. Only a policy in an Unlocked state can transition to a Locked state which cannot be reverted. Changing from `Locked` forces a new resource to be created.
        """
        pulumi.set(__self__, "allow_protected_append_writes", allow_protected_append_writes)
        pulumi.set(__self__, "period_since_creation_in_days", period_since_creation_in_days)
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="allowProtectedAppendWrites")
    def allow_protected_append_writes(self) -> _builtins.bool:
        """
        When enabled, new blocks can be written to an append blob while maintaining immutability protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted.
        """
        return pulumi.get(self, "allow_protected_append_writes")

    @_builtins.property
    @pulumi.getter(name="periodSinceCreationInDays")
    def period_since_creation_in_days(self) -> _builtins.int:
        """
        The immutability period for the blobs in the container since the policy creation, in days.
        """
        return pulumi.get(self, "period_since_creation_in_days")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        Defines the mode of the policy. `Disabled` state disables the policy, `Unlocked` state allows increase and decrease of immutability retention time and also allows toggling allowProtectedAppendWrites property, `Locked` state only allows the increase of the immutability retention time. A policy can only be created in a Disabled or Unlocked state and can be toggled between the two states. Only a policy in an Unlocked state can transition to a Locked state which cannot be reverted. Changing from `Locked` forces a new resource to be created.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class AccountNetworkRules(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultAction":
            suggest = "default_action"
        elif key == "ipRules":
            suggest = "ip_rules"
        elif key == "privateLinkAccesses":
            suggest = "private_link_accesses"
        elif key == "virtualNetworkSubnetIds":
            suggest = "virtual_network_subnet_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountNetworkRules. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountNetworkRules.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountNetworkRules.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_action: _builtins.str,
                 bypasses: Optional[Sequence[_builtins.str]] = None,
                 ip_rules: Optional[Sequence[_builtins.str]] = None,
                 private_link_accesses: Optional[Sequence['outputs.AccountNetworkRulesPrivateLinkAccess']] = None,
                 virtual_network_subnet_ids: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str default_action: Specifies the default action of allow or deny when no other rules match. Valid options are `Deny` or `Allow`.
        :param Sequence[_builtins.str] bypasses: Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Valid options are any combination of `Logging`, `Metrics`, `AzureServices`, or `None`.
        :param Sequence[_builtins.str] ip_rules: List of public IP or IP ranges in CIDR Format. Only IPv4 addresses are allowed. /31 CIDRs, /32 CIDRs, and Private IP address ranges (as defined in [RFC 1918](https://tools.ietf.org/html/rfc1918#section-3)), are not allowed.
        :param Sequence['AccountNetworkRulesPrivateLinkAccessArgs'] private_link_accesses: One or more `private_link_access` block as defined below.
               
               > **Note:** If specifying `network_rules`, one of either `ip_rules` or `virtual_network_subnet_ids` must be specified and `default_action` must be set to `Deny`.
               
               > **Note:** Network Rules can be defined either directly on the `storage.Account` resource, or using the `storage.AccountNetworkRules` resource - but the two cannot be used together. If both are used against the same Storage Account, spurious changes will occur. When managing Network Rules using this resource, to change from a `default_action` of `Deny` to `Allow` requires defining, rather than removing, the block.
               
               > **Note:** The prefix of `ip_rules` must be between 0 and 30 and only supports public IP addresses.
               
               > **Note:** [More information on Validation is available here](https://docs.microsoft.com/en-gb/azure/storage/blobs/storage-custom-domain-name)
        :param Sequence[_builtins.str] virtual_network_subnet_ids: A list of resource ids for subnets.
        """
        pulumi.set(__self__, "default_action", default_action)
        if bypasses is not None:
            pulumi.set(__self__, "bypasses", bypasses)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)
        if private_link_accesses is not None:
            pulumi.set(__self__, "private_link_accesses", private_link_accesses)
        if virtual_network_subnet_ids is not None:
            pulumi.set(__self__, "virtual_network_subnet_ids", virtual_network_subnet_ids)

    @_builtins.property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> _builtins.str:
        """
        Specifies the default action of allow or deny when no other rules match. Valid options are `Deny` or `Allow`.
        """
        return pulumi.get(self, "default_action")

    @_builtins.property
    @pulumi.getter
    def bypasses(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies whether traffic is bypassed for Logging/Metrics/AzureServices. Valid options are any combination of `Logging`, `Metrics`, `AzureServices`, or `None`.
        """
        return pulumi.get(self, "bypasses")

    @_builtins.property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of public IP or IP ranges in CIDR Format. Only IPv4 addresses are allowed. /31 CIDRs, /32 CIDRs, and Private IP address ranges (as defined in [RFC 1918](https://tools.ietf.org/html/rfc1918#section-3)), are not allowed.
        """
        return pulumi.get(self, "ip_rules")

    @_builtins.property
    @pulumi.getter(name="privateLinkAccesses")
    def private_link_accesses(self) -> Optional[Sequence['outputs.AccountNetworkRulesPrivateLinkAccess']]:
        """
        One or more `private_link_access` block as defined below.

        > **Note:** If specifying `network_rules`, one of either `ip_rules` or `virtual_network_subnet_ids` must be specified and `default_action` must be set to `Deny`.

        > **Note:** Network Rules can be defined either directly on the `storage.Account` resource, or using the `storage.AccountNetworkRules` resource - but the two cannot be used together. If both are used against the same Storage Account, spurious changes will occur. When managing Network Rules using this resource, to change from a `default_action` of `Deny` to `Allow` requires defining, rather than removing, the block.

        > **Note:** The prefix of `ip_rules` must be between 0 and 30 and only supports public IP addresses.

        > **Note:** [More information on Validation is available here](https://docs.microsoft.com/en-gb/azure/storage/blobs/storage-custom-domain-name)
        """
        return pulumi.get(self, "private_link_accesses")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkSubnetIds")
    def virtual_network_subnet_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of resource ids for subnets.
        """
        return pulumi.get(self, "virtual_network_subnet_ids")


@pulumi.output_type
class AccountNetworkRulesPrivateLinkAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointResourceId":
            suggest = "endpoint_resource_id"
        elif key == "endpointTenantId":
            suggest = "endpoint_tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountNetworkRulesPrivateLinkAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountNetworkRulesPrivateLinkAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountNetworkRulesPrivateLinkAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_resource_id: _builtins.str,
                 endpoint_tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str endpoint_resource_id: The ID of the Azure resource that should be allowed access to the target storage account.
        :param _builtins.str endpoint_tenant_id: The tenant id of the resource of the resource access rule to be granted access. Defaults to the current tenant id.
        """
        pulumi.set(__self__, "endpoint_resource_id", endpoint_resource_id)
        if endpoint_tenant_id is not None:
            pulumi.set(__self__, "endpoint_tenant_id", endpoint_tenant_id)

    @_builtins.property
    @pulumi.getter(name="endpointResourceId")
    def endpoint_resource_id(self) -> _builtins.str:
        """
        The ID of the Azure resource that should be allowed access to the target storage account.
        """
        return pulumi.get(self, "endpoint_resource_id")

    @_builtins.property
    @pulumi.getter(name="endpointTenantId")
    def endpoint_tenant_id(self) -> Optional[_builtins.str]:
        """
        The tenant id of the resource of the resource access rule to be granted access. Defaults to the current tenant id.
        """
        return pulumi.get(self, "endpoint_tenant_id")


@pulumi.output_type
class AccountNetworkRulesPrivateLinkAccessRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endpointResourceId":
            suggest = "endpoint_resource_id"
        elif key == "endpointTenantId":
            suggest = "endpoint_tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountNetworkRulesPrivateLinkAccessRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountNetworkRulesPrivateLinkAccessRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountNetworkRulesPrivateLinkAccessRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 endpoint_resource_id: _builtins.str,
                 endpoint_tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str endpoint_resource_id: The resource id of the resource access rule to be granted access.
        :param _builtins.str endpoint_tenant_id: The tenant id of the resource of the resource access rule to be granted access. Defaults to the current tenant id.
        """
        pulumi.set(__self__, "endpoint_resource_id", endpoint_resource_id)
        if endpoint_tenant_id is not None:
            pulumi.set(__self__, "endpoint_tenant_id", endpoint_tenant_id)

    @_builtins.property
    @pulumi.getter(name="endpointResourceId")
    def endpoint_resource_id(self) -> _builtins.str:
        """
        The resource id of the resource access rule to be granted access.
        """
        return pulumi.get(self, "endpoint_resource_id")

    @_builtins.property
    @pulumi.getter(name="endpointTenantId")
    def endpoint_tenant_id(self) -> Optional[_builtins.str]:
        """
        The tenant id of the resource of the resource access rule to be granted access. Defaults to the current tenant id.
        """
        return pulumi.get(self, "endpoint_tenant_id")


@pulumi.output_type
class AccountQueueProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "corsRules":
            suggest = "cors_rules"
        elif key == "hourMetrics":
            suggest = "hour_metrics"
        elif key == "minuteMetrics":
            suggest = "minute_metrics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountQueueProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountQueueProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountQueueProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cors_rules: Optional[Sequence['outputs.AccountQueuePropertiesCorsRule']] = None,
                 hour_metrics: Optional['outputs.AccountQueuePropertiesHourMetrics'] = None,
                 logging: Optional['outputs.AccountQueuePropertiesLogging'] = None,
                 minute_metrics: Optional['outputs.AccountQueuePropertiesMinuteMetrics'] = None):
        """
        :param Sequence['AccountQueuePropertiesCorsRuleArgs'] cors_rules: A `cors_rule` block as defined above.
        :param 'AccountQueuePropertiesHourMetricsArgs' hour_metrics: A `hour_metrics` block as defined below.
        :param 'AccountQueuePropertiesLoggingArgs' logging: A `logging` block as defined below.
        :param 'AccountQueuePropertiesMinuteMetricsArgs' minute_metrics: A `minute_metrics` block as defined below.
        """
        if cors_rules is not None:
            pulumi.set(__self__, "cors_rules", cors_rules)
        if hour_metrics is not None:
            pulumi.set(__self__, "hour_metrics", hour_metrics)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if minute_metrics is not None:
            pulumi.set(__self__, "minute_metrics", minute_metrics)

    @_builtins.property
    @pulumi.getter(name="corsRules")
    def cors_rules(self) -> Optional[Sequence['outputs.AccountQueuePropertiesCorsRule']]:
        """
        A `cors_rule` block as defined above.
        """
        return pulumi.get(self, "cors_rules")

    @_builtins.property
    @pulumi.getter(name="hourMetrics")
    def hour_metrics(self) -> Optional['outputs.AccountQueuePropertiesHourMetrics']:
        """
        A `hour_metrics` block as defined below.
        """
        return pulumi.get(self, "hour_metrics")

    @_builtins.property
    @pulumi.getter
    def logging(self) -> Optional['outputs.AccountQueuePropertiesLogging']:
        """
        A `logging` block as defined below.
        """
        return pulumi.get(self, "logging")

    @_builtins.property
    @pulumi.getter(name="minuteMetrics")
    def minute_metrics(self) -> Optional['outputs.AccountQueuePropertiesMinuteMetrics']:
        """
        A `minute_metrics` block as defined below.
        """
        return pulumi.get(self, "minute_metrics")


@pulumi.output_type
class AccountQueuePropertiesCorsRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "exposedHeaders":
            suggest = "exposed_headers"
        elif key == "maxAgeInSeconds":
            suggest = "max_age_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountQueuePropertiesCorsRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountQueuePropertiesCorsRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountQueuePropertiesCorsRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_headers: Sequence[_builtins.str],
                 allowed_methods: Sequence[_builtins.str],
                 allowed_origins: Sequence[_builtins.str],
                 exposed_headers: Sequence[_builtins.str],
                 max_age_in_seconds: _builtins.int):
        """
        :param Sequence[_builtins.str] allowed_headers: A list of headers that are allowed to be a part of the cross-origin request.
        :param Sequence[_builtins.str] allowed_methods: A list of HTTP methods that are allowed to be executed by the origin. Valid options are
               `DELETE`, `GET`, `HEAD`, `MERGE`, `POST`, `OPTIONS`, `PUT` or `PATCH`.
        :param Sequence[_builtins.str] allowed_origins: A list of origin domains that will be allowed by CORS.
        :param Sequence[_builtins.str] exposed_headers: A list of response headers that are exposed to CORS clients.
        :param _builtins.int max_age_in_seconds: The number of seconds the client should cache a preflight response.
        """
        pulumi.set(__self__, "allowed_headers", allowed_headers)
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        pulumi.set(__self__, "exposed_headers", exposed_headers)
        pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)

    @_builtins.property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Sequence[_builtins.str]:
        """
        A list of headers that are allowed to be a part of the cross-origin request.
        """
        return pulumi.get(self, "allowed_headers")

    @_builtins.property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[_builtins.str]:
        """
        A list of HTTP methods that are allowed to be executed by the origin. Valid options are
        `DELETE`, `GET`, `HEAD`, `MERGE`, `POST`, `OPTIONS`, `PUT` or `PATCH`.
        """
        return pulumi.get(self, "allowed_methods")

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[_builtins.str]:
        """
        A list of origin domains that will be allowed by CORS.
        """
        return pulumi.get(self, "allowed_origins")

    @_builtins.property
    @pulumi.getter(name="exposedHeaders")
    def exposed_headers(self) -> Sequence[_builtins.str]:
        """
        A list of response headers that are exposed to CORS clients.
        """
        return pulumi.get(self, "exposed_headers")

    @_builtins.property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> _builtins.int:
        """
        The number of seconds the client should cache a preflight response.
        """
        return pulumi.get(self, "max_age_in_seconds")


@pulumi.output_type
class AccountQueuePropertiesHourMetrics(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeApis":
            suggest = "include_apis"
        elif key == "retentionPolicyDays":
            suggest = "retention_policy_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountQueuePropertiesHourMetrics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountQueuePropertiesHourMetrics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountQueuePropertiesHourMetrics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 version: _builtins.str,
                 include_apis: Optional[_builtins.bool] = None,
                 retention_policy_days: Optional[_builtins.int] = None):
        """
        :param _builtins.str version: The version of storage analytics to configure.
        :param _builtins.bool include_apis: Indicates whether metrics should generate summary statistics for called API operations.
        :param _builtins.int retention_policy_days: Specifies the number of days that logs will be retained.
        """
        pulumi.set(__self__, "version", version)
        if include_apis is not None:
            pulumi.set(__self__, "include_apis", include_apis)
        if retention_policy_days is not None:
            pulumi.set(__self__, "retention_policy_days", retention_policy_days)

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of storage analytics to configure.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="includeApis")
    def include_apis(self) -> Optional[_builtins.bool]:
        """
        Indicates whether metrics should generate summary statistics for called API operations.
        """
        return pulumi.get(self, "include_apis")

    @_builtins.property
    @pulumi.getter(name="retentionPolicyDays")
    def retention_policy_days(self) -> Optional[_builtins.int]:
        """
        Specifies the number of days that logs will be retained.
        """
        return pulumi.get(self, "retention_policy_days")


@pulumi.output_type
class AccountQueuePropertiesLogging(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionPolicyDays":
            suggest = "retention_policy_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountQueuePropertiesLogging. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountQueuePropertiesLogging.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountQueuePropertiesLogging.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 delete: _builtins.bool,
                 read: _builtins.bool,
                 version: _builtins.str,
                 write: _builtins.bool,
                 retention_policy_days: Optional[_builtins.int] = None):
        """
        :param _builtins.bool delete: Indicates whether all delete requests should be logged.
        :param _builtins.bool read: Indicates whether all read requests should be logged.
        :param _builtins.str version: The version of storage analytics to configure.
        :param _builtins.bool write: Indicates whether all write requests should be logged.
        :param _builtins.int retention_policy_days: Specifies the number of days that logs will be retained.
        """
        pulumi.set(__self__, "delete", delete)
        pulumi.set(__self__, "read", read)
        pulumi.set(__self__, "version", version)
        pulumi.set(__self__, "write", write)
        if retention_policy_days is not None:
            pulumi.set(__self__, "retention_policy_days", retention_policy_days)

    @_builtins.property
    @pulumi.getter
    def delete(self) -> _builtins.bool:
        """
        Indicates whether all delete requests should be logged.
        """
        return pulumi.get(self, "delete")

    @_builtins.property
    @pulumi.getter
    def read(self) -> _builtins.bool:
        """
        Indicates whether all read requests should be logged.
        """
        return pulumi.get(self, "read")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of storage analytics to configure.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter
    def write(self) -> _builtins.bool:
        """
        Indicates whether all write requests should be logged.
        """
        return pulumi.get(self, "write")

    @_builtins.property
    @pulumi.getter(name="retentionPolicyDays")
    def retention_policy_days(self) -> Optional[_builtins.int]:
        """
        Specifies the number of days that logs will be retained.
        """
        return pulumi.get(self, "retention_policy_days")


@pulumi.output_type
class AccountQueuePropertiesMinuteMetrics(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "includeApis":
            suggest = "include_apis"
        elif key == "retentionPolicyDays":
            suggest = "retention_policy_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountQueuePropertiesMinuteMetrics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountQueuePropertiesMinuteMetrics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountQueuePropertiesMinuteMetrics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 version: _builtins.str,
                 include_apis: Optional[_builtins.bool] = None,
                 retention_policy_days: Optional[_builtins.int] = None):
        """
        :param _builtins.str version: The version of storage analytics to configure.
        :param _builtins.bool include_apis: Indicates whether metrics should generate summary statistics for called API operations.
        :param _builtins.int retention_policy_days: Specifies the number of days that logs will be retained.
        """
        pulumi.set(__self__, "version", version)
        if include_apis is not None:
            pulumi.set(__self__, "include_apis", include_apis)
        if retention_policy_days is not None:
            pulumi.set(__self__, "retention_policy_days", retention_policy_days)

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of storage analytics to configure.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="includeApis")
    def include_apis(self) -> Optional[_builtins.bool]:
        """
        Indicates whether metrics should generate summary statistics for called API operations.
        """
        return pulumi.get(self, "include_apis")

    @_builtins.property
    @pulumi.getter(name="retentionPolicyDays")
    def retention_policy_days(self) -> Optional[_builtins.int]:
        """
        Specifies the number of days that logs will be retained.
        """
        return pulumi.get(self, "retention_policy_days")


@pulumi.output_type
class AccountRouting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publishInternetEndpoints":
            suggest = "publish_internet_endpoints"
        elif key == "publishMicrosoftEndpoints":
            suggest = "publish_microsoft_endpoints"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountRouting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountRouting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountRouting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 choice: Optional[_builtins.str] = None,
                 publish_internet_endpoints: Optional[_builtins.bool] = None,
                 publish_microsoft_endpoints: Optional[_builtins.bool] = None):
        """
        :param _builtins.str choice: Specifies the kind of network routing opted by the user. Possible values are `InternetRouting` and `MicrosoftRouting`. Defaults to `MicrosoftRouting`.
        :param _builtins.bool publish_internet_endpoints: Should internet routing storage endpoints be published? Defaults to `false`.
        :param _builtins.bool publish_microsoft_endpoints: Should Microsoft routing storage endpoints be published? Defaults to `false`.
        """
        if choice is not None:
            pulumi.set(__self__, "choice", choice)
        if publish_internet_endpoints is not None:
            pulumi.set(__self__, "publish_internet_endpoints", publish_internet_endpoints)
        if publish_microsoft_endpoints is not None:
            pulumi.set(__self__, "publish_microsoft_endpoints", publish_microsoft_endpoints)

    @_builtins.property
    @pulumi.getter
    def choice(self) -> Optional[_builtins.str]:
        """
        Specifies the kind of network routing opted by the user. Possible values are `InternetRouting` and `MicrosoftRouting`. Defaults to `MicrosoftRouting`.
        """
        return pulumi.get(self, "choice")

    @_builtins.property
    @pulumi.getter(name="publishInternetEndpoints")
    def publish_internet_endpoints(self) -> Optional[_builtins.bool]:
        """
        Should internet routing storage endpoints be published? Defaults to `false`.
        """
        return pulumi.get(self, "publish_internet_endpoints")

    @_builtins.property
    @pulumi.getter(name="publishMicrosoftEndpoints")
    def publish_microsoft_endpoints(self) -> Optional[_builtins.bool]:
        """
        Should Microsoft routing storage endpoints be published? Defaults to `false`.
        """
        return pulumi.get(self, "publish_microsoft_endpoints")


@pulumi.output_type
class AccountSasPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationPeriod":
            suggest = "expiration_period"
        elif key == "expirationAction":
            suggest = "expiration_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountSasPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountSasPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountSasPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expiration_period: _builtins.str,
                 expiration_action: Optional[_builtins.str] = None):
        """
        :param _builtins.str expiration_period: The SAS expiration period in format of `DD.HH:MM:SS`.
        :param _builtins.str expiration_action: The SAS expiration action. Possible values are `Log` and `Block`. Defaults to `Log`.
        """
        pulumi.set(__self__, "expiration_period", expiration_period)
        if expiration_action is not None:
            pulumi.set(__self__, "expiration_action", expiration_action)

    @_builtins.property
    @pulumi.getter(name="expirationPeriod")
    def expiration_period(self) -> _builtins.str:
        """
        The SAS expiration period in format of `DD.HH:MM:SS`.
        """
        return pulumi.get(self, "expiration_period")

    @_builtins.property
    @pulumi.getter(name="expirationAction")
    def expiration_action(self) -> Optional[_builtins.str]:
        """
        The SAS expiration action. Possible values are `Log` and `Block`. Defaults to `Log`.
        """
        return pulumi.get(self, "expiration_action")


@pulumi.output_type
class AccountShareProperties(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "corsRules":
            suggest = "cors_rules"
        elif key == "retentionPolicy":
            suggest = "retention_policy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountShareProperties. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountShareProperties.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountShareProperties.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cors_rules: Optional[Sequence['outputs.AccountSharePropertiesCorsRule']] = None,
                 retention_policy: Optional['outputs.AccountSharePropertiesRetentionPolicy'] = None,
                 smb: Optional['outputs.AccountSharePropertiesSmb'] = None):
        """
        :param Sequence['AccountSharePropertiesCorsRuleArgs'] cors_rules: A `cors_rule` block as defined below.
        :param 'AccountSharePropertiesRetentionPolicyArgs' retention_policy: A `retention_policy` block as defined below.
        :param 'AccountSharePropertiesSmbArgs' smb: A `smb` block as defined below.
        """
        if cors_rules is not None:
            pulumi.set(__self__, "cors_rules", cors_rules)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if smb is not None:
            pulumi.set(__self__, "smb", smb)

    @_builtins.property
    @pulumi.getter(name="corsRules")
    def cors_rules(self) -> Optional[Sequence['outputs.AccountSharePropertiesCorsRule']]:
        """
        A `cors_rule` block as defined below.
        """
        return pulumi.get(self, "cors_rules")

    @_builtins.property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional['outputs.AccountSharePropertiesRetentionPolicy']:
        """
        A `retention_policy` block as defined below.
        """
        return pulumi.get(self, "retention_policy")

    @_builtins.property
    @pulumi.getter
    def smb(self) -> Optional['outputs.AccountSharePropertiesSmb']:
        """
        A `smb` block as defined below.
        """
        return pulumi.get(self, "smb")


@pulumi.output_type
class AccountSharePropertiesCorsRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "exposedHeaders":
            suggest = "exposed_headers"
        elif key == "maxAgeInSeconds":
            suggest = "max_age_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountSharePropertiesCorsRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountSharePropertiesCorsRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountSharePropertiesCorsRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_headers: Sequence[_builtins.str],
                 allowed_methods: Sequence[_builtins.str],
                 allowed_origins: Sequence[_builtins.str],
                 exposed_headers: Sequence[_builtins.str],
                 max_age_in_seconds: _builtins.int):
        """
        :param Sequence[_builtins.str] allowed_headers: A list of headers that are allowed to be a part of the cross-origin request.
        :param Sequence[_builtins.str] allowed_methods: A list of HTTP methods that are allowed to be executed by the origin. Valid options are
               `DELETE`, `GET`, `HEAD`, `MERGE`, `POST`, `OPTIONS`, `PUT` or `PATCH`.
        :param Sequence[_builtins.str] allowed_origins: A list of origin domains that will be allowed by CORS.
        :param Sequence[_builtins.str] exposed_headers: A list of response headers that are exposed to CORS clients.
        :param _builtins.int max_age_in_seconds: The number of seconds the client should cache a preflight response.
        """
        pulumi.set(__self__, "allowed_headers", allowed_headers)
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        pulumi.set(__self__, "exposed_headers", exposed_headers)
        pulumi.set(__self__, "max_age_in_seconds", max_age_in_seconds)

    @_builtins.property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Sequence[_builtins.str]:
        """
        A list of headers that are allowed to be a part of the cross-origin request.
        """
        return pulumi.get(self, "allowed_headers")

    @_builtins.property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[_builtins.str]:
        """
        A list of HTTP methods that are allowed to be executed by the origin. Valid options are
        `DELETE`, `GET`, `HEAD`, `MERGE`, `POST`, `OPTIONS`, `PUT` or `PATCH`.
        """
        return pulumi.get(self, "allowed_methods")

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[_builtins.str]:
        """
        A list of origin domains that will be allowed by CORS.
        """
        return pulumi.get(self, "allowed_origins")

    @_builtins.property
    @pulumi.getter(name="exposedHeaders")
    def exposed_headers(self) -> Sequence[_builtins.str]:
        """
        A list of response headers that are exposed to CORS clients.
        """
        return pulumi.get(self, "exposed_headers")

    @_builtins.property
    @pulumi.getter(name="maxAgeInSeconds")
    def max_age_in_seconds(self) -> _builtins.int:
        """
        The number of seconds the client should cache a preflight response.
        """
        return pulumi.get(self, "max_age_in_seconds")


@pulumi.output_type
class AccountSharePropertiesRetentionPolicy(dict):
    def __init__(__self__, *,
                 days: Optional[_builtins.int] = None):
        """
        :param _builtins.int days: Specifies the number of days that the `storage.Share` should be retained, between `1` and `365` days. Defaults to `7`.
        """
        if days is not None:
            pulumi.set(__self__, "days", days)

    @_builtins.property
    @pulumi.getter
    def days(self) -> Optional[_builtins.int]:
        """
        Specifies the number of days that the `storage.Share` should be retained, between `1` and `365` days. Defaults to `7`.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class AccountSharePropertiesSmb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authenticationTypes":
            suggest = "authentication_types"
        elif key == "channelEncryptionTypes":
            suggest = "channel_encryption_types"
        elif key == "kerberosTicketEncryptionTypes":
            suggest = "kerberos_ticket_encryption_types"
        elif key == "multichannelEnabled":
            suggest = "multichannel_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountSharePropertiesSmb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountSharePropertiesSmb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountSharePropertiesSmb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authentication_types: Optional[Sequence[_builtins.str]] = None,
                 channel_encryption_types: Optional[Sequence[_builtins.str]] = None,
                 kerberos_ticket_encryption_types: Optional[Sequence[_builtins.str]] = None,
                 multichannel_enabled: Optional[_builtins.bool] = None,
                 versions: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] authentication_types: A set of SMB authentication methods. Possible values are `NTLMv2`, and `Kerberos`.
        :param Sequence[_builtins.str] channel_encryption_types: A set of SMB channel encryption. Possible values are `AES-128-CCM`, `AES-128-GCM`, and `AES-256-GCM`.
        :param Sequence[_builtins.str] kerberos_ticket_encryption_types: A set of Kerberos ticket encryption. Possible values are `RC4-HMAC`, and `AES-256`.
        :param _builtins.bool multichannel_enabled: Indicates whether multichannel is enabled. Defaults to `false`. This is only supported on Premium storage accounts.
        :param Sequence[_builtins.str] versions: A set of SMB protocol versions. Possible values are `SMB2.1`, `SMB3.0`, and `SMB3.1.1`.
        """
        if authentication_types is not None:
            pulumi.set(__self__, "authentication_types", authentication_types)
        if channel_encryption_types is not None:
            pulumi.set(__self__, "channel_encryption_types", channel_encryption_types)
        if kerberos_ticket_encryption_types is not None:
            pulumi.set(__self__, "kerberos_ticket_encryption_types", kerberos_ticket_encryption_types)
        if multichannel_enabled is not None:
            pulumi.set(__self__, "multichannel_enabled", multichannel_enabled)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter(name="authenticationTypes")
    def authentication_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        A set of SMB authentication methods. Possible values are `NTLMv2`, and `Kerberos`.
        """
        return pulumi.get(self, "authentication_types")

    @_builtins.property
    @pulumi.getter(name="channelEncryptionTypes")
    def channel_encryption_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        A set of SMB channel encryption. Possible values are `AES-128-CCM`, `AES-128-GCM`, and `AES-256-GCM`.
        """
        return pulumi.get(self, "channel_encryption_types")

    @_builtins.property
    @pulumi.getter(name="kerberosTicketEncryptionTypes")
    def kerberos_ticket_encryption_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        A set of Kerberos ticket encryption. Possible values are `RC4-HMAC`, and `AES-256`.
        """
        return pulumi.get(self, "kerberos_ticket_encryption_types")

    @_builtins.property
    @pulumi.getter(name="multichannelEnabled")
    def multichannel_enabled(self) -> Optional[_builtins.bool]:
        """
        Indicates whether multichannel is enabled. Defaults to `false`. This is only supported on Premium storage accounts.
        """
        return pulumi.get(self, "multichannel_enabled")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Optional[Sequence[_builtins.str]]:
        """
        A set of SMB protocol versions. Possible values are `SMB2.1`, `SMB3.0`, and `SMB3.1.1`.
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class AccountStaticWebsite(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "error404Document":
            suggest = "error404_document"
        elif key == "indexDocument":
            suggest = "index_document"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountStaticWebsite. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountStaticWebsite.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountStaticWebsite.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error404_document: Optional[_builtins.str] = None,
                 index_document: Optional[_builtins.str] = None):
        """
        :param _builtins.str error404_document: The absolute path to a custom webpage that should be used when a request is made which does not correspond to an existing file.
        :param _builtins.str index_document: The webpage that Azure Storage serves for requests to the root of a website or any subfolder. For example, index.html. The value is case-sensitive.
        """
        if error404_document is not None:
            pulumi.set(__self__, "error404_document", error404_document)
        if index_document is not None:
            pulumi.set(__self__, "index_document", index_document)

    @_builtins.property
    @pulumi.getter(name="error404Document")
    def error404_document(self) -> Optional[_builtins.str]:
        """
        The absolute path to a custom webpage that should be used when a request is made which does not correspond to an existing file.
        """
        return pulumi.get(self, "error404_document")

    @_builtins.property
    @pulumi.getter(name="indexDocument")
    def index_document(self) -> Optional[_builtins.str]:
        """
        The webpage that Azure Storage serves for requests to the root of a website or any subfolder. For example, index.html. The value is case-sensitive.
        """
        return pulumi.get(self, "index_document")


@pulumi.output_type
class BlobInventoryPolicyRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "schemaFields":
            suggest = "schema_fields"
        elif key == "storageContainerName":
            suggest = "storage_container_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlobInventoryPolicyRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlobInventoryPolicyRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlobInventoryPolicyRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 format: _builtins.str,
                 name: _builtins.str,
                 schedule: _builtins.str,
                 schema_fields: Sequence[_builtins.str],
                 scope: _builtins.str,
                 storage_container_name: _builtins.str,
                 filter: Optional['outputs.BlobInventoryPolicyRuleFilter'] = None):
        """
        :param _builtins.str format: The format of the inventory files. Possible values are `Csv` and `Parquet`.
        :param _builtins.str name: The name which should be used for this Blob Inventory Policy Rule.
        :param _builtins.str schedule: The inventory schedule applied by this rule. Possible values are `Daily` and `Weekly`.
        :param Sequence[_builtins.str] schema_fields: A list of fields to be included in the inventory. See the [Azure API reference](https://docs.microsoft.com/rest/api/storagerp/blob-inventory-policies/create-or-update#blobinventorypolicydefinition) for all the supported fields.
        :param _builtins.str scope: The scope of the inventory for this rule. Possible values are `Blob` and `Container`.
        :param _builtins.str storage_container_name: The storage container name to store the blob inventory files for this rule.
        :param 'BlobInventoryPolicyRuleFilterArgs' filter: A `filter` block as defined above.
        """
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "schedule", schedule)
        pulumi.set(__self__, "schema_fields", schema_fields)
        pulumi.set(__self__, "scope", scope)
        pulumi.set(__self__, "storage_container_name", storage_container_name)
        if filter is not None:
            pulumi.set(__self__, "filter", filter)

    @_builtins.property
    @pulumi.getter
    def format(self) -> _builtins.str:
        """
        The format of the inventory files. Possible values are `Csv` and `Parquet`.
        """
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name which should be used for this Blob Inventory Policy Rule.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> _builtins.str:
        """
        The inventory schedule applied by this rule. Possible values are `Daily` and `Weekly`.
        """
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter(name="schemaFields")
    def schema_fields(self) -> Sequence[_builtins.str]:
        """
        A list of fields to be included in the inventory. See the [Azure API reference](https://docs.microsoft.com/rest/api/storagerp/blob-inventory-policies/create-or-update#blobinventorypolicydefinition) for all the supported fields.
        """
        return pulumi.get(self, "schema_fields")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> _builtins.str:
        """
        The scope of the inventory for this rule. Possible values are `Blob` and `Container`.
        """
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter(name="storageContainerName")
    def storage_container_name(self) -> _builtins.str:
        """
        The storage container name to store the blob inventory files for this rule.
        """
        return pulumi.get(self, "storage_container_name")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> Optional['outputs.BlobInventoryPolicyRuleFilter']:
        """
        A `filter` block as defined above.
        """
        return pulumi.get(self, "filter")


@pulumi.output_type
class BlobInventoryPolicyRuleFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blobTypes":
            suggest = "blob_types"
        elif key == "excludePrefixes":
            suggest = "exclude_prefixes"
        elif key == "includeBlobVersions":
            suggest = "include_blob_versions"
        elif key == "includeDeleted":
            suggest = "include_deleted"
        elif key == "includeSnapshots":
            suggest = "include_snapshots"
        elif key == "prefixMatches":
            suggest = "prefix_matches"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BlobInventoryPolicyRuleFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BlobInventoryPolicyRuleFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BlobInventoryPolicyRuleFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 blob_types: Sequence[_builtins.str],
                 exclude_prefixes: Optional[Sequence[_builtins.str]] = None,
                 include_blob_versions: Optional[_builtins.bool] = None,
                 include_deleted: Optional[_builtins.bool] = None,
                 include_snapshots: Optional[_builtins.bool] = None,
                 prefix_matches: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] blob_types: A set of blob types. Possible values are `blockBlob`, `appendBlob`, and `pageBlob`. The storage account with `is_hns_enabled` is `true` doesn't support `pageBlob`.
               
               > **Note:** The `rules.*.schema_fields` for this rule has to include `BlobType` so that you can specify the `blob_types`.
        :param Sequence[_builtins.str] exclude_prefixes: A set of strings for blob prefixes to be excluded. Maximum of 10 blob prefixes.
        :param _builtins.bool include_blob_versions: Includes blob versions in blob inventory or not? Defaults to `false`.
               
               > **Note:** The `rules.*.schema_fields` for this rule has to include `IsCurrentVersion` and `VersionId` so that you can specify the `include_blob_versions`.
        :param _builtins.bool include_deleted: Includes deleted blobs in blob inventory or not? Defaults to `false`.
               
               > **Note:** If `rules.*.scope` is `Container`, the `rules.*.schema_fields` for this rule must include `Deleted`, `Version`, `DeletedTime`, and `RemainingRetentionDays` so that you can specify the `include_deleted`. If `rules.*.scope` is `Blob`, the `rules.*.schema_fields` must include `Deleted` and `RemainingRetentionDays` so that you can specify the `include_deleted`. If `rules.*.scope` is `Blob` and the storage account specified by `storage_account_id` has hierarchical namespaces enabled (`is_hns_enabled` is `true` on the storage account), the `rules.*.schema_fields` for this rule must include `Deleted`, `Version`, `DeletedTime`, and `RemainingRetentionDays` so that you can specify the `include_deleted`.
        :param _builtins.bool include_snapshots: Includes blob snapshots in blob inventory or not? Defaults to `false`.
               
               > **Note:** The `rules.*.schema_fields` for this rule has to include `Snapshot` so that you can specify the `include_snapshots`.
        :param Sequence[_builtins.str] prefix_matches: A set of strings for blob prefixes to be matched. Maximum of 10 blob prefixes.
        """
        pulumi.set(__self__, "blob_types", blob_types)
        if exclude_prefixes is not None:
            pulumi.set(__self__, "exclude_prefixes", exclude_prefixes)
        if include_blob_versions is not None:
            pulumi.set(__self__, "include_blob_versions", include_blob_versions)
        if include_deleted is not None:
            pulumi.set(__self__, "include_deleted", include_deleted)
        if include_snapshots is not None:
            pulumi.set(__self__, "include_snapshots", include_snapshots)
        if prefix_matches is not None:
            pulumi.set(__self__, "prefix_matches", prefix_matches)

    @_builtins.property
    @pulumi.getter(name="blobTypes")
    def blob_types(self) -> Sequence[_builtins.str]:
        """
        A set of blob types. Possible values are `blockBlob`, `appendBlob`, and `pageBlob`. The storage account with `is_hns_enabled` is `true` doesn't support `pageBlob`.

        > **Note:** The `rules.*.schema_fields` for this rule has to include `BlobType` so that you can specify the `blob_types`.
        """
        return pulumi.get(self, "blob_types")

    @_builtins.property
    @pulumi.getter(name="excludePrefixes")
    def exclude_prefixes(self) -> Optional[Sequence[_builtins.str]]:
        """
        A set of strings for blob prefixes to be excluded. Maximum of 10 blob prefixes.
        """
        return pulumi.get(self, "exclude_prefixes")

    @_builtins.property
    @pulumi.getter(name="includeBlobVersions")
    def include_blob_versions(self) -> Optional[_builtins.bool]:
        """
        Includes blob versions in blob inventory or not? Defaults to `false`.

        > **Note:** The `rules.*.schema_fields` for this rule has to include `IsCurrentVersion` and `VersionId` so that you can specify the `include_blob_versions`.
        """
        return pulumi.get(self, "include_blob_versions")

    @_builtins.property
    @pulumi.getter(name="includeDeleted")
    def include_deleted(self) -> Optional[_builtins.bool]:
        """
        Includes deleted blobs in blob inventory or not? Defaults to `false`.

        > **Note:** If `rules.*.scope` is `Container`, the `rules.*.schema_fields` for this rule must include `Deleted`, `Version`, `DeletedTime`, and `RemainingRetentionDays` so that you can specify the `include_deleted`. If `rules.*.scope` is `Blob`, the `rules.*.schema_fields` must include `Deleted` and `RemainingRetentionDays` so that you can specify the `include_deleted`. If `rules.*.scope` is `Blob` and the storage account specified by `storage_account_id` has hierarchical namespaces enabled (`is_hns_enabled` is `true` on the storage account), the `rules.*.schema_fields` for this rule must include `Deleted`, `Version`, `DeletedTime`, and `RemainingRetentionDays` so that you can specify the `include_deleted`.
        """
        return pulumi.get(self, "include_deleted")

    @_builtins.property
    @pulumi.getter(name="includeSnapshots")
    def include_snapshots(self) -> Optional[_builtins.bool]:
        """
        Includes blob snapshots in blob inventory or not? Defaults to `false`.

        > **Note:** The `rules.*.schema_fields` for this rule has to include `Snapshot` so that you can specify the `include_snapshots`.
        """
        return pulumi.get(self, "include_snapshots")

    @_builtins.property
    @pulumi.getter(name="prefixMatches")
    def prefix_matches(self) -> Optional[Sequence[_builtins.str]]:
        """
        A set of strings for blob prefixes to be matched. Maximum of 10 blob prefixes.
        """
        return pulumi.get(self, "prefix_matches")


@pulumi.output_type
class DataLakeGen2FilesystemAce(dict):
    def __init__(__self__, *,
                 permissions: _builtins.str,
                 type: _builtins.str,
                 id: Optional[_builtins.str] = None,
                 scope: Optional[_builtins.str] = None):
        """
        :param _builtins.str permissions: Specifies the permissions for the entry in `rwx` form. For example, `rwx` gives full permissions but `r--` only gives read permissions.
               
               More details on ACLs can be found here: <https://docs.microsoft.com/azure/storage/blobs/data-lake-storage-access-control#access-control-lists-on-files-and-directories>
        :param _builtins.str type: Specifies the type of entry. Can be `user`, `group`, `mask` or `other`.
        :param _builtins.str id: Specifies the Object ID of the Azure Active Directory User or Group that the entry relates to. Only valid for `user` or `group` entries.
        :param _builtins.str scope: Specifies whether the ACE represents an `access` entry or a `default` entry. Default value is `access`.
        """
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> _builtins.str:
        """
        Specifies the permissions for the entry in `rwx` form. For example, `rwx` gives full permissions but `r--` only gives read permissions.

        More details on ACLs can be found here: <https://docs.microsoft.com/azure/storage/blobs/data-lake-storage-access-control#access-control-lists-on-files-and-directories>
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of entry. Can be `user`, `group`, `mask` or `other`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Specifies the Object ID of the Azure Active Directory User or Group that the entry relates to. Only valid for `user` or `group` entries.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[_builtins.str]:
        """
        Specifies whether the ACE represents an `access` entry or a `default` entry. Default value is `access`.
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class DataLakeGen2PathAce(dict):
    def __init__(__self__, *,
                 permissions: _builtins.str,
                 type: _builtins.str,
                 id: Optional[_builtins.str] = None,
                 scope: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of entry. Can be `user`, `group`, `mask` or `other`.
        :param _builtins.str id: Specifies the Object ID of the Azure Active Directory User or Group that the entry relates to. Only valid for `user` or `group` entries.
        :param _builtins.str scope: Specifies whether the ACE represents an `access` entry or a `default` entry. Default value is `access`.
        """
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "type", type)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> _builtins.str:
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of entry. Can be `user`, `group`, `mask` or `other`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Specifies the Object ID of the Azure Active Directory User or Group that the entry relates to. Only valid for `user` or `group` entries.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[_builtins.str]:
        """
        Specifies whether the ACE represents an `access` entry or a `default` entry. Default value is `access`.
        """
        return pulumi.get(self, "scope")


@pulumi.output_type
class LocalUserPermissionScope(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceName":
            suggest = "resource_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocalUserPermissionScope. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocalUserPermissionScope.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocalUserPermissionScope.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 permissions: 'outputs.LocalUserPermissionScopePermissions',
                 resource_name: _builtins.str,
                 service: _builtins.str):
        """
        :param 'LocalUserPermissionScopePermissionsArgs' permissions: A `permissions` block as defined below.
        :param _builtins.str resource_name: The container name (when `service` is set to `blob`) or the file share name (when `service` is set to `file`), used by the Storage Account Local User.
        :param _builtins.str service: The storage service used by this Storage Account Local User. Possible values are `blob` and `file`.
        """
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "resource_name", resource_name)
        pulumi.set(__self__, "service", service)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> 'outputs.LocalUserPermissionScopePermissions':
        """
        A `permissions` block as defined below.
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> _builtins.str:
        """
        The container name (when `service` is set to `blob`) or the file share name (when `service` is set to `file`), used by the Storage Account Local User.
        """
        return pulumi.get(self, "resource_name")

    @_builtins.property
    @pulumi.getter
    def service(self) -> _builtins.str:
        """
        The storage service used by this Storage Account Local User. Possible values are `blob` and `file`.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class LocalUserPermissionScopePermissions(dict):
    def __init__(__self__, *,
                 create: Optional[_builtins.bool] = None,
                 delete: Optional[_builtins.bool] = None,
                 list: Optional[_builtins.bool] = None,
                 read: Optional[_builtins.bool] = None,
                 write: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool create: Specifies if the Local User has the create permission for this scope. Defaults to `false`.
        :param _builtins.bool delete: Specifies if the Local User has the delete permission for this scope. Defaults to `false`.
        :param _builtins.bool list: Specifies if the Local User has the list permission for this scope. Defaults to `false`.
        :param _builtins.bool read: Specifies if the Local User has the read permission for this scope. Defaults to `false`.
        :param _builtins.bool write: Specifies if the Local User has the write permission for this scope. Defaults to `false`.
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if list is not None:
            pulumi.set(__self__, "list", list)
        if read is not None:
            pulumi.set(__self__, "read", read)
        if write is not None:
            pulumi.set(__self__, "write", write)

    @_builtins.property
    @pulumi.getter
    def create(self) -> Optional[_builtins.bool]:
        """
        Specifies if the Local User has the create permission for this scope. Defaults to `false`.
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> Optional[_builtins.bool]:
        """
        Specifies if the Local User has the delete permission for this scope. Defaults to `false`.
        """
        return pulumi.get(self, "delete")

    @_builtins.property
    @pulumi.getter
    def list(self) -> Optional[_builtins.bool]:
        """
        Specifies if the Local User has the list permission for this scope. Defaults to `false`.
        """
        return pulumi.get(self, "list")

    @_builtins.property
    @pulumi.getter
    def read(self) -> Optional[_builtins.bool]:
        """
        Specifies if the Local User has the read permission for this scope. Defaults to `false`.
        """
        return pulumi.get(self, "read")

    @_builtins.property
    @pulumi.getter
    def write(self) -> Optional[_builtins.bool]:
        """
        Specifies if the Local User has the write permission for this scope. Defaults to `false`.
        """
        return pulumi.get(self, "write")


@pulumi.output_type
class LocalUserSshAuthorizedKey(dict):
    def __init__(__self__, *,
                 key: _builtins.str,
                 description: Optional[_builtins.str] = None):
        """
        :param _builtins.str key: The public key value of this SSH authorized key.
        :param _builtins.str description: The description of this SSH authorized key.
        """
        pulumi.set(__self__, "key", key)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def key(self) -> _builtins.str:
        """
        The public key value of this SSH authorized key.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[_builtins.str]:
        """
        The description of this SSH authorized key.
        """
        return pulumi.get(self, "description")


@pulumi.output_type
class ManagementPolicyRule(dict):
    def __init__(__self__, *,
                 actions: 'outputs.ManagementPolicyRuleActions',
                 enabled: _builtins.bool,
                 filters: 'outputs.ManagementPolicyRuleFilters',
                 name: _builtins.str):
        """
        :param 'ManagementPolicyRuleActionsArgs' actions: An `actions` block as documented below.
        :param _builtins.bool enabled: Boolean to specify whether the rule is enabled.
        :param 'ManagementPolicyRuleFiltersArgs' filters: A `filters` block as documented below.
        :param _builtins.str name: The name of the rule. Rule name is case-sensitive. It must be unique within a policy.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "filters", filters)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> 'outputs.ManagementPolicyRuleActions':
        """
        An `actions` block as documented below.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Boolean to specify whether the rule is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> 'outputs.ManagementPolicyRuleFilters':
        """
        A `filters` block as documented below.
        """
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the rule. Rule name is case-sensitive. It must be unique within a policy.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ManagementPolicyRuleActions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseBlob":
            suggest = "base_blob"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagementPolicyRuleActions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagementPolicyRuleActions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagementPolicyRuleActions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_blob: Optional['outputs.ManagementPolicyRuleActionsBaseBlob'] = None,
                 snapshot: Optional['outputs.ManagementPolicyRuleActionsSnapshot'] = None,
                 version: Optional['outputs.ManagementPolicyRuleActionsVersion'] = None):
        """
        :param 'ManagementPolicyRuleActionsBaseBlobArgs' base_blob: A `base_blob` block as documented below.
        :param 'ManagementPolicyRuleActionsSnapshotArgs' snapshot: A `snapshot` block as documented below.
        :param 'ManagementPolicyRuleActionsVersionArgs' version: A `version` block as documented below.
        """
        if base_blob is not None:
            pulumi.set(__self__, "base_blob", base_blob)
        if snapshot is not None:
            pulumi.set(__self__, "snapshot", snapshot)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="baseBlob")
    def base_blob(self) -> Optional['outputs.ManagementPolicyRuleActionsBaseBlob']:
        """
        A `base_blob` block as documented below.
        """
        return pulumi.get(self, "base_blob")

    @_builtins.property
    @pulumi.getter
    def snapshot(self) -> Optional['outputs.ManagementPolicyRuleActionsSnapshot']:
        """
        A `snapshot` block as documented below.
        """
        return pulumi.get(self, "snapshot")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional['outputs.ManagementPolicyRuleActionsVersion']:
        """
        A `version` block as documented below.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ManagementPolicyRuleActionsBaseBlob(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoTierToHotFromCoolEnabled":
            suggest = "auto_tier_to_hot_from_cool_enabled"
        elif key == "deleteAfterDaysSinceCreationGreaterThan":
            suggest = "delete_after_days_since_creation_greater_than"
        elif key == "deleteAfterDaysSinceLastAccessTimeGreaterThan":
            suggest = "delete_after_days_since_last_access_time_greater_than"
        elif key == "deleteAfterDaysSinceModificationGreaterThan":
            suggest = "delete_after_days_since_modification_greater_than"
        elif key == "tierToArchiveAfterDaysSinceCreationGreaterThan":
            suggest = "tier_to_archive_after_days_since_creation_greater_than"
        elif key == "tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan":
            suggest = "tier_to_archive_after_days_since_last_access_time_greater_than"
        elif key == "tierToArchiveAfterDaysSinceLastTierChangeGreaterThan":
            suggest = "tier_to_archive_after_days_since_last_tier_change_greater_than"
        elif key == "tierToArchiveAfterDaysSinceModificationGreaterThan":
            suggest = "tier_to_archive_after_days_since_modification_greater_than"
        elif key == "tierToColdAfterDaysSinceCreationGreaterThan":
            suggest = "tier_to_cold_after_days_since_creation_greater_than"
        elif key == "tierToColdAfterDaysSinceLastAccessTimeGreaterThan":
            suggest = "tier_to_cold_after_days_since_last_access_time_greater_than"
        elif key == "tierToColdAfterDaysSinceModificationGreaterThan":
            suggest = "tier_to_cold_after_days_since_modification_greater_than"
        elif key == "tierToCoolAfterDaysSinceCreationGreaterThan":
            suggest = "tier_to_cool_after_days_since_creation_greater_than"
        elif key == "tierToCoolAfterDaysSinceLastAccessTimeGreaterThan":
            suggest = "tier_to_cool_after_days_since_last_access_time_greater_than"
        elif key == "tierToCoolAfterDaysSinceModificationGreaterThan":
            suggest = "tier_to_cool_after_days_since_modification_greater_than"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagementPolicyRuleActionsBaseBlob. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagementPolicyRuleActionsBaseBlob.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagementPolicyRuleActionsBaseBlob.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_tier_to_hot_from_cool_enabled: Optional[_builtins.bool] = None,
                 delete_after_days_since_creation_greater_than: Optional[_builtins.int] = None,
                 delete_after_days_since_last_access_time_greater_than: Optional[_builtins.int] = None,
                 delete_after_days_since_modification_greater_than: Optional[_builtins.int] = None,
                 tier_to_archive_after_days_since_creation_greater_than: Optional[_builtins.int] = None,
                 tier_to_archive_after_days_since_last_access_time_greater_than: Optional[_builtins.int] = None,
                 tier_to_archive_after_days_since_last_tier_change_greater_than: Optional[_builtins.int] = None,
                 tier_to_archive_after_days_since_modification_greater_than: Optional[_builtins.int] = None,
                 tier_to_cold_after_days_since_creation_greater_than: Optional[_builtins.int] = None,
                 tier_to_cold_after_days_since_last_access_time_greater_than: Optional[_builtins.int] = None,
                 tier_to_cold_after_days_since_modification_greater_than: Optional[_builtins.int] = None,
                 tier_to_cool_after_days_since_creation_greater_than: Optional[_builtins.int] = None,
                 tier_to_cool_after_days_since_last_access_time_greater_than: Optional[_builtins.int] = None,
                 tier_to_cool_after_days_since_modification_greater_than: Optional[_builtins.int] = None):
        """
        :param _builtins.bool auto_tier_to_hot_from_cool_enabled: Whether a blob should automatically be tiered from cool back to hot if it's accessed again after being tiered to cool. Defaults to `false`.
               
               > **Note:** The `auto_tier_to_hot_from_cool_enabled` must be used together with `tier_to_cool_after_days_since_last_access_time_greater_than`.
        :param _builtins.int delete_after_days_since_creation_greater_than: The age in days after creation to delete the blob. Must be between `0` and `99999`. Defaults to `-1`.
               
               > **Note:** The `delete_after_days_since_modification_greater_than`, `delete_after_days_since_last_access_time_greater_than` and `delete_after_days_since_creation_greater_than` can not be set at the same time.
               
               > **Note:** The `last_access_time_enabled` must be set to `true` in the `storage.Account` in order to use `tier_to_cool_after_days_since_last_access_time_greater_than`, `tier_to_archive_after_days_since_last_access_time_greater_than` and `delete_after_days_since_last_access_time_greater_than`.
        :param _builtins.int delete_after_days_since_last_access_time_greater_than: The age in days after last access time to delete the blob. Must be between `0` and `99999`. Defaults to `-1`.
        :param _builtins.int delete_after_days_since_modification_greater_than: The age in days after last modification to delete the blob. Must be between `0` and `99999`. Defaults to `-1`.
        :param _builtins.int tier_to_archive_after_days_since_creation_greater_than: The age in days after creation to archive storage. Supports blob currently at Hot or Cool tier. Must be between `0` and `99999`. Defaults to `-1`.
               
               > **Note:** The `tier_to_archive_after_days_since_modification_greater_than`, `tier_to_archive_after_days_since_last_access_time_greater_than` and `tier_to_archive_after_days_since_creation_greater_than` can not be set at the same time.
        :param _builtins.int tier_to_archive_after_days_since_last_access_time_greater_than: The age in days after last access time to tier blobs to archive storage. Supports blob currently at Hot or Cool tier. Must be between `0` and `99999`. Defaults to `-1`.
        :param _builtins.int tier_to_archive_after_days_since_last_tier_change_greater_than: The age in days after last tier change to the blobs to skip to be archived. Must be between `0` and `99999`. Defaults to `-1`.
        :param _builtins.int tier_to_archive_after_days_since_modification_greater_than: The age in days after last modification to tier blobs to archive storage. Supports blob currently at Hot or Cool tier. Must be between `0` and `99999`. Defaults to `-1`.
        :param _builtins.int tier_to_cold_after_days_since_creation_greater_than: The age in days after creation to cold storage. Supports blob currently at Hot tier. Must be between `0` and `99999`. Defaults to `-1`.
               
               > **Note:** The `tier_to_cool_after_days_since_modification_greater_than`, `tier_to_cool_after_days_since_last_access_time_greater_than` and `tier_to_cool_after_days_since_creation_greater_than` can not be set at the same time.
        :param _builtins.int tier_to_cold_after_days_since_last_access_time_greater_than: The age in days after last access time to tier blobs to cold storage. Supports blob currently at Hot tier. Must be between `0` and `99999`. Defaults to `-1`.
        :param _builtins.int tier_to_cold_after_days_since_modification_greater_than: The age in days after last modification to tier blobs to cold storage. Supports blob currently at Hot tier. Must be between `0` and `99999`. Defaults to `-1`.
        :param _builtins.int tier_to_cool_after_days_since_creation_greater_than: The age in days after creation to cool storage. Supports blob currently at Hot tier. Must be between `0` and `99999`. Defaults to `-1`.
               
               > **Note:** The `tier_to_cool_after_days_since_modification_greater_than`, `tier_to_cool_after_days_since_last_access_time_greater_than` and `tier_to_cool_after_days_since_creation_greater_than` can not be set at the same time.
        :param _builtins.int tier_to_cool_after_days_since_last_access_time_greater_than: The age in days after last access time to tier blobs to cool storage. Supports blob currently at Hot tier. Must be between `0` and `99999`. Defaults to `-1`.
        :param _builtins.int tier_to_cool_after_days_since_modification_greater_than: The age in days after last modification to tier blobs to cool storage. Supports blob currently at Hot tier. Must be between `0` and `99999`. Defaults to `-1`.
        """
        if auto_tier_to_hot_from_cool_enabled is not None:
            pulumi.set(__self__, "auto_tier_to_hot_from_cool_enabled", auto_tier_to_hot_from_cool_enabled)
        if delete_after_days_since_creation_greater_than is not None:
            pulumi.set(__self__, "delete_after_days_since_creation_greater_than", delete_after_days_since_creation_greater_than)
        if delete_after_days_since_last_access_time_greater_than is not None:
            pulumi.set(__self__, "delete_after_days_since_last_access_time_greater_than", delete_after_days_since_last_access_time_greater_than)
        if delete_after_days_since_modification_greater_than is not None:
            pulumi.set(__self__, "delete_after_days_since_modification_greater_than", delete_after_days_since_modification_greater_than)
        if tier_to_archive_after_days_since_creation_greater_than is not None:
            pulumi.set(__self__, "tier_to_archive_after_days_since_creation_greater_than", tier_to_archive_after_days_since_creation_greater_than)
        if tier_to_archive_after_days_since_last_access_time_greater_than is not None:
            pulumi.set(__self__, "tier_to_archive_after_days_since_last_access_time_greater_than", tier_to_archive_after_days_since_last_access_time_greater_than)
        if tier_to_archive_after_days_since_last_tier_change_greater_than is not None:
            pulumi.set(__self__, "tier_to_archive_after_days_since_last_tier_change_greater_than", tier_to_archive_after_days_since_last_tier_change_greater_than)
        if tier_to_archive_after_days_since_modification_greater_than is not None:
            pulumi.set(__self__, "tier_to_archive_after_days_since_modification_greater_than", tier_to_archive_after_days_since_modification_greater_than)
        if tier_to_cold_after_days_since_creation_greater_than is not None:
            pulumi.set(__self__, "tier_to_cold_after_days_since_creation_greater_than", tier_to_cold_after_days_since_creation_greater_than)
        if tier_to_cold_after_days_since_last_access_time_greater_than is not None:
            pulumi.set(__self__, "tier_to_cold_after_days_since_last_access_time_greater_than", tier_to_cold_after_days_since_last_access_time_greater_than)
        if tier_to_cold_after_days_since_modification_greater_than is not None:
            pulumi.set(__self__, "tier_to_cold_after_days_since_modification_greater_than", tier_to_cold_after_days_since_modification_greater_than)
        if tier_to_cool_after_days_since_creation_greater_than is not None:
            pulumi.set(__self__, "tier_to_cool_after_days_since_creation_greater_than", tier_to_cool_after_days_since_creation_greater_than)
        if tier_to_cool_after_days_since_last_access_time_greater_than is not None:
            pulumi.set(__self__, "tier_to_cool_after_days_since_last_access_time_greater_than", tier_to_cool_after_days_since_last_access_time_greater_than)
        if tier_to_cool_after_days_since_modification_greater_than is not None:
            pulumi.set(__self__, "tier_to_cool_after_days_since_modification_greater_than", tier_to_cool_after_days_since_modification_greater_than)

    @_builtins.property
    @pulumi.getter(name="autoTierToHotFromCoolEnabled")
    def auto_tier_to_hot_from_cool_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether a blob should automatically be tiered from cool back to hot if it's accessed again after being tiered to cool. Defaults to `false`.

        > **Note:** The `auto_tier_to_hot_from_cool_enabled` must be used together with `tier_to_cool_after_days_since_last_access_time_greater_than`.
        """
        return pulumi.get(self, "auto_tier_to_hot_from_cool_enabled")

    @_builtins.property
    @pulumi.getter(name="deleteAfterDaysSinceCreationGreaterThan")
    def delete_after_days_since_creation_greater_than(self) -> Optional[_builtins.int]:
        """
        The age in days after creation to delete the blob. Must be between `0` and `99999`. Defaults to `-1`.

        > **Note:** The `delete_after_days_since_modification_greater_than`, `delete_after_days_since_last_access_time_greater_than` and `delete_after_days_since_creation_greater_than` can not be set at the same time.

        > **Note:** The `last_access_time_enabled` must be set to `true` in the `storage.Account` in order to use `tier_to_cool_after_days_since_last_access_time_greater_than`, `tier_to_archive_after_days_since_last_access_time_greater_than` and `delete_after_days_since_last_access_time_greater_than`.
        """
        return pulumi.get(self, "delete_after_days_since_creation_greater_than")

    @_builtins.property
    @pulumi.getter(name="deleteAfterDaysSinceLastAccessTimeGreaterThan")
    def delete_after_days_since_last_access_time_greater_than(self) -> Optional[_builtins.int]:
        """
        The age in days after last access time to delete the blob. Must be between `0` and `99999`. Defaults to `-1`.
        """
        return pulumi.get(self, "delete_after_days_since_last_access_time_greater_than")

    @_builtins.property
    @pulumi.getter(name="deleteAfterDaysSinceModificationGreaterThan")
    def delete_after_days_since_modification_greater_than(self) -> Optional[_builtins.int]:
        """
        The age in days after last modification to delete the blob. Must be between `0` and `99999`. Defaults to `-1`.
        """
        return pulumi.get(self, "delete_after_days_since_modification_greater_than")

    @_builtins.property
    @pulumi.getter(name="tierToArchiveAfterDaysSinceCreationGreaterThan")
    def tier_to_archive_after_days_since_creation_greater_than(self) -> Optional[_builtins.int]:
        """
        The age in days after creation to archive storage. Supports blob currently at Hot or Cool tier. Must be between `0` and `99999`. Defaults to `-1`.

        > **Note:** The `tier_to_archive_after_days_since_modification_greater_than`, `tier_to_archive_after_days_since_last_access_time_greater_than` and `tier_to_archive_after_days_since_creation_greater_than` can not be set at the same time.
        """
        return pulumi.get(self, "tier_to_archive_after_days_since_creation_greater_than")

    @_builtins.property
    @pulumi.getter(name="tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan")
    def tier_to_archive_after_days_since_last_access_time_greater_than(self) -> Optional[_builtins.int]:
        """
        The age in days after last access time to tier blobs to archive storage. Supports blob currently at Hot or Cool tier. Must be between `0` and `99999`. Defaults to `-1`.
        """
        return pulumi.get(self, "tier_to_archive_after_days_since_last_access_time_greater_than")

    @_builtins.property
    @pulumi.getter(name="tierToArchiveAfterDaysSinceLastTierChangeGreaterThan")
    def tier_to_archive_after_days_since_last_tier_change_greater_than(self) -> Optional[_builtins.int]:
        """
        The age in days after last tier change to the blobs to skip to be archived. Must be between `0` and `99999`. Defaults to `-1`.
        """
        return pulumi.get(self, "tier_to_archive_after_days_since_last_tier_change_greater_than")

    @_builtins.property
    @pulumi.getter(name="tierToArchiveAfterDaysSinceModificationGreaterThan")
    def tier_to_archive_after_days_since_modification_greater_than(self) -> Optional[_builtins.int]:
        """
        The age in days after last modification to tier blobs to archive storage. Supports blob currently at Hot or Cool tier. Must be between `0` and `99999`. Defaults to `-1`.
        """
        return pulumi.get(self, "tier_to_archive_after_days_since_modification_greater_than")

    @_builtins.property
    @pulumi.getter(name="tierToColdAfterDaysSinceCreationGreaterThan")
    def tier_to_cold_after_days_since_creation_greater_than(self) -> Optional[_builtins.int]:
        """
        The age in days after creation to cold storage. Supports blob currently at Hot tier. Must be between `0` and `99999`. Defaults to `-1`.

        > **Note:** The `tier_to_cool_after_days_since_modification_greater_than`, `tier_to_cool_after_days_since_last_access_time_greater_than` and `tier_to_cool_after_days_since_creation_greater_than` can not be set at the same time.
        """
        return pulumi.get(self, "tier_to_cold_after_days_since_creation_greater_than")

    @_builtins.property
    @pulumi.getter(name="tierToColdAfterDaysSinceLastAccessTimeGreaterThan")
    def tier_to_cold_after_days_since_last_access_time_greater_than(self) -> Optional[_builtins.int]:
        """
        The age in days after last access time to tier blobs to cold storage. Supports blob currently at Hot tier. Must be between `0` and `99999`. Defaults to `-1`.
        """
        return pulumi.get(self, "tier_to_cold_after_days_since_last_access_time_greater_than")

    @_builtins.property
    @pulumi.getter(name="tierToColdAfterDaysSinceModificationGreaterThan")
    def tier_to_cold_after_days_since_modification_greater_than(self) -> Optional[_builtins.int]:
        """
        The age in days after last modification to tier blobs to cold storage. Supports blob currently at Hot tier. Must be between `0` and `99999`. Defaults to `-1`.
        """
        return pulumi.get(self, "tier_to_cold_after_days_since_modification_greater_than")

    @_builtins.property
    @pulumi.getter(name="tierToCoolAfterDaysSinceCreationGreaterThan")
    def tier_to_cool_after_days_since_creation_greater_than(self) -> Optional[_builtins.int]:
        """
        The age in days after creation to cool storage. Supports blob currently at Hot tier. Must be between `0` and `99999`. Defaults to `-1`.

        > **Note:** The `tier_to_cool_after_days_since_modification_greater_than`, `tier_to_cool_after_days_since_last_access_time_greater_than` and `tier_to_cool_after_days_since_creation_greater_than` can not be set at the same time.
        """
        return pulumi.get(self, "tier_to_cool_after_days_since_creation_greater_than")

    @_builtins.property
    @pulumi.getter(name="tierToCoolAfterDaysSinceLastAccessTimeGreaterThan")
    def tier_to_cool_after_days_since_last_access_time_greater_than(self) -> Optional[_builtins.int]:
        """
        The age in days after last access time to tier blobs to cool storage. Supports blob currently at Hot tier. Must be between `0` and `99999`. Defaults to `-1`.
        """
        return pulumi.get(self, "tier_to_cool_after_days_since_last_access_time_greater_than")

    @_builtins.property
    @pulumi.getter(name="tierToCoolAfterDaysSinceModificationGreaterThan")
    def tier_to_cool_after_days_since_modification_greater_than(self) -> Optional[_builtins.int]:
        """
        The age in days after last modification to tier blobs to cool storage. Supports blob currently at Hot tier. Must be between `0` and `99999`. Defaults to `-1`.
        """
        return pulumi.get(self, "tier_to_cool_after_days_since_modification_greater_than")


@pulumi.output_type
class ManagementPolicyRuleActionsSnapshot(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "changeTierToArchiveAfterDaysSinceCreation":
            suggest = "change_tier_to_archive_after_days_since_creation"
        elif key == "changeTierToCoolAfterDaysSinceCreation":
            suggest = "change_tier_to_cool_after_days_since_creation"
        elif key == "deleteAfterDaysSinceCreationGreaterThan":
            suggest = "delete_after_days_since_creation_greater_than"
        elif key == "tierToArchiveAfterDaysSinceLastTierChangeGreaterThan":
            suggest = "tier_to_archive_after_days_since_last_tier_change_greater_than"
        elif key == "tierToColdAfterDaysSinceCreationGreaterThan":
            suggest = "tier_to_cold_after_days_since_creation_greater_than"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagementPolicyRuleActionsSnapshot. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagementPolicyRuleActionsSnapshot.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagementPolicyRuleActionsSnapshot.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 change_tier_to_archive_after_days_since_creation: Optional[_builtins.int] = None,
                 change_tier_to_cool_after_days_since_creation: Optional[_builtins.int] = None,
                 delete_after_days_since_creation_greater_than: Optional[_builtins.int] = None,
                 tier_to_archive_after_days_since_last_tier_change_greater_than: Optional[_builtins.int] = None,
                 tier_to_cold_after_days_since_creation_greater_than: Optional[_builtins.int] = None):
        """
        :param _builtins.int change_tier_to_archive_after_days_since_creation: The age in days after creation to tier blob snapshot to archive storage. Must be between `0` and `99999`. Defaults to `-1`.
        :param _builtins.int change_tier_to_cool_after_days_since_creation: The age in days after creation to tier blob snapshot to cool storage. Must be between `0` and `99999`. Defaults to `-1`.
        :param _builtins.int delete_after_days_since_creation_greater_than: The age in days after creation to delete the blob snapshot. Must be between `0` and `99999`. Defaults to `-1`.
        :param _builtins.int tier_to_archive_after_days_since_last_tier_change_greater_than: The age in days after last tier change to the blobs to skip to be archived. Must be between `0` and `99999`. Defaults to `-1`.
        :param _builtins.int tier_to_cold_after_days_since_creation_greater_than: The age in days after creation to cold storage. Supports blob currently at Hot tier. Must be between `0` and `99999`. Defaults to `-1`.
        """
        if change_tier_to_archive_after_days_since_creation is not None:
            pulumi.set(__self__, "change_tier_to_archive_after_days_since_creation", change_tier_to_archive_after_days_since_creation)
        if change_tier_to_cool_after_days_since_creation is not None:
            pulumi.set(__self__, "change_tier_to_cool_after_days_since_creation", change_tier_to_cool_after_days_since_creation)
        if delete_after_days_since_creation_greater_than is not None:
            pulumi.set(__self__, "delete_after_days_since_creation_greater_than", delete_after_days_since_creation_greater_than)
        if tier_to_archive_after_days_since_last_tier_change_greater_than is not None:
            pulumi.set(__self__, "tier_to_archive_after_days_since_last_tier_change_greater_than", tier_to_archive_after_days_since_last_tier_change_greater_than)
        if tier_to_cold_after_days_since_creation_greater_than is not None:
            pulumi.set(__self__, "tier_to_cold_after_days_since_creation_greater_than", tier_to_cold_after_days_since_creation_greater_than)

    @_builtins.property
    @pulumi.getter(name="changeTierToArchiveAfterDaysSinceCreation")
    def change_tier_to_archive_after_days_since_creation(self) -> Optional[_builtins.int]:
        """
        The age in days after creation to tier blob snapshot to archive storage. Must be between `0` and `99999`. Defaults to `-1`.
        """
        return pulumi.get(self, "change_tier_to_archive_after_days_since_creation")

    @_builtins.property
    @pulumi.getter(name="changeTierToCoolAfterDaysSinceCreation")
    def change_tier_to_cool_after_days_since_creation(self) -> Optional[_builtins.int]:
        """
        The age in days after creation to tier blob snapshot to cool storage. Must be between `0` and `99999`. Defaults to `-1`.
        """
        return pulumi.get(self, "change_tier_to_cool_after_days_since_creation")

    @_builtins.property
    @pulumi.getter(name="deleteAfterDaysSinceCreationGreaterThan")
    def delete_after_days_since_creation_greater_than(self) -> Optional[_builtins.int]:
        """
        The age in days after creation to delete the blob snapshot. Must be between `0` and `99999`. Defaults to `-1`.
        """
        return pulumi.get(self, "delete_after_days_since_creation_greater_than")

    @_builtins.property
    @pulumi.getter(name="tierToArchiveAfterDaysSinceLastTierChangeGreaterThan")
    def tier_to_archive_after_days_since_last_tier_change_greater_than(self) -> Optional[_builtins.int]:
        """
        The age in days after last tier change to the blobs to skip to be archived. Must be between `0` and `99999`. Defaults to `-1`.
        """
        return pulumi.get(self, "tier_to_archive_after_days_since_last_tier_change_greater_than")

    @_builtins.property
    @pulumi.getter(name="tierToColdAfterDaysSinceCreationGreaterThan")
    def tier_to_cold_after_days_since_creation_greater_than(self) -> Optional[_builtins.int]:
        """
        The age in days after creation to cold storage. Supports blob currently at Hot tier. Must be between `0` and `99999`. Defaults to `-1`.
        """
        return pulumi.get(self, "tier_to_cold_after_days_since_creation_greater_than")


@pulumi.output_type
class ManagementPolicyRuleActionsVersion(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "changeTierToArchiveAfterDaysSinceCreation":
            suggest = "change_tier_to_archive_after_days_since_creation"
        elif key == "changeTierToCoolAfterDaysSinceCreation":
            suggest = "change_tier_to_cool_after_days_since_creation"
        elif key == "deleteAfterDaysSinceCreation":
            suggest = "delete_after_days_since_creation"
        elif key == "tierToArchiveAfterDaysSinceLastTierChangeGreaterThan":
            suggest = "tier_to_archive_after_days_since_last_tier_change_greater_than"
        elif key == "tierToColdAfterDaysSinceCreationGreaterThan":
            suggest = "tier_to_cold_after_days_since_creation_greater_than"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagementPolicyRuleActionsVersion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagementPolicyRuleActionsVersion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagementPolicyRuleActionsVersion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 change_tier_to_archive_after_days_since_creation: Optional[_builtins.int] = None,
                 change_tier_to_cool_after_days_since_creation: Optional[_builtins.int] = None,
                 delete_after_days_since_creation: Optional[_builtins.int] = None,
                 tier_to_archive_after_days_since_last_tier_change_greater_than: Optional[_builtins.int] = None,
                 tier_to_cold_after_days_since_creation_greater_than: Optional[_builtins.int] = None):
        """
        :param _builtins.int change_tier_to_archive_after_days_since_creation: The age in days after creation to tier blob version to archive storage. Must be between `0` and `99999`. Defaults to `-1`.
        :param _builtins.int change_tier_to_cool_after_days_since_creation: The age in days creation create to tier blob version to cool storage. Must be between `0` and `99999`. Defaults to `-1`.
        :param _builtins.int delete_after_days_since_creation: The age in days after creation to delete the blob version. Must be between `0` and `99999`. Defaults to `-1`.
        :param _builtins.int tier_to_archive_after_days_since_last_tier_change_greater_than: The age in days after last tier change to the blobs to skip to be archived. Must be between `0` and `99999`. Defaults to `-1`.
        :param _builtins.int tier_to_cold_after_days_since_creation_greater_than: The age in days after creation to cold storage. Supports blob currently at Hot tier. Must be between `0` and `99999`. Defaults to `-1`.
        """
        if change_tier_to_archive_after_days_since_creation is not None:
            pulumi.set(__self__, "change_tier_to_archive_after_days_since_creation", change_tier_to_archive_after_days_since_creation)
        if change_tier_to_cool_after_days_since_creation is not None:
            pulumi.set(__self__, "change_tier_to_cool_after_days_since_creation", change_tier_to_cool_after_days_since_creation)
        if delete_after_days_since_creation is not None:
            pulumi.set(__self__, "delete_after_days_since_creation", delete_after_days_since_creation)
        if tier_to_archive_after_days_since_last_tier_change_greater_than is not None:
            pulumi.set(__self__, "tier_to_archive_after_days_since_last_tier_change_greater_than", tier_to_archive_after_days_since_last_tier_change_greater_than)
        if tier_to_cold_after_days_since_creation_greater_than is not None:
            pulumi.set(__self__, "tier_to_cold_after_days_since_creation_greater_than", tier_to_cold_after_days_since_creation_greater_than)

    @_builtins.property
    @pulumi.getter(name="changeTierToArchiveAfterDaysSinceCreation")
    def change_tier_to_archive_after_days_since_creation(self) -> Optional[_builtins.int]:
        """
        The age in days after creation to tier blob version to archive storage. Must be between `0` and `99999`. Defaults to `-1`.
        """
        return pulumi.get(self, "change_tier_to_archive_after_days_since_creation")

    @_builtins.property
    @pulumi.getter(name="changeTierToCoolAfterDaysSinceCreation")
    def change_tier_to_cool_after_days_since_creation(self) -> Optional[_builtins.int]:
        """
        The age in days creation create to tier blob version to cool storage. Must be between `0` and `99999`. Defaults to `-1`.
        """
        return pulumi.get(self, "change_tier_to_cool_after_days_since_creation")

    @_builtins.property
    @pulumi.getter(name="deleteAfterDaysSinceCreation")
    def delete_after_days_since_creation(self) -> Optional[_builtins.int]:
        """
        The age in days after creation to delete the blob version. Must be between `0` and `99999`. Defaults to `-1`.
        """
        return pulumi.get(self, "delete_after_days_since_creation")

    @_builtins.property
    @pulumi.getter(name="tierToArchiveAfterDaysSinceLastTierChangeGreaterThan")
    def tier_to_archive_after_days_since_last_tier_change_greater_than(self) -> Optional[_builtins.int]:
        """
        The age in days after last tier change to the blobs to skip to be archived. Must be between `0` and `99999`. Defaults to `-1`.
        """
        return pulumi.get(self, "tier_to_archive_after_days_since_last_tier_change_greater_than")

    @_builtins.property
    @pulumi.getter(name="tierToColdAfterDaysSinceCreationGreaterThan")
    def tier_to_cold_after_days_since_creation_greater_than(self) -> Optional[_builtins.int]:
        """
        The age in days after creation to cold storage. Supports blob currently at Hot tier. Must be between `0` and `99999`. Defaults to `-1`.
        """
        return pulumi.get(self, "tier_to_cold_after_days_since_creation_greater_than")


@pulumi.output_type
class ManagementPolicyRuleFilters(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "blobTypes":
            suggest = "blob_types"
        elif key == "matchBlobIndexTags":
            suggest = "match_blob_index_tags"
        elif key == "prefixMatches":
            suggest = "prefix_matches"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagementPolicyRuleFilters. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagementPolicyRuleFilters.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagementPolicyRuleFilters.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 blob_types: Sequence[_builtins.str],
                 match_blob_index_tags: Optional[Sequence['outputs.ManagementPolicyRuleFiltersMatchBlobIndexTag']] = None,
                 prefix_matches: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] blob_types: An array of predefined values. Valid options are `blockBlob` and `appendBlob`.
        :param Sequence['ManagementPolicyRuleFiltersMatchBlobIndexTagArgs'] match_blob_index_tags: A `match_blob_index_tag` block as defined below. The block defines the blob index tag based filtering for blob objects.
               
               > **Note:** The `match_blob_index_tag` property requires enabling the `blobIndex` feature with [PSH or CLI commands](https://azure.microsoft.com/en-us/blog/manage-and-find-data-with-blob-index-for-azure-storage-now-in-preview/).
        :param Sequence[_builtins.str] prefix_matches: An array of strings for prefixes to be matched.
        """
        pulumi.set(__self__, "blob_types", blob_types)
        if match_blob_index_tags is not None:
            pulumi.set(__self__, "match_blob_index_tags", match_blob_index_tags)
        if prefix_matches is not None:
            pulumi.set(__self__, "prefix_matches", prefix_matches)

    @_builtins.property
    @pulumi.getter(name="blobTypes")
    def blob_types(self) -> Sequence[_builtins.str]:
        """
        An array of predefined values. Valid options are `blockBlob` and `appendBlob`.
        """
        return pulumi.get(self, "blob_types")

    @_builtins.property
    @pulumi.getter(name="matchBlobIndexTags")
    def match_blob_index_tags(self) -> Optional[Sequence['outputs.ManagementPolicyRuleFiltersMatchBlobIndexTag']]:
        """
        A `match_blob_index_tag` block as defined below. The block defines the blob index tag based filtering for blob objects.

        > **Note:** The `match_blob_index_tag` property requires enabling the `blobIndex` feature with [PSH or CLI commands](https://azure.microsoft.com/en-us/blog/manage-and-find-data-with-blob-index-for-azure-storage-now-in-preview/).
        """
        return pulumi.get(self, "match_blob_index_tags")

    @_builtins.property
    @pulumi.getter(name="prefixMatches")
    def prefix_matches(self) -> Optional[Sequence[_builtins.str]]:
        """
        An array of strings for prefixes to be matched.
        """
        return pulumi.get(self, "prefix_matches")


@pulumi.output_type
class ManagementPolicyRuleFiltersMatchBlobIndexTag(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str,
                 operation: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The filter tag name used for tag based filtering for blob objects.
        :param _builtins.str value: The filter tag value used for tag based filtering for blob objects.
        :param _builtins.str operation: The comparison operator which is used for object comparison and filtering. Possible value is `==`. Defaults to `==`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The filter tag name used for tag based filtering for blob objects.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The filter tag value used for tag based filtering for blob objects.
        """
        return pulumi.get(self, "value")

    @_builtins.property
    @pulumi.getter
    def operation(self) -> Optional[_builtins.str]:
        """
        The comparison operator which is used for object comparison and filtering. Possible value is `==`. Defaults to `==`.
        """
        return pulumi.get(self, "operation")


@pulumi.output_type
class ObjectReplicationRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationContainerName":
            suggest = "destination_container_name"
        elif key == "sourceContainerName":
            suggest = "source_container_name"
        elif key == "copyBlobsCreatedAfter":
            suggest = "copy_blobs_created_after"
        elif key == "filterOutBlobsWithPrefixes":
            suggest = "filter_out_blobs_with_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObjectReplicationRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObjectReplicationRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObjectReplicationRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_container_name: _builtins.str,
                 source_container_name: _builtins.str,
                 copy_blobs_created_after: Optional[_builtins.str] = None,
                 filter_out_blobs_with_prefixes: Optional[Sequence[_builtins.str]] = None,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str destination_container_name: The destination storage container name.
        :param _builtins.str source_container_name: The source storage container name.
        :param _builtins.str copy_blobs_created_after: The time after which the Block Blobs created will be copies to the destination. Possible values are `OnlyNewObjects`, `Everything` and time in RFC3339 format: `2006-01-02T15:04:00Z`. Defaults to `OnlyNewObjects`.
        :param Sequence[_builtins.str] filter_out_blobs_with_prefixes: Specifies a list of filters prefixes, the blobs whose names begin with which will be replicated.
        """
        pulumi.set(__self__, "destination_container_name", destination_container_name)
        pulumi.set(__self__, "source_container_name", source_container_name)
        if copy_blobs_created_after is not None:
            pulumi.set(__self__, "copy_blobs_created_after", copy_blobs_created_after)
        if filter_out_blobs_with_prefixes is not None:
            pulumi.set(__self__, "filter_out_blobs_with_prefixes", filter_out_blobs_with_prefixes)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="destinationContainerName")
    def destination_container_name(self) -> _builtins.str:
        """
        The destination storage container name.
        """
        return pulumi.get(self, "destination_container_name")

    @_builtins.property
    @pulumi.getter(name="sourceContainerName")
    def source_container_name(self) -> _builtins.str:
        """
        The source storage container name.
        """
        return pulumi.get(self, "source_container_name")

    @_builtins.property
    @pulumi.getter(name="copyBlobsCreatedAfter")
    def copy_blobs_created_after(self) -> Optional[_builtins.str]:
        """
        The time after which the Block Blobs created will be copies to the destination. Possible values are `OnlyNewObjects`, `Everything` and time in RFC3339 format: `2006-01-02T15:04:00Z`. Defaults to `OnlyNewObjects`.
        """
        return pulumi.get(self, "copy_blobs_created_after")

    @_builtins.property
    @pulumi.getter(name="filterOutBlobsWithPrefixes")
    def filter_out_blobs_with_prefixes(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of filters prefixes, the blobs whose names begin with which will be replicated.
        """
        return pulumi.get(self, "filter_out_blobs_with_prefixes")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name")


@pulumi.output_type
class ShareAcl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessPolicies":
            suggest = "access_policies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShareAcl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShareAcl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShareAcl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: _builtins.str,
                 access_policies: Optional[Sequence['outputs.ShareAclAccessPolicy']] = None):
        """
        :param _builtins.str id: The ID which should be used for this Shared Identifier.
        :param Sequence['ShareAclAccessPolicyArgs'] access_policies: An `access_policy` block as defined below.
        """
        pulumi.set(__self__, "id", id)
        if access_policies is not None:
            pulumi.set(__self__, "access_policies", access_policies)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID which should be used for this Shared Identifier.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="accessPolicies")
    def access_policies(self) -> Optional[Sequence['outputs.ShareAclAccessPolicy']]:
        """
        An `access_policy` block as defined below.
        """
        return pulumi.get(self, "access_policies")


@pulumi.output_type
class ShareAclAccessPolicy(dict):
    def __init__(__self__, *,
                 permissions: _builtins.str,
                 expiry: Optional[_builtins.str] = None,
                 start: Optional[_builtins.str] = None):
        """
        :param _builtins.str permissions: The permissions which should be associated with this Shared Identifier. Possible value is combination of `r` (read), `w` (write), `d` (delete), and `l` (list).
               
               > **Note:** Permission order is strict at the service side, and permissions need to be listed in the order above.
        :param _builtins.str expiry: The time at which this Access Policy should be valid untilWhen using `storage_account_id` this should be in RFC3339 format. If using the deprecated `storage_account_name` property, this uses the [ISO8601](https://en.wikipedia.org/wiki/ISO_8601) format.
        :param _builtins.str start: The time at which this Access Policy should be valid from. When using `storage_account_id` this should be in RFC3339 format. If using the deprecated `storage_account_name` property, this uses the [ISO8601](https://en.wikipedia.org/wiki/ISO_8601) format.
        """
        pulumi.set(__self__, "permissions", permissions)
        if expiry is not None:
            pulumi.set(__self__, "expiry", expiry)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> _builtins.str:
        """
        The permissions which should be associated with this Shared Identifier. Possible value is combination of `r` (read), `w` (write), `d` (delete), and `l` (list).

        > **Note:** Permission order is strict at the service side, and permissions need to be listed in the order above.
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter
    def expiry(self) -> Optional[_builtins.str]:
        """
        The time at which this Access Policy should be valid untilWhen using `storage_account_id` this should be in RFC3339 format. If using the deprecated `storage_account_name` property, this uses the [ISO8601](https://en.wikipedia.org/wiki/ISO_8601) format.
        """
        return pulumi.get(self, "expiry")

    @_builtins.property
    @pulumi.getter
    def start(self) -> Optional[_builtins.str]:
        """
        The time at which this Access Policy should be valid from. When using `storage_account_id` this should be in RFC3339 format. If using the deprecated `storage_account_name` property, this uses the [ISO8601](https://en.wikipedia.org/wiki/ISO_8601) format.
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class TableAcl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessPolicies":
            suggest = "access_policies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableAcl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableAcl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableAcl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: _builtins.str,
                 access_policies: Optional[Sequence['outputs.TableAclAccessPolicy']] = None):
        """
        :param _builtins.str id: The ID which should be used for this Shared Identifier.
        :param Sequence['TableAclAccessPolicyArgs'] access_policies: An `access_policy` block as defined below.
        """
        pulumi.set(__self__, "id", id)
        if access_policies is not None:
            pulumi.set(__self__, "access_policies", access_policies)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID which should be used for this Shared Identifier.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="accessPolicies")
    def access_policies(self) -> Optional[Sequence['outputs.TableAclAccessPolicy']]:
        """
        An `access_policy` block as defined below.
        """
        return pulumi.get(self, "access_policies")


@pulumi.output_type
class TableAclAccessPolicy(dict):
    def __init__(__self__, *,
                 expiry: _builtins.str,
                 permissions: _builtins.str,
                 start: _builtins.str):
        """
        :param _builtins.str expiry: The ISO8061 UTC time at which this Access Policy should be valid until.
        :param _builtins.str permissions: The permissions which should associated with this Shared Identifier.
        :param _builtins.str start: The ISO8061 UTC time at which this Access Policy should be valid from.
        """
        pulumi.set(__self__, "expiry", expiry)
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "start", start)

    @_builtins.property
    @pulumi.getter
    def expiry(self) -> _builtins.str:
        """
        The ISO8061 UTC time at which this Access Policy should be valid until.
        """
        return pulumi.get(self, "expiry")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> _builtins.str:
        """
        The permissions which should associated with this Shared Identifier.
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter
    def start(self) -> _builtins.str:
        """
        The ISO8061 UTC time at which this Access Policy should be valid from.
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class GetAccountAzureFilesAuthenticationResult(dict):
    def __init__(__self__, *,
                 active_directories: Sequence['outputs.GetAccountAzureFilesAuthenticationActiveDirectoryResult'],
                 default_share_level_permission: _builtins.str,
                 directory_type: _builtins.str):
        """
        :param Sequence['GetAccountAzureFilesAuthenticationActiveDirectoryArgs'] active_directories: An `active_directory` block as documented below.
        :param _builtins.str default_share_level_permission: The default share level permissions applied to all users.
        :param _builtins.str directory_type: The directory service used for this Storage Account.
        """
        pulumi.set(__self__, "active_directories", active_directories)
        pulumi.set(__self__, "default_share_level_permission", default_share_level_permission)
        pulumi.set(__self__, "directory_type", directory_type)

    @_builtins.property
    @pulumi.getter(name="activeDirectories")
    def active_directories(self) -> Sequence['outputs.GetAccountAzureFilesAuthenticationActiveDirectoryResult']:
        """
        An `active_directory` block as documented below.
        """
        return pulumi.get(self, "active_directories")

    @_builtins.property
    @pulumi.getter(name="defaultShareLevelPermission")
    def default_share_level_permission(self) -> _builtins.str:
        """
        The default share level permissions applied to all users.
        """
        return pulumi.get(self, "default_share_level_permission")

    @_builtins.property
    @pulumi.getter(name="directoryType")
    def directory_type(self) -> _builtins.str:
        """
        The directory service used for this Storage Account.
        """
        return pulumi.get(self, "directory_type")


@pulumi.output_type
class GetAccountAzureFilesAuthenticationActiveDirectoryResult(dict):
    def __init__(__self__, *,
                 domain_guid: _builtins.str,
                 domain_name: _builtins.str,
                 domain_sid: _builtins.str,
                 forest_name: _builtins.str,
                 netbios_domain_name: _builtins.str,
                 storage_sid: _builtins.str):
        """
        :param _builtins.str domain_guid: The domain GUID.
        :param _builtins.str domain_name: The primary domain that the AD DNS server is authoritative for.
        :param _builtins.str domain_sid: The domain security identifier.
        :param _builtins.str forest_name: The name of the Active Directory forest.
        :param _builtins.str netbios_domain_name: The NetBIOS domain name.
        :param _builtins.str storage_sid: The security identifier for Azure Storage.
        """
        pulumi.set(__self__, "domain_guid", domain_guid)
        pulumi.set(__self__, "domain_name", domain_name)
        pulumi.set(__self__, "domain_sid", domain_sid)
        pulumi.set(__self__, "forest_name", forest_name)
        pulumi.set(__self__, "netbios_domain_name", netbios_domain_name)
        pulumi.set(__self__, "storage_sid", storage_sid)

    @_builtins.property
    @pulumi.getter(name="domainGuid")
    def domain_guid(self) -> _builtins.str:
        """
        The domain GUID.
        """
        return pulumi.get(self, "domain_guid")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> _builtins.str:
        """
        The primary domain that the AD DNS server is authoritative for.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="domainSid")
    def domain_sid(self) -> _builtins.str:
        """
        The domain security identifier.
        """
        return pulumi.get(self, "domain_sid")

    @_builtins.property
    @pulumi.getter(name="forestName")
    def forest_name(self) -> _builtins.str:
        """
        The name of the Active Directory forest.
        """
        return pulumi.get(self, "forest_name")

    @_builtins.property
    @pulumi.getter(name="netbiosDomainName")
    def netbios_domain_name(self) -> _builtins.str:
        """
        The NetBIOS domain name.
        """
        return pulumi.get(self, "netbios_domain_name")

    @_builtins.property
    @pulumi.getter(name="storageSid")
    def storage_sid(self) -> _builtins.str:
        """
        The security identifier for Azure Storage.
        """
        return pulumi.get(self, "storage_sid")


@pulumi.output_type
class GetAccountBlobContainerSASPermissionsResult(dict):
    def __init__(__self__, *,
                 add: _builtins.bool,
                 create: _builtins.bool,
                 delete: _builtins.bool,
                 list: _builtins.bool,
                 read: _builtins.bool,
                 write: _builtins.bool):
        """
        :param _builtins.bool add: Should Add permissions be enabled for this SAS?
        :param _builtins.bool create: Should Create permissions be enabled for this SAS?
        :param _builtins.bool delete: Should Delete permissions be enabled for this SAS?
        :param _builtins.bool list: Should List permissions be enabled for this SAS?
               
               Refer to the [SAS creation reference from Azure](https://docs.microsoft.com/rest/api/storageservices/create-service-sas)
               for additional details on the fields above.
        :param _builtins.bool read: Should Read permissions be enabled for this SAS?
        :param _builtins.bool write: Should Write permissions be enabled for this SAS?
        """
        pulumi.set(__self__, "add", add)
        pulumi.set(__self__, "create", create)
        pulumi.set(__self__, "delete", delete)
        pulumi.set(__self__, "list", list)
        pulumi.set(__self__, "read", read)
        pulumi.set(__self__, "write", write)

    @_builtins.property
    @pulumi.getter
    def add(self) -> _builtins.bool:
        """
        Should Add permissions be enabled for this SAS?
        """
        return pulumi.get(self, "add")

    @_builtins.property
    @pulumi.getter
    def create(self) -> _builtins.bool:
        """
        Should Create permissions be enabled for this SAS?
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> _builtins.bool:
        """
        Should Delete permissions be enabled for this SAS?
        """
        return pulumi.get(self, "delete")

    @_builtins.property
    @pulumi.getter
    def list(self) -> _builtins.bool:
        """
        Should List permissions be enabled for this SAS?

        Refer to the [SAS creation reference from Azure](https://docs.microsoft.com/rest/api/storageservices/create-service-sas)
        for additional details on the fields above.
        """
        return pulumi.get(self, "list")

    @_builtins.property
    @pulumi.getter
    def read(self) -> _builtins.bool:
        """
        Should Read permissions be enabled for this SAS?
        """
        return pulumi.get(self, "read")

    @_builtins.property
    @pulumi.getter
    def write(self) -> _builtins.bool:
        """
        Should Write permissions be enabled for this SAS?
        """
        return pulumi.get(self, "write")


@pulumi.output_type
class GetAccountCustomDomainResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: Specifies the name of the Storage Account
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the Storage Account
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetAccountIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[_builtins.str],
                 principal_id: _builtins.str,
                 tenant_id: _builtins.str,
                 type: _builtins.str):
        """
        :param Sequence[_builtins.str] identity_ids: A list of User Assigned Managed Identity IDs assigned with the Identity of this Storage Account.
        :param _builtins.str principal_id: The Principal ID for the Service Principal associated with the Identity of this Storage Account.
        :param _builtins.str tenant_id: The Tenant ID for the Service Principal associated with the Identity of this Storage Account.
        :param _builtins.str type: The type of Managed Service Identity that is configured on this Storage Account
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[_builtins.str]:
        """
        A list of User Assigned Managed Identity IDs assigned with the Identity of this Storage Account.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> _builtins.str:
        """
        The Principal ID for the Service Principal associated with the Identity of this Storage Account.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        The Tenant ID for the Service Principal associated with the Identity of this Storage Account.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of Managed Service Identity that is configured on this Storage Account
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetAccountSASPermissionsResult(dict):
    def __init__(__self__, *,
                 add: _builtins.bool,
                 create: _builtins.bool,
                 delete: _builtins.bool,
                 filter: _builtins.bool,
                 list: _builtins.bool,
                 process: _builtins.bool,
                 read: _builtins.bool,
                 tag: _builtins.bool,
                 update: _builtins.bool,
                 write: _builtins.bool):
        """
        :param _builtins.bool add: Should Add permissions be enabled for this SAS?
        :param _builtins.bool create: Should Create permissions be enabled for this SAS?
        :param _builtins.bool delete: Should Delete permissions be enabled for this SAS?
        :param _builtins.bool filter: Should Filter by Index Tags permissions be enabled for this SAS?
               
               Refer to the [SAS creation reference from Azure](https://docs.microsoft.com/rest/api/storageservices/constructing-an-account-sas)
               for additional details on the fields above.
        :param _builtins.bool list: Should List permissions be enabled for this SAS?
        :param _builtins.bool process: Should Process permissions be enabled for this SAS?
        :param _builtins.bool read: Should Read permissions be enabled for this SAS?
        :param _builtins.bool tag: Should Get / Set Index Tags permissions be enabled for this SAS?
        :param _builtins.bool update: Should Update permissions be enabled for this SAS?
        :param _builtins.bool write: Should Write permissions be enabled for this SAS?
        """
        pulumi.set(__self__, "add", add)
        pulumi.set(__self__, "create", create)
        pulumi.set(__self__, "delete", delete)
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "list", list)
        pulumi.set(__self__, "process", process)
        pulumi.set(__self__, "read", read)
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "update", update)
        pulumi.set(__self__, "write", write)

    @_builtins.property
    @pulumi.getter
    def add(self) -> _builtins.bool:
        """
        Should Add permissions be enabled for this SAS?
        """
        return pulumi.get(self, "add")

    @_builtins.property
    @pulumi.getter
    def create(self) -> _builtins.bool:
        """
        Should Create permissions be enabled for this SAS?
        """
        return pulumi.get(self, "create")

    @_builtins.property
    @pulumi.getter
    def delete(self) -> _builtins.bool:
        """
        Should Delete permissions be enabled for this SAS?
        """
        return pulumi.get(self, "delete")

    @_builtins.property
    @pulumi.getter
    def filter(self) -> _builtins.bool:
        """
        Should Filter by Index Tags permissions be enabled for this SAS?

        Refer to the [SAS creation reference from Azure](https://docs.microsoft.com/rest/api/storageservices/constructing-an-account-sas)
        for additional details on the fields above.
        """
        return pulumi.get(self, "filter")

    @_builtins.property
    @pulumi.getter
    def list(self) -> _builtins.bool:
        """
        Should List permissions be enabled for this SAS?
        """
        return pulumi.get(self, "list")

    @_builtins.property
    @pulumi.getter
    def process(self) -> _builtins.bool:
        """
        Should Process permissions be enabled for this SAS?
        """
        return pulumi.get(self, "process")

    @_builtins.property
    @pulumi.getter
    def read(self) -> _builtins.bool:
        """
        Should Read permissions be enabled for this SAS?
        """
        return pulumi.get(self, "read")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> _builtins.bool:
        """
        Should Get / Set Index Tags permissions be enabled for this SAS?
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter
    def update(self) -> _builtins.bool:
        """
        Should Update permissions be enabled for this SAS?
        """
        return pulumi.get(self, "update")

    @_builtins.property
    @pulumi.getter
    def write(self) -> _builtins.bool:
        """
        Should Write permissions be enabled for this SAS?
        """
        return pulumi.get(self, "write")


@pulumi.output_type
class GetAccountSASResourceTypesResult(dict):
    def __init__(__self__, *,
                 container: _builtins.bool,
                 object: _builtins.bool,
                 service: _builtins.bool):
        """
        :param _builtins.bool container: Should permission be granted to the container?
        :param _builtins.bool object: Should permission be granted only to a specific object?
        :param _builtins.bool service: Should permission be granted to the entire service?
        """
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "service", service)

    @_builtins.property
    @pulumi.getter
    def container(self) -> _builtins.bool:
        """
        Should permission be granted to the container?
        """
        return pulumi.get(self, "container")

    @_builtins.property
    @pulumi.getter
    def object(self) -> _builtins.bool:
        """
        Should permission be granted only to a specific object?
        """
        return pulumi.get(self, "object")

    @_builtins.property
    @pulumi.getter
    def service(self) -> _builtins.bool:
        """
        Should permission be granted to the entire service?
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class GetAccountSASServicesResult(dict):
    def __init__(__self__, *,
                 blob: _builtins.bool,
                 file: _builtins.bool,
                 queue: _builtins.bool,
                 table: _builtins.bool):
        """
        :param _builtins.bool blob: Should permission be granted to `blob` services within this storage account?
        :param _builtins.bool file: Should permission be granted to `file` services within this storage account?
        :param _builtins.bool queue: Should permission be granted to `queue` services within this storage account?
        :param _builtins.bool table: Should permission be granted to `table` services within this storage account?
        """
        pulumi.set(__self__, "blob", blob)
        pulumi.set(__self__, "file", file)
        pulumi.set(__self__, "queue", queue)
        pulumi.set(__self__, "table", table)

    @_builtins.property
    @pulumi.getter
    def blob(self) -> _builtins.bool:
        """
        Should permission be granted to `blob` services within this storage account?
        """
        return pulumi.get(self, "blob")

    @_builtins.property
    @pulumi.getter
    def file(self) -> _builtins.bool:
        """
        Should permission be granted to `file` services within this storage account?
        """
        return pulumi.get(self, "file")

    @_builtins.property
    @pulumi.getter
    def queue(self) -> _builtins.bool:
        """
        Should permission be granted to `queue` services within this storage account?
        """
        return pulumi.get(self, "queue")

    @_builtins.property
    @pulumi.getter
    def table(self) -> _builtins.bool:
        """
        Should permission be granted to `table` services within this storage account?
        """
        return pulumi.get(self, "table")


@pulumi.output_type
class GetContainersContainerResult(dict):
    def __init__(__self__, *,
                 data_plane_id: _builtins.str,
                 name: _builtins.str,
                 resource_manager_id: _builtins.str):
        """
        :param _builtins.str data_plane_id: The data plane ID of the Storage Container.
        :param _builtins.str name: The name of this Storage Container.
        :param _builtins.str resource_manager_id: The resource manager ID of the Storage Container.
        """
        pulumi.set(__self__, "data_plane_id", data_plane_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "resource_manager_id", resource_manager_id)

    @_builtins.property
    @pulumi.getter(name="dataPlaneId")
    def data_plane_id(self) -> _builtins.str:
        """
        The data plane ID of the Storage Container.
        """
        return pulumi.get(self, "data_plane_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of this Storage Container.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceManagerId")
    def resource_manager_id(self) -> _builtins.str:
        """
        The resource manager ID of the Storage Container.
        """
        return pulumi.get(self, "resource_manager_id")


@pulumi.output_type
class GetPolicyRuleResult(dict):
    def __init__(__self__, *,
                 actions: Sequence['outputs.GetPolicyRuleActionResult'],
                 enabled: _builtins.bool,
                 filters: Sequence['outputs.GetPolicyRuleFilterResult'],
                 name: _builtins.str):
        """
        :param Sequence['GetPolicyRuleActionArgs'] actions: An `actions` block as documented below.
        :param _builtins.bool enabled: Boolean to specify whether the rule is enabled.
        :param Sequence['GetPolicyRuleFilterArgs'] filters: A `filter` block as documented below.
        :param _builtins.str name: The filter tag name used for tag based filtering for blob objects.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "filters", filters)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Sequence['outputs.GetPolicyRuleActionResult']:
        """
        An `actions` block as documented below.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Boolean to specify whether the rule is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Sequence['outputs.GetPolicyRuleFilterResult']:
        """
        A `filter` block as documented below.
        """
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The filter tag name used for tag based filtering for blob objects.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetPolicyRuleActionResult(dict):
    def __init__(__self__, *,
                 base_blobs: Sequence['outputs.GetPolicyRuleActionBaseBlobResult'],
                 snapshots: Sequence['outputs.GetPolicyRuleActionSnapshotResult'],
                 versions: Sequence['outputs.GetPolicyRuleActionVersionResult']):
        """
        :param Sequence['GetPolicyRuleActionBaseBlobArgs'] base_blobs: A `base_blob` block as documented below.
        :param Sequence['GetPolicyRuleActionSnapshotArgs'] snapshots: A `snapshot` block as documented below.
        :param Sequence['GetPolicyRuleActionVersionArgs'] versions: A `version` block as documented below.
        """
        pulumi.set(__self__, "base_blobs", base_blobs)
        pulumi.set(__self__, "snapshots", snapshots)
        pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter(name="baseBlobs")
    def base_blobs(self) -> Sequence['outputs.GetPolicyRuleActionBaseBlobResult']:
        """
        A `base_blob` block as documented below.
        """
        return pulumi.get(self, "base_blobs")

    @_builtins.property
    @pulumi.getter
    def snapshots(self) -> Sequence['outputs.GetPolicyRuleActionSnapshotResult']:
        """
        A `snapshot` block as documented below.
        """
        return pulumi.get(self, "snapshots")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Sequence['outputs.GetPolicyRuleActionVersionResult']:
        """
        A `version` block as documented below.
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class GetPolicyRuleActionBaseBlobResult(dict):
    def __init__(__self__, *,
                 auto_tier_to_hot_from_cool_enabled: _builtins.bool,
                 delete_after_days_since_creation_greater_than: _builtins.int,
                 delete_after_days_since_last_access_time_greater_than: _builtins.int,
                 delete_after_days_since_modification_greater_than: _builtins.int,
                 tier_to_archive_after_days_since_creation_greater_than: _builtins.int,
                 tier_to_archive_after_days_since_last_access_time_greater_than: _builtins.int,
                 tier_to_archive_after_days_since_last_tier_change_greater_than: _builtins.int,
                 tier_to_archive_after_days_since_modification_greater_than: _builtins.int,
                 tier_to_cold_after_days_since_creation_greater_than: _builtins.int,
                 tier_to_cold_after_days_since_last_access_time_greater_than: _builtins.int,
                 tier_to_cold_after_days_since_modification_greater_than: _builtins.int,
                 tier_to_cool_after_days_since_creation_greater_than: _builtins.int,
                 tier_to_cool_after_days_since_last_access_time_greater_than: _builtins.int,
                 tier_to_cool_after_days_since_modification_greater_than: _builtins.int):
        """
        :param _builtins.bool auto_tier_to_hot_from_cool_enabled: Whether a blob should automatically be tiered from cool back to hot if it's accessed again after being tiered to cool.
        :param _builtins.int delete_after_days_since_creation_greater_than: The age in days after creation to delete the blob snapshot.
        :param _builtins.int delete_after_days_since_last_access_time_greater_than: The age in days after last access time to delete the blob.
        :param _builtins.int delete_after_days_since_modification_greater_than: The age in days after last modification to delete the blob.
        :param _builtins.int tier_to_archive_after_days_since_creation_greater_than: The age in days after creation to archive storage.
        :param _builtins.int tier_to_archive_after_days_since_last_access_time_greater_than: The age in days after last access time to tier blobs to archive storage.
        :param _builtins.int tier_to_archive_after_days_since_last_tier_change_greater_than: The age in days after last tier change to the blobs to skip to be archived.
        :param _builtins.int tier_to_archive_after_days_since_modification_greater_than: The age in days after last modification to tier blobs to archive storage.
        :param _builtins.int tier_to_cold_after_days_since_creation_greater_than: Optional The age in days after creation to cold storage. Supports blob currently at Hot tier.
        :param _builtins.int tier_to_cold_after_days_since_last_access_time_greater_than: The age in days after last access time to tier blobs to cold storage. Supports blob currently at Hot tier.
        :param _builtins.int tier_to_cold_after_days_since_modification_greater_than: The age in days after last modification to tier blobs to cold storage. Supports blob currently at Hot tier.
        :param _builtins.int tier_to_cool_after_days_since_creation_greater_than: Optional The age in days after creation to cool storage. Supports blob currently at Hot tier.
        :param _builtins.int tier_to_cool_after_days_since_last_access_time_greater_than: The age in days after last access time to tier blobs to cool storage. Supports blob currently at Hot tier.
        :param _builtins.int tier_to_cool_after_days_since_modification_greater_than: The age in days after last modification to tier blobs to cool storage. Supports blob currently at Hot tier.
        """
        pulumi.set(__self__, "auto_tier_to_hot_from_cool_enabled", auto_tier_to_hot_from_cool_enabled)
        pulumi.set(__self__, "delete_after_days_since_creation_greater_than", delete_after_days_since_creation_greater_than)
        pulumi.set(__self__, "delete_after_days_since_last_access_time_greater_than", delete_after_days_since_last_access_time_greater_than)
        pulumi.set(__self__, "delete_after_days_since_modification_greater_than", delete_after_days_since_modification_greater_than)
        pulumi.set(__self__, "tier_to_archive_after_days_since_creation_greater_than", tier_to_archive_after_days_since_creation_greater_than)
        pulumi.set(__self__, "tier_to_archive_after_days_since_last_access_time_greater_than", tier_to_archive_after_days_since_last_access_time_greater_than)
        pulumi.set(__self__, "tier_to_archive_after_days_since_last_tier_change_greater_than", tier_to_archive_after_days_since_last_tier_change_greater_than)
        pulumi.set(__self__, "tier_to_archive_after_days_since_modification_greater_than", tier_to_archive_after_days_since_modification_greater_than)
        pulumi.set(__self__, "tier_to_cold_after_days_since_creation_greater_than", tier_to_cold_after_days_since_creation_greater_than)
        pulumi.set(__self__, "tier_to_cold_after_days_since_last_access_time_greater_than", tier_to_cold_after_days_since_last_access_time_greater_than)
        pulumi.set(__self__, "tier_to_cold_after_days_since_modification_greater_than", tier_to_cold_after_days_since_modification_greater_than)
        pulumi.set(__self__, "tier_to_cool_after_days_since_creation_greater_than", tier_to_cool_after_days_since_creation_greater_than)
        pulumi.set(__self__, "tier_to_cool_after_days_since_last_access_time_greater_than", tier_to_cool_after_days_since_last_access_time_greater_than)
        pulumi.set(__self__, "tier_to_cool_after_days_since_modification_greater_than", tier_to_cool_after_days_since_modification_greater_than)

    @_builtins.property
    @pulumi.getter(name="autoTierToHotFromCoolEnabled")
    def auto_tier_to_hot_from_cool_enabled(self) -> _builtins.bool:
        """
        Whether a blob should automatically be tiered from cool back to hot if it's accessed again after being tiered to cool.
        """
        return pulumi.get(self, "auto_tier_to_hot_from_cool_enabled")

    @_builtins.property
    @pulumi.getter(name="deleteAfterDaysSinceCreationGreaterThan")
    def delete_after_days_since_creation_greater_than(self) -> _builtins.int:
        """
        The age in days after creation to delete the blob snapshot.
        """
        return pulumi.get(self, "delete_after_days_since_creation_greater_than")

    @_builtins.property
    @pulumi.getter(name="deleteAfterDaysSinceLastAccessTimeGreaterThan")
    def delete_after_days_since_last_access_time_greater_than(self) -> _builtins.int:
        """
        The age in days after last access time to delete the blob.
        """
        return pulumi.get(self, "delete_after_days_since_last_access_time_greater_than")

    @_builtins.property
    @pulumi.getter(name="deleteAfterDaysSinceModificationGreaterThan")
    def delete_after_days_since_modification_greater_than(self) -> _builtins.int:
        """
        The age in days after last modification to delete the blob.
        """
        return pulumi.get(self, "delete_after_days_since_modification_greater_than")

    @_builtins.property
    @pulumi.getter(name="tierToArchiveAfterDaysSinceCreationGreaterThan")
    def tier_to_archive_after_days_since_creation_greater_than(self) -> _builtins.int:
        """
        The age in days after creation to archive storage.
        """
        return pulumi.get(self, "tier_to_archive_after_days_since_creation_greater_than")

    @_builtins.property
    @pulumi.getter(name="tierToArchiveAfterDaysSinceLastAccessTimeGreaterThan")
    def tier_to_archive_after_days_since_last_access_time_greater_than(self) -> _builtins.int:
        """
        The age in days after last access time to tier blobs to archive storage.
        """
        return pulumi.get(self, "tier_to_archive_after_days_since_last_access_time_greater_than")

    @_builtins.property
    @pulumi.getter(name="tierToArchiveAfterDaysSinceLastTierChangeGreaterThan")
    def tier_to_archive_after_days_since_last_tier_change_greater_than(self) -> _builtins.int:
        """
        The age in days after last tier change to the blobs to skip to be archived.
        """
        return pulumi.get(self, "tier_to_archive_after_days_since_last_tier_change_greater_than")

    @_builtins.property
    @pulumi.getter(name="tierToArchiveAfterDaysSinceModificationGreaterThan")
    def tier_to_archive_after_days_since_modification_greater_than(self) -> _builtins.int:
        """
        The age in days after last modification to tier blobs to archive storage.
        """
        return pulumi.get(self, "tier_to_archive_after_days_since_modification_greater_than")

    @_builtins.property
    @pulumi.getter(name="tierToColdAfterDaysSinceCreationGreaterThan")
    def tier_to_cold_after_days_since_creation_greater_than(self) -> _builtins.int:
        """
        Optional The age in days after creation to cold storage. Supports blob currently at Hot tier.
        """
        return pulumi.get(self, "tier_to_cold_after_days_since_creation_greater_than")

    @_builtins.property
    @pulumi.getter(name="tierToColdAfterDaysSinceLastAccessTimeGreaterThan")
    def tier_to_cold_after_days_since_last_access_time_greater_than(self) -> _builtins.int:
        """
        The age in days after last access time to tier blobs to cold storage. Supports blob currently at Hot tier.
        """
        return pulumi.get(self, "tier_to_cold_after_days_since_last_access_time_greater_than")

    @_builtins.property
    @pulumi.getter(name="tierToColdAfterDaysSinceModificationGreaterThan")
    def tier_to_cold_after_days_since_modification_greater_than(self) -> _builtins.int:
        """
        The age in days after last modification to tier blobs to cold storage. Supports blob currently at Hot tier.
        """
        return pulumi.get(self, "tier_to_cold_after_days_since_modification_greater_than")

    @_builtins.property
    @pulumi.getter(name="tierToCoolAfterDaysSinceCreationGreaterThan")
    def tier_to_cool_after_days_since_creation_greater_than(self) -> _builtins.int:
        """
        Optional The age in days after creation to cool storage. Supports blob currently at Hot tier.
        """
        return pulumi.get(self, "tier_to_cool_after_days_since_creation_greater_than")

    @_builtins.property
    @pulumi.getter(name="tierToCoolAfterDaysSinceLastAccessTimeGreaterThan")
    def tier_to_cool_after_days_since_last_access_time_greater_than(self) -> _builtins.int:
        """
        The age in days after last access time to tier blobs to cool storage. Supports blob currently at Hot tier.
        """
        return pulumi.get(self, "tier_to_cool_after_days_since_last_access_time_greater_than")

    @_builtins.property
    @pulumi.getter(name="tierToCoolAfterDaysSinceModificationGreaterThan")
    def tier_to_cool_after_days_since_modification_greater_than(self) -> _builtins.int:
        """
        The age in days after last modification to tier blobs to cool storage. Supports blob currently at Hot tier.
        """
        return pulumi.get(self, "tier_to_cool_after_days_since_modification_greater_than")


@pulumi.output_type
class GetPolicyRuleActionSnapshotResult(dict):
    def __init__(__self__, *,
                 change_tier_to_archive_after_days_since_creation: _builtins.int,
                 change_tier_to_cool_after_days_since_creation: _builtins.int,
                 delete_after_days_since_creation_greater_than: _builtins.int,
                 tier_to_archive_after_days_since_last_tier_change_greater_than: _builtins.int,
                 tier_to_cold_after_days_since_creation_greater_than: _builtins.int):
        """
        :param _builtins.int change_tier_to_archive_after_days_since_creation: The age in days after creation to tier blob version to archive storage.
        :param _builtins.int change_tier_to_cool_after_days_since_creation: The age in days after creation to tier blob version to cool storage.
        :param _builtins.int delete_after_days_since_creation_greater_than: The age in days after creation to delete the blob snapshot.
        :param _builtins.int tier_to_archive_after_days_since_last_tier_change_greater_than: The age in days after last tier change to the blobs to skip to be archived.
        :param _builtins.int tier_to_cold_after_days_since_creation_greater_than: Optional The age in days after creation to cold storage. Supports blob currently at Hot tier.
        """
        pulumi.set(__self__, "change_tier_to_archive_after_days_since_creation", change_tier_to_archive_after_days_since_creation)
        pulumi.set(__self__, "change_tier_to_cool_after_days_since_creation", change_tier_to_cool_after_days_since_creation)
        pulumi.set(__self__, "delete_after_days_since_creation_greater_than", delete_after_days_since_creation_greater_than)
        pulumi.set(__self__, "tier_to_archive_after_days_since_last_tier_change_greater_than", tier_to_archive_after_days_since_last_tier_change_greater_than)
        pulumi.set(__self__, "tier_to_cold_after_days_since_creation_greater_than", tier_to_cold_after_days_since_creation_greater_than)

    @_builtins.property
    @pulumi.getter(name="changeTierToArchiveAfterDaysSinceCreation")
    def change_tier_to_archive_after_days_since_creation(self) -> _builtins.int:
        """
        The age in days after creation to tier blob version to archive storage.
        """
        return pulumi.get(self, "change_tier_to_archive_after_days_since_creation")

    @_builtins.property
    @pulumi.getter(name="changeTierToCoolAfterDaysSinceCreation")
    def change_tier_to_cool_after_days_since_creation(self) -> _builtins.int:
        """
        The age in days after creation to tier blob version to cool storage.
        """
        return pulumi.get(self, "change_tier_to_cool_after_days_since_creation")

    @_builtins.property
    @pulumi.getter(name="deleteAfterDaysSinceCreationGreaterThan")
    def delete_after_days_since_creation_greater_than(self) -> _builtins.int:
        """
        The age in days after creation to delete the blob snapshot.
        """
        return pulumi.get(self, "delete_after_days_since_creation_greater_than")

    @_builtins.property
    @pulumi.getter(name="tierToArchiveAfterDaysSinceLastTierChangeGreaterThan")
    def tier_to_archive_after_days_since_last_tier_change_greater_than(self) -> _builtins.int:
        """
        The age in days after last tier change to the blobs to skip to be archived.
        """
        return pulumi.get(self, "tier_to_archive_after_days_since_last_tier_change_greater_than")

    @_builtins.property
    @pulumi.getter(name="tierToColdAfterDaysSinceCreationGreaterThan")
    def tier_to_cold_after_days_since_creation_greater_than(self) -> _builtins.int:
        """
        Optional The age in days after creation to cold storage. Supports blob currently at Hot tier.
        """
        return pulumi.get(self, "tier_to_cold_after_days_since_creation_greater_than")


@pulumi.output_type
class GetPolicyRuleActionVersionResult(dict):
    def __init__(__self__, *,
                 change_tier_to_archive_after_days_since_creation: _builtins.int,
                 change_tier_to_cool_after_days_since_creation: _builtins.int,
                 delete_after_days_since_creation: _builtins.int,
                 tier_to_archive_after_days_since_last_tier_change_greater_than: _builtins.int,
                 tier_to_cold_after_days_since_creation_greater_than: _builtins.int):
        """
        :param _builtins.int change_tier_to_archive_after_days_since_creation: The age in days after creation to tier blob version to archive storage.
        :param _builtins.int change_tier_to_cool_after_days_since_creation: The age in days after creation to tier blob version to cool storage.
        :param _builtins.int delete_after_days_since_creation: The age in days after creation to delete the blob version.
        :param _builtins.int tier_to_archive_after_days_since_last_tier_change_greater_than: The age in days after last tier change to the blobs to skip to be archived.
        :param _builtins.int tier_to_cold_after_days_since_creation_greater_than: Optional The age in days after creation to cold storage. Supports blob currently at Hot tier.
        """
        pulumi.set(__self__, "change_tier_to_archive_after_days_since_creation", change_tier_to_archive_after_days_since_creation)
        pulumi.set(__self__, "change_tier_to_cool_after_days_since_creation", change_tier_to_cool_after_days_since_creation)
        pulumi.set(__self__, "delete_after_days_since_creation", delete_after_days_since_creation)
        pulumi.set(__self__, "tier_to_archive_after_days_since_last_tier_change_greater_than", tier_to_archive_after_days_since_last_tier_change_greater_than)
        pulumi.set(__self__, "tier_to_cold_after_days_since_creation_greater_than", tier_to_cold_after_days_since_creation_greater_than)

    @_builtins.property
    @pulumi.getter(name="changeTierToArchiveAfterDaysSinceCreation")
    def change_tier_to_archive_after_days_since_creation(self) -> _builtins.int:
        """
        The age in days after creation to tier blob version to archive storage.
        """
        return pulumi.get(self, "change_tier_to_archive_after_days_since_creation")

    @_builtins.property
    @pulumi.getter(name="changeTierToCoolAfterDaysSinceCreation")
    def change_tier_to_cool_after_days_since_creation(self) -> _builtins.int:
        """
        The age in days after creation to tier blob version to cool storage.
        """
        return pulumi.get(self, "change_tier_to_cool_after_days_since_creation")

    @_builtins.property
    @pulumi.getter(name="deleteAfterDaysSinceCreation")
    def delete_after_days_since_creation(self) -> _builtins.int:
        """
        The age in days after creation to delete the blob version.
        """
        return pulumi.get(self, "delete_after_days_since_creation")

    @_builtins.property
    @pulumi.getter(name="tierToArchiveAfterDaysSinceLastTierChangeGreaterThan")
    def tier_to_archive_after_days_since_last_tier_change_greater_than(self) -> _builtins.int:
        """
        The age in days after last tier change to the blobs to skip to be archived.
        """
        return pulumi.get(self, "tier_to_archive_after_days_since_last_tier_change_greater_than")

    @_builtins.property
    @pulumi.getter(name="tierToColdAfterDaysSinceCreationGreaterThan")
    def tier_to_cold_after_days_since_creation_greater_than(self) -> _builtins.int:
        """
        Optional The age in days after creation to cold storage. Supports blob currently at Hot tier.
        """
        return pulumi.get(self, "tier_to_cold_after_days_since_creation_greater_than")


@pulumi.output_type
class GetPolicyRuleFilterResult(dict):
    def __init__(__self__, *,
                 blob_types: Sequence[_builtins.str],
                 match_blob_index_tags: Sequence['outputs.GetPolicyRuleFilterMatchBlobIndexTagResult'],
                 prefix_matches: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] blob_types: An array of predefined values. Valid options are `blockBlob` and `appendBlob`.
        :param Sequence['GetPolicyRuleFilterMatchBlobIndexTagArgs'] match_blob_index_tags: A `match_blob_index_tag` block as defined below. The block defines the blob index tag based filtering for blob objects.
        :param Sequence[_builtins.str] prefix_matches: An array of strings for prefixes to be matched.
        """
        pulumi.set(__self__, "blob_types", blob_types)
        pulumi.set(__self__, "match_blob_index_tags", match_blob_index_tags)
        pulumi.set(__self__, "prefix_matches", prefix_matches)

    @_builtins.property
    @pulumi.getter(name="blobTypes")
    def blob_types(self) -> Sequence[_builtins.str]:
        """
        An array of predefined values. Valid options are `blockBlob` and `appendBlob`.
        """
        return pulumi.get(self, "blob_types")

    @_builtins.property
    @pulumi.getter(name="matchBlobIndexTags")
    def match_blob_index_tags(self) -> Sequence['outputs.GetPolicyRuleFilterMatchBlobIndexTagResult']:
        """
        A `match_blob_index_tag` block as defined below. The block defines the blob index tag based filtering for blob objects.
        """
        return pulumi.get(self, "match_blob_index_tags")

    @_builtins.property
    @pulumi.getter(name="prefixMatches")
    def prefix_matches(self) -> Sequence[_builtins.str]:
        """
        An array of strings for prefixes to be matched.
        """
        return pulumi.get(self, "prefix_matches")


@pulumi.output_type
class GetPolicyRuleFilterMatchBlobIndexTagResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 operation: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The filter tag name used for tag based filtering for blob objects.
        :param _builtins.str operation: The comparison operator which is used for object comparison and filtering. Possible value is `==`. Defaults to `==`.
        :param _builtins.str value: The filter tag value used for tag based filtering for blob objects.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The filter tag name used for tag based filtering for blob objects.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def operation(self) -> _builtins.str:
        """
        The comparison operator which is used for object comparison and filtering. Possible value is `==`. Defaults to `==`.
        """
        return pulumi.get(self, "operation")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The filter tag value used for tag based filtering for blob objects.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetShareAclResult(dict):
    def __init__(__self__, *,
                 access_policies: Sequence['outputs.GetShareAclAccessPolicyResult'],
                 id: _builtins.str):
        """
        :param Sequence['GetShareAclAccessPolicyArgs'] access_policies: An `access_policy` block as defined below.
        :param _builtins.str id: The ID which should be used for this Shared Identifier.
        """
        pulumi.set(__self__, "access_policies", access_policies)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="accessPolicies")
    def access_policies(self) -> Sequence['outputs.GetShareAclAccessPolicyResult']:
        """
        An `access_policy` block as defined below.
        """
        return pulumi.get(self, "access_policies")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID which should be used for this Shared Identifier.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetShareAclAccessPolicyResult(dict):
    def __init__(__self__, *,
                 expiry: _builtins.str,
                 permissions: _builtins.str,
                 start: _builtins.str):
        """
        :param _builtins.str expiry: The time at which this Access Policy is valid until.
        :param _builtins.str permissions: The permissions which should be associated with this Shared Identifier. Possible value is combination of `r` (read), `w` (write), `d` (delete), and `l` (list).
        :param _builtins.str start: The time at which this Access Policy is valid from.
        """
        pulumi.set(__self__, "expiry", expiry)
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "start", start)

    @_builtins.property
    @pulumi.getter
    def expiry(self) -> _builtins.str:
        """
        The time at which this Access Policy is valid until.
        """
        return pulumi.get(self, "expiry")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> _builtins.str:
        """
        The permissions which should be associated with this Shared Identifier. Possible value is combination of `r` (read), `w` (write), `d` (delete), and `l` (list).
        """
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter
    def start(self) -> _builtins.str:
        """
        The time at which this Access Policy is valid from.
        """
        return pulumi.get(self, "start")


@pulumi.output_type
class GetTableAclResult(dict):
    def __init__(__self__, *,
                 access_policies: Sequence['outputs.GetTableAclAccessPolicyResult'],
                 id: _builtins.str):
        """
        :param _builtins.str id: The ID of the Storage Table.
        """
        pulumi.set(__self__, "access_policies", access_policies)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="accessPolicies")
    def access_policies(self) -> Sequence['outputs.GetTableAclAccessPolicyResult']:
        return pulumi.get(self, "access_policies")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of the Storage Table.
        """
        return pulumi.get(self, "id")


@pulumi.output_type
class GetTableAclAccessPolicyResult(dict):
    def __init__(__self__, *,
                 expiry: _builtins.str,
                 permissions: _builtins.str,
                 start: _builtins.str):
        pulumi.set(__self__, "expiry", expiry)
        pulumi.set(__self__, "permissions", permissions)
        pulumi.set(__self__, "start", start)

    @_builtins.property
    @pulumi.getter
    def expiry(self) -> _builtins.str:
        return pulumi.get(self, "expiry")

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> _builtins.str:
        return pulumi.get(self, "permissions")

    @_builtins.property
    @pulumi.getter
    def start(self) -> _builtins.str:
        return pulumi.get(self, "start")


@pulumi.output_type
class GetTableEntitiesItemResult(dict):
    def __init__(__self__, *,
                 partition_key: _builtins.str,
                 properties: Mapping[str, _builtins.str],
                 row_key: _builtins.str):
        """
        :param _builtins.str partition_key: Partition Key of the Entity.
        :param Mapping[str, _builtins.str] properties: A map of any additional properties in key-value format.
        :param _builtins.str row_key: Row Key of the Entity.
        """
        pulumi.set(__self__, "partition_key", partition_key)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "row_key", row_key)

    @_builtins.property
    @pulumi.getter(name="partitionKey")
    def partition_key(self) -> _builtins.str:
        """
        Partition Key of the Entity.
        """
        return pulumi.get(self, "partition_key")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Mapping[str, _builtins.str]:
        """
        A map of any additional properties in key-value format.
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="rowKey")
    def row_key(self) -> _builtins.str:
        """
        Row Key of the Entity.
        """
        return pulumi.get(self, "row_key")


