# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReferenceInputBlobArgs', 'ReferenceInputBlob']

@pulumi.input_type
class ReferenceInputBlobArgs:
    def __init__(__self__, *,
                 date_format: pulumi.Input[_builtins.str],
                 path_pattern: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 serialization: pulumi.Input['ReferenceInputBlobSerializationArgs'],
                 storage_account_name: pulumi.Input[_builtins.str],
                 storage_container_name: pulumi.Input[_builtins.str],
                 stream_analytics_job_name: pulumi.Input[_builtins.str],
                 time_format: pulumi.Input[_builtins.str],
                 authentication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_key: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ReferenceInputBlob resource.
        :param pulumi.Input[_builtins.str] date_format: The date format. Wherever `{date}` appears in `path_pattern`, the value of this property is used as the date format instead.
        :param pulumi.Input[_builtins.str] path_pattern: The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Stream Analytics Job exists. Changing this forces a new resource to be created.
        :param pulumi.Input['ReferenceInputBlobSerializationArgs'] serialization: A `serialization` block as defined below.
        :param pulumi.Input[_builtins.str] storage_account_name: The name of the Storage Account that has the blob container with reference data.
        :param pulumi.Input[_builtins.str] storage_container_name: The name of the Container within the Storage Account.
        :param pulumi.Input[_builtins.str] stream_analytics_job_name: The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] time_format: The time format. Wherever `{time}` appears in `path_pattern`, the value of this property is used as the time format instead.
        :param pulumi.Input[_builtins.str] authentication_mode: The authentication mode for the Stream Analytics Reference Input. Possible values are `Msi` and `ConnectionString`. Defaults to `ConnectionString`.
        :param pulumi.Input[_builtins.str] name: The name of the Reference Input Blob. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_account_key: The Access Key which should be used to connect to this Storage Account. Required if `authentication_mode` is `ConnectionString`.
        """
        pulumi.set(__self__, "date_format", date_format)
        pulumi.set(__self__, "path_pattern", path_pattern)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "serialization", serialization)
        pulumi.set(__self__, "storage_account_name", storage_account_name)
        pulumi.set(__self__, "storage_container_name", storage_container_name)
        pulumi.set(__self__, "stream_analytics_job_name", stream_analytics_job_name)
        pulumi.set(__self__, "time_format", time_format)
        if authentication_mode is not None:
            pulumi.set(__self__, "authentication_mode", authentication_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if storage_account_key is not None:
            pulumi.set(__self__, "storage_account_key", storage_account_key)

    @_builtins.property
    @pulumi.getter(name="dateFormat")
    def date_format(self) -> pulumi.Input[_builtins.str]:
        """
        The date format. Wherever `{date}` appears in `path_pattern`, the value of this property is used as the date format instead.
        """
        return pulumi.get(self, "date_format")

    @date_format.setter
    def date_format(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "date_format", value)

    @_builtins.property
    @pulumi.getter(name="pathPattern")
    def path_pattern(self) -> pulumi.Input[_builtins.str]:
        """
        The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job.
        """
        return pulumi.get(self, "path_pattern")

    @path_pattern.setter
    def path_pattern(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "path_pattern", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Stream Analytics Job exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def serialization(self) -> pulumi.Input['ReferenceInputBlobSerializationArgs']:
        """
        A `serialization` block as defined below.
        """
        return pulumi.get(self, "serialization")

    @serialization.setter
    def serialization(self, value: pulumi.Input['ReferenceInputBlobSerializationArgs']):
        pulumi.set(self, "serialization", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Storage Account that has the blob container with reference data.
        """
        return pulumi.get(self, "storage_account_name")

    @storage_account_name.setter
    def storage_account_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_account_name", value)

    @_builtins.property
    @pulumi.getter(name="storageContainerName")
    def storage_container_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Container within the Storage Account.
        """
        return pulumi.get(self, "storage_container_name")

    @storage_container_name.setter
    def storage_container_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_container_name", value)

    @_builtins.property
    @pulumi.getter(name="streamAnalyticsJobName")
    def stream_analytics_job_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "stream_analytics_job_name")

    @stream_analytics_job_name.setter
    def stream_analytics_job_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "stream_analytics_job_name", value)

    @_builtins.property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> pulumi.Input[_builtins.str]:
        """
        The time format. Wherever `{time}` appears in `path_pattern`, the value of this property is used as the time format instead.
        """
        return pulumi.get(self, "time_format")

    @time_format.setter
    def time_format(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "time_format", value)

    @_builtins.property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication mode for the Stream Analytics Reference Input. Possible values are `Msi` and `ConnectionString`. Defaults to `ConnectionString`.
        """
        return pulumi.get(self, "authentication_mode")

    @authentication_mode.setter
    def authentication_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_mode", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Reference Input Blob. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountKey")
    def storage_account_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Access Key which should be used to connect to this Storage Account. Required if `authentication_mode` is `ConnectionString`.
        """
        return pulumi.get(self, "storage_account_key")

    @storage_account_key.setter
    def storage_account_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_key", value)


@pulumi.input_type
class _ReferenceInputBlobState:
    def __init__(__self__, *,
                 authentication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 date_format: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 path_pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 serialization: Optional[pulumi.Input['ReferenceInputBlobSerializationArgs']] = None,
                 storage_account_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_analytics_job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 time_format: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ReferenceInputBlob resources.
        :param pulumi.Input[_builtins.str] authentication_mode: The authentication mode for the Stream Analytics Reference Input. Possible values are `Msi` and `ConnectionString`. Defaults to `ConnectionString`.
        :param pulumi.Input[_builtins.str] date_format: The date format. Wherever `{date}` appears in `path_pattern`, the value of this property is used as the date format instead.
        :param pulumi.Input[_builtins.str] name: The name of the Reference Input Blob. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] path_pattern: The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Stream Analytics Job exists. Changing this forces a new resource to be created.
        :param pulumi.Input['ReferenceInputBlobSerializationArgs'] serialization: A `serialization` block as defined below.
        :param pulumi.Input[_builtins.str] storage_account_key: The Access Key which should be used to connect to this Storage Account. Required if `authentication_mode` is `ConnectionString`.
        :param pulumi.Input[_builtins.str] storage_account_name: The name of the Storage Account that has the blob container with reference data.
        :param pulumi.Input[_builtins.str] storage_container_name: The name of the Container within the Storage Account.
        :param pulumi.Input[_builtins.str] stream_analytics_job_name: The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] time_format: The time format. Wherever `{time}` appears in `path_pattern`, the value of this property is used as the time format instead.
        """
        if authentication_mode is not None:
            pulumi.set(__self__, "authentication_mode", authentication_mode)
        if date_format is not None:
            pulumi.set(__self__, "date_format", date_format)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path_pattern is not None:
            pulumi.set(__self__, "path_pattern", path_pattern)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if serialization is not None:
            pulumi.set(__self__, "serialization", serialization)
        if storage_account_key is not None:
            pulumi.set(__self__, "storage_account_key", storage_account_key)
        if storage_account_name is not None:
            pulumi.set(__self__, "storage_account_name", storage_account_name)
        if storage_container_name is not None:
            pulumi.set(__self__, "storage_container_name", storage_container_name)
        if stream_analytics_job_name is not None:
            pulumi.set(__self__, "stream_analytics_job_name", stream_analytics_job_name)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)

    @_builtins.property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The authentication mode for the Stream Analytics Reference Input. Possible values are `Msi` and `ConnectionString`. Defaults to `ConnectionString`.
        """
        return pulumi.get(self, "authentication_mode")

    @authentication_mode.setter
    def authentication_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_mode", value)

    @_builtins.property
    @pulumi.getter(name="dateFormat")
    def date_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date format. Wherever `{date}` appears in `path_pattern`, the value of this property is used as the date format instead.
        """
        return pulumi.get(self, "date_format")

    @date_format.setter
    def date_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "date_format", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Reference Input Blob. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="pathPattern")
    def path_pattern(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job.
        """
        return pulumi.get(self, "path_pattern")

    @path_pattern.setter
    def path_pattern(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path_pattern", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Stream Analytics Job exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def serialization(self) -> Optional[pulumi.Input['ReferenceInputBlobSerializationArgs']]:
        """
        A `serialization` block as defined below.
        """
        return pulumi.get(self, "serialization")

    @serialization.setter
    def serialization(self, value: Optional[pulumi.Input['ReferenceInputBlobSerializationArgs']]):
        pulumi.set(self, "serialization", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountKey")
    def storage_account_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Access Key which should be used to connect to this Storage Account. Required if `authentication_mode` is `ConnectionString`.
        """
        return pulumi.get(self, "storage_account_key")

    @storage_account_key.setter
    def storage_account_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_key", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Storage Account that has the blob container with reference data.
        """
        return pulumi.get(self, "storage_account_name")

    @storage_account_name.setter
    def storage_account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_name", value)

    @_builtins.property
    @pulumi.getter(name="storageContainerName")
    def storage_container_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Container within the Storage Account.
        """
        return pulumi.get(self, "storage_container_name")

    @storage_container_name.setter
    def storage_container_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_container_name", value)

    @_builtins.property
    @pulumi.getter(name="streamAnalyticsJobName")
    def stream_analytics_job_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "stream_analytics_job_name")

    @stream_analytics_job_name.setter
    def stream_analytics_job_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stream_analytics_job_name", value)

    @_builtins.property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time format. Wherever `{time}` appears in `path_pattern`, the value of this property is used as the time format instead.
        """
        return pulumi.get(self, "time_format")

    @time_format.setter
    def time_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_format", value)


@pulumi.type_token("azure:streamanalytics/referenceInputBlob:ReferenceInputBlob")
class ReferenceInputBlob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 date_format: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 path_pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 serialization: Optional[pulumi.Input[Union['ReferenceInputBlobSerializationArgs', 'ReferenceInputBlobSerializationArgsDict']]] = None,
                 storage_account_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_analytics_job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 time_format: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Stream Analytics Reference Input Blob. Reference data (also known as a lookup table) is a finite data set that is static or slowly changing in nature, used to perform a lookup or to correlate with your data stream. Learn more [here](https://docs.microsoft.com/azure/stream-analytics/stream-analytics-use-reference-data#azure-blob-storage).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example = azure.streamanalytics.get_job_output(name="example-job",
            resource_group_name=example_resource_group.name)
        example_account = azure.storage.Account("example",
            name="examplestoracc",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="example",
            storage_account_name=example_account.name,
            container_access_type="private")
        test = azure.streamanalytics.ReferenceInputBlob("test",
            name="blob-reference-input",
            stream_analytics_job_name=example.name,
            resource_group_name=example.resource_group_name,
            storage_account_name=example_account.name,
            storage_account_key=example_account.primary_access_key,
            storage_container_name=example_container.name,
            path_pattern="some-random-pattern",
            date_format="yyyy/MM/dd",
            time_format="HH",
            serialization={
                "type": "Json",
                "encoding": "UTF8",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StreamAnalytics` - 2020-03-01

        ## Import

        Stream Analytics Reference Input Blob's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:streamanalytics/referenceInputBlob:ReferenceInputBlob example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.StreamAnalytics/streamingJobs/job1/inputs/input1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authentication_mode: The authentication mode for the Stream Analytics Reference Input. Possible values are `Msi` and `ConnectionString`. Defaults to `ConnectionString`.
        :param pulumi.Input[_builtins.str] date_format: The date format. Wherever `{date}` appears in `path_pattern`, the value of this property is used as the date format instead.
        :param pulumi.Input[_builtins.str] name: The name of the Reference Input Blob. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] path_pattern: The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Stream Analytics Job exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ReferenceInputBlobSerializationArgs', 'ReferenceInputBlobSerializationArgsDict']] serialization: A `serialization` block as defined below.
        :param pulumi.Input[_builtins.str] storage_account_key: The Access Key which should be used to connect to this Storage Account. Required if `authentication_mode` is `ConnectionString`.
        :param pulumi.Input[_builtins.str] storage_account_name: The name of the Storage Account that has the blob container with reference data.
        :param pulumi.Input[_builtins.str] storage_container_name: The name of the Container within the Storage Account.
        :param pulumi.Input[_builtins.str] stream_analytics_job_name: The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] time_format: The time format. Wherever `{time}` appears in `path_pattern`, the value of this property is used as the time format instead.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReferenceInputBlobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Stream Analytics Reference Input Blob. Reference data (also known as a lookup table) is a finite data set that is static or slowly changing in nature, used to perform a lookup or to correlate with your data stream. Learn more [here](https://docs.microsoft.com/azure/stream-analytics/stream-analytics-use-reference-data#azure-blob-storage).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example = azure.streamanalytics.get_job_output(name="example-job",
            resource_group_name=example_resource_group.name)
        example_account = azure.storage.Account("example",
            name="examplestoracc",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_container = azure.storage.Container("example",
            name="example",
            storage_account_name=example_account.name,
            container_access_type="private")
        test = azure.streamanalytics.ReferenceInputBlob("test",
            name="blob-reference-input",
            stream_analytics_job_name=example.name,
            resource_group_name=example.resource_group_name,
            storage_account_name=example_account.name,
            storage_account_key=example_account.primary_access_key,
            storage_container_name=example_container.name,
            path_pattern="some-random-pattern",
            date_format="yyyy/MM/dd",
            time_format="HH",
            serialization={
                "type": "Json",
                "encoding": "UTF8",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.StreamAnalytics` - 2020-03-01

        ## Import

        Stream Analytics Reference Input Blob's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:streamanalytics/referenceInputBlob:ReferenceInputBlob example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.StreamAnalytics/streamingJobs/job1/inputs/input1
        ```

        :param str resource_name: The name of the resource.
        :param ReferenceInputBlobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReferenceInputBlobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authentication_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 date_format: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 path_pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 serialization: Optional[pulumi.Input[Union['ReferenceInputBlobSerializationArgs', 'ReferenceInputBlobSerializationArgsDict']]] = None,
                 storage_account_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_container_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_analytics_job_name: Optional[pulumi.Input[_builtins.str]] = None,
                 time_format: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReferenceInputBlobArgs.__new__(ReferenceInputBlobArgs)

            __props__.__dict__["authentication_mode"] = authentication_mode
            if date_format is None and not opts.urn:
                raise TypeError("Missing required property 'date_format'")
            __props__.__dict__["date_format"] = date_format
            __props__.__dict__["name"] = name
            if path_pattern is None and not opts.urn:
                raise TypeError("Missing required property 'path_pattern'")
            __props__.__dict__["path_pattern"] = path_pattern
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if serialization is None and not opts.urn:
                raise TypeError("Missing required property 'serialization'")
            __props__.__dict__["serialization"] = serialization
            __props__.__dict__["storage_account_key"] = None if storage_account_key is None else pulumi.Output.secret(storage_account_key)
            if storage_account_name is None and not opts.urn:
                raise TypeError("Missing required property 'storage_account_name'")
            __props__.__dict__["storage_account_name"] = storage_account_name
            if storage_container_name is None and not opts.urn:
                raise TypeError("Missing required property 'storage_container_name'")
            __props__.__dict__["storage_container_name"] = storage_container_name
            if stream_analytics_job_name is None and not opts.urn:
                raise TypeError("Missing required property 'stream_analytics_job_name'")
            __props__.__dict__["stream_analytics_job_name"] = stream_analytics_job_name
            if time_format is None and not opts.urn:
                raise TypeError("Missing required property 'time_format'")
            __props__.__dict__["time_format"] = time_format
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["storageAccountKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ReferenceInputBlob, __self__).__init__(
            'azure:streamanalytics/referenceInputBlob:ReferenceInputBlob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authentication_mode: Optional[pulumi.Input[_builtins.str]] = None,
            date_format: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            path_pattern: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            serialization: Optional[pulumi.Input[Union['ReferenceInputBlobSerializationArgs', 'ReferenceInputBlobSerializationArgsDict']]] = None,
            storage_account_key: Optional[pulumi.Input[_builtins.str]] = None,
            storage_account_name: Optional[pulumi.Input[_builtins.str]] = None,
            storage_container_name: Optional[pulumi.Input[_builtins.str]] = None,
            stream_analytics_job_name: Optional[pulumi.Input[_builtins.str]] = None,
            time_format: Optional[pulumi.Input[_builtins.str]] = None) -> 'ReferenceInputBlob':
        """
        Get an existing ReferenceInputBlob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authentication_mode: The authentication mode for the Stream Analytics Reference Input. Possible values are `Msi` and `ConnectionString`. Defaults to `ConnectionString`.
        :param pulumi.Input[_builtins.str] date_format: The date format. Wherever `{date}` appears in `path_pattern`, the value of this property is used as the date format instead.
        :param pulumi.Input[_builtins.str] name: The name of the Reference Input Blob. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] path_pattern: The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Stream Analytics Job exists. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ReferenceInputBlobSerializationArgs', 'ReferenceInputBlobSerializationArgsDict']] serialization: A `serialization` block as defined below.
        :param pulumi.Input[_builtins.str] storage_account_key: The Access Key which should be used to connect to this Storage Account. Required if `authentication_mode` is `ConnectionString`.
        :param pulumi.Input[_builtins.str] storage_account_name: The name of the Storage Account that has the blob container with reference data.
        :param pulumi.Input[_builtins.str] storage_container_name: The name of the Container within the Storage Account.
        :param pulumi.Input[_builtins.str] stream_analytics_job_name: The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] time_format: The time format. Wherever `{time}` appears in `path_pattern`, the value of this property is used as the time format instead.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReferenceInputBlobState.__new__(_ReferenceInputBlobState)

        __props__.__dict__["authentication_mode"] = authentication_mode
        __props__.__dict__["date_format"] = date_format
        __props__.__dict__["name"] = name
        __props__.__dict__["path_pattern"] = path_pattern
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["serialization"] = serialization
        __props__.__dict__["storage_account_key"] = storage_account_key
        __props__.__dict__["storage_account_name"] = storage_account_name
        __props__.__dict__["storage_container_name"] = storage_container_name
        __props__.__dict__["stream_analytics_job_name"] = stream_analytics_job_name
        __props__.__dict__["time_format"] = time_format
        return ReferenceInputBlob(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authenticationMode")
    def authentication_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The authentication mode for the Stream Analytics Reference Input. Possible values are `Msi` and `ConnectionString`. Defaults to `ConnectionString`.
        """
        return pulumi.get(self, "authentication_mode")

    @_builtins.property
    @pulumi.getter(name="dateFormat")
    def date_format(self) -> pulumi.Output[_builtins.str]:
        """
        The date format. Wherever `{date}` appears in `path_pattern`, the value of this property is used as the date format instead.
        """
        return pulumi.get(self, "date_format")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Reference Input Blob. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pathPattern")
    def path_pattern(self) -> pulumi.Output[_builtins.str]:
        """
        The blob path pattern. Not a regular expression. It represents a pattern against which blob names will be matched to determine whether or not they should be included as input or output to the job.
        """
        return pulumi.get(self, "path_pattern")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Stream Analytics Job exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def serialization(self) -> pulumi.Output['outputs.ReferenceInputBlobSerialization']:
        """
        A `serialization` block as defined below.
        """
        return pulumi.get(self, "serialization")

    @_builtins.property
    @pulumi.getter(name="storageAccountKey")
    def storage_account_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Access Key which should be used to connect to this Storage Account. Required if `authentication_mode` is `ConnectionString`.
        """
        return pulumi.get(self, "storage_account_key")

    @_builtins.property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Storage Account that has the blob container with reference data.
        """
        return pulumi.get(self, "storage_account_name")

    @_builtins.property
    @pulumi.getter(name="storageContainerName")
    def storage_container_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Container within the Storage Account.
        """
        return pulumi.get(self, "storage_container_name")

    @_builtins.property
    @pulumi.getter(name="streamAnalyticsJobName")
    def stream_analytics_job_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Stream Analytics Job. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "stream_analytics_job_name")

    @_builtins.property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> pulumi.Output[_builtins.str]:
        """
        The time format. Wherever `{time}` appears in `path_pattern`, the value of this property is used as the time format instead.
        """
        return pulumi.get(self, "time_format")

