# Generated by Django 5.1.3 on 2025-04-03 04:21

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('instagram', '0046_alter_media_download_url'),
    ]

    operations = [
        migrations.CreateModel(
            name='Account',
            fields=[
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, default=None, editable=False, null=True)),
                ('id', models.CharField(db_index=True, max_length=255, primary_key=True, serialize=False, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('igname', models.CharField(blank=True, max_length=255, null=True)),
                ('assigned_to', models.TextField(default='Robot')),
                ('referral', models.TextField(blank=True, default='', null=True)),
                ('full_name', models.CharField(blank=True, max_length=1024, null=True)),
                ('email', models.EmailField(blank=True, max_length=254, null=True)),
                ('phone_number', models.CharField(blank=True, max_length=255, null=True)),
                ('profile_url', models.URLField(blank=True, null=True)),
                ('script_score', models.IntegerField(blank=True, null=True)),
                ('script_version', models.CharField(blank=True, max_length=255, null=True)),
                ('status_param', models.CharField(blank=True, max_length=255, null=True)),
                ('confirmed_problems', models.TextField(blank=True, default='test', null=True)),
                ('solution_presented', models.BooleanField(default=False)),
                ('question_asked', models.BooleanField(default=False)),
                ('rejected_problems', models.TextField(blank=True, default='test', null=True)),
                ('linked_to', models.CharField(blank=True, default='no_one', max_length=255, null=True)),
                ('dormant_profile_created', models.BooleanField(blank=True, default=True, null=True)),
                ('qualified', models.BooleanField(default=False)),
                ('scraped', models.BooleanField(default=False)),
                ('relevant_information', models.JSONField(blank=True, null=True)),
                ('is_manually_triggered', models.BooleanField(default=False)),
                ('index', models.IntegerField(default=1)),
                ('notes', models.TextField(blank=True, null=True)),
                ('outreach_time', models.DateTimeField(blank=True, null=True)),
                ('outreach_success', models.BooleanField(default=False)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AccountsClosed',
            fields=[
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, default=None, editable=False, null=True)),
                ('id', models.CharField(db_index=True, max_length=255, primary_key=True, serialize=False, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('data', models.TextField(blank=True, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='HashTag',
            fields=[
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, default=None, editable=False, null=True)),
                ('id', models.CharField(db_index=True, max_length=255, primary_key=True, serialize=False, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('hashtag_id', models.CharField(max_length=255)),
                ('name', models.CharField(blank=True, max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='OutSourcedInfo',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('source', models.CharField(blank=True, max_length=255, null=True)),
                ('results', models.TextField(blank=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
        ),
        migrations.CreateModel(
            name='Reel',
            fields=[
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, default=None, editable=False, null=True)),
                ('id', models.CharField(db_index=True, max_length=255, primary_key=True, serialize=False, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('reel_id', models.CharField(max_length=50)),
                ('link', models.URLField()),
                ('name', models.CharField(max_length=255)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='StatusCheck',
            fields=[
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, default=None, editable=False, null=True)),
                ('id', models.CharField(db_index=True, max_length=255, primary_key=True, serialize=False, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('stage', models.IntegerField(choices=[(1, 'Oven'), (2, 'Needs Assessment'), (3, 'Overcoming Objections'), (4, 'Activation')], default=1)),
                ('name', models.CharField(max_length=255)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Story',
            fields=[
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, default=None, editable=False, null=True)),
                ('id', models.CharField(db_index=True, max_length=255, primary_key=True, serialize=False, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('story_id', models.CharField(blank=True, max_length=50, null=True)),
                ('link', models.URLField()),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='UnwantedAccount',
            fields=[
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, default=None, editable=False, null=True)),
                ('id', models.CharField(db_index=True, max_length=255, primary_key=True, serialize=False, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('username', models.CharField(blank=True, max_length=255, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Video',
            fields=[
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, default=None, editable=False, null=True)),
                ('id', models.CharField(db_index=True, max_length=255, primary_key=True, serialize=False, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('video_id', models.CharField(max_length=50)),
                ('link', models.URLField()),
                ('name', models.CharField(max_length=255)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Comment',
            fields=[
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, default=None, editable=False, null=True)),
                ('id', models.CharField(db_index=True, max_length=255, primary_key=True, serialize=False, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('comment_id', models.CharField(max_length=50)),
                ('message', models.TextField(blank=True, null=True)),
                ('media_id', models.CharField(blank=True, max_length=255, null=True)),
                ('target_comment_id', models.CharField(blank=True, max_length=255, null=True)),
                ('collapseKey', models.CharField(blank=True, max_length=50, null=True)),
                ('optionalAvatarUrl', models.URLField(blank=True, max_length=2048, null=True)),
                ('pushId', models.CharField(blank=True, max_length=255, null=True)),
                ('pushCategory', models.CharField(blank=True, max_length=255, null=True)),
                ('intendedRecipientUserId', models.CharField(blank=True, max_length=50, null=True)),
                ('sourceUserId', models.CharField(blank=True, max_length=50, null=True)),
                ('account', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='instagram.account')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Like',
            fields=[
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, default=None, editable=False, null=True)),
                ('id', models.CharField(db_index=True, max_length=255, primary_key=True, serialize=False, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('message', models.TextField(blank=True, null=True)),
                ('media_id', models.CharField(blank=True, max_length=255, null=True)),
                ('collapseKey', models.CharField(blank=True, max_length=50, null=True)),
                ('optionalAvatarUrl', models.URLField(blank=True, max_length=2048, null=True)),
                ('pushId', models.CharField(blank=True, max_length=50, null=True)),
                ('pushCategory', models.CharField(blank=True, max_length=255, null=True)),
                ('intendedRecipientUserId', models.CharField(blank=True, max_length=50, null=True)),
                ('sourceUserId', models.CharField(blank=True, max_length=50, null=True)),
                ('account', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='instagram.account')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='OutreachTime',
            fields=[
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, default=None, editable=False, null=True)),
                ('id', models.CharField(db_index=True, max_length=255, primary_key=True, serialize=False, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('time_slot', models.DateTimeField()),
                ('account_to_be_assigned', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='instagram.account')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='OutSourced',
            fields=[
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, default=None, editable=False, null=True)),
                ('id', models.CharField(db_index=True, max_length=255, primary_key=True, serialize=False, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('source', models.CharField(blank=True, max_length=255, null=True)),
                ('results', models.JSONField()),
                ('account', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='instagram.account')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Photo',
            fields=[
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, default=None, editable=False, null=True)),
                ('id', models.CharField(db_index=True, max_length=255, primary_key=True, serialize=False, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('photo_id', models.CharField(max_length=50)),
                ('link', models.URLField()),
                ('name', models.CharField(max_length=255)),
                ('account', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='instagram.account')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='account',
            name='status',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='instagram.statuscheck'),
        ),
        migrations.CreateModel(
            name='Thread',
            fields=[
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, default=None, editable=False, null=True)),
                ('id', models.CharField(db_index=True, max_length=255, primary_key=True, serialize=False, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('thread_id', models.CharField(max_length=255)),
                ('unread_message_count', models.IntegerField(default=0)),
                ('last_message_content', models.TextField(blank=True, null=True)),
                ('last_message_at', models.DateTimeField(blank=True, null=True)),
                ('account', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='instagram.account')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Message',
            fields=[
                ('deleted_at', models.DateTimeField(blank=True, db_index=True, default=None, editable=False, null=True)),
                ('id', models.CharField(db_index=True, max_length=255, primary_key=True, serialize=False, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('content', models.TextField(blank=True, default='test', null=True)),
                ('sent_by', models.CharField(blank=True, max_length=255, null=True)),
                ('sent_on', models.DateTimeField()),
                ('content_type', models.CharField(blank=True, max_length=255, null=True)),
                ('content_link', models.CharField(blank=True, max_length=255, null=True)),
                ('content_data', models.JSONField(blank=True, null=True)),
                ('message_id', models.CharField(blank=True, max_length=50, null=True)),
                ('thread', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='instagram.thread')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
