"""
Django settings for api project.

Generated by 'django-admin startproject' using Django 5.0.1.

For more information on this file, see
https://docs.djangoproject.com/en/5.0/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/5.0/ref/settings/
Author: Martin Luther Bironga 
Profession: Data Consultant
"""
import os
from pathlib import Path
from datetime import timedelta
import sentry_sdk


PHONE_NUMBER_ID = os.environ.get("PHONE_NUMBER_ID","")
VERIFY_TOKEN = os.environ.get("VERIFY_TOKEN","")
ACCESS_TOKEN = os.environ.get("ACCESS_TOKEN","")
WHATSAPP_BUSINESS_ACCOUNT_ID = os.environ.get("WHATSAPP_BUSINESS_ACCOUNT_ID","")
TOKEN = os.environ.get("TOKEN","")
OPENAI_API_KEY = os.environ.get("OPENAI_API_KEY","")

sentry_sdk.init(
    dsn=os.getenv("SENTRY_DSN"),
    # Set traces_sample_rate to 1.0 to capture 100%
    # of transactions for tracing.
    traces_sample_rate=1.0,
    _experiments={
        # Set continuous_profiling_auto_start to True
        # to automatically start the profiler on when
        # possible.
        "continuous_profiling_auto_start": True,
    },
)

# Build paths inside the project like this: BASE_DIR / 'subdir'.
BASE_DIR = Path(__file__).resolve().parent.parent
NOTEBOOK_ARGUMENTS = [
    '--ip', '0.0.0.0',
    '--port', '8888',
    '--notebook-dir', BASE_DIR / "notebooks",  # Adjust the path as needed
    '--NotebookApp.default_url', '/tree'  # Change to '/lab' for JupyterLab
]
IPYTHON_KERNEL_DISPLAY_NAME = 'Django Kernel'
os.environ["DJANGO_ALLOW_ASYNC_UNSAFE"] = "true"


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/5.0/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = 'django-insecure-utr163745j!iq*)7h-+g6_!y+z$mkmcx3x2ouv$gq$8-42)yn+'

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True


ALLOWED_HOSTS = [
    f"{os.environ.get('DOMAIN1', '')}.boostedchat.com",
    f"{os.environ.get('DOMAIN2', '')}.boostedchat.com",
    f"scrapper.{os.environ.get('DOMAIN1', '')}.boostedchat.com",
    f"airflow.{os.environ.get('DOMAIN1', '')}.boostedchat.com",
    f"scrapper.{os.environ.get('DOMAIN2', '')}.boostedchat.com",
    f"airflow.{os.environ.get('DOMAIN2', '')}.boostedchat.com",
    "34.28.104.255",
    "173.249.6.165",
    "127.0.0.1",
    "0.0.0.0",
    "localhost",
    "web",
    "booksy.us.boostedchat.com",
    "scrapper.booksy.boostedchat.com",
    "airflow.booksy.boostedchat.com",
    "lunyamwi.localhost",
]
CSRF_TRUSTED_ORIGINS = [
    f"https://api.{os.environ.get('DOMAIN1', '')}.boostedchat.com",
    f"https://api.{os.environ.get('DOMAIN2', '')}.boostedchat.com",
    f"https://scrapper.{os.environ.get('DOMAIN1', '')}.boostedchat.com",
    f"https://scrapper.{os.environ.get('DOMAIN2', '')}.boostedchat.com",
    "http://34.28.104.255",
    "http://173.249.6.165",
    "https://173.249.6.165",
    "http://lunyamwi.localhost/",
    "http://lunyamwi.localhost",
]

# Application definition

SHARED_APPS = [
    'auditlog',
    'django_tenants',
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'rest_framework',
    'rest_framework.authtoken',
    'django_celery_beat',
    'softdelete',
    'boostedchatScrapper',
    'sitemaps',
    "crispy_forms",
    "crispy_bootstrap5",
    "api.authentication",
    "api.serviceManager",
    "allauth",
    "allauth.account",
    "dj_rest_auth",
    "allauth.socialaccount",
    "allauth.socialaccount.providers.google",

    # "django_extensions"
    'api.instagram','api.scout', 'api.helpers','api.prompt',
    'api.analyst','api.sales_rep','api.whatsapp','api.outreaches',
    'api.facebook','api.workflow','api.linkedin','api.gmail'
]

TENANT_APPS = [
    'api.outreaches',
]
INSTALLED_APPS = SHARED_APPS + [app for app in TENANT_APPS if app not in SHARED_APPS]
TENANT_MODEL = "boostedchatScrapper.Client"
TENANT_DOMAIN_MODEL = "boostedchatScrapper.Domain"

MIDDLEWARE = [
    "allauth.account.middleware.AccountMiddleware",
    'django_tenants.middleware.main.TenantMainMiddleware',
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    "corsheaders.middleware.CorsMiddleware",
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'api.urls'
PUBLIC_SCHEMA_URLCONF = 'boostedchatScrapper.urls'

STATICFILES_FINDERS = (
    'django.contrib.staticfiles.finders.FileSystemFinder',
    'django.contrib.staticfiles.finders.AppDirectoriesFinder',
)

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
            'libraries': {
                'crispy_forms_tags': 'crispy_forms.templatetags.crispy_forms_tags',
            },
        },
    },
]

WSGI_APPLICATION = 'api.wsgi.application'

AIRFLOW_API_BASE_URL = 'http://localhost:8080/api/v1'
# settings.py

# ... other settings ...

TEST_RUNNER = 'api.test_runner.NoTestDBTestRunner'

# ... other settings ...

# Database
# https://docs.djangoproject.com/en/5.0/ref/settings/#databases

DATABASES = {
    "default": {
        "ENGINE": "django_tenants.postgresql_backend",
        "NAME": os.getenv("POSTGRES_DBNAME_ETL").strip(),
        "USER": os.getenv("POSTGRES_USERNAME_ETL").strip(),
        "PASSWORD": os.getenv("POSTGRES_PASSWORD_ETL").strip(),
        "HOST": os.getenv("POSTGRES_HOST_ETL").strip(),
        "PORT": os.getenv("POSTGRES_PORT_ETL").strip(),
    }

}

DATABASE_ROUTERS = (
    "django_tenants.routers.TenantSyncRouter",
) 

AUTH_USER_MODEL = "authentication.User"
# Password validation
# https://docs.djangoproject.com/en/5.0/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]

CELERY_BROKER_URL = os.getenv("CELERY_BROKER_URL_")
CELERY_RESULT_BACKEND = os.getenv("CELERY_RESULT_BACKEND_")
CELERY_BEAT_SCHEDULER = "django_celery_beat.schedulers:DatabaseScheduler"
CRISPY_ALLOWED_TEMPLATE_PACKS = "bootstrap5"
CRISPY_TEMPLATE_PACK = "bootstrap5"
MAILCHIMP_API_KEY = os.getenv("MAILCHIMP_API_KEY").strip()
MAILCHIMP_DATA_CENTER = os.getenv("MAILCHIMP_DATA_CENTER").strip()
MAILCHIMP_EMAIL_LIST_ID = os.getenv("MAILCHIMP_EMAIL_LIST_ID").strip()
DEFAULT_FROM_EMAIL = os.getenv("EMAIL_HOST_USER").strip()

EMAIL_BACKEND = "django.core.mail.backends.smtp.EmailBackend"
EMAIL_HOST = "smtp.gmail.com"
EMAIL_HOST_USER = os.getenv("EMAIL_HOST_USER").strip()
EMAIL_HOST_PASSWORD = os.getenv("EMAIL_HOST_PASSWORD").strip()
EMAIL_PORT = 587
EMAIL_USE_TLS = True

# Internationalization
# https://docs.djangoproject.com/en/5.0/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/5.0/howto/static-files/

STATIC_URL = 'static/'
STATIC_ROOT = '/usr/src/app/static'

# Default primary key field type
# https://docs.djangoproject.com/en/5.0/ref/settings/#default-auto-field

DEFAULT_AUTO_FIELD = 'django.db.models.BigAutoField'

CORS_ALLOWED_ORIGINS = [
    f"https://{os.environ.get('DOMAIN1', '')}.boostedchat.com",
    f"https://{os.environ.get('DOMAIN2', '')}.boostedchat.com",
    "http://localhost:8080",
    "http://127.0.0.1:9000",
    "http://localhost:9000",
    "http://localhost:5173",
    "https://booksy.us.boostedchat.com",
    "http://localhost:3000",
    "https://jamel.boostedchat.com"
]

CORS_ALLOW_HEADERS = (
    "accept",
    "authorization",
    "content-type",
    "user-agent",
    "x-csrftoken",
    "x-requested-with",
)


CORS_ALLOW_METHODS = (
    "DELETE",
    "GET",
    "OPTIONS",
    "PATCH",
    "POST",
    "PUT",
)

AI_MICROSERVICE_URL = "http://34.170.152.34/modelhub/"
DIALOGFLOW_BASE_URL = (
    "https://us-central1-dialogflow.googleapis.com/v3beta1/projects/boostedchatapi/locations/us-central1/"
)
OPENAI_BASE_URL = "https://api.openai.com/v1"
# Application definition

MQTT_BASE_URL = os.environ.get('MQTT_URL', "http://mqtt:3000")
print(MQTT_BASE_URL)
SCRAPPER_BASE_URL = os.environ.get('SCRAPPER_URL', "http://web:8003")
API_BASE_URL = os.environ.get('API_BASE_URL', os.environ.get('API_URL', "http://web:8003"))

SIMPLE_JWT = {
    "ACCESS_TOKEN_LIFETIME": timedelta(hours=2),
    "REFRESH_TOKEN_LIFETIME": timedelta(days=1),
    "ROTATE_REFRESH_TOKENS": False,
    "BLACKLIST_AFTER_ROTATION": False,
    "UPDATE_LAST_LOGIN": False,
    "ALGORITHM": "HS256",
    "SIGNING_KEY": SECRET_KEY,
    "VERIFYING_KEY": "",
    "AUDIENCE": None,
    "ISSUER": None,
    "JSON_ENCODER": None,
    "JWK_URL": None,
    "LEEWAY": 0,
    "AUTH_HEADER_TYPES": ("Bearer",),
    "AUTH_HEADER_NAME": "HTTP_AUTHORIZATION",
    "USER_ID_FIELD": "id",
    "USER_ID_CLAIM": "user_id",
    "USER_AUTHENTICATION_RULE": "rest_framework_simplejwt.authentication.default_user_authentication_rule",
    "AUTH_TOKEN_CLASSES": ("rest_framework_simplejwt.tokens.AccessToken",),
    "TOKEN_TYPE_CLAIM": "token_type",
    "TOKEN_USER_CLASS": "rest_framework_simplejwt.models.TokenUser",
    "JTI_CLAIM": "jti",
    "SLIDING_TOKEN_REFRESH_EXP_CLAIM": "refresh_exp",
    "SLIDING_TOKEN_LIFETIME": timedelta(hours=2),
    "SLIDING_TOKEN_REFRESH_LIFETIME": timedelta(days=1),
    "TOKEN_OBTAIN_SERIALIZER": "rest_framework_simplejwt.serializers.TokenObtainPairSerializer",
    "TOKEN_REFRESH_SERIALIZER": "rest_framework_simplejwt.serializers.TokenRefreshSerializer",
    "TOKEN_VERIFY_SERIALIZER": "rest_framework_simplejwt.serializers.TokenVerifySerializer",
    "TOKEN_BLACKLIST_SERIALIZER": "rest_framework_simplejwt.serializers.TokenBlacklistSerializer",
    "SLIDING_TOKEN_OBTAIN_SERIALIZER": "rest_framework_simplejwt.serializers.TokenObtainSlidingSerializer",
    "SLIDING_TOKEN_REFRESH_SERIALIZER": "rest_framework_simplejwt.serializers.TokenRefreshSlidingSerializer",
}

