from django.urls import path
from . import views


urlpatterns = [
    path('create-flow/', views.CreateFlowView.as_view(), name='create_flow'),
    path('webhook/', views.webhook, name='webhook'),
    path('send-message/',views.SendBatchWhatsAppView.as_view(), name='send_message'),
    path('send-message-test/',views.query_gpt_test, name='send_message_test'),
    # path('webhook/survey/',views.WebhookView.as_view(), name='webhook_survey'),
    path('webhook/', views.webhook, name='webhook'),
    path('whapi/webhook/', views.webhook_whapi, name='whatsapp_webhook'),
    path('whapi/query-gpt-test/', views.query_gpt_test, name='query_gpt_test'),
    path('whapi/batch-send/', views.SendBatchWhatsAppView.as_view(), name='batch_send'),
    path('whapi/health/', views.ChannelHealthView.as_view(), name='channel_health'),
    path('whapi/settings/', views.ChannelSettingsView.as_view(), name='channel_settings'),
    path('whapi/settings/events/', views.ChannelEventsView.as_view(), name='channel_events'),
    path('whapi/settings/webhook_test/', views.WebhookTestView.as_view(), name='webhook_test'),
    path('whapi/limits/', views.ChannelLimitsView.as_view(), name='channel_limits'),
    path('whapi/users/login/', views.UserLoginView.as_view(), name='user_login'),
    path('whapi/users/logout/', views.UserLogoutView.as_view(), name='user_logout'),
    path('whapi/users/profile/', views.UserProfileView.as_view(), name='user_profile'),
    path('whapi/users/info/', views.UserInfoView.as_view(), name='user_info'),
    # path('whapi/users/gdpr/', views.UserGDPRView.as_view(), name='user_gdpr'),
    path('whapi/status/', views.UserStatusView.as_view(), name='user_status'),
    path('whapi/messages/list/', views.MessagesListView.as_view(), name='messages_list'),
    path('whapi/messages/list/<str:chat_id>/', views.MessagesListView.as_view(), name='messages_list_by_chat'),
    path('whapi/messages/text/', views.SendTextMessageView.as_view(), name='send_text'),
    path('whapi/messages/image/', views.SendImageMessageView.as_view(), name='send_image'),
    path('whapi/messages/video/', views.SendVideoMessageView.as_view(), name='send_video'),
    path('whapi/messages/short/', views.SendShortVideoMessageView.as_view(), name='send_short_video'),
    path('whapi/messages/gif/', views.SendGifMessageView.as_view(), name='send_gif'),
    path('whapi/messages/audio/', views.SendAudioMessageView.as_view(), name='send_audio'),
    path('whapi/messages/voice/', views.SendVoiceMessageView.as_view(), name='send_voice'),
    path('whapi/messages/document/', views.SendDocumentMessageView.as_view(), name='send_document'),
    path('whapi/messages/link_preview/', views.SendLinkPreviewMessageView.as_view(), name='send_link_preview'),
    path('whapi/messages/location/', views.SendLocationMessageView.as_view(), name='send_location'),
    path('whapi/messages/live_location/', views.SendLiveLocationMessageView.as_view(), name='send_live_location'),
    path('whapi/messages/contact/', views.SendContactMessageView.as_view(), name='send_contact'),
    path('whapi/messages/contact_list/', views.SendContactListMessageView.as_view(), name='send_contact_list'),
    path('whapi/messages/poll/', views.SendPollMessageView.as_view(), name='send_poll'),
    path('whapi/messages/interactive/', views.SendInteractiveMessageView.as_view(), name='send_interactive'),
    path('whapi/messages/sticker/', views.SendStickerMessageView.as_view(), name='send_sticker'),
    path('whapi/messages/story/', views.SendStoryMessageView.as_view(), name='send_story'),
    path('whapi/messages/story/audio/', views.SendStoryAudioMessageView.as_view(), name='send_story_audio'),
    path('whapi/messages/story/media/', views.SendStoryMediaMessageView.as_view(), name='send_story_media'),
    path('whapi/messages/story/text/', views.SendStoryTextMessageView.as_view(), name='send_story_text'),
    path('whapi/messages/media/<str:media_type>/', views.SendMediaMessageView.as_view(), name='send_media'),
    path('whapi/messages/<str:message_id>/', views.MessageView.as_view(), name='message_detail'),
    path('whapi/messages/<str:message_id>/reaction/', views.MessageReactionView.as_view(), name='message_reaction'),
    path('whapi/messages/<str:message_id>/star/', views.MessageStarView.as_view(), name='message_star'),
    path('whapi/messages/<str:message_id>/pin/', views.MessagePinView.as_view(), name='message_pin'),
    path('whapi/chats/', views.ChatsView.as_view(), name='chats_list'),
    path('whapi/chats/<str:chat_id>/', views.ChatView.as_view(), name='chat_detail'),
    path('whapi/contacts/', views.ContactsView.as_view(), name='contacts'),
    path('whapi/contacts/<str:contact_id>/', views.ContactView.as_view(), name='contact_detail'),
    path('whapi/contacts/<str:contact_id>/profile/', views.ContactProfileView.as_view(), name='contact_profile'),
    path('whapi/contacts/lids/', views.ContactLidsView.as_view(), name='contact_lids'),
    path('whapi/contacts/lids/<str:contact_id>/', views.ContactLidsView.as_view(), name='contact_lid_detail'),
    path('whapi/presences/me/', views.PresencesMeView.as_view(), name='presences_me'),
    path('whapi/presences/<str:entry_id>/', views.PresenceView.as_view(), name='presence_detail'),
    path('whapi/groups/', views.GroupsView.as_view(), name='groups'),
    path('whapi/groups/<str:group_id>/', views.GroupView.as_view(), name='group_detail'),
    path('whapi/groups/<str:group_id>/invite/', views.GroupInviteView.as_view(), name='group_invite'),
    path('whapi/groups/<str:group_id>/participants/', views.GroupParticipantsView.as_view(), name='group_participants'),
    path('whapi/groups/<str:group_id>/icon/', views.GroupIconView.as_view(), name='group_icon'),
    path('whapi/groups/<str:group_id>/admins/', views.GroupAdminsView.as_view(), name='group_admins'),
    path('whapi/groups/link/<str:invite_code>/', views.GroupInviteLinkView.as_view(), name='group_invite_link'),
    path('whapi/groups/<str:group_id>/applications/', views.GroupApplicationsView.as_view(), name='group_applications'),
    path('whapi/stories/', views.StoriesView.as_view(), name='stories'),
    path('whapi/stories/send/text/', views.StoriesSendTextView.as_view(), name='stories_send_text'),
    path('whapi/stories/send/media/', views.StoriesSendMediaView.as_view(), name='stories_send_media'),
    path('whapi/stories/send/audio/', views.StoriesSendAudioView.as_view(), name='stories_send_audio'),
    path('whapi/stories/<str:message_id>/', views.StoryView.as_view(), name='story_detail'),
    path('whapi/statuses/<str:message_id>/', views.StatusesView.as_view(), name='statuses'),
    path('whapi/newsletters/', views.NewslettersView.as_view(), name='newsletters'),
    path('whapi/newsletters/find/', views.NewslettersFindView.as_view(), name='newsletters_find'),
    path('whapi/newsletters/recommended/', views.NewslettersRecommendedView.as_view(), name='newsletters_recommended'),
    path('whapi/newsletters/<str:newsletter_id>/', views.NewsletterView.as_view(), name='newsletter_detail'),
    path('whapi/newsletters/<str:newsletter_id>/subscription/', views.NewsletterSubscriptionView.as_view(), name='newsletter_subscription'),
    path('whapi/newsletters/invite/<str:invite_code>/subscription/', views.NewsletterInviteSubscriptionView.as_view(), name='newsletter_invite_subscription'),
    path('whapi/newsletters/<str:newsletter_id>/tracking/', views.NewsletterTrackingView.as_view(), name='newsletter_tracking'),
    path('whapi/newsletters/<str:newsletter_id>/messages/', views.NewsletterMessagesView.as_view(), name='newsletter_messages'),
    path('whapi/newsletters/<str:newsletter_id>/invite/<str:contact_id>/', views.NewsletterInviteView.as_view(), name='newsletter_invite'),
    path('whapi/newsletters/<str:newsletter_id>/admins/<str:contact_id>/', views.NewsletterAdminsView.as_view(), name='newsletter_admins'),
    path('whapi/newsletters/link/<str:invite_code>/', views.NewsletterLinkView.as_view(), name='newsletter_link'),
    path('whapi/media/', views.MediaView.as_view(), name='media'),
    path('whapi/media/<str:media_id>/', views.MediaView.as_view(), name='media_detail'),
    path('whapi/business/', views.BusinessView.as_view(), name='business'),
    path('whapi/business/products/', views.BusinessProductsView.as_view(), name='business_products'),
    path('whapi/business/<str:contact_id>/products/', views.BusinessProductsView.as_view(), name='business_products_by_contact'),
    path('whapi/business/products/<str:product_id>/', views.BusinessProductView.as_view(), name='business_product'),
    path('whapi/business/orders/', views.BusinessOrdersView.as_view(), name='business_orders'),
    path('whapi/business/orders/<str:order_id>/', views.BusinessOrderView.as_view(), name='business_order'),
    path('whapi/business/cart/', views.BusinessCartView.as_view(), name='business_cart'),
    path('whapi/business/cart/enabled/', views.BusinessCartEnabledView.as_view(), name='business_cart_enabled'),
    path('whapi/business/catalogs/<str:contact_id>/', views.BusinessCatalogView.as_view(), name='business_catalog'),
    path('whapi/labels/', views.LabelsView.as_view(), name='labels'),
    path('whapi/labels/<str:label_id>/', views.LabelView.as_view(), name='label_detail'),
    path('whapi/labels/<str:label_id>/<str:association_id>/', views.LabelAssociationView.as_view(), name='label_association'),
    path('whapi/blacklist/', views.BlacklistView.as_view(), name='blacklist'),
    path('whapi/blacklist/<str:contact_id>/', views.BlacklistContactView.as_view(), name='blacklist_contact'),
    path('whapi/communities/', views.CommunitiesView.as_view(), name='communities'),
    path('whapi/communities/<str:community_id>/', views.CommunityView.as_view(), name='community_detail'),
    path('whapi/communities/<str:community_id>/link/', views.CommunityLinkView.as_view(), name='community_link'),
    path('whapi/communities/<str:community_id>/<str:group_id>/', views.CommunityGroupView.as_view(), name='community_group'),
    path('whapi/communities/<str:community_id>/<str:group_id>/join/', views.CommunityGroupJoinView.as_view(), name='community_group_join'),
    path('whapi/bots/', views.BotsView.as_view(), name='bots'),
    path('whapi/calls/', views.CallsView.as_view(), name='calls'),
    path('whapi/calls/<str:call_id>/', views.CallView.as_view(), name='call_detail'),
    path('whapi/calls/<str:call_id>/reject/', views.CallRejectView.as_view(), name='call_reject'),
    path('whapi/calls/group_link/', views.CallsGroupLinkView.as_view(), name='calls_group_link'),
]
