# Generated by Django 5.1.5 on 2025-09-24 16:21

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='JobConfiguration',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_dtm', models.DateTimeField(auto_now_add=True)),
                ('updated_dtm', models.DateTimeField(auto_now=True)),
                ('job_name', models.CharField(max_length=100)),
                ('is_scheduled_run_enabled', models.BooleanField(default=True)),
                ('is_realtime_run_enabled', models.BooleanField(default=False)),
                ('batch_size', models.PositiveSmallIntegerField()),
                ('records_to_fetch_count', models.PositiveIntegerField()),
                ('run_async', models.BooleanField(default=False)),
                ('task_queue_name', models.CharField(default='celery', max_length=30)),
                ('process_at_partner_level', models.BooleanField(default=False)),
                ('config', models.JSONField(null=True)),
                ('type', models.CharField(choices=[('P', 'PARTNER'), ('SY', 'SYSTEM')], default='P', max_length=2)),
            ],
            options={
                'verbose_name': 'Job Configuration',
                'verbose_name_plural': 'Job Configurations',
                'db_table': 'job_configuration',
            },
        ),
        migrations.CreateModel(
            name='JobRunMetaDataV2',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_dtm', models.DateTimeField()),
                ('updated_dtm', models.DateTimeField()),
                ('job_id', models.PositiveSmallIntegerField()),
                ('job_run_log_id', models.CharField(max_length=35, null=True)),
                ('metadata', models.JSONField(null=True)),
                ('error_info', models.TextField(null=True)),
                ('status', models.PositiveSmallIntegerField()),
            ],
            options={
                'verbose_name': 'Job Run Meta Data V2',
                'verbose_name_plural': 'Job Run Meta Data V2',
                'db_table': 'job_run_meta_data_v2',
            },
        ),
        migrations.CreateModel(
            name='JobStatusConstant',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_dtm', models.DateTimeField(auto_now_add=True)),
                ('updated_dtm', models.DateTimeField(auto_now=True)),
                ('status', models.CharField(max_length=10)),
                ('code', models.CharField(max_length=2)),
            ],
            options={
                'verbose_name': 'Job Status Constant',
                'verbose_name_plural': 'Job Status Constants',
                'db_table': 'job_status_constant',
            },
        ),
        migrations.CreateModel(
            name='PeriodicJobRunLog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_dtm', models.DateTimeField()),
                ('updated_dtm', models.DateTimeField()),
                ('job_id', models.PositiveSmallIntegerField()),
                ('job_run_log_id', models.CharField(max_length=35)),
                ('status', models.PositiveSmallIntegerField()),
                ('parameters', models.JSONField(null=True)),
                ('error_info', models.TextField(null=True)),
            ],
            options={
                'verbose_name': 'Periodic Job Run Log',
                'verbose_name_plural': 'Periodic Job Run Logs',
                'db_table': 'periodic_job_run_log',
            },
        ),
        migrations.CreateModel(
            name='JobPartnerMapping',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_dtm', models.DateTimeField(auto_now_add=True)),
                ('updated_dtm', models.DateTimeField(auto_now=True)),
                ('partner_id', models.PositiveSmallIntegerField()),
                ('is_enabled', models.BooleanField(default=False)),
                ('config', models.JSONField(null=True)),
                ('job', models.ForeignKey(on_delete=django.db.models.deletion.DO_NOTHING, related_name='partner_configs', to='job_template.jobconfiguration')),
            ],
            options={
                'verbose_name': 'Job Partner Mapping',
                'verbose_name_plural': 'Job Partner Mappings',
                'db_table': 'job_partner_mapping',
                'unique_together': {('job', 'partner_id')},
            },
        ),
    ]
