
from kotonebot.kaa.common import sprite_path
from kotonebot.backend.core import Image, HintBox, HintPoint



class Common:
    
    ButtonClose = Image(path=sprite_path(r"7b8541a8-9e82-410b-b053-3ebc96b36604.png"), name="button_close.png")

    ButtonCompletion = Image(path=sprite_path(r"a898c01d-1347-484f-b2b0-10858a1ef3a6.png"), name="button_completion.png")

    ButtonConfirm = Image(path=sprite_path(r"0e332904-cace-4d02-9575-100a359c548f.png"), name="button_confirm.png")

    ButtonConfirmNoIcon = Image(path=sprite_path(r"5cd3481b-2388-4461-b525-c2f78050822f.png"), name="button_confirm_no_icon.png")

    ButtonContest = Image(path=sprite_path(r"b5a883c1-8086-4c60-a789-a7819c674645.png"), name="button_contest.png")

    ButtonEnd = Image(path=sprite_path(r"ccbbecec-5cf5-4f9f-8358-6b3408689234.png"), name="button_end.png")

    ButtonHome = Image(path=sprite_path(r"06df0c16-bb7e-41b7-90fe-afc14379b90f.png"), name="button_home.png")

    ButtonIconArrowShort = Image(path=sprite_path(r"25ceaa36-a432-4bf3-80b7-11c94cd82357.png"), name="button_icon_arrow_short.png")

    ButtonIconArrowShortDisabled = Image(path=sprite_path(r"bfa4b6bf-c032-46b8-9ce3-268717e4e364.png"), name="button_icon_arrow_short_disabled.png")

    ButtonIconCheckMark = Image(path=sprite_path(r"8bad2dbc-9f3a-443f-a3ff-048e70577a97.png"), name="button_icon_check_mark.png")

    ButtonIconClose = Image(path=sprite_path(r"2fc0a912-8d9b-48a3-b942-a25274c83edd.png"), name="button_icon_close.png")

    ButtonIdol = Image(path=sprite_path(r"04622143-7f9e-47a8-86a5-be2b81d13cb6.png"), name="button_idol.png")

    ButtonIdolSupportCard = Image(path=sprite_path(r"8bdcc43b-876d-451f-b300-67c16c6f5c9f.png"), name="button_idol_support_card.png")

    ButtonNext = Image(path=sprite_path(r"7533e4fd-e411-4386-a0fb-aa8f2cbeb216.png"), name="button_next.png")

    ButtonNextNoIcon = Image(path=sprite_path(r"bc393fa9-317c-48f9-88cf-cd4d93af1569.png"), name="button_next_no_icon.png")

    ButtonRetry = Image(path=sprite_path(r"5528a0a0-2f1e-41f8-b55f-a565a2f80908.png"), name="button_retry.png")

    ButtonSelect = Image(path=sprite_path(r"651b2464-0c4a-4f3d-9452-5a40897b39e1.png"), name="button_select.png")

    ButtonStart = Image(path=sprite_path(r"288a0541-a175-47b4-b75c-2e845e27cba6.png"), name="button_start.png")

    ButtonToolbarHome = Image(path=sprite_path(r"a18a08f5-c752-4fa4-a451-b48f5ca11360.png"), name="button_toolbar_home.png")

    ButtonToolbarMenu = Image(path=sprite_path(r"db86f5a5-0272-4a74-893e-077acbbecf23.png"), name="button_toolbar_menu.png")

    CheckboxUnchecked = Image(path=sprite_path(r"f47d8096-63bf-42ed-8f4f-5f6f1d8772f4.png"), name="checkbox_unchecked.png")

    TextGameUpdate = Image(path=sprite_path(r"65dbaa8c-2053-4441-9c31-8fd8fc8c87d8.png"), name="text_game_update.png")

    TextNetworkError = Image(path=sprite_path(r"c1504a57-77f0-46ca-a30b-162120489d5c.png"), name="text_network_error.png")

    TextFastforwardCommuDialogTitle = Image(path=sprite_path(r"50e23c8a-7ba2-4c9c-9cfb-196c260fa1d5.png"), name="早送り確認")

    ButtonCommuSkip = Image(path=sprite_path(r"f1f21925-3e22-4dd1-b53b-bb52bcf26c2b.png"), name="跳过交流按钮")

    ButtonCommuFastforward = Image(path=sprite_path(r"f6ca6bd3-543f-4779-8367-c5c883f04b95.png"), name="快进交流按钮")

    ButtonOK = Image(path=sprite_path(r"8424ecdd-8857-4764-9fd0-d4bfa440c128.png"), name="OK 按钮")

    ButtonSelect2 = Image(path=sprite_path(r"5ebcde3b-f0fd-4e5d-b3de-ada8f0b5e03b.png"), name="選択する")

    TextSkipCommuComfirmation = Image(path=sprite_path(r"4d78add6-1027-4939-bb51-f99fca7db2ce.png"), name="跳过未读交流确认对话框标题")

    IconButtonCheck = Image(path=sprite_path(r"fad5eec2-5fd5-412f-9abb-987a3087dc54.png"), name="按钮✓图标")

    IconButtonCross = Image(path=sprite_path(r"bc7155ac-18c9-4335-9ec2-c8762d37a057.png"), name="按钮×图标")


    pass
class Daily:
    
    ButonLinkData = Image(path=sprite_path(r"dfe926f6-a3b3-48c2-9ebd-757f77d932a6.png"), name="buton_link_data.png")

    ButtonAssignmentPartial = Image(path=sprite_path(r"0bd59a8f-6fbd-4c92-8c1e-1d58716b6d84.png"), name="button_assignment_partial.png")

    ButtonClaimAllNoIcon = Image(path=sprite_path(r"a1bae28b-7b90-4009-b384-79f7a8974078.png"), name="button_claim_all_no_icon.png")

    ButtonClubCollectReward = Image(path=sprite_path(r"9b0f6620-5fd0-4393-ae67-555baf171550.png"), name="button_club_collect_reward.png")

    ButtonClubSendGift = Image(path=sprite_path(r"57cee3e6-eee4-4023-85f3-52959fa372a0.png"), name="button_club_send_gift.png")

    ButtonClubSendGiftNext = Image(path=sprite_path(r"9f41a6b4-2955-4105-8610-423f267807de.png"), name="button_club_send_gift_next.png")

    ButtonContestChallenge = Image(path=sprite_path(r"8c9c9195-4eed-407c-b1ab-bb616c7b2acc.png"), name="button_contest_challenge.png")

    ButtonContestChallengeStart = Image(path=sprite_path(r"ecc2500b-4916-4c47-a840-98233d53522b.png"), name="button_contest_challenge_start.png")

    ButtonContestRanking = Image(path=sprite_path(r"78e27204-2544-419d-b66e-e9e7244f4460.png"), name="button_contest_ranking.png")

    ButtonContestStart = Image(path=sprite_path(r"6d58dbfa-84e2-4a84-8c7c-133e459e9b40.png"), name="button_contest_start.png")

    ButtonDailyShop = Image(path=sprite_path(r"1a06449d-472e-4c06-9dc1-1cb06b1b1ce5.png"), name="button_daily_shop.png")

    ButtonHomeCurrent = Image(path=sprite_path(r"1e17f7b1-4f64-474c-aade-4b3de32c0de4.png"), name="button_home_current.png")

    ButtonIconPass = Image(path=sprite_path(r"5fb7c821-63b4-4ee2-b6ea-16eec3a77251.png"), name="button_icon_pass.png")

    ButtonIconSkip = Image(path=sprite_path(r"2fa084f5-0637-4d53-ada8-9c542d597a51.png"), name="button_icon_skip.png")

    ButtonMission = Image(path=sprite_path(r"cf615078-aedf-46af-a94d-9328a16fbc13.png"), name="button_mission.png")

    ButtonPass = Image(path=sprite_path(r"40fc17b0-718c-432d-b784-92a22c2f7512.png"), name="button_pass.png")

    ButtonPassClaim = Image(path=sprite_path(r"9d9dd078-9bb3-4f5f-9ef5-63c203bf02c9.png"), name="button_pass_claim.png")

    ButtonPresentsPartial = Image(path=sprite_path(r"ca680286-0937-46e1-8b4d-ee900baed756.png"), name="button_presents_partial.png")

    ButtonProduce = Image(path=sprite_path(r"ad455e8e-fb2f-4180-af29-7ef66c98daa9.png"), name="button_produce.png")

    ButtonShop = Image(path=sprite_path(r"fb870576-1837-4267-bc0f-e0685bf7a136.png"), name="button_shop.png")

    ButtonShopCapsuleToys = Image(path=sprite_path(r"62676c2c-814a-4d8b-9bb2-232c3b434287.png"), name="button_shop_capsule_toys.png")

    ButtonShopCapsuleToysDraw = Image(path=sprite_path(r"cf8b2ae3-f948-4204-b7da-c0801f1368f4.png"), name="button_shop_capsule_toys_draw.png")

    ButtonShopCountAdd = Image(path=sprite_path(r"ccb8054c-345d-43c9-8b2c-7b2243ad6668.png"), name="button_shop_count_add.png")

    ButtonShopCountAddDisabled = Image(path=sprite_path(r"3997a0e3-0826-4b1e-b7e9-4a36ebaaa9e8.png"), name="button_shop_count_add_disabled.png")

    ButtonSupportCardUpgrade = Image(path=sprite_path(r"146c742a-0fb3-4d88-851e-ddd621533ad3.png"), name="button_support_card_upgrade.png")

    ButtonRefreshMoneyShop = Image(path=sprite_path(r"81c97cd3-df53-44d3-bf3d-1eb4dc67b62a.png"), name="リスト更新：1回無料")

    IconTitleDailyShop = Image(path=sprite_path(r"e9ee330d-dfca-440e-8b8c-0a3b4e8c8730.png"), name="日常商店标题图标")

    BoxHomeAssignment = HintBox(x1=33, y1=650, x2=107, y2=746, source_resolution=(720, 1280))

    BoxHomeAP = HintBox(x1=291, y1=4, x2=500, y2=82, source_resolution=(720, 1280))

    BoxHomeJewel = HintBox(x1=500, y1=7, x2=703, y2=82, source_resolution=(720, 1280))

    BoxHomeActivelyFunds = HintBox(x1=29, y1=530, x2=109, y2=633, source_resolution=(720, 1280))

    IconAssignKouchou = Image(path=sprite_path(r"77b0a64c-1e14-41d6-94af-8824982f2119.png"), name="icon_assign_kouchou.png")

    IconAssignMiniLive = Image(path=sprite_path(r"36039a1a-52e6-428d-9866-0f0f65a7298f.png"), name="icon_assign_mini_live.png")

    IconAssignOnlineLive = Image(path=sprite_path(r"ceb4fae9-b5e5-41cf-856b-bcf753f477d9.png"), name="icon_assign_online_live.png")

    IconAssignTitle = Image(path=sprite_path(r"e2a98bd2-56d1-47e9-806a-a36d06bd3f16.png"), name="icon_assign_title.png")

    IconMenuClub = Image(path=sprite_path(r"a921b8d5-93b7-4346-9ae4-d2e1def1ec1a.png"), name="icon_menu_club.png")

    IconShopAp = Image(path=sprite_path(r"04b33e1f-a341-46d4-a54b-a05f1e765c10.png"), name="icon_shop_ap.png")

    IconShopMoney = Image(path=sprite_path(r"a975a75e-e774-481b-8ade-9b1229bc95dd.png"), name="icon_shop_money.png")

    IconShopTitle = Image(path=sprite_path(r"f0370809-4383-4039-b8ec-f80a9216a7b3.png"), name="icon_shop_title.png")

    IconTitleAssign = Image(path=sprite_path(r"98deb79d-e32b-4551-bc26-c4722d2b1307.png"), name="icon_title_assign.png")

    IconTitlePass = Image(path=sprite_path(r"276239b5-e41b-4ae5-9be6-37d251292d39.png"), name="icon_title_pass.png")

    BoxApkUpdateDialogTitle = HintBox(x1=26, y1=905, x2=342, y2=967, source_resolution=(720, 1280))

    ButtonAssignmentShortenTime = Image(path=sprite_path(r"1652f06a-5417-49ef-8949-4854772d9ab7.png"), name="工作页面 短缩 时间")

    class Club:
        
        NoteRequestHintBox = HintBox(x1=314, y1=1071, x2=450, y2=1099, source_resolution=(720, 1280))
    
    
        pass
    TextRoadToIdol = Image(path=sprite_path(r"4503db6b-7224-4b81-9971-e7cfa56e10f2.png"), name="文字「アイドルへの道」")

    PointContest = HintPoint(x=492, y=878)

    PointDissmissContestReward = HintPoint(x=604, y=178)

    BoxMissonTabs = HintBox(x1=11, y1=929, x2=703, y2=1030, source_resolution=(720, 1280))

    class CapsuleToys:
        
        NextPageStartPoint = HintPoint(x=360, y=1167)
    
        NextPageEndPoint = HintPoint(x=362, y=267)
    
        IconTitle = Image(path=sprite_path(r"2bd6fe88-99fa-443d-8e42-bb3de5881213.png"), name="日常 扭蛋 页面标题图标")
    
        SliderStartPoint = HintPoint(x=476, y=898)
    
        SliderEndPoint = HintPoint(x=230, y=898)
    
    
        pass
    TextDefaultExchangeCountChangeDialog = Image(path=sprite_path(r"de325534-3fd3-480a-9eb8-eb47960a753a.png"), name="商店默认购买次数改变对话框")

    TextShopItemPurchased = Image(path=sprite_path(r"5d36b880-7b3f-49b1-a018-7de59867d376.png"), name="交換しました")

    TextShopItemSoldOut = Image(path=sprite_path(r"24dc7158-036c-4a66-9280-e934f470be53.png"), name="交換済みです")

    class SupportCard:
        
        DragDownStartPoint = HintPoint(x=357, y=872)
    
        DragDownEndPoint = HintPoint(x=362, y=194)
    
        TargetSupportCard = HintPoint(x=138, y=432)
    
    
        pass
    TextActivityFundsMax = Image(path=sprite_path(r"03985ce5-781f-4c1b-8d49-c5f97010d5ff.png"), name="text_activity_funds_max.png")

    TextAssignmentCompleted = Image(path=sprite_path(r"833ce8cb-01cd-4457-94b9-ff3f93d33f05.png"), name="text_assignment_completed.png")

    TextContest = Image(path=sprite_path(r"6bb37f56-bac2-4852-82b0-e9b65ce0cbe8.png"), name="text_contest.png")

    TextContestLastOngoing = Image(path=sprite_path(r"5fb96a83-7b37-435b-9d7e-9caf0bc022e4.png"), name="text_contest_last_ongoing.png")

    TextContestNoMemory = Image(path=sprite_path(r"fa1eea22-b329-4c1c-8446-279c542f6da0.png"), name="text_contest_no_memory.png")

    TextContestOverallStats = Image(path=sprite_path(r"f60a8a24-b358-4f3a-af2c-4e4a31c5d36e.png"), name="text_contest_overall_stats.png")

    TextShopRecommended = Image(path=sprite_path(r"9e5afe22-f817-45f7-b0dd-2c808adff8cb.png"), name="text_shop_recommended.png")

    TextTabShopAp = Image(path=sprite_path(r"4d0f75f5-632b-4c59-88a5-058622a4c3af.png"), name="text_tab_shop_ap.png")


    pass
class Shop:
    
    ItemLessonNote = Image(path=sprite_path(r"0949c622-9067-4f0d-bac2-3f938a1d2ed2.png"), name="レッスンノート")

    ItemVeteranNote = Image(path=sprite_path(r"b2af59e9-60e3-4d97-8c72-c7ba092113a3.png"), name="ベテランノート")

    ItemSupportEnhancementPt = Image(path=sprite_path(r"835489e2-b29b-426c-b4c9-3bb9f8eb6195.png"), name="サポート強化Pt 支援强化Pt")

    ItemSenseNoteVocal = Image(path=sprite_path(r"c5b7d67e-7260-4f08-a0e9-4d31ce9bbecf.png"), name="センスノート（ボーカル）感性笔记（声乐）")

    ItemSenseNoteDance = Image(path=sprite_path(r"0f7d581d-cea3-4039-9205-732e4cd29293.png"), name="センスノート（ダンス）感性笔记（舞蹈）")

    ItemSenseNoteVisual = Image(path=sprite_path(r"d3cc3323-51af-4882-ae12-49e7384b746d.png"), name="センスノート（ビジュアル）感性笔记（形象）")

    ItemLogicNoteVocal = Image(path=sprite_path(r"a1df3af1-a3e7-4521-a085-e4dc3cd1cc57.png"), name="ロジックノート（ボーカル）理性笔记（声乐）")

    ItemLogicNoteDance = Image(path=sprite_path(r"a9fcaf04-0c1f-4b0f-bb5b-ede9da96180f.png"), name="ロジックノート（ダンス）理性笔记（舞蹈）")

    ItemLogicNoteVisual = Image(path=sprite_path(r"c3f536d6-a04a-4651-b3f9-dd2c22593f7f.png"), name="ロジックノート（ビジュアル）理性笔记（形象）")

    ItemAnomalyNoteVocal = Image(path=sprite_path(r"eef25cf9-afd0-43b1-b9c5-fbd997bd5fe0.png"), name="アノマリーノート（ボーカル）非凡笔记（声乐）")

    ItemAnomalyNoteDance = Image(path=sprite_path(r"df991b42-ed8e-4f2c-bf0c-aa7522f147b6.png"), name="アノマリーノート（ダンス）非凡笔记（舞蹈）")

    ItemAnomalyNoteVisual = Image(path=sprite_path(r"9340b854-025c-40da-9387-385d38433bef.png"), name="アノマリーノート（ビジュアル）非凡笔记（形象）")

    ItemRechallengeTicket = Image(path=sprite_path(r"ea1ba124-9cb3-4427-969a-bacd47e7d920.png"), name="再挑戦チケット 重新挑战券")

    ItemRecordKey = Image(path=sprite_path(r"1926f2f9-4bd7-48eb-9eba-28ec4efb0606.png"), name="記録の鍵  解锁交流的物品")

    class IdolPiece:
        
        花海咲季_FightingMyWay = Image(path=sprite_path(r"3942ae40-7f22-412c-aebe-4b064f68db9b.png"), name="")
    
        月村手毬_LunaSayMaybe = Image(path=sprite_path(r"185f7838-92a7-460b-9340-f60858948ce9.png"), name="")
    
        藤田ことね_世界一可愛い私  = Image(path=sprite_path(r"cb3d0ca7-8d14-408a-a2f5-2e25f7b86d6c.png"), name="")
    
        花海佑芽_TheRollingRiceball = Image(path=sprite_path(r"213016c2-c3a2-43d8-86a3-ab4d27666ced.png"), name="")
    
        葛城リーリヤ_白線 = Image(path=sprite_path(r"cc60b509-2ed5-493d-bb9f-333c6d2a6006.png"), name="")
    
        紫云清夏_TameLieOneStep = Image(path=sprite_path(r"5031808b-5525-4118-92b4-317ec8bda985.png"), name="")
    
        篠泽广_光景 = Image(path=sprite_path(r"ae9fe233-9acc-4e96-ba8e-1fb1d9bc2ea5.png"), name="")
    
        倉本千奈_WonderScale = Image(path=sprite_path(r"8f8b7b46-53bb-42ab-907a-4ea87eb09ab4.png"), name="")
    
        有村麻央_Fluorite = Image(path=sprite_path(r"0d9ac648-eefa-4869-ac99-1b0c83649681.png"), name="")
    
        姬崎莉波_clumsy_trick = Image(path=sprite_path(r"921eefeb-730e-46fc-9924-d338fb286592.png"), name="")
    
    
        pass

    pass
class Produce:
    
    BoxProduceOngoing = HintBox(x1=179, y1=937, x2=551, y2=1091, source_resolution=(720, 1280))

    ButtonAutoSet = Image(path=sprite_path(r"8a62a66d-4b66-42d5-b004-b56eb7c45d68.png"), name="button_auto_set.png")

    ButtonProduce = Image(path=sprite_path(r"7a54f094-bc75-48d3-8253-cca80a7052a2.png"), name="button_produce.png")

    ButtonProduceStart = Image(path=sprite_path(r"2227a4ac-a933-4165-b594-2720a26f9e44.png"), name="button_produce_start.png")

    ButtonRegular = Image(path=sprite_path(r"9a816f64-b16e-4e8a-b4d8-d056c31c85f1.png"), name="button_regular.png")

    CheckboxIconNoteBoost = Image(path=sprite_path(r"80ae6f18-cc26-4b31-9202-b5a0656b23ce.png"), name="checkbox_icon_note_boost.png")

    CheckboxIconSupportPtBoost = Image(path=sprite_path(r"a04c4402-e071-401a-9549-d573eabc0e59.png"), name="checkbox_icon_support_pt_boost.png")

    IconPIdolLevel = Image(path=sprite_path(r"30a6f399-6999-4f04-bb77-651e0214112f.png"), name="P偶像卡上的等级图标")

    KbIdolOverviewName = HintBox(x1=140, y1=16, x2=615, y2=97, source_resolution=(720, 1280))

    BoxIdolOverviewIdols = HintBox(x1=26, y1=568, x2=696, y2=992, source_resolution=(720, 1280))

    ButtonResume = Image(path=sprite_path(r"ccbcb114-7f73-43d1-904a-3a7ae660c531.png"), name="再開する")

    ResumeDialogRegular = Image(path=sprite_path(r"daf3d823-b7f1-4584-acf3-90b9d880332c.png"), name="培育再开对话框 REGULAR")

    BoxResumeDialogWeeks = HintBox(x1=504, y1=559, x2=643, y2=595, source_resolution=(720, 1280))

    BoxResumeDialogIdolCard = HintBox(x1=53, y1=857, x2=197, y2=1048, source_resolution=(720, 1280))

    ResumeDialogPro = Image(path=sprite_path(r"c954e153-d3e9-4488-869f-d00cfdfac5ee.png"), name="培育再开对话框 PRO")

    ResumeDialogMaster = Image(path=sprite_path(r"3c8b477a-8eda-407e-9e9f-7540c8808f89.png"), name="培育再开对话框 MASTER")

    RadioTextSkipCommu = Image(path=sprite_path(r"aeff3068-5f5c-4685-a328-fe367d426c46.png"), name="radio_text_skip_commu.png")

    TextAnotherIdolAvailableDialog = Image(path=sprite_path(r"cbf4ce9c-f8d8-4fb7-a197-15bb9847df04.png"), name="Another 版本偶像可用对话框标题")

    ScreenshotMemoryConfirmDialog = Image(path=sprite_path(r"3746df74-fe63-442c-85d2-8a3696cb2fcd.png"), name="screenshot_memory_confirm_dialog.png")

    LogoNia = Image(path=sprite_path(r"a0bd6a5f-784d-4f0a-9d66-10f4b80c8d3e.png"), name="NIA LOGO (NEXT IDOL AUDITION)")

    PointNiaToHajime = HintPoint(x=34, y=596)

    TextAPInsufficient = Image(path=sprite_path(r"4883c564-f950-4a29-9f5f-6f924123cd22.png"), name="培育 AP 不足提示弹窗 标题")

    ButtonRefillAP = Image(path=sprite_path(r"eaba6ebe-f0df-4918-aee5-ef4e3ffedcf0.png"), name="确认恢复AP按钮")

    ButtonUse = Image(path=sprite_path(r"cfc9c8e8-cbe1-49f0-9afa-ead7f9455a2e.png"), name="按钮「使う」")

    ScreenshotNoEnoughAp3 = Image(path=sprite_path(r"791e885e-6e27-498f-81ff-87a40582507d.png"), name="screenshot_no_enough_ap_3.png")

    ButtonSkipLive = Image(path=sprite_path(r"e5e84f9e-28da-4cf4-bcba-c9145fe39b07.png"), name="培育结束跳过演出按钮")

    TextSkipLiveDialogTitle = Image(path=sprite_path(r"b6b94f21-ef4b-4425-9c7e-ca2b574b0add.png"), name="跳过演出确认对话框标题")

    ButtonHajime0Regular = Image(path=sprite_path(r"6cd80be8-c9b3-4ba5-bf17-3ffc9b000743.png"), name="")

    ButtonHajime0Pro = Image(path=sprite_path(r"55f7db71-0a18-4b3d-b847-57959b8d2e32.png"), name="")

    TitleIconProudce = Image(path=sprite_path(r"0bf5e34e-afc6-4447-bbac-67026ce2ad26.png"), name="培育页面左上角标题图标")

    ButtonHajime1Regular = Image(path=sprite_path(r"3b473fe6-e147-477f-b088-9b8fb042a4f6.png"), name="")

    ButtonHajime1Pro = Image(path=sprite_path(r"2ededcf5-1d80-4e2a-9c83-2a31998331ce.png"), name="")

    ButtonHajime1Master = Image(path=sprite_path(r"24e99232-9434-457f-a9a0-69dd7ecf675f.png"), name="")

    PointHajimeToNia = HintPoint(x=680, y=592)

    LogoHajime = Image(path=sprite_path(r"e6b45405-cd9f-4c6e-a9f1-6ec953747c65.png"), name="Hajime LOGO 定期公演")

    ButtonPIdolOverview = Image(path=sprite_path(r"e88c9ad1-ec37-4fcd-b086-862e1e7ce8fd.png"), name="Pアイドルー覧  P偶像列表展示")

    TextStepIndicator1 = Image(path=sprite_path(r"44ba8515-4a60-42c9-8878-b42e4e34ee15.png"), name="1. アイドル選択")

    BoxSelectedIdol = HintBox(x1=149, y1=783, x2=317, y2=1006, source_resolution=(720, 1280))

    BoxSetCountIndicator = HintBox(x1=66, y1=651, x2=139, y2=686, source_resolution=(720, 1280))

    PointProduceNextSet = HintPoint(x=702, y=832)

    PointProducePrevSet = HintPoint(x=14, y=832)

    TextStepIndicator2 = Image(path=sprite_path(r"a48324ae-7c1a-489e-b3c4-93d12267f88d.png"), name="2. サポート選択")

    EmptySupportCardSlot = Image(path=sprite_path(r"d3424d31-0502-4623-996e-f0194e5085ce.png"), name="空支援卡槽位")

    TextAutoSet = Image(path=sprite_path(r"f5c16d2f-ebc5-4617-9b96-971696af7c52.png"), name="おまかせ編成")

    TextStepIndicator3 = Image(path=sprite_path(r"f43c313b-8a7b-467b-8442-fc5bcb8b4388.png"), name="3.メモリー選択")

    TextRentAvailable = Image(path=sprite_path(r"74ec3510-583d-4a76-ac69-38480fbf1387.png"), name="レンタル可能")

    TextStepIndicator4 = Image(path=sprite_path(r"b62bf889-da3c-495a-8707-f3bde73efe92.png"), name="4.開始確認")


    pass
class InPurodyuusu:
    
    A = Image(path=sprite_path(r"ef21cbe1-7263-4a68-ad8c-b9aac503978a.png"), name="A.png")

    AcquireBtnDisabled = Image(path=sprite_path(r"6a59aafc-4962-490e-8ab1-9ad59d22db3d.png"), name="acquire_btn_disabled.png")

    ButtonCancel = Image(path=sprite_path(r"382cb218-9e58-406f-9a3b-a9d990fc0fff.png"), name="button_cancel.png")

    ButtonComplete = Image(path=sprite_path(r"54e29f7f-c951-46a2-a068-6911dfcf1966.png"), name="button_complete.png")

    ButtonFinalPracticeDance = Image(path=sprite_path(r"b5ecb8e2-8b1a-4240-a2c9-152ccecdacbe.png"), name="button_final_practice_dance.png")

    ButtonFinalPracticeVisual = Image(path=sprite_path(r"12f47930-f691-4a3e-8c83-e47f63fb1f2b.png"), name="button_final_practice_visual.png")

    ButtonFinalPracticeVocal = Image(path=sprite_path(r"795961a5-78c5-4ac4-a250-b1879cd2f60d.png"), name="button_final_practice_vocal.png")

    ButtonFollowNoIcon = Image(path=sprite_path(r"72a9238a-de6d-4665-85d4-265180d00db2.png"), name="button_follow_no_icon.png")

    ButtonIconStudy = Image(path=sprite_path(r"658eb246-1469-4a86-b7a7-5e66b3102084.png"), name="button_icon_study.png")

    ButtonIconStudyVisual = Image(path=sprite_path(r"30ce2e03-e9b3-4b4f-aded-51a05bfca91f.png"), name="button_icon_study_visual.png")

    ButtonLeave = Image(path=sprite_path(r"fd354169-e32a-45be-9a1e-da0136b91dc3.png"), name="button_leave.png")

    ButtonNextNoIcon = Image(path=sprite_path(r"ed081194-272d-461a-93a1-ec476a896753.png"), name="button_next_no_icon.png")

    ButtonRetry = Image(path=sprite_path(r"47d9fac4-2caf-4479-a97a-e519ddbfb3cf.png"), name="button_retry.png")

    ButtonTextActionOuting = Image(path=sprite_path(r"45abba60-06d7-4921-b2a2-9ce790c2b25b.png"), name="button_text_action_outing.png")

    ButtonTextAllowance = Image(path=sprite_path(r"c86250ac-bde0-45bb-b696-f8b94e2d2d3b.png"), name="button_text_allowance.png")

    ButtonTextConsult = Image(path=sprite_path(r"6a272201-1311-41ee-b296-0a8d812d8173.png"), name="button_text_consult.png")

    IconClearBlue = Image(path=sprite_path(r"7eff6c59-a7ed-43d5-8b67-083127e9e748.png"), name="icon_clear_blue.png")

    IconTitleAllowance = Image(path=sprite_path(r"b6cda449-d5ab-4a38-9c85-c25e1b73f588.png"), name="icon_title_allowance.png")

    IconTitleStudy = Image(path=sprite_path(r"00707545-6ed3-4c3a-9c84-89cb75ac1adc.png"), name="icon_title_study.png")

    LootboxSliverLock = Image(path=sprite_path(r"a4935638-882c-4d3f-af77-e5888ad0b71e.png"), name="lootbox_sliver_lock.png")

    LootBoxSkillCard = Image(path=sprite_path(r"cd8d48f2-77d2-4d0b-a81f-53a1549457e9.png"), name="loot_box_skill_card.png")

    M = Image(path=sprite_path(r"94165d54-2c09-427f-9cb1-e23fa9b06a96.png"), name="M.png")

    BoxExamTop = HintBox(x1=5, y1=2, x2=712, y2=55, source_resolution=(720, 1280))

    BoxCardLetter = HintBox(x1=6, y1=1081, x2=715, y2=1100, source_resolution=(720, 1280))

    PDrinkIcon = Image(path=sprite_path(r"fcbeb870-6853-4e2c-8a6e-54b4787e3a2e.png"), name="p_drink_icon.png")

    PItemIconColorful = Image(path=sprite_path(r"08f593a9-d9eb-41ee-b2c0-010562e7ef10.png"), name="p_item_icon_colorful.png")

    PSkillCardIconBlue = Image(path=sprite_path(r"5b2e7826-0e1c-4fd8-965c-6a3498c59825.png"), name="p_skill_card_icon_blue.png")

    PSkillCardIconColorful = Image(path=sprite_path(r"fa72809a-d057-40a0-b771-f4d96bc1ced2.png"), name="p_skill_card_icon_colorful.png")

    Rest = Image(path=sprite_path(r"6aa1fbb0-3880-49e1-ade3-29f627d0e38b.png"), name="rest.png")

    RestConfirmBtn = Image(path=sprite_path(r"8b3cfcfc-fa00-4bc5-9ea4-b350f2c08cb0.png"), name="rest_confirm_btn.png")

    Screenshot4Cards = Image(path=sprite_path(r"35f613e8-61af-41b0-a397-44ae7566a233.png"), name="screenshot_4_cards.png")

    Screenshot5Cards = Image(path=sprite_path(r"229366ae-dbcd-4378-84a2-8a7eb1d1e084.png"), name="screenshot_5_cards.png")

    BoxWeeksUntilExam = HintBox(x1=11, y1=8, x2=237, y2=196, source_resolution=(720, 1280))

    TextActionVocal = Image(path=sprite_path(r"d6b64759-26b7-45b1-bf8e-5c0d98611e0d.png"), name="Vo. レッスン")

    TextActionDance = Image(path=sprite_path(r"303cccc1-c674-4d3a-8c89-19ea729fdbef.png"), name="Da. レッスン")

    TextActionVisual = Image(path=sprite_path(r"cc8a495d-330d-447d-8a80-a8a6ecc409c5.png"), name="Vi. レッスン")

    IconAsariSenseiAvatar = Image(path=sprite_path(r"d7667903-7149-4f2f-9c15-d8a4b5f4d347.png"), name="Asari 老师头像")

    BoxAsariSenseiTip = HintBox(x1=245, y1=150, x2=702, y2=243, source_resolution=(720, 1280))

    ButtonPracticeVocal = Image(path=sprite_path(r"ce1d1d6f-38f2-48bf-98bd-6e091c7ca5b8.png"), name="行动页 声乐课程按钮图标")

    ButtonPracticeDance = Image(path=sprite_path(r"b2e1bf3c-2c36-4fb5-9db7-c10a29563a37.png"), name="行动页 舞蹈课程按钮图标")

    ButtonPracticeVisual = Image(path=sprite_path(r"adc533a7-970b-4c5b-a037-2181531a35d6.png"), name="行动页 形象课程按钮图标")

    TextFinalExamRemaining = Image(path=sprite_path(r"70898bf8-56c5-4f84-becb-629c9ab6a7da.png"), name="最終まで")

    ButtonIconOuting = Image(path=sprite_path(r"8ded6c98-85ea-4858-a66d-4fc8caecb7c5.png"), name="行动按钮图标 外出（おでかけ）")

    ButtonIconConsult = Image(path=sprite_path(r"d83f338d-dde3-494b-9bea-cae511e3517c.png"), name="行动按钮图标 咨询（相談）")

    TextMidExamRemaining = Image(path=sprite_path(r"ce20a856-5629-4f8e-a8e1-d1bd14e18e4f.png"), name="中間まで")

    IconTitleConsult = Image(path=sprite_path(r"23d88465-65d9-4718-8725-8dbf0a98a5a4.png"), name="「相談」页面左上角图标")

    PointConsultFirstItem = HintPoint(x=123, y=550)

    ButtonEndConsult = Image(path=sprite_path(r"9fd0753f-c607-4d49-82d1-40bda27e014f.png"), name="相談 结束按钮")

    ButtonIconExchange = Image(path=sprite_path(r"4096cffa-a889-4622-852e-760fc7022d93.png"), name="交换按钮的图标")

    TextExchangeConfirm = Image(path=sprite_path(r"25f00ee3-8dfe-42d1-a67e-191fa5c3df4b.png"), name="交換確認")

    TextGoalClearNext = Image(path=sprite_path(r"05890a1b-8764-4e9f-9d21-65d292c22e13.png"), name="培育目标达成 NEXT 文字")

    BoxLessonCards5_1 = HintBox(x1=16, y1=882, x2=208, y2=1136, source_resolution=(720, 1280))

    BoxNoSkillCard = HintBox(x1=180, y1=977, x2=529, y2=1026, source_resolution=(720, 1280))

    TitleIconOuting = Image(path=sprite_path(r"ee4e512b-4982-49b6-9c71-31984b58e1d0.png"), name="外出（おでかけ）页面 标题图标")

    TextPDrinkMaxConfirmTitle = Image(path=sprite_path(r"582d36c0-0916-4706-9833-4fbc026701f5.png"), name="P饮料溢出 不领取弹窗标题")

    IconTitleSkillCardRemoval = Image(path=sprite_path(r"bab6c393-692c-4681-ac0d-76c0d9dabea6.png"), name="技能卡自选删除 标题图标")

    ButtonRemove = Image(path=sprite_path(r"00551158-fee9-483f-b034-549139a96f58.png"), name="削除")

    TextPDrink = Image(path=sprite_path(r"8c179a21-be6f-4db8-a9b0-9afeb5c36b1c.png"), name="文本「Pドリンク」")

    TextDontClaim = Image(path=sprite_path(r"e4683def-8d1d-472b-a5ab-bb3885c0c98e.png"), name="受け取らない")

    ButtonDontClaim = Image(path=sprite_path(r"447d0e44-5d87-4b7c-8e60-edb111fe1639.png"), name="「受け取らない」按钮")

    BoxSelectPStuffComfirm = HintBox(x1=256, y1=1064, x2=478, y2=1128, source_resolution=(720, 1280))

    TextClaim = Image(path=sprite_path(r"c948f136-416f-447e-8152-54a1cd1d1329.png"), name="文字「受け取る」")

    TextPItem = Image(path=sprite_path(r"0c0627be-4a09-4450-a078-1858d3ace532.png"), name="文字「Pアイテム」")

    TextSkillCard = Image(path=sprite_path(r"d271a24f-efe8-424d-8fd5-f6b3756ba4ca.png"), name="文字「スキルカード」")

    TextRecommend = Image(path=sprite_path(r"b0283997-7931-476d-a92f-d7569f6ea34c.png"), name="おすすめ")

    ScreenshotSenseiTipConsult = Image(path=sprite_path(r"c89ce004-a437-4b94-9420-0d9bf2ed7e25.png"), name="screenshot_sensei_tip_consult.png")

    TextSkillCardSelectGuideDialogTitle = Image(path=sprite_path(r"3f637e86-6b74-4693-9131-1fe411fc21e5.png"), name="獲得ガイド表示設定")

    BoxSkillCardAcquired = HintBox(x1=194, y1=712, x2=528, y2=765, source_resolution=(720, 1280))

    IconSkillCardEventBubble = Image(path=sprite_path(r"6b58d90d-2e5e-4b7f-bc01-941f2633de89.png"), name="技能卡事件气泡框图标")

    ScreenshotSkillCardEnhanceDialog = Image(path=sprite_path(r"80fac9c6-e6de-4fb5-9543-77797ffcde7a.png"), name="screenshot_skill_card_enhance_dialog.png")

    IconTitleSkillCardEnhance = Image(path=sprite_path(r"79abd239-5eed-4195-9fa8-d729daa874ca.png"), name="技能卡强化 标题 图标")

    ButtonEnhance = Image(path=sprite_path(r"da439e8c-3b74-4371-9657-0736d826c7d1.png"), name="技能卡 强化按钮")

    IconTitleSkillCardMove = Image(path=sprite_path(r"db7d3f03-1f7f-43bf-8125-f7c2d345fca2.png"), name="培育中技能卡移动对话框")

    BoxSkillCardMoveButtonCount = HintBox(x1=339, y1=1170, x2=381, y2=1195, source_resolution=(720, 1280))

    T = Image(path=sprite_path(r"16fbc93d-b294-4001-b4e9-ee2af181415f.png"), name="睡意卡字母 T（眠気）")

    IconSp = Image(path=sprite_path(r"d982d2b5-4bc0-4ae9-a516-f29c2848d64b.png"), name="SP 课程图标")

    BoxCommuEventButtonsArea = HintBox(x1=14, y1=412, x2=703, y2=1089, source_resolution=(720, 1280))

    TextSelfStudyVocal = Image(path=sprite_path(r"c78c38cc-7b61-4dc4-820d-0a5b684ef52e.png"), name="文化课事件 自习 声乐")

    TextSelfStudyDance = Image(path=sprite_path(r"83d0a033-466c-463a-bb8c-be0f2953e9b2.png"), name="文化课事件 自习 舞蹈")

    TextSelfStudyVisual = Image(path=sprite_path(r"4695f96b-c4f5-4bb6-a021-a13b6ceb2883.png"), name="文化课事件 自习 形象")

    TextAsariProduceEnd = Image(path=sprite_path(r"9fb0f700-1eaf-4677-bd1f-05f9f311cdfc.png"), name="text_asari_produce_end.png")

    TextButtonExamSkipTurn = Image(path=sprite_path(r"1dd337ca-20f1-4dc6-8254-235d7ec74158.png"), name="text_button_exam_skip_turn.png")

    TextClearUntil = Image(path=sprite_path(r"fc7b1cdb-d0d0-4470-b5fd-218a8551dc9f.png"), name="text_clear_until.png")

    TextDance = Image(path=sprite_path(r"bdc3b84b-18a4-4abe-938d-3e6495bef7eb.png"), name="text_dance.png")

    TextFinalProduceRating = Image(path=sprite_path(r"b9e687ca-ba44-4aa1-a282-b7da6cffb2ba.png"), name="text_final_produce_rating.png")

    TextOneWeekRemaining = Image(path=sprite_path(r"359d6d34-ea55-470b-b682-6c9252953e8d.png"), name="text_one_week_remaining.png")

    TextPerfectUntil = Image(path=sprite_path(r"ae1a5e05-d53d-43aa-9f27-b9117483d19e.png"), name="text_perfect_until.png")

    TextPleaseSelectPDrink = Image(path=sprite_path(r"1b60b852-dc93-48a1-8b73-0d728d04e057.png"), name="text_please_select_p_drink.png")

    TextPDiary = Image(path=sprite_path(r"29449202-a6cc-4080-bb87-816481ec9506.png"), name="text_p_diary.png")

    TextPDrinkMax = Image(path=sprite_path(r"c3d5a935-6e77-4751-a0b1-b1ac3a3edf0a.png"), name="text_p_drink_max.png")

    TextSenseiTipConsult = Image(path=sprite_path(r"71e84fb3-9474-4bbc-8543-ffba5758dcc0.png"), name="text_sensei_tip_consult.png")

    TextSenseiTipDance = Image(path=sprite_path(r"7ff80aa1-94c3-417e-9fae-3c2f2b8036a8.png"), name="text_sensei_tip_dance.png")

    TextSenseiTipRest = Image(path=sprite_path(r"4f2fcec7-399e-4184-b1dc-eabae92d63dd.png"), name="text_sensei_tip_rest.png")

    TextSenseiTipVisual = Image(path=sprite_path(r"2ee5d498-1370-4f09-b187-41dbe582f498.png"), name="text_sensei_tip_visual.png")

    TextSenseiTipVocal = Image(path=sprite_path(r"3a41fe06-7f33-4c21-9edd-291191e3c563.png"), name="text_sensei_tip_vocal.png")

    TextSkipTurnDialog = Image(path=sprite_path(r"4fd7d95e-7955-4a70-ad91-67a230c647a3.png"), name="text_skip_turn_dialog.png")

    TextVisual = Image(path=sprite_path(r"1262d83a-8f2a-4f75-b70a-385a04d35ae1.png"), name="text_visual.png")


    pass
class Kuyo:
    
    ButtonStartGame = Image(path=sprite_path(r"3675c4aa-a208-47d1-bbcb-48bce40e6ae9.png"), name="button_start_game.png")

    ButtonTab3Speedup = Image(path=sprite_path(r"67da7040-7183-4d30-89a7-e78345f42948.png"), name="button_tab3_speedup.png")


    pass