# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.bad_request_error import BadRequestError
from ..errors.unauthorized_error import UnauthorizedError
from ..types.document_list_response import DocumentListResponse
from ..types.document_local_ingest_request import DocumentLocalIngestRequest
from ..types.document_lookup_response import DocumentLookupResponse
from ..types.document_response import DocumentResponse
from ..types.ingest_remote_document import IngestRemoteDocument
from ..types.ingest_response import IngestResponse
from ..types.processes_status_response import ProcessesStatusResponse
from ..types.processing_status import ProcessingStatus
from ..types.sort import Sort
from ..types.sort_order import SortOrder
from ..types.website_source import WebsiteSource

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawDocumentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def ingest_remote(
        self,
        *,
        documents: typing.Sequence[IngestRemoteDocument],
        callback_url: typing.Optional[str] = OMIT,
        callback_data: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[IngestResponse]:
        """
        Ingest documents hosted on public URLs into a GroundX bucket.

        [Supported Document Types and Ingest Capacities](https://docs.eyelevel.ai/documentation/fundamentals/document-types-and-ingest-capacities)

        Parameters
        ----------
        documents : typing.Sequence[IngestRemoteDocument]

        callback_url : typing.Optional[str]
            An endpoint that will receive processing event updates as POST.

        callback_data : typing.Optional[str]
            A string that is returned, along with processing event updates, to the callback URL.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[IngestResponse]
            Documents successfully uploaded
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/ingest/documents/remote",
            method="POST",
            json={
                "documents": convert_and_respect_annotation_metadata(
                    object_=documents, annotation=typing.Sequence[IngestRemoteDocument], direction="write"
                ),
                "callbackUrl": callback_url,
                "callbackData": callback_data,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    IngestResponse,
                    parse_obj_as(
                        type_=IngestResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def ingest_local(
        self, *, request: DocumentLocalIngestRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[IngestResponse]:
        """
        Upload documents hosted on a local file system into a GroundX bucket.

        [Supported Document Types and Ingest Capacities](https://docs.eyelevel.ai/documentation/fundamentals/document-types-and-ingest-capacities)

        Parameters
        ----------
        request : DocumentLocalIngestRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[IngestResponse]
            Documents successfully uploaded
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/ingest/documents/local",
            method="POST",
            json=convert_and_respect_annotation_metadata(
                object_=request, annotation=DocumentLocalIngestRequest, direction="write"
            ),
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    IngestResponse,
                    parse_obj_as(
                        type_=IngestResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def crawl_website(
        self,
        *,
        websites: typing.Sequence[WebsiteSource],
        callback_url: typing.Optional[str] = OMIT,
        callback_data: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[IngestResponse]:
        """
        Upload the content of a publicly accessible website for ingestion into a GroundX bucket. This is done by following links within a specified URL, recursively, up to a specified depth or number of pages.

        Note1: This endpoint is currently not supported for on-prem deployments.
        Note2: The `source_url` must include the protocol, http:// or https://.

        [Supported Document Types and Ingest Capacities](https://docs.eyelevel.ai/documentation/fundamentals/document-types-and-ingest-capacities)

        Parameters
        ----------
        websites : typing.Sequence[WebsiteSource]

        callback_url : typing.Optional[str]
            The URL that will receive processing event updates.

        callback_data : typing.Optional[str]
            A string that is returned, along with processing event updates, to the callback URL.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[IngestResponse]
            Website successfully queued
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/ingest/documents/website",
            method="POST",
            json={
                "websites": convert_and_respect_annotation_metadata(
                    object_=websites, annotation=typing.Sequence[WebsiteSource], direction="write"
                ),
                "callbackUrl": callback_url,
                "callbackData": callback_data,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    IngestResponse,
                    parse_obj_as(
                        type_=IngestResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def list(
        self,
        *,
        n: typing.Optional[int] = None,
        filter: typing.Optional[str] = None,
        sort: typing.Optional[Sort] = None,
        sort_order: typing.Optional[SortOrder] = None,
        status: typing.Optional[ProcessingStatus] = None,
        next_token: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[DocumentListResponse]:
        """
        lookup all documents across all resources which are currently on GroundX

        Parameters
        ----------
        n : typing.Optional[int]
            The maximum number of returned documents. Accepts 1-100 with a default of 20.

        filter : typing.Optional[str]
            Only documents with names that contain the filter string will be returned in the results.

        sort : typing.Optional[Sort]
            The document attribute that will be used to sort the results.

        sort_order : typing.Optional[SortOrder]
            The order in which to sort the results. A value for sort must also be set.

        status : typing.Optional[ProcessingStatus]
            A status filter on the get documents query. If this value is set, then only documents with this status will be returned in the results.

        next_token : typing.Optional[str]
            A token for pagination. If the number of documents for a given query is larger than n, the response will include a "nextToken" value. That token can be included in this field to retrieve the next batch of n documents.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DocumentListResponse]
            Look up success
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/ingest/documents",
            method="GET",
            params={
                "n": n,
                "filter": filter,
                "sort": sort,
                "sortOrder": sort_order,
                "status": status,
                "nextToken": next_token,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DocumentListResponse,
                    parse_obj_as(
                        type_=DocumentListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(
        self,
        *,
        document_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[IngestResponse]:
        """
        Delete multiple documents hosted on GroundX

        Parameters
        ----------
        document_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of documentIds which correspond to documents ingested by GroundX

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[IngestResponse]
            Documents are queued to be deleted
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/ingest/documents",
            method="DELETE",
            params={
                "documentIds": document_ids,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    IngestResponse,
                    parse_obj_as(
                        type_=IngestResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_processing_status_by_id(
        self, process_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[IngestResponse]:
        """
        Get the current status of an ingest, initiated with documents.ingest_remote, documents.ingest_local, or documents.crawl_website, by specifying the processId (the processId is included in the response of the documents.ingest functions).

        Parameters
        ----------
        process_id : str
            the processId for the ingest process being checked

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[IngestResponse]
            Look up success
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/ingest/{jsonable_encoder(process_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    IngestResponse,
                    parse_obj_as(
                        type_=IngestResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def lookup(
        self,
        id: int,
        *,
        n: typing.Optional[int] = None,
        filter: typing.Optional[str] = None,
        sort: typing.Optional[Sort] = None,
        sort_order: typing.Optional[SortOrder] = None,
        status: typing.Optional[ProcessingStatus] = None,
        next_token: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[DocumentLookupResponse]:
        """
        lookup the document(s) associated with a processId, bucketId, or groupId.

        Parameters
        ----------
        id : int
            a processId, bucketId, or groupId

        n : typing.Optional[int]
            The maximum number of returned documents. Accepts 1-100 with a default of 20.

        filter : typing.Optional[str]
            Only documents with names that contain the filter string will be returned in the results.

        sort : typing.Optional[Sort]
            The document attribute that will be used to sort the results.

        sort_order : typing.Optional[SortOrder]
            The order in which to sort the results. A value for sort must also be set.

        status : typing.Optional[ProcessingStatus]
            A status filter on the get documents query. If this value is set, then only documents with this status will be returned in the results.

        next_token : typing.Optional[str]
            A token for pagination. If the number of documents for a given query is larger than n, the response will include a "nextToken" value. That token can be included in this field to retrieve the next batch of n documents.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DocumentLookupResponse]
            Look up success
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/ingest/documents/{jsonable_encoder(id)}",
            method="GET",
            params={
                "n": n,
                "filter": filter,
                "sort": sort,
                "sortOrder": sort_order,
                "status": status,
                "nextToken": next_token,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DocumentLookupResponse,
                    parse_obj_as(
                        type_=DocumentLookupResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self, document_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[DocumentResponse]:
        """
        Look up an existing document by documentId.

        Parameters
        ----------
        document_id : str
            The documentId of the document for which GroundX information will be provided.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DocumentResponse]
            Look up success
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/ingest/document/{jsonable_encoder(document_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DocumentResponse,
                    parse_obj_as(
                        type_=DocumentResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_by_id(
        self, document_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[IngestResponse]:
        """
        Delete a single document hosted on GroundX

        Parameters
        ----------
        document_id : str
            A documentId which correspond to a document ingested by GroundX

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[IngestResponse]
            Document successfully deleted
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v1/ingest/document/{jsonable_encoder(document_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    IngestResponse,
                    parse_obj_as(
                        type_=IngestResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_processes(
        self,
        *,
        n: typing.Optional[int] = None,
        status: typing.Optional[ProcessingStatus] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ProcessesStatusResponse]:
        """
        Get a list of ingest process requests, sorted from most recent to least.

        Parameters
        ----------
        n : typing.Optional[int]
            The maximum number of returned processes. Accepts 1-100 with a default of 20.

        status : typing.Optional[ProcessingStatus]
            A status filter on the processing status. If this value is set, then only processes with this status will be returned in the results.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ProcessesStatusResponse]
            Look up success
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/ingest",
            method="GET",
            params={
                "n": n,
                "status": status,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProcessesStatusResponse,
                    parse_obj_as(
                        type_=ProcessesStatusResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawDocumentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def ingest_remote(
        self,
        *,
        documents: typing.Sequence[IngestRemoteDocument],
        callback_url: typing.Optional[str] = OMIT,
        callback_data: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[IngestResponse]:
        """
        Ingest documents hosted on public URLs into a GroundX bucket.

        [Supported Document Types and Ingest Capacities](https://docs.eyelevel.ai/documentation/fundamentals/document-types-and-ingest-capacities)

        Parameters
        ----------
        documents : typing.Sequence[IngestRemoteDocument]

        callback_url : typing.Optional[str]
            An endpoint that will receive processing event updates as POST.

        callback_data : typing.Optional[str]
            A string that is returned, along with processing event updates, to the callback URL.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[IngestResponse]
            Documents successfully uploaded
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/ingest/documents/remote",
            method="POST",
            json={
                "documents": convert_and_respect_annotation_metadata(
                    object_=documents, annotation=typing.Sequence[IngestRemoteDocument], direction="write"
                ),
                "callbackUrl": callback_url,
                "callbackData": callback_data,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    IngestResponse,
                    parse_obj_as(
                        type_=IngestResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def ingest_local(
        self, *, request: DocumentLocalIngestRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[IngestResponse]:
        """
        Upload documents hosted on a local file system into a GroundX bucket.

        [Supported Document Types and Ingest Capacities](https://docs.eyelevel.ai/documentation/fundamentals/document-types-and-ingest-capacities)

        Parameters
        ----------
        request : DocumentLocalIngestRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[IngestResponse]
            Documents successfully uploaded
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/ingest/documents/local",
            method="POST",
            json=convert_and_respect_annotation_metadata(
                object_=request, annotation=DocumentLocalIngestRequest, direction="write"
            ),
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    IngestResponse,
                    parse_obj_as(
                        type_=IngestResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def crawl_website(
        self,
        *,
        websites: typing.Sequence[WebsiteSource],
        callback_url: typing.Optional[str] = OMIT,
        callback_data: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[IngestResponse]:
        """
        Upload the content of a publicly accessible website for ingestion into a GroundX bucket. This is done by following links within a specified URL, recursively, up to a specified depth or number of pages.

        Note1: This endpoint is currently not supported for on-prem deployments.
        Note2: The `source_url` must include the protocol, http:// or https://.

        [Supported Document Types and Ingest Capacities](https://docs.eyelevel.ai/documentation/fundamentals/document-types-and-ingest-capacities)

        Parameters
        ----------
        websites : typing.Sequence[WebsiteSource]

        callback_url : typing.Optional[str]
            The URL that will receive processing event updates.

        callback_data : typing.Optional[str]
            A string that is returned, along with processing event updates, to the callback URL.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[IngestResponse]
            Website successfully queued
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/ingest/documents/website",
            method="POST",
            json={
                "websites": convert_and_respect_annotation_metadata(
                    object_=websites, annotation=typing.Sequence[WebsiteSource], direction="write"
                ),
                "callbackUrl": callback_url,
                "callbackData": callback_data,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    IngestResponse,
                    parse_obj_as(
                        type_=IngestResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def list(
        self,
        *,
        n: typing.Optional[int] = None,
        filter: typing.Optional[str] = None,
        sort: typing.Optional[Sort] = None,
        sort_order: typing.Optional[SortOrder] = None,
        status: typing.Optional[ProcessingStatus] = None,
        next_token: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[DocumentListResponse]:
        """
        lookup all documents across all resources which are currently on GroundX

        Parameters
        ----------
        n : typing.Optional[int]
            The maximum number of returned documents. Accepts 1-100 with a default of 20.

        filter : typing.Optional[str]
            Only documents with names that contain the filter string will be returned in the results.

        sort : typing.Optional[Sort]
            The document attribute that will be used to sort the results.

        sort_order : typing.Optional[SortOrder]
            The order in which to sort the results. A value for sort must also be set.

        status : typing.Optional[ProcessingStatus]
            A status filter on the get documents query. If this value is set, then only documents with this status will be returned in the results.

        next_token : typing.Optional[str]
            A token for pagination. If the number of documents for a given query is larger than n, the response will include a "nextToken" value. That token can be included in this field to retrieve the next batch of n documents.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DocumentListResponse]
            Look up success
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/ingest/documents",
            method="GET",
            params={
                "n": n,
                "filter": filter,
                "sort": sort,
                "sortOrder": sort_order,
                "status": status,
                "nextToken": next_token,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DocumentListResponse,
                    parse_obj_as(
                        type_=DocumentListResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(
        self,
        *,
        document_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[IngestResponse]:
        """
        Delete multiple documents hosted on GroundX

        Parameters
        ----------
        document_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of documentIds which correspond to documents ingested by GroundX

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[IngestResponse]
            Documents are queued to be deleted
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/ingest/documents",
            method="DELETE",
            params={
                "documentIds": document_ids,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    IngestResponse,
                    parse_obj_as(
                        type_=IngestResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_processing_status_by_id(
        self, process_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[IngestResponse]:
        """
        Get the current status of an ingest, initiated with documents.ingest_remote, documents.ingest_local, or documents.crawl_website, by specifying the processId (the processId is included in the response of the documents.ingest functions).

        Parameters
        ----------
        process_id : str
            the processId for the ingest process being checked

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[IngestResponse]
            Look up success
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/ingest/{jsonable_encoder(process_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    IngestResponse,
                    parse_obj_as(
                        type_=IngestResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def lookup(
        self,
        id: int,
        *,
        n: typing.Optional[int] = None,
        filter: typing.Optional[str] = None,
        sort: typing.Optional[Sort] = None,
        sort_order: typing.Optional[SortOrder] = None,
        status: typing.Optional[ProcessingStatus] = None,
        next_token: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[DocumentLookupResponse]:
        """
        lookup the document(s) associated with a processId, bucketId, or groupId.

        Parameters
        ----------
        id : int
            a processId, bucketId, or groupId

        n : typing.Optional[int]
            The maximum number of returned documents. Accepts 1-100 with a default of 20.

        filter : typing.Optional[str]
            Only documents with names that contain the filter string will be returned in the results.

        sort : typing.Optional[Sort]
            The document attribute that will be used to sort the results.

        sort_order : typing.Optional[SortOrder]
            The order in which to sort the results. A value for sort must also be set.

        status : typing.Optional[ProcessingStatus]
            A status filter on the get documents query. If this value is set, then only documents with this status will be returned in the results.

        next_token : typing.Optional[str]
            A token for pagination. If the number of documents for a given query is larger than n, the response will include a "nextToken" value. That token can be included in this field to retrieve the next batch of n documents.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DocumentLookupResponse]
            Look up success
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/ingest/documents/{jsonable_encoder(id)}",
            method="GET",
            params={
                "n": n,
                "filter": filter,
                "sort": sort,
                "sortOrder": sort_order,
                "status": status,
                "nextToken": next_token,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DocumentLookupResponse,
                    parse_obj_as(
                        type_=DocumentLookupResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self, document_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[DocumentResponse]:
        """
        Look up an existing document by documentId.

        Parameters
        ----------
        document_id : str
            The documentId of the document for which GroundX information will be provided.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DocumentResponse]
            Look up success
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/ingest/document/{jsonable_encoder(document_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DocumentResponse,
                    parse_obj_as(
                        type_=DocumentResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_by_id(
        self, document_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[IngestResponse]:
        """
        Delete a single document hosted on GroundX

        Parameters
        ----------
        document_id : str
            A documentId which correspond to a document ingested by GroundX

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[IngestResponse]
            Document successfully deleted
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v1/ingest/document/{jsonable_encoder(document_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    IngestResponse,
                    parse_obj_as(
                        type_=IngestResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        parse_obj_as(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_processes(
        self,
        *,
        n: typing.Optional[int] = None,
        status: typing.Optional[ProcessingStatus] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ProcessesStatusResponse]:
        """
        Get a list of ingest process requests, sorted from most recent to least.

        Parameters
        ----------
        n : typing.Optional[int]
            The maximum number of returned processes. Accepts 1-100 with a default of 20.

        status : typing.Optional[ProcessingStatus]
            A status filter on the processing status. If this value is set, then only processes with this status will be returned in the results.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ProcessesStatusResponse]
            Look up success
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/ingest",
            method="GET",
            params={
                "n": n,
                "status": status,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ProcessesStatusResponse,
                    parse_obj_as(
                        type_=ProcessesStatusResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
