# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.group_list_response import GroupListResponse
from ..types.group_response import GroupResponse
from ..types.message_response import MessageResponse
from .raw_client import AsyncRawGroupsClient, RawGroupsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class GroupsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawGroupsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawGroupsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawGroupsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        n: typing.Optional[int] = None,
        next_token: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupListResponse:
        """
        list all groups within your GroundX account.

        Parameters
        ----------
        n : typing.Optional[int]
            The maximum number of returned groups. Accepts 1-100 with a default of 20.

        next_token : typing.Optional[str]
            A token for pagination. If the number of groups for a given query is larger than n, the response will include a "nextToken" value. That token can be included in this field to retrieve the next batch of n groups.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupListResponse
            Successful retrieval of groups

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.groups.list(
            n=1,
            next_token="nextToken",
        )
        """
        _response = self._raw_client.list(n=n, next_token=next_token, request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        name: str,
        bucket_name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupResponse:
        """
        create a new group, a group being a collection of buckets which can be searched.

        Parameters
        ----------
        name : str
            The name of the group being created.

        bucket_name : typing.Optional[str]
            Specify bucketName to automatically create a bucket, by the name specified, and add it to the created group.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupResponse
            Group successfully created

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.groups.create(
            name="your_group_name",
        )
        """
        _response = self._raw_client.create(name=name, bucket_name=bucket_name, request_options=request_options)
        return _response.data

    def get(self, group_id: int, *, request_options: typing.Optional[RequestOptions] = None) -> GroupResponse:
        """
        look up a specific group by its groupId.

        Parameters
        ----------
        group_id : int
            The groupId of the group to look up.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupResponse
            Successful retrieval of group

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.groups.get(
            group_id=1,
        )
        """
        _response = self._raw_client.get(group_id, request_options=request_options)
        return _response.data

    def update(
        self, group_id: int, *, new_name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> GroupResponse:
        """
        Rename a group

        Parameters
        ----------
        group_id : int
            The groupId of the group to update.

        new_name : str
            The new name of the group being renamed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupResponse
            Successful update of group

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.groups.update(
            group_id=1,
            new_name="your_group_name",
        )
        """
        _response = self._raw_client.update(group_id, new_name=new_name, request_options=request_options)
        return _response.data

    def delete(self, group_id: int, *, request_options: typing.Optional[RequestOptions] = None) -> MessageResponse:
        """
        Delete a group.

        Parameters
        ----------
        group_id : int
            The groupId of the group to be deleted.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MessageResponse
            Group successfully deleted

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.groups.delete(
            group_id=1,
        )
        """
        _response = self._raw_client.delete(group_id, request_options=request_options)
        return _response.data

    def add_bucket(
        self, group_id: int, bucket_id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> MessageResponse:
        """
        Add an existing bucket to an existing group. Buckets and groups can be associated many to many.

        Parameters
        ----------
        group_id : int
            The groupId of the group which the bucket will be added to.

        bucket_id : int
            The bucketId of the bucket being added to the group.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MessageResponse
            Successful update of group

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.groups.add_bucket(
            group_id=1,
            bucket_id=1,
        )
        """
        _response = self._raw_client.add_bucket(group_id, bucket_id, request_options=request_options)
        return _response.data

    def remove_bucket(
        self, group_id: int, bucket_id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> MessageResponse:
        """
        remove a bucket from a group. Buckets and groups can be associated many to many, this removes one bucket to group association without disturbing others.

        Parameters
        ----------
        group_id : int
            The groupId of the group which the bucket will be removed from.

        bucket_id : int
            The bucketId of the bucket which will be removed from the group.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MessageResponse
            Successful update of group

        Examples
        --------
        from groundx import GroundX

        client = GroundX(
            api_key="YOUR_API_KEY",
        )
        client.groups.remove_bucket(
            group_id=1,
            bucket_id=1,
        )
        """
        _response = self._raw_client.remove_bucket(group_id, bucket_id, request_options=request_options)
        return _response.data


class AsyncGroupsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawGroupsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawGroupsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawGroupsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        n: typing.Optional[int] = None,
        next_token: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupListResponse:
        """
        list all groups within your GroundX account.

        Parameters
        ----------
        n : typing.Optional[int]
            The maximum number of returned groups. Accepts 1-100 with a default of 20.

        next_token : typing.Optional[str]
            A token for pagination. If the number of groups for a given query is larger than n, the response will include a "nextToken" value. That token can be included in this field to retrieve the next batch of n groups.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupListResponse
            Successful retrieval of groups

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.groups.list(
                n=1,
                next_token="nextToken",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(n=n, next_token=next_token, request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        name: str,
        bucket_name: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GroupResponse:
        """
        create a new group, a group being a collection of buckets which can be searched.

        Parameters
        ----------
        name : str
            The name of the group being created.

        bucket_name : typing.Optional[str]
            Specify bucketName to automatically create a bucket, by the name specified, and add it to the created group.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupResponse
            Group successfully created

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.groups.create(
                name="your_group_name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(name=name, bucket_name=bucket_name, request_options=request_options)
        return _response.data

    async def get(self, group_id: int, *, request_options: typing.Optional[RequestOptions] = None) -> GroupResponse:
        """
        look up a specific group by its groupId.

        Parameters
        ----------
        group_id : int
            The groupId of the group to look up.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupResponse
            Successful retrieval of group

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.groups.get(
                group_id=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(group_id, request_options=request_options)
        return _response.data

    async def update(
        self, group_id: int, *, new_name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> GroupResponse:
        """
        Rename a group

        Parameters
        ----------
        group_id : int
            The groupId of the group to update.

        new_name : str
            The new name of the group being renamed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GroupResponse
            Successful update of group

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.groups.update(
                group_id=1,
                new_name="your_group_name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(group_id, new_name=new_name, request_options=request_options)
        return _response.data

    async def delete(
        self, group_id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> MessageResponse:
        """
        Delete a group.

        Parameters
        ----------
        group_id : int
            The groupId of the group to be deleted.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MessageResponse
            Group successfully deleted

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.groups.delete(
                group_id=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(group_id, request_options=request_options)
        return _response.data

    async def add_bucket(
        self, group_id: int, bucket_id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> MessageResponse:
        """
        Add an existing bucket to an existing group. Buckets and groups can be associated many to many.

        Parameters
        ----------
        group_id : int
            The groupId of the group which the bucket will be added to.

        bucket_id : int
            The bucketId of the bucket being added to the group.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MessageResponse
            Successful update of group

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.groups.add_bucket(
                group_id=1,
                bucket_id=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.add_bucket(group_id, bucket_id, request_options=request_options)
        return _response.data

    async def remove_bucket(
        self, group_id: int, bucket_id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> MessageResponse:
        """
        remove a bucket from a group. Buckets and groups can be associated many to many, this removes one bucket to group association without disturbing others.

        Parameters
        ----------
        group_id : int
            The groupId of the group which the bucket will be removed from.

        bucket_id : int
            The bucketId of the bucket which will be removed from the group.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MessageResponse
            Successful update of group

        Examples
        --------
        import asyncio

        from groundx import AsyncGroundX

        client = AsyncGroundX(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.groups.remove_bucket(
                group_id=1,
                bucket_id=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.remove_bucket(group_id, bucket_id, request_options=request_options)
        return _response.data
