from typing import Protocol


class GitServiceProtocol(Protocol):
    def get_diff(self, base_sha: str, head_sha: str, unified: int = 3) -> str: ...

    def get_diff_for_file(self, base_sha: str, head_sha: str, file: str, unified: int = 3) -> str: ...

    def get_changed_files(self, base_sha: str, head_sha: str) -> list[str]: ...

    def get_file_at_commit(self, file_path: str, sha: str) -> str | None: ...
