Songpress is a free, easy to use song typeset program for Windows and Linux, that generates high-quality songbooks.

Songpress is focused on song formatting. Once your song is ready, you can copy-paste it into your favorite program, to give your songbook the look you like the most.


### Installation

You can install Songpress using [https://github.com/pypa/pipx](`pipx`):

```bash
pipx install songpress
```

Then you can run Songpress simply typing:

```bash
songpress
```

You can create a start menu shortcut by executing:

```bash
songpress --create-shortcuts
```




### Highlights

- Produce **high-quality guitar scores** (text and chords)
- **Easy** to learn, quick to use
- You can **paste formatted songs** into any Windows application, to layout your songbook with maximum flexibility (Microsoft Word, LibreOffice, Microsoft Publisher, Inkscape etc.)
- **Export** formatted songs to PNG and HTML (web pages and snippets)
- **Chord transposition** with automatic key detection
- **Chord simplification** for beginner guitarists: determine the easiest key to play your song, and transpose it automatically
- Support several **chord notations**: American (C, D, E), Italian (Do, Re, Mi), French, German and Portuguese; notation conversion
- Support Chordpro and Tab (i.e. two-line) **chord formats**
- **Clean up** dirty songs with spurious blank lines (such as songs copied and pasted from web pages) and not homogeneous chord notations

Learn more at http://www.skeed.it/songpress
