<div align="middle">
  <img src="https://raw.githubusercontent.com/atomiechen/HandyLLM/main/assets/banner.svg" />
  <p>
    🌟 <b>Support us!</b> <small>If you find HandyLLM useful, please consider <a href="https://github.com/atomiechen/HandyLLM">starring it</a> to help it spread and improve</small> 🌟
  </p>
</div><br>

# HandyLLM

[![GitHub](https://img.shields.io/badge/github-HandyLLM-blue?logo=github)](https://github.com/atomiechen/HandyLLM) [![PyPI](https://img.shields.io/pypi/v/HandyLLM?logo=pypi&logoColor=white)](https://pypi.org/project/HandyLLM/) [![vsmarketplace](https://vsmarketplacebadges.dev/version-short/atomiechen.handyllm.svg)](https://marketplace.visualstudio.com/items?itemName=atomiechen.handyllm)

A handy toolkit for using LLM, with both [***development support***](https://pypi.org/project/HandyLLM/) and [***VSCode editor support***](https://marketplace.visualstudio.com/items?itemName=atomiechen.handyllm).



## 🙌 Why HandyLLM?

📃 **Handy Prompt**: self-containing prompt in a human-friendly mark-up format `.hprompt`. 

- **Easy write**: mark-up format, placeholder variables, request arguments, output logs... And most importantly VSCode syntax highlight!
- **Easy run**: both CLI and APIs available for parsing and running; run it with the CLI tool *WITHOUT* any code! 
- **Easy chain**: You can chain `hprompt` files to construct dynamic logic.

<p float="left" align="center">
  <img src="https://raw.githubusercontent.com/atomiechen/vscode-handyllm/main/demo/example.png" width="70%" />
</p>


**Other features:**

☯️ Unified API design with both sync and async support

🍡 OpenAI and Azure APIs all in one

☕️ Easy life with API endpoint management



## Installation

```shell
pip3 install handyllm
```

or, install from the Github repo to get latest updates:

```shell
pip3 install git+https://github.com/atomiechen/handyllm.git
```

Please check [HandyLLM VSCode extension](https://marketplace.visualstudio.com/items?itemName=atomiechen.handyllm) for editor support.



## Documentation

Please check out our [wiki](https://github.com/atomiechen/HandyLLM/wiki) for comprehensive guides ^_^



## License

[HandyLLM](https://github.com/atomiechen/HandyLLM) © 2024 by [Atomie CHEN](https://github.com/atomiechen) is licensed under the MIT License - see the [LICENSE](https://github.com/atomiechen/HandyLLM/blob/main/LICENSE) file for details.

