If you are implementing a new matcher or metric, please append this `&template=new_matcher_metric.md` to your url to load the correct template.

# Proposed Change
Briefly describe the contribution. If it resolves an issue or feature request, be sure to link to that issue.

# Types of Changes
What types of changes does your code introduce? Delete those that do not apply.
- Bugfix (non-breaking change which fixes an issue)
- New feature or enhancement
- Documentation update
- Tests and benchmarks
- Maintenance (e.g. dependencies, CI, releases, etc.)

Which topics does your change affect? Delete those that do not apply.
- Loaders
- Matchers
- Track Errors
- Metrics
- Core functionality (e.g. `TrackingGraph`, `run_metrics`, `cli`, etc.)

# Checklist
Put an x in the boxes that apply. You can also fill these out after creating the PR. If you're unsure about any of them, don't hesitate to ask. We're here to help! This is simply a reminder of what we are going to look for before merging your code.

- [ ] I have read the developer/contributing docs.
- [ ] I have added tests that prove that my feature works in various situations or tests the bugfix (if appropriate).
- [ ] I have checked that I maintained or improved code coverage.
- [ ] I have checked the benchmarking action to verify that my changes did not adversely affect performance.
- [ ] I have written docstrings and checked that they render correctly in the Read The Docs build (created after the PR is opened).
- [ ] I have updated the general documentation including Metric descriptions and example notebooks if necessary.

# Further Comments
If this is a relatively large or complex change, kick off the discussion by explaining why you chose the solution you did and what alternatives you considered, etc...