# Proposed Matcher or Metric Addition
- [ ] Matcher
- [ ] Metric

Briefly describe your new Matcher or Metric class, including links to publication or other source code if relevant. A full description should be included in the documentation. If it resolves a feature request, be sure to link to that issue.

# Checklist
Put an x in the boxes that apply. You can also fill these out after creating the PR. If you're unsure about any of them, don't hesitate to ask. We're here to help! This is simply a reminder of what we are going to look for before merging your code.

- [ ] I have read the developer/contributing docs.
- [ ] I have added tests for the standard test examples documented [here](https://traccuracy.readthedocs.io/en/latest/test_cases/index.html), along with end-to-end tests.
- [ ] I have checked that I maintained or improved code coverage.
- [ ] I have added benchmarking functions for my change `tests/bench.py`.
- [ ] I have added a page to the documentation with a complete description of my matcher/metric including any references.
- [ ] I have written docstrings and checked that they render correctly in the Read The Docs build (created after the PR is opened).

# Further Comments
If this is a relatively large or complex change, kick off the discussion by explaining why you chose the solution you did and what alternatives you considered, etc...