# CoolLog


## ✨ ویژگی‌ها
- نمایش لاگ‌ها در ترمینال با رنگ‌بندی متفاوت برای هر سطح
- ذخیره لاگ‌ها در فایل `logs.txt`
- شامل سطوح:
  - `ERROR`
  - `WARNING`
  - `SUCCESS`
  - `INFO`
  - `DEBUG`
  - `CRITICAL`

---

## 📦 نصب
```bash
pip install coollog
````
---

## 📖 مثال استفاده

```python
from coollog import CoolLog

CoolLog.error("این یک خطای تستی است")
CoolLog.warning("این یک هشدار است")
CoolLog.success("عملیات با موفقیت انجام شد")
CoolLog.info("اطلاعات سیستمی ثبت شد")
CoolLog.debug("دیباگ کردن مرحله‌ی 1")
CoolLog.critical("خطای بحرانی در سیستم")
```

---

## 📂 خروجی در ترمینال
مثال (با رنگ‌بندی واقعی در ترمینال قابل مشاهده است):

```
[ERROR-2025-08-27 12:30:15]  این یک خطای تستی است
[WARNING-2025-08-27 12:30:15]  این یک هشدار است
[SUCCESS-2025-08-27 12:30:15]  عملیات با موفقیت انجام شد
```

---

## 📝 ذخیره در فایل
تمامی لاگ‌ها علاوه بر نمایش در ترمینال، در فایل `logs.txt` نیز ذخیره می‌شوند:

```
[ERROR-2025-08-27 12:30:15] این یک خطای تستی است
[WARNING-2025-08-27 12:30:15] این یک هشدار است
```

---

## 📜 لایسنس
این پروژه آزاد است و می‌توانید بدون محدودیت از آن استفاده کنید.
