/* ----------------------------------------------------------------- */
/*           The Japanese TTS System "Open JTalk"                    */
/*           developed by HTS Working Group                          */
/*           http://open-jtalk.sourceforge.net/                      */
/* ----------------------------------------------------------------- */
/*                                                                   */
/*  Copyright (c) 2008-2016  Nagoya Institute of Technology          */
/*                           Department of Computer Science          */
/*                                                                   */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/* - Redistributions of source code must retain the above copyright  */
/*   notice, this list of conditions and the following disclaimer.   */
/* - Redistributions in binary form must reproduce the above         */
/*   copyright notice, this list of conditions and the following     */
/*   disclaimer in the documentation and/or other materials provided */
/*   with the distribution.                                          */
/* - Neither the name of the HTS working group nor the names of its  */
/*   contributors may be used to endorse or promote products derived */
/*   from this software without specific prior written permission.   */
/*                                                                   */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND            */
/* CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,       */
/* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF          */
/* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE          */
/* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS */
/* BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,          */
/* EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,     */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON */
/* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,   */
/* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY    */
/* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/* POSSIBILITY OF SUCH DAMAGE.                                       */
/* ----------------------------------------------------------------- */

#ifndef NJD_SET_PRONUNCIATION_RULE_H
#define NJD_SET_PRONUNCIATION_RULE_H

#ifdef __cplusplus
#define NJD_SET_PRONUNCIATION_RULE_H_START extern "C" {
#define NJD_SET_PRONUNCIATION_RULE_H_END   }
#else
#define NJD_SET_PRONUNCIATION_RULE_H_START
#define NJD_SET_PRONUNCIATION_RULE_H_END
#endif                          /* __CPLUSPLUS */

NJD_SET_PRONUNCIATION_RULE_H_START;

static const char *njd_set_pronunciation_list[] = {
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "Ǥ", "ǥ", "1",
   "դ", "ե", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "ǥ", "ǥ", "1",
   "ե", "ե", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "ꥧ", "ꥧ", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "ߥ", "ߥ", "1",
   "ߥ", "ߥ", "1",
   "ߥ", "ߥ", "1",
   "ߥ", "ߥ", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "ե", "ե", "1",
   "ե", "ե", "1",
   "ե", "ե", "1",
   "ե", "ե", "1",
   "", "", "1",
   "ԥ", "ԥ", "1",
   "ԥ", "ԥ", "1",
   "ԥ", "ԥ", "1",
   "ԥ", "ԥ", "1",
   "", "", "1",
   "ӥ", "ӥ", "1",
   "ӥ", "ӥ", "1",
   "ӥ", "ӥ", "1",
   "ӥ", "ӥ", "1",
   "", "", "1",
   "ҥ", "ҥ", "1",
   "ҥ", "ҥ", "1",
   "ҥ", "ҥ", "1",
   "ҥ", "ҥ", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "˥", "˥", "1",
   "˥", "˥", "1",
   "˥", "˥", "1",
   "˥", "˥", "1",
   "", "", "1",
   "", "", "1",
   "ɥ", "ɥ", "1",
   "", "", "1",
   "ȥ", "ȥ", "1",
   "", "", "1",
   "ǥ", "ǥ", "1",
   "ǥ", "ǥ", "1",
   "ǥ", "ǥ", "1",
   "ǥ", "ǥ", "1",
   "", "", "1",
   "ƥ", "ƥ", "1",
   "ƥ", "ƥ", "1",
   "ƥ", "ƥ", "1",
   "ƥ", "ƥ", "1",
   "", "", "1",
   "", "", "1",
   "ĥ", "ĥ", "1",
   "ĥ", "ĥ", "1",
   "ĥ", "ĥ", "1",
   "ĥ", "ĥ", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1", /* none in this charcode */
   "", "", "1", /* none in this charcode */
   "", "", "1", /* none in this charcode */
   "", "", "1", /* none in this charcode */
   "", "", "1", /* none in this charcode */
   "", "", "1", /* none in this charcode */
   "", "", "1", /* none in this charcode */
   "", "", "1", /* none in this charcode */
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "ꤧ", "ꥧ", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "ߤ", "ߥ", "1",
   "ߤ", "ߥ", "1",
   "ߤ", "ߥ", "1",
   "ߤ", "ߥ", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "դ", "ե", "1",
   "դ", "ե", "1",
   "դ", "ե", "1",
   "դ", "ե", "1",
   "", "", "1",
   "Ԥ", "ԥ", "1",
   "Ԥ", "ԥ", "1",
   "Ԥ", "ԥ", "1",
   "Ԥ", "ԥ", "1",
   "", "", "1",
   "Ӥ", "ӥ", "1",
   "Ӥ", "ӥ", "1",
   "Ӥ", "ӥ", "1",
   "Ӥ", "ӥ", "1",
   "", "", "1",
   "Ҥ", "ҥ", "1",
   "Ҥ", "ҥ", "1",
   "Ҥ", "ҥ", "1",
   "Ҥ", "ҥ", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "ˤ", "˥", "1",
   "ˤ", "˥", "1",
   "ˤ", "˥", "1",
   "ˤ", "˥", "1",
   "", "", "1",
   "", "", "1",
   "ɤ", "ɥ", "1",
   "", "", "1",
   "Ȥ", "ȥ", "1",
   "", "", "1",
   "Ǥ", "ǥ", "1",
   "Ǥ", "ǥ", "1",
   "Ǥ", "ǥ", "1",
   "Ǥ", "ǥ", "1",
   "", "", "1",
   "Ƥ", "ƥ", "1",
   "Ƥ", "ƥ", "1",
   "Ƥ", "ƥ", "1",
   "Ƥ", "ƥ", "1",
   "", "", "1",
   "", "", "1",
   "Ĥ", "ĥ", "1",
   "Ĥ", "ĥ", "1",
   "Ĥ", "ĥ", "1",
   "Ĥ", "ĥ", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "", "1",
   "", "å", "2",
   "", "磻", "2",
   "", "å", "4",
   "", "֥塼", "4",
   "", "֥", "2",
   "", "桼", "2",
   "", "ƥ", "2",
   "", "", "2",
   "", "", "3",
   "", "塼", "2",
   "", "ԡ", "2",
   "", "", "2",
   "", "", "2",
   "", "", "2",
   "", "", "2",
   "", "", "2",
   "", "", "2",
   "", "", "2",
   "", "", "3",
   "", "", "2",
   "", "", "2",
   "", "", "2",
   "", "ǥ", "2",
   "", "", "2",
   "", "ӡ", "2",
   "", "", "2",
   "", "å", "2",
   "", "磻", "2",
   "", "å", "4",
   "", "֥塼", "4",
   "", "֥", "2",
   "", "桼", "2",
   "", "ƥ", "2",
   "", "", "2",
   "", "", "3",
   "", "塼", "2",
   "", "ԡ", "2",
   "", "", "2",
   "", "", "2",
   "", "", "2",
   "", "", "2",
   "", "", "2",
   "", "", "2",
   "", "", "2",
   "", "", "3",
   "", "", "2",
   "", "", "2",
   "", "", "2",
   "", "ǥ", "2",
   "", "", "2",
   "", "ӡ", "2",
   "", "", "2",
   "", "", "1",
   NULL, NULL, NULL
};

#define NJD_SET_PRONUNCIATION_KIGOU ""
#define NJD_SET_PRONUNCIATION_KAZU ""

static const char *njd_set_pronunciation_symbol_list[] = {
   "", "",
   "", "",
   NULL, NULL
};

#define NJD_SET_PRONUNCIATION_FILLER "ե顼"

#define NJD_SET_PRONUNCIATION_U        ""
#define NJD_SET_PRONUNCIATION_DOUSHI   "ư"
#define NJD_SET_PRONUNCIATION_JODOUSHI "ư"
#define NJD_SET_PRONUNCIATION_CHOUON   ""

#define NJD_SET_PRONUNCIATION_QUESTION  ""
#define NJD_SET_PRONUNCIATION_EXCLAMATION "" // added by me
#define NJD_SET_PRONUNCIATION_DESU_STR  "Ǥ"
#define NJD_SET_PRONUNCIATION_MASU_STR  "ޤ"
#define NJD_SET_PRONUNCIATION_DESU_PRON "ǥ"
#define NJD_SET_PRONUNCIATION_MASU_PRON "ޥ"

#define NJD_SET_PRONUNCIATION_TOUTEN ""
#define NJD_SET_PRONUNCIATION_TOUTEN_POS_GROUP1 ""

NJD_SET_PRONUNCIATION_RULE_H_END;

#endif                          /* !NJD_SET_PRONUNCIATION_RULE_H */
