You are executing a systematic portfolio rebalancing to restore target allocations while optimizing for taxes and transaction costs. Follow this disciplined execution workflow:

**WORKFLOW: Portfolio Rebalancing & Trade Execution**

1. **Rebalancing Analysis (Rebalance Bot)**
   - Use rebalance-bot agent to analyze current vs target allocations
   - Identify significant portfolio drift requiring correction
   - Calculate specific trades needed to restore strategic targets
   - Consider tax implications and suggest tax-efficient rebalancing strategies
   - Prioritize trades by magnitude of drift and importance

2. **Risk Validation (Risk Shield Manager)**
   - Use risk-shield-manager agent to validate rebalancing plan
   - Ensure proposed trades don't violate risk limits or create new concentrations
   - Check that final allocation aligns with risk parameters and IPS guidelines
   - Assess market timing considerations and execution risks

3. **Tax Optimization (Tax Scout)**
   - Use tax-scout agent to optimize trade sequencing for tax efficiency
   - Identify tax-loss harvesting opportunities within rebalancing
   - Consider wash-sale rule compliance and lot selection strategies
   - Balance rebalancing needs with tax optimization benefits

4. **Trade Execution (Trader Jane)**
   - Use trader-jane-execution agent for optimal trade execution
   - Apply appropriate order slicing and venue selection for each trade
   - Monitor execution progress and market impact
   - Provide real-time execution reports and cost analysis

5. **Cash Management (Cash Treasury Steward)**
   - Use cash-treasury-steward agent for optimal cash deployment
   - Manage cash flows from sales and ensure efficient reinvestment
   - Optimize cash buffers and sweep arrangements
   - Coordinate with trade execution timing

6. **Compliance Verification (Compliance Sentinel)**
   - Use compliance-sentinel agent for pre and post-trade compliance checks
   - Validate all trades meet regulatory and account-specific requirements
   - Generate compliance logs and audit trail
   - Flag any potential issues before execution

**Output Format:**
- Rebalancing Summary: Current vs target allocations and required trades
- Execution Plan: Specific trade orders with optimal routing and timing
- Tax Impact Analysis: Estimated tax consequences and optimization strategies
- Cost Estimate: Expected transaction costs and market impact
- Completion Report: Final allocations, execution quality, and performance impact

Execute rebalancing with institutional-quality precision while minimizing costs and tax impact to maximize long-term portfolio efficiency.
Save your response in reports/ folder as a well formatted markdown file with appropriate name and timestamp.