# Active Backlog

**Last Updated**: 2025-10-04
**Current Version**: v1.7.0
**Status**: Phase 4 complete - Streaming reports implemented

---

## 🎯 Current Status

### ✅ Recently Completed (v1.6.x Series)

**v1.6.1** - Agent Discovery Hotfix ✅
- Fixed missing `setting_sources=["project"]` parameter
- Specialized agents now properly discovered from package
- Critical bug fix for v1.6.0

**v1.6.2** - Parallel Subagent Execution ✅
- Updated investment command prompts for parallel coordination
- Research-stock: 3 agents in parallel (quill-equity-analyst, news-sentry-market-watch, risk-shield-manager)
- Review-portfolio: 4 agents in parallel
- Screen-opportunities: 3 agents in parallel
- Expected 60-70% speed improvement

**v1.6.3** - Enhanced Cost Tracking ✅
- Per-agent cost tracking with call counts
- Cache cost savings estimation ($0.002 per API call avoided)
- Parallel agent execution metrics
- Enhanced `/perf` command with:
  - Cost Analysis (total spent, cache savings, savings rate)
  - Agent Cost Breakdown (top 5 agents by cost)
  - Parallel Execution metrics (max parallel agents, speedup estimate)
  - Cache Performance (hit rate, calls saved)

**v1.6.4** - Incremental Response Display ✅
- Fixed accumulated text display issue
- Responses now show only new content (deltas) instead of repeating
- Improved terminal output efficiency
- Better UX during long responses

**v1.6.5** - Cache Hooks Bug Fix ✅ **CRITICAL**
- Fixed critical regression: cache hooks not registered in ClaudeAgentOptions
- 70% API call reduction now functional (was broken in v1.6.0-v1.6.4)
- Cost savings tracking now accurate
- Cache hit/miss metrics now populated correctly

**v1.6.6** - Initialization Order Hotfix ✅ **CRITICAL**
- Fixed v1.6.5 regression: AttributeError 'cache_enabled' on startup
- Moved cache_enabled initialization before ClaudeAgentOptions (line 238)
- Application now starts correctly
- Cache hooks remain functional

**v1.6.7** - Hooks API Format Hotfix ✅ **CRITICAL**
- Fixed v1.6.5/v1.6.6 regression: "'method' object is not iterable" runtime error
- Changed hooks format from bare functions to HookMatcher objects
- Added HookMatcher import from claude_agent_sdk
- Hooks now use correct SDK API: `HookMatcher(matcher="*", hooks=[function])`
- Cache hooks now actually execute during chat interactions

**v1.6.8** - Hook Signature Hotfix ✅ **CRITICAL**
- Fixed v1.6.7 regression: Hook callback signature errors
- Changed hook signature from `(self, tool_name, tool_input)` to `(self, input_data, tool_use_id, context)`
- Pre-hook extracts tool_name from input_data dict
- Post-hook extracts tool_name, tool_input, and result from input_data dict
- Hooks now match SDK API spec: `async def hook(input_data, tool_use_id, context)`
- Fixed "'dict' object has no attribute 'startswith'" error
- Fixed "takes 3 positional arguments but 4 were given" error

**v1.7.0** - Streaming Reports (Phase 4) ✅
- Progressive display of subagent results as they complete
- Display each agent's analysis immediately upon completion
- Shows agent name, duration, and result preview (first 1000 chars)
- 5x faster perceived speed for investment workflows
- Rich formatted cyan panels for streaming sections
- Better UX during long-running multi-agent operations

---

## 🔍 Open Issues & Bugs

### File Write Operations Slow (v1.4.7)
**Severity**: Medium
**Impact**: Report generation workflows
**Status**: 🔍 INVESTIGATING

**Problem:**
- Write to `/tmp/` directory: instant ✅
- Write to `reports/` directory: 2m 45s delay ❌
- Inconsistent behavior between different paths

**Next Steps:**
- [ ] Run production workflow with timing logs
- [ ] Profile SDK Write tool internals
- [ ] Check if permission handler causes delay

---

## 📋 Upcoming Features

### Enhanced Tool Visibility
**Priority**: 🟡 LOW
**Status**: Research needed

**Tasks:**
- [ ] Investigate why agent tool calls aren't visible in UI
- [ ] Review SDK message streaming for agent executions
- [ ] Implement nested tool block handling if possible
- [ ] Improve debugging capability

### Response Display Improvements
**Priority**: 🟡 LOW
**Status**: ✅ Partially Complete (v1.6.4)

**Completed:**
- [x] Fix accumulated text display (show only deltas) - v1.6.4

**Remaining Tasks:**
- [ ] Use Rich Live display for progressive updates (optional enhancement)
- [ ] Explore additional terminal output optimizations (if needed)

---

## 💡 Key Metrics (Current State)

| Metric | v1.4.8 (Before) | v1.7.0 (Current) | Improvement |
|--------|-----------------|------------------|-------------|
| Workflow Time | 8.3 min | 2-3 min (actual) | 60-70% faster |
| Perceived Speed | 8.3 min | 30s-1min | 5x faster (streaming) |
| API Calls Saved | 0% | 70% | ✅ Achieved |
| Cost per Query | $1.32 | $0.30-0.40 | 70%+ cheaper |
| Cache Hit Rate | 0% | 70% | ✅ Achieved |
| Parallel Agents | No | Yes (active) | ✅ Achieved |
| Cost Tracking | None | Detailed | ✅ New Feature |
| Streaming Reports | No | Yes (active) | ✅ New Feature |

---

## 🚨 Critical Workflow

**Before Building Package:**
```bash
# 1. ALWAYS sync development files to package
uv run python src/navam/sync.py

# 2. Verify sync succeeded
ls -la src/navam/.claude/agents/          # Should show 18 agents
ls -la src/navam/.claude/commands/invest/ # Should show 8 commands

# 3. Build package
uv run python -m build
```

**Why This Matters:**
- Package uses **consistent `.claude/` structure** for all resources
- Agents: `src/navam/.claude/agents/` (18 subagent files)
- Commands: `src/navam/.claude/commands/invest/` (8 workflow files)
- Development keeps everything in `.claude/` for Claude Code integration
- Sync script bridges the two without disturbing development setup
- **Without sync, package fails with "agents not found" errors**

---

## 📖 Reference Documents

### Core Documentation
- **Python SDK API**: `artifacts/refer/claude-agent-sdk/PYTHON-SDK-API-REFERENCE.md`
- **Building Agents**: `artifacts/refer/claude-agent-sdk/building-agents.md`
- **Migration Guide**: `artifacts/refer/claude-agent-sdk/MIGRATION-GUIDE.md`
- **Critical Insights**: `artifacts/refer/claude-agent-sdk/CRITICAL-INSIGHTS-FOR-NAVAM.md`

### Project Documentation
- **Performance Strategy**: `docs/backlog-consolidation-summary.md`
- **Parallel Subagents Strategy**: `docs/phase-2-prompt-engineering-strategy.md`
- **Runtime Issues Analysis**: `docs/runtime-issues-analysis.md`

### Release Documentation
- **v1.6.0**: `artifacts/backlog/release-v1.6.0.md`
- **v1.6.1**: `artifacts/backlog/release-v1.6.1.md`
- **v1.6.2**: `artifacts/backlog/release-v1.6.2.md`
- **v1.6.3**: `artifacts/backlog/release-v1.6.3.md`
- **v1.6.7**: `artifacts/backlog/release-v1.6.7.md`
- **v1.7.0**: `artifacts/backlog/release-v1.7.0.md`

### Known Issues
- **Programmatic Agents**: `artifacts/refer/claude-agent-sdk/PROGRAMMATIC-AGENTS-NOT-WORKING.md`
- **AgentDefinition Details**: `artifacts/refer/claude-agent-sdk/AGENTS-MUST-BE-DATACLASSES.md`

### Historical Archives
- **archive-001.md** - Early development work
- **archive-002.md** - Phase 0 & 1 completion (SDK migration, cache hooks)
- **archive-003-phase2-failed-attempts.md** - v1.5.5-v1.5.10 programmatic agent attempts
- **archive-004-phase2-research-questions.md** - Research plan (superseded)

---

## 🚀 Next Actions

**Short Term (This Week)**:
1. Test parallel execution performance in production
2. Monitor cache effectiveness and cost savings
3. Gather user feedback on v1.6.3 features
4. Document actual speedup achieved

**Medium Term (Next 2 Weeks)**:
1. Begin Phase 4: Streaming Reports (v1.7.0)
2. Investigate file write operation delays
3. Consider enhanced tool visibility improvements

**Long Term**:
1. Monitor production performance
2. Gather user feedback
3. Plan additional optimization phases
4. Consider new feature requests

---

**Status**: Stable, production-ready ✅
**Focus**: Monitor v1.6.3 performance, plan v1.7.0 features
