# Navam v1.6.1 Release Plan

**Target Date**: 2025-10-04 (Hotfix release)
**Type**: Critical bug fix release
**Impact**: CRITICAL - Fixes agent discovery that was broken in v1.6.0

---

## 🚨 Critical Fix: Agent Discovery

**Problem**: v1.6.0 package uses "general-purpose" fallback agent instead of specialized agents

**Root Cause**: Missing `setting_sources=["project"]` parameter in ClaudeAgentOptions

**Status**: ✅ FIXED in `src/navam/chat.py:252`

**Change**:
```python
self.claude_options = ClaudeAgentOptions(
    allowed_tools=allowed_tools or self._get_default_tools(),
    permission_mode=self.permission_mode,
    system_prompt=self._get_system_prompt(),
    mcp_servers=self.mcp_servers,
    add_dirs=agent_dirs,
    setting_sources=["project"],  # ← ADDED: Required to load project-level agents
    can_use_tool=self._handle_tool_permission if should_use_permission_callback else None,
)
```

**Impact**:
- ✅ Specialized agents now properly discovered
- ✅ quill-equity-analyst, news-sentry-market-watch, etc. will be called by name
- ✅ Unlocks core agent functionality advertised in v1.6.0

---

## 📋 Release Checklist

### Code Changes
- [x] Add `setting_sources=["project"]` to ClaudeAgentOptions (chat.py:252)
- [ ] Update version in pyproject.toml (1.6.0 → 1.6.1)
- [ ] Test agent discovery with `/invest:research-stock AAPL`
- [ ] Verify specialized agents are called (not "general-purpose")

### Documentation
- [ ] Update CHANGELOG.md with v1.6.1 hotfix notes
- [ ] Create v1.6.1 release summary in artifacts/backlog/
- [ ] Update README.md if needed

### Testing
- [ ] Clean environment test:
  ```bash
  pip install --upgrade navam
  navam chat
  > /invest:research-stock AAPL
  # Verify: Agent should be "quill-equity-analyst"
  ```
- [ ] Verify all 18 agents discoverable:
  ```bash
  navam chat
  > /agents
  # Should list all 18 specialized agents
  ```

### Build & Publish
- [ ] Run sync script: `uv run python src/navam/sync.py`
- [ ] Build package: `uv run python -m build`
- [ ] Validate: `uv run twine check dist/navam-1.6.1*`
- [ ] Publish: `uv run twine upload dist/navam-1.6.1*`

---

## 🎯 v1.6.1 Features

### Fixed
- ✅ **Agent Discovery** - Specialized agents now properly loaded from package
- ✅ **Task Tool Integration** - SDK can now find and invoke named agents

### Known Limitations (Future Releases)
- ⏳ **Tool Visibility** - Agent tool calls not visible in UI (v1.6.2)
- ⏳ **Cache Hooks** - Not yet implemented (v1.6.2)
- ⏳ **Response Display** - Accumulation vs incremental (v1.6.2)
- ⏳ **Performance Metrics** - Not tracking agent operations (v1.6.2)

---

## 📝 Release Notes (Draft)

### Version 1.6.1 - Hotfix Release

**Critical Bug Fix** 🔧

Fixed agent discovery issue that prevented specialized agents from being loaded. In v1.6.0, all investment commands fell back to "general-purpose" agent instead of using specialized agents like quill-equity-analyst, news-sentry-market-watch, etc.

**Changes:**
- Added `setting_sources=["project"]` to ClaudeAgentOptions for proper project-level agent discovery
- Specialized agents now correctly invoked by investment commands

**Upgrade:**
```bash
pip install --upgrade navam
```

**Verify Fix:**
```bash
navam chat
> /invest:research-stock AAPL
# Agent should now be "quill-equity-analyst" instead of "general-purpose"
```

---

## 🔜 Next Release (v1.6.2) - Performance & UX

**Target**: 2025-10-05 or later
**Focus**: Implement remaining fixes from runtime analysis

### Planned Features
1. **Cache Hooks** - 70% API call reduction via pre/post tool hooks
2. **Tool Visibility** - Show agent tool executions in UI
3. **Response Display** - Incremental text updates (no accumulation)
4. **Performance Metrics** - Track tool calls, timing, cache hits

### Implementation Order
1. Cache hooks (2 hours) - Immediate cost savings
2. Response display (1-2 hours) - Better UX
3. Tool visibility (4-6 hours) - Requires investigation
4. Performance metrics (2-3 hours) - Depends on tool visibility

---

## 📊 Testing Results

### Before Fix (v1.6.0)
```
🤖 Agent Execution
┃ Agent: general-purpose  ❌
┃ Task: Research Google (Alphabet Inc) stock comprehensively
```

### After Fix (v1.6.1) - Expected
```
🤖 Agent Execution
┃ Agent: quill-equity-analyst  ✅
┃ Task: Analyze Google (Alphabet Inc) fundamentals
```

---

## 🔗 References

- **Issue Analysis**: artifacts/backlog/RUNTIME-ISSUES-ANALYSIS.md
- **API Reference**: artifacts/refer/claude-agent-sdk/PYTHON-SDK-API-REFERENCE.md:389-412
- **v1.6.0 Release**: artifacts/backlog/v1.6.0-RELEASE-SUMMARY.md

---

**Status**: 🟡 IN PROGRESS
**Priority**: CRITICAL
**ETA**: Same day hotfix

---

*Created: 2025-10-04*
