# Navam Documentation

This directory contains technical documentation, development guides, and project analysis.

---

## 📚 Documentation Index

### Development Guides
- **[development.md](development.md)** - Package build and development workflow
- **[agent-integration.md](agent-integration.md)** - Agent SDK integration guide

### Performance & Optimization
- **[performance-optimization.md](performance-optimization.md)** - Performance analysis and optimization strategies
- **[backlog-consolidation-summary.md](backlog-consolidation-summary.md)** - Strategic performance insights and Phase 2 breakthrough

### Implementation Strategies
- **[phase-2-prompt-engineering-strategy.md](phase-2-prompt-engineering-strategy.md)** - Parallel subagents implementation via prompt engineering
- **[zero-dependency-package-fix.md](zero-dependency-package-fix.md)** - Making package standalone (v1.6.0)

### Technical Analysis
- **[runtime-issues-analysis.md](runtime-issues-analysis.md)** - Runtime behavior analysis and debugging insights

### Historical Release Notes
- **[release-notes-1.4.3.md](release-notes-1.4.3.md)** - Cache implementation release

---

## 📋 Backlog Organization

**Active Development**: See `artifacts/backlog/active.md`

**Release History**: See `artifacts/backlog/release-v*.md` files
- release-v1.6.0.md - Zero dependencies + 70% performance boost
- release-v1.6.1.md - Agent discovery hotfix
- release-v1.6.2.md - Parallel subagent execution
- release-v1.6.3.md - Enhanced cost tracking

**Historical Archives**: See `artifacts/backlog/archive-*.md` files

---

## 🔍 Quick Navigation

### For Developers
1. Start with [development.md](development.md) for build workflow
2. Review [agent-integration.md](agent-integration.md) for SDK patterns
3. Check [performance-optimization.md](performance-optimization.md) for best practices

### For Performance Analysis
1. Read [backlog-consolidation-summary.md](backlog-consolidation-summary.md) for strategic insights
2. Review [phase-2-prompt-engineering-strategy.md](phase-2-prompt-engineering-strategy.md) for parallel execution
3. Check [performance-optimization.md](performance-optimization.md) for optimization techniques

### For Troubleshooting
1. Check [runtime-issues-analysis.md](runtime-issues-analysis.md) for known issues
2. Review [zero-dependency-package-fix.md](zero-dependency-package-fix.md) for package structure
3. See active backlog for open issues

---

## 📖 Reference Documentation

**Claude Agent SDK**:
- Complete API reference: `artifacts/refer/claude-agent-sdk/PYTHON-SDK-API-REFERENCE.md`
- Building agents guide: `artifacts/refer/claude-agent-sdk/building-agents.md`
- Migration guide: `artifacts/refer/claude-agent-sdk/MIGRATION-GUIDE.md`

**MCP Development**:
- Python SDK: `artifacts/refer/mcp/Python-SDK-README.md`
- Full ecosystem: `artifacts/refer/mcp/llms-full.txt`

---

## 🔗 Quick Links

- [Main README](../README.md) - Project overview and installation
- [Active Backlog](../artifacts/backlog/active.md) - Current development status
- [Source Code](../src/) - Package source code

---

*Last Updated: 2025-10-04*
