You are conducting comprehensive year-end tax optimization to minimize tax liability while maintaining strategic portfolio positioning. Execute this tax-efficient workflow:

**WORKFLOW: Tax Optimization & Year-End Planning**

1. **Tax-Loss Harvesting Analysis (Tax Scout)**
   - Use tax-scout agent for comprehensive tax-loss harvesting review
   - Identify all unrealized losses available for harvesting
   - Calculate potential tax savings and optimal harvesting sequence
   - Check wash-sale rule compliance and suggest compliant alternatives
   - Plan tax-loss harvesting to offset realized gains

2. **Portfolio Impact Assessment (Risk Shield)**
   - Use risk-shield-manager agent to evaluate tax optimization impact on portfolio risk
   - Ensure tax-driven trades don't create unwanted concentrations or exposures
   - Validate that post-tax-optimization portfolio remains within risk parameters
   - Assess correlation impacts of selling losing positions

3. **Rebalancing Coordination (Rebalance Bot)**
   - Use rebalance-bot agent to coordinate tax optimization with strategic rebalancing
   - Identify opportunities to achieve rebalancing while harvesting losses
   - Optimize trade sequencing to minimize tax impact while restoring target allocations
   - Consider asset location optimization across taxable and tax-advantaged accounts

4. **Execution Planning (Trader Jane)**
   - Use trader-jane-execution agent for tax-efficient trade execution
   - Plan optimal timing for loss harvesting (avoid wash-sale windows)
   - Coordinate lot selection strategies for tax optimization
   - Execute trades with minimal market impact while achieving tax objectives

5. **Cash Flow Management (Cash Treasury Steward)**
   - Use cash-treasury-steward agent to optimize cash generated from tax-loss harvesting
   - Plan efficient reinvestment in compliant substitute securities
   - Manage cash flows to maintain appropriate liquidity buffers
   - Coordinate tax payment planning with cash management

6. **Investment Thesis Preservation (Quill Equity Analyst)**
   - Use quill-equity-analyst agent to ensure tax optimization doesn't compromise investment strategy
   - Identify suitable substitute securities that maintain desired exposures
   - Validate that tax-driven sales align with fundamental investment views
   - Recommend replacement positions that preserve strategic allocation intent

**Output Format:**
- Tax Optimization Summary: Total potential tax savings and harvesting opportunities
- Trade Execution Plan: Specific trades with timing and compliance considerations
- Portfolio Impact Analysis: Risk and allocation changes from tax optimization
- Reinvestment Strategy: Compliant substitute securities and allocation maintenance
- Implementation Timeline: Optimal sequencing to maximize tax benefits

Execute sophisticated tax optimization strategies that maximize after-tax returns while preserving long-term investment strategy and portfolio risk management discipline.
Save your response in reports/ folder as a well formatted markdown file with appropriate name and timestamp.