You are conducting comprehensive stock research for potential investment. Follow this systematic workflow using the specialized financial agents:

**⚡ PERFORMANCE OPTIMIZATION (CRITICAL):**

**Phase 1: Data Collection (Batch API Calls)**
Gather ALL required data in ONE batch to eliminate redundant API calls:
   - Call `get_company_profile` for target symbol
   - Call `get_company_financials` for target symbol (annual period)
   - Call `get_analyst_ratings` for target symbol
   - Call `analyze_stock` for target symbol
   - Call `get_company_news` for target symbol (7 days)

**Phase 2: PARALLEL Agent Coordination (CRITICAL FOR SPEED)**
Launch these specialized agents IN PARALLEL using the Task tool - DO NOT run them sequentially:

1. **quill-equity-analyst** - Fundamental analysis and valuation
2. **news-sentry-market-watch** - News sentiment and event analysis
3. **risk-shield-manager** - Risk assessment and position sizing

**CRITICAL INSTRUCTIONS:**
- Use the Task tool to launch ALL THREE agents SIMULTANEOUSLY
- Pass the pre-gathered data as context to each agent
- Wait for ALL agents to complete before synthesizing results
- Agents should use provided data rather than making duplicate API calls

This parallel approach reduces execution time from ~9 minutes to ~2-3 minutes (70% faster).

**WORKFLOW: Stock Research & Investment Analysis**

1. **Initial Screening (Optional - Screen Forge)**
   - If researching a specific symbol: Skip to step 2
   - If seeking investment ideas: Use screen-forge agent to identify candidates based on user criteria (value, growth, sector, momentum, etc.)
   - Generate shortlist of 3-5 top candidates with key metrics

2. **Data Collection Phase**
   - Gather all required market data in ONE batch (see Phase 1 above)
   - Store results to pass as context to agents

3. **PARALLEL Agent Execution (Use Task Tool for ALL THREE Simultaneously)**

   Launch all three agents IN PARALLEL in a SINGLE response with three Task tool calls:

   **Agent 1: quill-equity-analyst** (Fundamental Analysis)
   - Task: "Analyze [SYMBOL] fundamentals using this data: [context]. Provide DCF valuation, comparable analysis, investment thesis, and BUY/HOLD/SELL recommendation with fair value range."

   **Agent 2: news-sentry-market-watch** (News & Events)
   - Task: "Analyze [SYMBOL] news and events using this data: [context]. Assess sentiment, upcoming events, earnings catalysts, and identify red flags or positive catalysts."

   **Agent 3: risk-shield-manager** (Risk Assessment)
   - Task: "Assess [SYMBOL] risks using this data: [context]. Evaluate stock-specific risks, portfolio impact, concentration risk, and provide position sizing recommendations."

4. **Synthesis & Decision Framework**
   - Wait for ALL three agents to complete
   - Combine insights from all agents into actionable investment recommendation
   - Provide: Entry price range, position size, stop-loss levels, timeline for review
   - Include specific catalysts to monitor and risk factors to watch

**Output Format:**
- Executive Summary: Clear investment decision with rationale
- Key Metrics: Valuation, risk measures, position sizing
- Action Plan: Entry strategy, monitoring checklist, exit criteria
- Follow-up: Schedule for re-evaluation and key events to track

Focus on delivering actionable intelligence that enables confident investment decisions while maintaining appropriate risk management discipline. 
Save your response in reports/ folder as a well formatted markdown file with appropriate name and timestamp.