/*
 * Decompiled with CFR 0.152.
 */
package net.thetadata;

import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import net.thetadata.JVMLauncher;
import net.thetadata.JarLibraryManager;
import net.thetadata.config.BuildInfo;
import net.thetadata.config.ConfigurationManager;
import net.thetadata.config.CredentialFileParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) {
        BuildInfo buildInfo = new BuildInfo();
        CredentialFileParser credentialFileParser = new CredentialFileParser(System.console());
        ConfigurationManager configurationManager = new ConfigurationManager(credentialFileParser);
        try {
            configurationManager.parseArgs(args);
        }
        catch (Exception e) {
            System.err.println("Theta Bootstrap: " + buildInfo.dateCommitVersion());
            System.err.println("Error parsing the command line: " + e.getMessage());
            configurationManager.printUsage();
            System.exit(-1);
        }
        logger.info("Theta Bootstrap: {}", (Object)buildInfo.dateCommitVersion());
        try {
            logger.debug("Configuration file: {}", (Object)configurationManager.getConfigFilePath());
            logger.debug("Log directory: {}", (Object)configurationManager.getLogDirectory());
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        try (JarLibraryManager jarLibraryManager = new JarLibraryManager(configurationManager);){
            JVMLauncher launcher = new JVMLauncher(args);
            System.exit(Main.run(configurationManager, jarLibraryManager, launcher));
        }
        catch (Exception e) {
            logger.error("Error starting Theta Terminal, please contact support: support@thetadata.net", e);
            System.exit(-1);
        }
    }

    public static int run(ConfigurationManager configurationManager, JarLibraryManager jarLibraryManager, JVMLauncher launcher) {
        Optional<String> version = jarLibraryManager.fetchAssignedVersion();
        if (configurationManager.isVersionCheck().booleanValue()) {
            ArrayList<Path> jars = new ArrayList<Path>(jarLibraryManager.getStoredJars());
            jars.sort(Comparator.comparing(Path::getFileName));
            if (jars.isEmpty()) {
                logger.info("There are no JARs installed on your machine at {}", (Object)configurationManager.getJarDirectory());
            } else {
                logger.info("JARs installed on your machine:");
                jars.forEach(path -> logger.info("\t{}", (Object)path.getFileName()));
            }
            if (version.isPresent()) {
                logger.info("Would run version: {}", (Object)version.get());
            } else {
                logger.info("Error contacting server to get the version to run");
            }
            return 0;
        }
        try {
            Path jarPath;
            if (configurationManager.getUserVersion() != null) {
                if (!configurationManager.getUserVersion().matches("^\\d{9}$")) {
                    logger.error("Entered version is not a valid version,");
                    logger.error("Please enter in format YYYYMMDDR");
                    return -1;
                }
                jarPath = configurationManager.getJarDirectory().resolve(configurationManager.getUserVersion() + ".jar");
                if (!jarLibraryManager.getStoredJars().contains(jarPath) && !jarLibraryManager.downloadJarFile(configurationManager.getUserVersion())) {
                    logger.error("Unable to download the version specified,");
                    logger.error("and the JAR file is not in the library. Please check the version you entered in the cmd-line.");
                    return -1;
                }
            } else if (version.isEmpty()) {
                opJarPath = jarLibraryManager.findLatestJar();
                if (opJarPath.isEmpty()) {
                    logger.error("Unable to contact the server to find the correct JAR file to run,");
                    logger.error("and there are no JAR files in the library. Please contact support: support@thetadata.net");
                    return -1;
                }
                jarPath = opJarPath.get();
            } else {
                jarPath = configurationManager.getJarDirectory().resolve(version.get() + ".jar");
                if (!jarLibraryManager.getStoredJars().contains(jarPath) && !jarLibraryManager.downloadJarFile(version.get())) {
                    opJarPath = jarLibraryManager.findLatestJar();
                    if (opJarPath.isEmpty()) {
                        logger.error("Unable to contact the server to find the correct JAR file to run,");
                        logger.error("and there are no JAR files in the library. Please contact support: support@thetadata.net");
                        return -1;
                    }
                    jarPath = opJarPath.get();
                }
            }
            logger.debug("Attempting to launch {}", (Object)jarPath);
            boolean successfulLaunch = launcher.launchJar(jarPath);
            if (!successfulLaunch && !configurationManager.isTerminalHelp()) {
                logger.error("Error starting {}", (Object)jarPath);
                Optional<Path> opFallbackJar = jarLibraryManager.findFallbackJar();
                if (opFallbackJar.isEmpty()) {
                    logger.error("Unable to get a fall-back JAR. Please contact support: support@thetadata.net");
                    return -1;
                }
                if (!launcher.launchJar(opFallbackJar.get())) {
                    logger.error("Error starting fall-back JAR as well: {}", (Object)opFallbackJar.get());
                    logger.error("Please contact support: support@thetadata.net");
                    return -1;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error, please contact support: support@thetadata.net" + e.getMessage());
            logger.error("ERROR", e);
        }
        return 0;
    }
}

